(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8378,        294]
NotebookOptionsPosition[      6661,        238]
NotebookOutlinePosition[      7627,        265]
CellTagsIndexPosition[      7584,        262]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Poundal" :> 
          Documentation`HelpLookup["paclet:Units/ref/Poundal"], 
          "KilogramForce" :> 
          Documentation`HelpLookup["paclet:Units/ref/KilogramForce"], 
          "TonForce" :> Documentation`HelpLookup["paclet:Units/ref/TonForce"],
           "Dyne" :> Documentation`HelpLookup["paclet:Units/ref/Dyne"], 
          "KilogramWeight" :> 
          Documentation`HelpLookup["paclet:Units/ref/KilogramWeight"], 
          "GramWeight" :> 
          Documentation`HelpLookup["paclet:Units/ref/GramWeight"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Poundal\"\>", 
       2->"\<\"KilogramForce\"\>", 3->"\<\"TonForce\"\>", 4->"\<\"Dyne\"\>", 
       5->"\<\"KilogramWeight\"\>", 
       6->"\<\"GramWeight\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PoundWeight", "ObjectName",
 CellID->5376],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["PoundWeight"], "InlineFormula"],
     " \[LineSeparator]is a unit of force."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8508]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["PoundWeight"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"4.44822", " ", 
   ButtonBox["Newton",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Newton"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->6652],

Cell[TextData[{
 Cell[BoxData["PoundWeight"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["PoundForce",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/PoundForce"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->17427],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "PoundWeight"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "PoundWeight"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->698]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22663],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Poundal",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Poundal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["KilogramForce",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/KilogramForce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TonForce",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/TonForce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dyne",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Dyne"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["KilogramWeight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/KilogramWeight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GramWeight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/GramWeight"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20255]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25129],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->15138]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PoundWeight - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 11, 38.5889706}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "PoundWeight is a unit of force.", "synonyms" -> {}, "title" -> 
    "PoundWeight", "type" -> "Symbol", "uri" -> "Units/ref/PoundWeight"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1725, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2348, 68, 48, 1, 70, "ObjectName",
 CellID->5376],
Cell[2399, 71, 319, 10, 70, "Usage",
 CellID->8508]
}, Open  ]],
Cell[CellGroupData[{
Cell[2755, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3233, 103, 297, 10, 70, "Notes",
 CellID->6652],
Cell[3533, 115, 249, 9, 70, "Notes",
 CellID->17427],
Cell[3785, 126, 511, 19, 70, "Notes",
 CellID->698]
}, Closed]],
Cell[CellGroupData[{
Cell[4333, 150, 311, 9, 70, "SeeAlsoSection",
 CellID->22663],
Cell[4647, 161, 1483, 53, 70, "SeeAlso",
 CellID->20255]
}, Open  ]],
Cell[CellGroupData[{
Cell[6167, 219, 314, 9, 70, "TutorialsSection",
 CellID->25129],
Cell[6484, 230, 135, 3, 70, "Tutorials",
 CellID->15138]
}, Open  ]],
Cell[6634, 236, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

