(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8610,        301]
NotebookOptionsPosition[      6793,        242]
NotebookOutlinePosition[      7799,        270]
CellTagsIndexPosition[      7756,        267]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Atmosphere" :> 
          Documentation`HelpLookup["paclet:Units/ref/Atmosphere"], "Bar" :> 
          Documentation`HelpLookup["paclet:Units/ref/Bar"], "Torr" :> 
          Documentation`HelpLookup["paclet:Units/ref/Torr"], "InchMercury" :> 
          Documentation`HelpLookup["paclet:Units/ref/InchMercury"], "Barye" :> 
          Documentation`HelpLookup["paclet:Units/ref/Barye"], 
          "MillimeterMercury" :> 
          Documentation`HelpLookup["paclet:Units/ref/MillimeterMercury"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Atmosphere\"\>", 
       2->"\<\"Bar\"\>", 3->"\<\"Torr\"\>", 4->"\<\"InchMercury\"\>", 
       5->"\<\"Barye\"\>", 
       6->"\<\"MillimeterMercury\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PoundsPerSquareInch", "ObjectName",
 CellID->30160],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["PoundsPerSquareInch"], "InlineFormula"],
     " \[LineSeparator]is a unit of pressure."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->710]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["PoundsPerSquareInch"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"6894.76", " ", 
   ButtonBox["Pascal",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Pascal"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->2101],

Cell[TextData[{
 Cell[BoxData["PoundsPerSquareInch"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["PSI",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/PSI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->25764],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "PoundsPerSquareInch"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "PoundsPerSquareInch"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->29710],

Cell[TextData[{
 Cell[BoxData["PoundsPerSquareInch"], "InlineFormula"],
 " is typically abbreviated as psi."
}], "Notes",
 CellID->634547771]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19886],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Atmosphere",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Atmosphere"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bar",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Bar"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Torr",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Torr"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InchMercury",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/InchMercury"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Barye",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Barye"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MillimeterMercury",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/MillimeterMercury"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25254]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22238],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->15796]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PoundsPerSquareInch - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 11, 32.1513058}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "PoundsPerSquareInch is a unit of pressure.", 
    "synonyms" -> {}, "title" -> "PoundsPerSquareInch", "type" -> "Symbol", 
    "uri" -> "Units/ref/PoundsPerSquareInch"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1686, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2309, 66, 57, 1, 70, "ObjectName",
 CellID->30160],
Cell[2369, 69, 329, 10, 70, "Usage",
 CellID->710]
}, Open  ]],
Cell[CellGroupData[{
Cell[2735, 84, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3213, 101, 305, 10, 70, "Notes",
 CellID->2101],
Cell[3521, 113, 243, 9, 70, "Notes",
 CellID->25764],
Cell[3767, 124, 529, 19, 70, "Notes",
 CellID->29710],
Cell[4299, 145, 141, 4, 70, "Notes",
 CellID->634547771]
}, Closed]],
Cell[CellGroupData[{
Cell[4477, 154, 311, 9, 70, "SeeAlsoSection",
 CellID->19886],
Cell[4791, 165, 1471, 53, 70, "SeeAlso",
 CellID->25254]
}, Open  ]],
Cell[CellGroupData[{
Cell[6299, 223, 314, 9, 70, "TutorialsSection",
 CellID->22238],
Cell[6616, 234, 135, 3, 70, "Tutorials",
 CellID->15796]
}, Open  ]],
Cell[6766, 240, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

