(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6573,        242]
NotebookOptionsPosition[      4879,        186]
NotebookOutlinePosition[      5821,        213]
CellTagsIndexPosition[      5778,        210]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Poise" :> 
          Documentation`HelpLookup["paclet:Units/ref/Poise"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Poise\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Rhes", "ObjectName",
 CellID->30537],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Rhes"], "InlineFormula"],
     " \[LineSeparator]is a unit of viscosity."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25483]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Rhes"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"10.", "/", 
   RowBox[{"(", 
    RowBox[{
     ButtonBox["Pascal",
      BaseStyle->"Link",
      ButtonData->"paclet:Units/ref/Pascal"], " ", 
     ButtonBox["Second",
      BaseStyle->"Link",
      ButtonData->"paclet:Units/ref/Second"]}], ")"}]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->18947],

Cell[TextData[{
 Cell[BoxData["Rhes"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"1", "/", 
   ButtonBox["Poise",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Poise"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->30678],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Rhes"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Rhes"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->25048]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7319],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Poise",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Poise"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->16753]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17361],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->3744]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Rhes - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 11, 47.1673152}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Rhes is a unit of viscosity.", "synonyms" -> {}, "title" -> 
    "Rhes", "type" -> "Symbol", "uri" -> "Units/ref/Rhes"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1120, 30, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1743, 57, 42, 1, 70, "ObjectName",
 CellID->30537],
Cell[1788, 60, 317, 10, 70, "Usage",
 CellID->25483]
}, Open  ]],
Cell[CellGroupData[{
Cell[2142, 75, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2620, 92, 420, 15, 70, "Notes",
 CellID->18947],
Cell[3043, 109, 258, 10, 70, "Notes",
 CellID->30678],
Cell[3304, 121, 499, 19, 70, "Notes",
 CellID->25048]
}, Closed]],
Cell[CellGroupData[{
Cell[3840, 145, 310, 9, 70, "SeeAlsoSection",
 CellID->7319],
Cell[4153, 156, 196, 6, 70, "SeeAlso",
 CellID->16753]
}, Open  ]],
Cell[CellGroupData[{
Cell[4386, 167, 314, 9, 70, "TutorialsSection",
 CellID->17361],
Cell[4703, 178, 134, 3, 70, "Tutorials",
 CellID->3744]
}, Open  ]],
Cell[4852, 184, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

