(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7971,        279]
NotebookOptionsPosition[      6299,        224]
NotebookOutlinePosition[      7273,        252]
CellTagsIndexPosition[      7230,        249]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Becquerel" :> 
          Documentation`HelpLookup["paclet:Units/ref/Becquerel"], "Curie" :> 
          Documentation`HelpLookup["paclet:Units/ref/Curie"], "GrayDose" :> 
          Documentation`HelpLookup["paclet:Units/ref/GrayDose"], "Rad" :> 
          Documentation`HelpLookup["paclet:Units/ref/Rad"], "Roentgen" :> 
          Documentation`HelpLookup["paclet:Units/ref/Roentgen"], "Rontgen" :> 
          Documentation`HelpLookup["paclet:Units/ref/Rontgen"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Becquerel\"\>", 2->"\<\"Curie\"\>", 
       3->"\<\"GrayDose\"\>", 4->"\<\"Rad\"\>", 5->"\<\"Roentgen\"\>", 
       6->"\<\"Rontgen\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Rutherford", "ObjectName",
 CellID->20028],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Rutherford"], "InlineFormula"],
     " \[LineSeparator]is a unit of radioactivity."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8342]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Rutherford"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["10", "6"], "/", 
   ButtonBox["Second",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Second"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->1783],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Rutherford"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Rutherford"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->14201]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14240],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Becquerel",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Becquerel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Curie",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Curie"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GrayDose",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/GrayDose"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rad",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Rad"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Roentgen",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Roentgen"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rontgen",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Rontgen"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29305]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18228],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->4019]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Rutherford - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 0.9020418}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Rutherford is a unit of radioactivity.", "synonyms" -> {}, 
    "title" -> "Rutherford", "type" -> "Symbol", "uri" -> 
    "Units/ref/Rutherford"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1636, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2259, 64, 48, 1, 70, "ObjectName",
 CellID->20028],
Cell[2310, 67, 326, 10, 70, "Usage",
 CellID->8342]
}, Open  ]],
Cell[CellGroupData[{
Cell[2673, 82, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3151, 99, 302, 11, 70, "Notes",
 CellID->1783],
Cell[3456, 112, 511, 19, 70, "Notes",
 CellID->14201]
}, Closed]],
Cell[CellGroupData[{
Cell[4004, 136, 311, 9, 70, "SeeAlsoSection",
 CellID->14240],
Cell[4318, 147, 1451, 53, 70, "SeeAlso",
 CellID->29305]
}, Open  ]],
Cell[CellGroupData[{
Cell[5806, 205, 314, 9, 70, "TutorialsSection",
 CellID->18228],
Cell[6123, 216, 134, 3, 70, "Tutorials",
 CellID->4019]
}, Open  ]],
Cell[6272, 222, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

