(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7506,        267]
NotebookOptionsPosition[      5772,        210]
NotebookOutlinePosition[      6750,        238]
CellTagsIndexPosition[      6707,        235]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Amp" :> Documentation`HelpLookup["paclet:Units/ref/Amp"], 
          "Biot" :> Documentation`HelpLookup["paclet:Units/ref/Biot"], 
          "Abampere" :> Documentation`HelpLookup["paclet:Units/ref/Abampere"],
           "Gilbert" :> 
          Documentation`HelpLookup["paclet:Units/ref/Gilbert"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Amp\"\>", 2->"\<\"Biot\"\>", 
       3->"\<\"Abampere\"\>", 4->"\<\"Gilbert\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Statampere", "ObjectName",
 CellID->7509],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Statampere"], "InlineFormula"],
     " \[LineSeparator]is a unit of electric current."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9054]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Statampere"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"3.33564", "\[Times]", 
   SuperscriptBox["10", 
    RowBox[{"-", "10"}]], " ", 
   ButtonBox["Ampere",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Ampere"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->16965],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Statampere"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Statampere"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->32509],

Cell[TextData[{
 Cell[BoxData["Statampere"], "InlineFormula"],
 " is typically abbreviated as statA."
}], "Notes",
 CellID->427537586]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29577],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Amp",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Amp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Biot",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Biot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Abampere",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Abampere"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gilbert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Gilbert"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19636]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14138],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->21321]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Statampere - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 10.7460438}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Statampere is a unit of electric current.", 
    "synonyms" -> {}, "title" -> "Statampere", "type" -> "Symbol", "uri" -> 
    "Units/ref/Statampere"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1416, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2039, 61, 47, 1, 70, "ObjectName",
 CellID->7509],
Cell[2089, 64, 329, 10, 70, "Usage",
 CellID->9054]
}, Open  ]],
Cell[CellGroupData[{
Cell[2455, 79, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2933, 96, 361, 12, 70, "Notes",
 CellID->16965],
Cell[3297, 110, 511, 19, 70, "Notes",
 CellID->32509],
Cell[3811, 131, 134, 4, 70, "Notes",
 CellID->427537586]
}, Closed]],
Cell[CellGroupData[{
Cell[3982, 140, 311, 9, 70, "SeeAlsoSection",
 CellID->29577],
Cell[4296, 151, 945, 35, 70, "SeeAlso",
 CellID->19636]
}, Open  ]],
Cell[CellGroupData[{
Cell[5278, 191, 314, 9, 70, "TutorialsSection",
 CellID->14138],
Cell[5595, 202, 135, 3, 70, "Tutorials",
 CellID->21321]
}, Open  ]],
Cell[5745, 208, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

