(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6492,        235]
NotebookOptionsPosition[      4759,        178]
NotebookOutlinePosition[      5740,        206]
CellTagsIndexPosition[      5697,        203]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Abcoulomb" :> 
          Documentation`HelpLookup["paclet:Units/ref/Abcoulomb"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Abcoulomb\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Statcoulomb", "ObjectName",
 CellID->481],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Statcoulomb"], "InlineFormula"],
     " \[LineSeparator]is a unit of electric charge."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16753]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Statcoulomb"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"3.33564", "\[Times]", 
   SuperscriptBox["10", 
    RowBox[{"-", "10"}]], " ", 
   ButtonBox["Coulomb",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Coulomb"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->30459],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Statcoulomb"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Statcoulomb"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->7643],

Cell[TextData[{
 Cell[BoxData["Statcoulomb"], "InlineFormula"],
 " is typically abbreviated as statC."
}], "Notes",
 CellID->457383162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20529],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Abcoulomb",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Abcoulomb"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->4578]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9778],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->23548]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Statcoulomb - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 10.9179232}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Statcoulomb is a unit of electric charge.", 
    "synonyms" -> {}, "title" -> "Statcoulomb", "type" -> "Symbol", "uri" -> 
    "Units/ref/Statcoulomb"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1140, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1763, 58, 47, 1, 70, "ObjectName",
 CellID->481],
Cell[1813, 61, 330, 10, 70, "Usage",
 CellID->16753]
}, Open  ]],
Cell[CellGroupData[{
Cell[2180, 76, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2658, 93, 364, 12, 70, "Notes",
 CellID->30459],
Cell[3025, 107, 512, 19, 70, "Notes",
 CellID->7643],
Cell[3540, 128, 135, 4, 70, "Notes",
 CellID->457383162]
}, Closed]],
Cell[CellGroupData[{
Cell[3712, 137, 311, 9, 70, "SeeAlsoSection",
 CellID->20529],
Cell[4026, 148, 203, 6, 70, "SeeAlso",
 CellID->4578]
}, Open  ]],
Cell[CellGroupData[{
Cell[4266, 159, 313, 9, 70, "TutorialsSection",
 CellID->9778],
Cell[4582, 170, 135, 3, 70, "Tutorials",
 CellID->23548]
}, Open  ]],
Cell[4732, 176, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

