(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6424,        233]
NotebookOptionsPosition[      4700,        176]
NotebookOutlinePosition[      5669,        204]
CellTagsIndexPosition[      5626,        201]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Abohm" :> 
          Documentation`HelpLookup["paclet:Units/ref/Abohm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Abohm\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Statohm", "ObjectName",
 CellID->31472],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Statohm"], "InlineFormula"],
     " \[LineSeparator]is a unit of electric resistance."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10713]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Statohm"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"8.98758", "\[Times]", 
   SuperscriptBox["10", "11"], " ", 
   ButtonBox["Ohm",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Ohm"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->25632],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Statohm"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Statohm"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->32751],

Cell[TextData[{
 Cell[BoxData["Statohm"], "InlineFormula"],
 " is typically abbreviated as stat\[CapitalOmega]."
}], "Notes",
 CellID->30635396]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6962],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Abohm",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Abohm"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->32664]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11657],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->16091]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Statohm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 11.6054408}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Statohm is a unit of electric resistance.", 
    "synonyms" -> {}, "title" -> "Statohm", "type" -> "Symbol", "uri" -> 
    "Units/ref/Statohm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1120, 30, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1743, 57, 45, 1, 70, "ObjectName",
 CellID->31472],
Cell[1791, 60, 330, 10, 70, "Usage",
 CellID->10713]
}, Open  ]],
Cell[CellGroupData[{
Cell[2158, 75, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2636, 92, 332, 11, 70, "Notes",
 CellID->25632],
Cell[2971, 105, 505, 19, 70, "Notes",
 CellID->32751],
Cell[3479, 126, 144, 4, 70, "Notes",
 CellID->30635396]
}, Closed]],
Cell[CellGroupData[{
Cell[3660, 135, 310, 9, 70, "SeeAlsoSection",
 CellID->6962],
Cell[3973, 146, 196, 6, 70, "SeeAlso",
 CellID->32664]
}, Open  ]],
Cell[CellGroupData[{
Cell[4206, 157, 314, 9, 70, "TutorialsSection",
 CellID->11657],
Cell[4523, 168, 135, 3, 70, "Tutorials",
 CellID->16091]
}, Open  ]],
Cell[4673, 174, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

