(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7609,        274]
NotebookOptionsPosition[      5867,        216]
NotebookOutlinePosition[      6862,        245]
CellTagsIndexPosition[      6819,        242]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Lambert" :> 
          Documentation`HelpLookup["paclet:Units/ref/Lambert"], "Nit" :> 
          Documentation`HelpLookup["paclet:Units/ref/Nit"], "Apostilb" :> 
          Documentation`HelpLookup["paclet:Units/ref/Apostilb"], "Lumen" :> 
          Documentation`HelpLookup["paclet:Units/ref/Lumen"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Lambert\"\>", 2->"\<\"Nit\"\>", 
       3->"\<\"Apostilb\"\>", 4->"\<\"Lumen\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Stilb", "ObjectName",
 CellID->9084],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Stilb"], "InlineFormula"],
     " \[LineSeparator]is the derived CGS unit of luminance (photometric \
brightness)."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31406]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Stilb"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"10000.", " ", 
   RowBox[{
    ButtonBox["Candela",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Candela"], "/", 
    RowBox[{"(", 
     SuperscriptBox[
      ButtonBox["Meter",
       BaseStyle->"Link",
       ButtonData->"paclet:Units/ref/Meter"], "2"], ")"}]}]}]], 
  "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->492],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Stilb"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Stilb"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->26279],

Cell[TextData[{
 Cell[BoxData["Stilb"], "InlineFormula"],
 " is typically abbreviated as sb."
}], "Notes",
 CellID->9797]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30113],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lambert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Lambert"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Nit",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Nit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Apostilb",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Apostilb"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lumen",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Lumen"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->839]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18028],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->4000]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Stilb - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 18.7618740}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> 
    "Stilb is the derived CGS unit of luminance (photometric brightness).", 
    "synonyms" -> {}, "title" -> "Stilb", "type" -> "Symbol", "uri" -> 
    "Units/ref/Stilb"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1419, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2042, 61, 42, 1, 70, "ObjectName",
 CellID->9084],
Cell[2087, 64, 359, 11, 70, "Usage",
 CellID->31406]
}, Open  ]],
Cell[CellGroupData[{
Cell[2483, 80, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2961, 97, 452, 17, 70, "Notes",
 CellID->492],
Cell[3416, 116, 501, 19, 70, "Notes",
 CellID->26279],
Cell[3920, 137, 121, 4, 70, "Notes",
 CellID->9797]
}, Closed]],
Cell[CellGroupData[{
Cell[4078, 146, 311, 9, 70, "SeeAlsoSection",
 CellID->30113],
Cell[4392, 157, 945, 35, 70, "SeeAlso",
 CellID->839]
}, Open  ]],
Cell[CellGroupData[{
Cell[5374, 197, 314, 9, 70, "TutorialsSection",
 CellID->18028],
Cell[5691, 208, 134, 3, 70, "Tutorials",
 CellID->4000]
}, Open  ]],
Cell[5840, 214, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

