(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8975,        313]
NotebookOptionsPosition[      7258,        257]
NotebookOutlinePosition[      8221,        284]
CellTagsIndexPosition[      8178,        281]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FluidOunce" :> 
          Documentation`HelpLookup["paclet:Units/ref/FluidOunce"], "Teaspoon" :> 
          Documentation`HelpLookup["paclet:Units/ref/Teaspoon"], "Pint" :> 
          Documentation`HelpLookup["paclet:Units/ref/Pint"], "Quart" :> 
          Documentation`HelpLookup["paclet:Units/ref/Quart"], "Liter" :> 
          Documentation`HelpLookup["paclet:Units/ref/Liter"], "Shot" :> 
          Documentation`HelpLookup["paclet:Units/ref/Shot"], "Jigger" :> 
          Documentation`HelpLookup["paclet:Units/ref/Jigger"], "Pony" :> 
          Documentation`HelpLookup["paclet:Units/ref/Pony"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FluidOunce\"\>", 
       2->"\<\"Teaspoon\"\>", 3->"\<\"Pint\"\>", 4->"\<\"Quart\"\>", 
       5->"\<\"Liter\"\>", 6->"\<\"Shot\"\>", 7->"\<\"Jigger\"\>", 
       8->"\<\"Pony\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Tablespoon", "ObjectName",
 CellID->20713],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Tablespoon"], "InlineFormula"],
     " \[LineSeparator]is a unit of volume."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2619]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Tablespoon"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"0.0000147868", " ", 
   SuperscriptBox[
    ButtonBox["Meter",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Meter"], "3"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->13504],

Cell[TextData[{
 Cell[BoxData["Tablespoon"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"4", " ", 
   ButtonBox["FluidDram",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/FluidDram"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11955],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Tablespoon"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Tablespoon"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->7560]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31054],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FluidOunce",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/FluidOunce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Teaspoon",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Teaspoon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pint",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Pint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quart",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Quart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Liter",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Liter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Shot",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Shot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Jigger",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Jigger"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pony",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Pony"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19271]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8047],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->16699]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Tablespoon - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 19.6368964}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Tablespoon is a unit of volume.", "synonyms" -> {}, "title" -> 
    "Tablespoon", "type" -> "Symbol", "uri" -> "Units/ref/Tablespoon"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1820, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2443, 67, 48, 1, 70, "ObjectName",
 CellID->20713],
Cell[2494, 70, 319, 10, 70, "Usage",
 CellID->2619]
}, Open  ]],
Cell[CellGroupData[{
Cell[2850, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3328, 102, 328, 11, 70, "Notes",
 CellID->13504],
Cell[3659, 115, 272, 10, 70, "Notes",
 CellID->11955],
Cell[3934, 127, 510, 19, 70, "Notes",
 CellID->7560]
}, Closed]],
Cell[CellGroupData[{
Cell[4481, 151, 311, 9, 70, "SeeAlsoSection",
 CellID->31054],
Cell[4795, 162, 1933, 71, 70, "SeeAlso",
 CellID->19271]
}, Open  ]],
Cell[CellGroupData[{
Cell[6765, 238, 313, 9, 70, "TutorialsSection",
 CellID->8047],
Cell[7081, 249, 135, 3, 70, "Tutorials",
 CellID->16699]
}, Open  ]],
Cell[7231, 255, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

