(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8197,        292]
NotebookOptionsPosition[      6444,        234]
NotebookOutlinePosition[      7387,        261]
CellTagsIndexPosition[      7344,        258]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BritishThermalUnit" :> 
          Documentation`HelpLookup["paclet:Units/ref/BritishThermalUnit"], 
          "Calorie" :> Documentation`HelpLookup["paclet:Units/ref/Calorie"], 
          "ElectronVolt" :> 
          Documentation`HelpLookup["paclet:Units/ref/ElectronVolt"], "Erg" :> 
          Documentation`HelpLookup["paclet:Units/ref/Erg"], "Rydberg" :> 
          Documentation`HelpLookup["paclet:Units/ref/Rydberg"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"BritishThermalUnit\"\>", 
       2->"\<\"Calorie\"\>", 3->"\<\"ElectronVolt\"\>", 4->"\<\"Erg\"\>", 
       5->"\<\"Rydberg\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Therm", "ObjectName",
 CellID->7252],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Therm"], "InlineFormula"],
     " \[LineSeparator]is a unit of energy."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9227]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Therm"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"1.05506", "\[Times]", 
   SuperscriptBox["10", "8"], " ", 
   ButtonBox["Joule",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Joule"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->2371],

Cell[TextData[{
 Cell[BoxData["Therm"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["10", "5"], " ", 
   ButtonBox["BTU",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/BTU"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->2288],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Therm"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Therm"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->20123],

Cell[TextData[{
 Cell[BoxData["Therm"], "InlineFormula"],
 " is typically abbreviated thm."
}], "Notes",
 CellID->289385990]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28838],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BritishThermalUnit",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/BritishThermalUnit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Calorie",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Calorie"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ElectronVolt",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/ElectronVolt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Erg",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Erg"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rydberg",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Rydberg"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18603]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30582],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->30594]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Therm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 26.9495836}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Therm is a unit of energy.", "synonyms" -> {}, "title" -> 
    "Therm", "type" -> "Symbol", "uri" -> "Units/ref/Therm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1589, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2212, 64, 42, 1, 70, "ObjectName",
 CellID->7252],
Cell[2257, 67, 314, 10, 70, "Usage",
 CellID->9227]
}, Open  ]],
Cell[CellGroupData[{
Cell[2608, 82, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3086, 99, 332, 11, 70, "Notes",
 CellID->2371],
Cell[3421, 112, 280, 11, 70, "Notes",
 CellID->2288],
Cell[3704, 125, 501, 19, 70, "Notes",
 CellID->20123],
Cell[4208, 146, 124, 4, 70, "Notes",
 CellID->289385990]
}, Closed]],
Cell[CellGroupData[{
Cell[4369, 155, 311, 9, 70, "SeeAlsoSection",
 CellID->28838],
Cell[4683, 166, 1230, 44, 70, "SeeAlso",
 CellID->18603]
}, Open  ]],
Cell[CellGroupData[{
Cell[5950, 215, 314, 9, 70, "TutorialsSection",
 CellID->30582],
Cell[6267, 226, 135, 3, 70, "Tutorials",
 CellID->30594]
}, Open  ]],
Cell[6417, 232, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

