(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8574,        301]
NotebookOptionsPosition[      6854,        244]
NotebookOutlinePosition[      7822,        272]
CellTagsIndexPosition[      7779,        269]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Maxwell" :> 
          Documentation`HelpLookup["paclet:Units/ref/Maxwell"], "Tesla" :> 
          Documentation`HelpLookup["paclet:Units/ref/Tesla"], "BohrMagneton" :> 
          Documentation`HelpLookup["paclet:Units/ref/BohrMagneton"], 
          "NuclearMagneton" :> 
          Documentation`HelpLookup["paclet:Units/ref/NuclearMagneton"], "Amp" :> 
          Documentation`HelpLookup["paclet:Units/ref/Amp"], "Ampere" :> 
          Documentation`HelpLookup["paclet:Units/ref/Ampere"], "Henry" :> 
          Documentation`HelpLookup["paclet:Units/ref/Henry"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Maxwell\"\>", 2->"\<\"Tesla\"\>", 
       3->"\<\"BohrMagneton\"\>", 4->"\<\"NuclearMagneton\"\>", 
       5->"\<\"Amp\"\>", 6->"\<\"Ampere\"\>", 
       7->"\<\"Henry\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Weber", "ObjectName",
 CellID->10401],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Weber"], "InlineFormula"],
     " \[LineSeparator]is the derived SI unit of magnetic flux."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15939]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Weber"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Volt",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Volt"], " ", 
   ButtonBox["Second",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Second"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->5965],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Weber"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Weber"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->31665],

Cell[TextData[{
 Cell[BoxData["Weber"], "InlineFormula"],
 " is typically abbreviated as Wb."
}], "Notes",
 CellID->14987]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->524],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Maxwell",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Maxwell"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tesla",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Tesla"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BohrMagneton",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/BohrMagneton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NuclearMagneton",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/NuclearMagneton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Amp",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Amp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ampere",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Ampere"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Henry",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Henry"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30578]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4399],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->10719]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Weber - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 35.7779346}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Weber is the derived SI unit of magnetic flux.", 
    "synonyms" -> {}, "title" -> "Weber", "type" -> "Symbol", "uri" -> 
    "Units/ref/Weber"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1773, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2396, 67, 43, 1, 70, "ObjectName",
 CellID->10401],
Cell[2442, 70, 335, 10, 70, "Usage",
 CellID->15939]
}, Open  ]],
Cell[CellGroupData[{
Cell[2814, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3292, 102, 342, 13, 70, "Notes",
 CellID->5965],
Cell[3637, 117, 501, 19, 70, "Notes",
 CellID->31665],
Cell[4141, 138, 122, 4, 70, "Notes",
 CellID->14987]
}, Closed]],
Cell[CellGroupData[{
Cell[4300, 147, 309, 9, 70, "SeeAlsoSection",
 CellID->524],
Cell[4612, 158, 1712, 62, 70, "SeeAlso",
 CellID->30578]
}, Open  ]],
Cell[CellGroupData[{
Cell[6361, 225, 313, 9, 70, "TutorialsSection",
 CellID->4399],
Cell[6677, 236, 135, 3, 70, "Tutorials",
 CellID->10719]
}, Open  ]],
Cell[6827, 242, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

