(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8880,        312]
NotebookOptionsPosition[      7188,        256]
NotebookOutlinePosition[      8125,        283]
CellTagsIndexPosition[      8082,        280]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Year" :> Documentation`HelpLookup["paclet:Units/ref/Year"], 
          "Hour" :> Documentation`HelpLookup["paclet:Units/ref/Hour"], 
          "Minute" :> Documentation`HelpLookup["paclet:Units/ref/Minute"], 
          "Fortnight" :> 
          Documentation`HelpLookup["paclet:Units/ref/Fortnight"], "Month" :> 
          Documentation`HelpLookup["paclet:Units/ref/Month"], "Decade" :> 
          Documentation`HelpLookup["paclet:Units/ref/Decade"], "Century" :> 
          Documentation`HelpLookup["paclet:Units/ref/Century"], "Millennium" :> 
          Documentation`HelpLookup["paclet:Units/ref/Millennium"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Year\"\>", 2->"\<\"Hour\"\>", 
       3->"\<\"Minute\"\>", 4->"\<\"Fortnight\"\>", 5->"\<\"Month\"\>", 
       6->"\<\"Decade\"\>", 7->"\<\"Century\"\>", 
       8->"\<\"Millennium\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Week", "ObjectName",
 CellID->23081],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Week"], "InlineFormula"],
     " \[LineSeparator]is a unit of time."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24916]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Week"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"604800", " ", 
   ButtonBox["Second",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Second"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->30769],

Cell[TextData[{
 Cell[BoxData["Week"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"7", " ", 
   ButtonBox["Day",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Day"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9841],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Week"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Week"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->7000]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12627],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Year",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Year"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hour",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Hour"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Minute",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Minute"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fortnight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Fortnight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Month",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Month"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Decade",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Decade"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Century",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Century"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Millennium",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Millennium"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21964]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29982],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->22538]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Week - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 36.0123156}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Week is a unit of time.", "synonyms" -> {}, "title" -> 
    "Week", "type" -> "Symbol", "uri" -> "Units/ref/Week"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1835, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2458, 67, 42, 1, 70, "ObjectName",
 CellID->23081],
Cell[2503, 70, 312, 10, 70, "Usage",
 CellID->24916]
}, Open  ]],
Cell[CellGroupData[{
Cell[2852, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3330, 102, 276, 10, 70, "Notes",
 CellID->30769],
Cell[3609, 114, 253, 10, 70, "Notes",
 CellID->9841],
Cell[3865, 126, 498, 19, 70, "Notes",
 CellID->7000]
}, Closed]],
Cell[CellGroupData[{
Cell[4400, 150, 311, 9, 70, "SeeAlsoSection",
 CellID->12627],
Cell[4714, 161, 1943, 71, 70, "SeeAlso",
 CellID->21964]
}, Open  ]],
Cell[CellGroupData[{
Cell[6694, 237, 314, 9, 70, "TutorialsSection",
 CellID->29982],
Cell[7011, 248, 135, 3, 70, "Tutorials",
 CellID->22538]
}, Open  ]],
Cell[7161, 254, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

