(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8148,        286]
NotebookOptionsPosition[      6460,        230]
NotebookOutlinePosition[      7395,        257]
CellTagsIndexPosition[      7352,        254]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AvoirdupoisPound" :> 
          Documentation`HelpLookup["paclet:Units/ref/AvoirdupoisPound"], 
          "Hundredweight" :> 
          Documentation`HelpLookup["paclet:Units/ref/Hundredweight"], 
          "GrossHundredweight" :> 
          Documentation`HelpLookup["paclet:Units/ref/GrossHundredweight"], 
          "NetHundredweight" :> 
          Documentation`HelpLookup["paclet:Units/ref/NetHundredweight"], 
          "ShortHundredweight" :> 
          Documentation`HelpLookup["paclet:Units/ref/ShortHundredweight"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"AvoirdupoisPound\"\>", 
       2->"\<\"Hundredweight\"\>", 3->"\<\"GrossHundredweight\"\>", 
       4->"\<\"NetHundredweight\"\>", 
       5->"\<\"ShortHundredweight\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Wey", "ObjectName",
 CellID->24642],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Wey"], "InlineFormula"],
     " \[LineSeparator]is a unit of weight."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17429]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Wey"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"114.305", " ", 
   ButtonBox["Kilogram",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Kilogram"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->6406],

Cell[TextData[{
 Cell[BoxData["Wey"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"252", " ", 
   ButtonBox["Pound",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Pound"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->28648],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Wey"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Wey"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9554]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2286],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AvoirdupoisPound",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/AvoirdupoisPound"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hundredweight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Hundredweight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GrossHundredweight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/GrossHundredweight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NetHundredweight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/NetHundredweight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShortHundredweight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/ShortHundredweight"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13799]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25937],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->6476]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Wey - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 36.1998204}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Wey is a unit of weight.", "synonyms" -> {}, "title" -> 
    "Wey", "type" -> "Symbol", "uri" -> "Units/ref/Wey"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1733, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2356, 68, 41, 1, 70, "ObjectName",
 CellID->24642],
Cell[2400, 71, 313, 10, 70, "Usage",
 CellID->17429]
}, Open  ]],
Cell[CellGroupData[{
Cell[2750, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3228, 103, 293, 10, 70, "Notes",
 CellID->6406],
Cell[3524, 115, 259, 10, 70, "Notes",
 CellID->28648],
Cell[3786, 127, 496, 19, 70, "Notes",
 CellID->9554]
}, Closed]],
Cell[CellGroupData[{
Cell[4319, 151, 310, 9, 70, "SeeAlsoSection",
 CellID->2286],
Cell[4632, 162, 1298, 44, 70, "SeeAlso",
 CellID->13799]
}, Open  ]],
Cell[CellGroupData[{
Cell[5967, 211, 314, 9, 70, "TutorialsSection",
 CellID->25937],
Cell[6284, 222, 134, 3, 70, "Tutorials",
 CellID->6476]
}, Open  ]],
Cell[6433, 228, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

