(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18824,        680]
NotebookOptionsPosition[     15037,        555]
NotebookOutlinePosition[     16528,        594]
CellTagsIndexPosition[     16443,        589]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VARIATIONAL METHODS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Variational Methods" :> 
          Documentation`HelpLookup[
           "paclet:VariationalMethods/tutorial/VariationalMethods"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Variational Methods\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FirstIntegral" :> 
          Documentation`HelpLookup[
           "paclet:VariationalMethods/ref/FirstIntegral"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"FirstIntegral\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FirstIntegrals", "ObjectName",
 CellID->15590],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FirstIntegrals", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{
         StyleBox["x", "TI"], "[", 
         StyleBox["t", "TI"], "]"}], ",", 
        StyleBox["t", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a list of first integrals corresponding to the \
coordinate ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "[", 
       StyleBox["t", "TI"], "]"}]], "InlineFormula"],
     " and independent variable ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " of the integrand ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FirstIntegrals", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           StyleBox["x", "TI"], "[", 
           StyleBox["t", "TI"], "]"}], ",", 
          RowBox[{
           StyleBox["y", "TI"], "[", 
           StyleBox["t", "TI"], "]"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["t", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns a list of first integrals corresponding to the \
coordinates ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"], ",", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     " and independent variable ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->21480]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
A first integral is a conserved quantity associated with a coordinate or the \
independent variable.\
\>", "Notes",
 CellID->17408],

Cell[TextData[{
 "A first integral associated with a coordinate ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["x", "TI"], "[", 
    StyleBox["t", "TI"], "]"}], ",", 
   RowBox[{
    StyleBox["y", "TI"], "[", 
    StyleBox["t", "TI"], "]"}], ",", 
   StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
 " is returned if ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is independent of that coordinate, although ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " may contain derivatives of the coordinate. Such coordinates are typically \
called cyclic or ignorable coordinates."
}], "Notes",
 CellID->15505],

Cell[TextData[{
 "A first integral associated with the independent variable ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " is returned if ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is independent of ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " and does not contain any second or higher derivatives of the coordinates."
}], "Notes",
 CellID->32702],

Cell["\<\
In mechanics, a first integral corresponding to a coordinate is typically \
associated with conservation of momentum, and a first integral corresponding \
to the independent variable is typically associated with conservation of \
energy.\
\>", "Notes",
 CellID->22858],

Cell[TextData[{
 Cell[BoxData["FirstIntegrals"], "InlineFormula"],
 " returns a list of rules of the form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["FirstIntegral",
     BaseStyle->"Link",
     ButtonData->"paclet:VariationalMethods/ref/FirstIntegral"], "[", 
    StyleBox["u", "TI"], "]"}], "->", 
   StyleBox["c", "TI"]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " may be either the coordinates ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], ",", 
   StyleBox["y", "TI"], ",", 
   StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
 " or the independent variable ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 " is the conserved quantity."
}], "Notes",
 CellID->9818]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->371326239],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->362339915],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VariationalMethods`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->556865822],

Cell["\<\
The Lagrangian of a particle in 2-dimensions with a central potential:\
\>", "ExampleText",
 CellID->26467],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptCapitalL]", "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], "m", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{
         RowBox[{"r", "'"}], "[", "t", "]"}], "2"], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"r", "[", "t", "]"}], "2"], 
        SuperscriptBox[
         RowBox[{
          RowBox[{"\[Theta]", "'"}], "[", "t", "]"}], "2"]}]}], ")"}]}], "-", 
    
    RowBox[{"V", "[", 
     RowBox[{"r", "[", "t", "]"}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11320],

Cell[TextData[{
 "The coordinates with conserved first integrals are the angle ",
 Cell[BoxData[
  StyleBox["\[Theta]", "TR"]], "InlineFormula"],
 " and the time ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 ", corresponding to conservation of angular momentum and energy:"
}], "ExampleText",
 CellID->7358],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FirstIntegrals", "[", 
  RowBox[{"\[ScriptCapitalL]", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"r", "[", "t", "]"}], ",", 
     RowBox[{"\[Theta]", "[", "t", "]"}]}], "}"}], ",", "t"}], "]"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->21074],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"FirstIntegral", "[", "\[Theta]", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", "m"}], " ", 
     SuperscriptBox[
      RowBox[{"r", "[", "t", "]"}], "2"], " ", 
     RowBox[{
      SuperscriptBox["\[Theta]", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"FirstIntegral", "[", "t", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"V", "[", 
         RowBox[{"r", "[", "t", "]"}], "]"}]}], "+", 
       RowBox[{"m", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{
            SuperscriptBox["r", "\[Prime]",
             MultilineFunction->None], "[", "t", "]"}], "2"], "+", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"r", "[", "t", "]"}], "2"], " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["\[Theta]", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "2"]}]}], ")"}]}]}], 
      ")"}]}]}]}], "}"}]], "Output",
 ImageSize->{393, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->3987]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9094],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VariationalMethods`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->445167129],

Cell[TextData[{
 "The area of a surface of revolution obtained by revolving the curve ",
 Cell[BoxData[
  RowBox[{
   StyleBox["y", "TI"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " about the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 "-axis has the integrand:"
}], "ExampleText",
 CellID->4983],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"2", "\[Pi]", " ", 
    RowBox[{"y", "[", "x", "]"}], 
    SqrtBox[
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}], "2"]}]]}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21364],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " has no explicit dependence on ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->27264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FirstIntegrals", "[", 
  RowBox[{"f", ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->19714],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"FirstIntegral", "[", "x", "]"}], "\[Rule]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", "\[Pi]", " ", 
      RowBox[{"y", "[", "x", "]"}]}], 
     SqrtBox[
      RowBox[{"1", "+", 
       SuperscriptBox[
        RowBox[{
         SuperscriptBox["y", "\[Prime]",
          MultilineFunction->None], "[", "x", "]"}], "2"]}]]]}]}], 
  "}"}]], "Output",
 ImageSize->{234, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->26746]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16128],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VariationalMethods`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->187353640],

Cell["\<\
For Lagrangians independent of time the first integral associated with time \
represents energy conservation:\
\>", "ExampleText",
 CellID->19948],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FirstIntegrals", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], "m", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{
         RowBox[{"x", "'"}], "[", "t", "]"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{
         RowBox[{"y", "'"}], "[", "t", "]"}], "2"]}], ")"}]}], "-", 
    RowBox[{"V", "[", 
     RowBox[{
      RowBox[{"x", "[", "t", "]"}], ",", 
      RowBox[{"y", "[", "t", "]"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "[", "t", "]"}], ",", 
     RowBox[{"y", "[", "t", "]"}]}], "}"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4720],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"FirstIntegral", "[", "t", "]"}], "\[Rule]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{"V", "[", 
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], ",", 
         RowBox[{"y", "[", "t", "]"}]}], "]"}]}], "+", 
      RowBox[{"m", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}], "2"]}], ")"}]}]}], 
     ")"}]}]}], "}"}]], "Output",
 ImageSize->{396, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9079]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23656],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["FirstIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:VariationalMethods/ref/FirstIntegral"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->25713]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10557],

Cell[TextData[ButtonBox["Variational Methods",
 BaseStyle->"Link",
 ButtonData->
  "paclet:VariationalMethods/tutorial/VariationalMethods"]], "Tutorials",
 CellID->15561]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FirstIntegrals - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 51.5595886}", "context" -> 
    "VariationalMethods`", "keywords" -> {}, "index" -> True, "label" -> 
    "Variational Methods Package Symbol", "language" -> "en", "paclet" -> 
    "VariationalMethods Package", "status" -> "None", "summary" -> 
    "FirstIntegrals[f, x[t], t] returns a list of first integrals \
corresponding to the coordinate x[t] and independent variable t of the \
integrand f. FirstIntegrals[f, {x[t], y[t], ...}, t] returns a list of first \
integrals corresponding to the coordinates x, y, ... and independent variable \
t.", "synonyms" -> {}, "title" -> "FirstIntegrals", "type" -> "Symbol", "uri" -> 
    "VariationalMethods/ref/FirstIntegrals"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6543, 225, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->371326239]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16300, 582}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1246, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1869, 61, 52, 1, 70, "ObjectName",
 CellID->15590],
Cell[1924, 64, 1771, 56, 70, "Usage",
 CellID->21480]
}, Open  ]],
Cell[CellGroupData[{
Cell[3732, 125, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4210, 142, 141, 4, 70, "Notes",
 CellID->17408],
Cell[4354, 148, 643, 20, 70, "Notes",
 CellID->15505],
Cell[5000, 170, 401, 12, 70, "Notes",
 CellID->32702],
Cell[5404, 184, 278, 6, 70, "Notes",
 CellID->22858],
Cell[5685, 192, 821, 28, 70, "Notes",
 CellID->9818]
}, Closed]],
Cell[CellGroupData[{
Cell[6543, 225, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->371326239],
Cell[CellGroupData[{
Cell[6928, 239, 148, 5, 70, "ExampleSection",
 CellID->362339915],
Cell[7079, 246, 143, 4, 70, "Input",
 CellID->556865822],
Cell[7225, 252, 117, 3, 70, "ExampleText",
 CellID->26467],
Cell[7345, 257, 588, 21, 70, "Input",
 CellID->11320],
Cell[7936, 280, 322, 9, 70, "ExampleText",
 CellID->7358],
Cell[CellGroupData[{
Cell[8283, 293, 275, 9, 70, "Input",
 CellID->21074],
Cell[8561, 304, 1272, 40, 73, "Output",
 CellID->3987]
}, Open  ]],
Cell[9848, 347, 120, 3, 70, "ExampleDelimiter",
 CellID->9094],
Cell[9971, 352, 143, 4, 70, "Input",
 CellID->445167129],
Cell[10117, 358, 329, 11, 70, "ExampleText",
 CellID->4983],
Cell[10449, 371, 299, 11, 70, "Input",
 CellID->21364],
Cell[10751, 384, 215, 9, 70, "ExampleText",
 CellID->27264],
Cell[CellGroupData[{
Cell[10991, 397, 168, 5, 70, "Input",
 CellID->19714],
Cell[11162, 404, 542, 19, 62, "Output",
 CellID->26746]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11753, 429, 233, 7, 70, "ExampleSection",
 CellID->16128],
Cell[11989, 438, 143, 4, 70, "Input",
 CellID->187353640],
Cell[12135, 444, 156, 4, 70, "ExampleText",
 CellID->19948],
Cell[CellGroupData[{
Cell[12316, 452, 671, 23, 70, "Input",
 CellID->4720],
Cell[12990, 477, 881, 29, 51, "Output",
 CellID->9079]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13932, 513, 311, 9, 70, "SeeAlsoSection",
 CellID->23656],
Cell[14246, 524, 225, 6, 70, "SeeAlso",
 CellID->25713]
}, Open  ]],
Cell[CellGroupData[{
Cell[14508, 535, 314, 9, 70, "TutorialsSection",
 CellID->10557],
Cell[14825, 546, 170, 4, 70, "Tutorials",
 CellID->15561]
}, Open  ]],
Cell[15010, 553, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

