(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18281,        624]
NotebookOptionsPosition[     14481,        513]
NotebookOutlinePosition[     16567,        560]
CellTagsIndexPosition[     16482,        555]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VARIATIONAL METHODS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Variational Methods" :> 
          Documentation`HelpLookup[
           "paclet:VariationalMethods/tutorial/VariationalMethods"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Variational Methods\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NVariationalBound" :> 
          Documentation`HelpLookup[
           "paclet:VariationalMethods/ref/NVariationalBound"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"NVariationalBound\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["VariationalBound", "ObjectName",
 CellID->19443],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"VariationalBound", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{
         StyleBox["u", "TI"], "[", 
         RowBox[{
          RowBox[{
           StyleBox["x", "TI"], 
           RowBox[{"]", ","}], 
           RowBox[{"{", 
            RowBox[{
             StyleBox["x", "TI"], ",", 
             SubscriptBox[
              StyleBox["x", "TI"], 
              StyleBox["min", "TI"]], ",", 
             SubscriptBox[
              StyleBox["x", "TI"], 
              StyleBox["max", "TI"]]}], "}"}]}], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["t", "TI"]], ",", 
          RowBox[{"{", 
           StyleBox["a", "TI"], "}"}], ",", 
          RowBox[{"{", 
           StyleBox["b", "TI"], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TI"]}], "]"}]}]}]], "InlineFormula"],
     "\[LineSeparator]finds values of the parameters ",
     Cell[BoxData[
      RowBox[{
       StyleBox["a", "TI"], ",", 
       StyleBox["b", "TI"], ",", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     " of a trial function ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["t", "TI"]]], "InlineFormula"],
     " that extremize the functional ",
     Cell[BoxData[
      RowBox[{
       SubsuperscriptBox["\[Integral]", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["min", "TI"]], 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["max", "TI"]]], 
       RowBox[{
        UnderscriptBox[
         StyleBox["f", "TI"], "\[InvisibleSpace]"], 
        RowBox[{"\[DifferentialD]", 
         StyleBox["x", "TI"]}]}]}]], "InlineFormula"],
     ", where the integrand ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " is a function of ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     ", its derivatives, and ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"VariationalBound", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{
         StyleBox["u", "TI"], "[", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            StyleBox["x", "TI"], ",", 
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["min", "TI"]], ",", 
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["max", "TI"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            StyleBox["y", "TI"], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["min", "TI"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["max", "TI"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        SubscriptBox[
         StyleBox["u", "TI"], 
         StyleBox["t", "TI"]], ",", 
        RowBox[{"{", 
         StyleBox["a", "TI"], "}"}], ",", 
        RowBox[{"{", 
         StyleBox["b", "TI"], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]finds values of the parameters of a trial function of \
two or more variables."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"VariationalBound", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["f", "TI"], ",", 
          StyleBox["g", "TI"]}], "}"}], ",", 
        RowBox[{
         StyleBox["u", "TI"], "[", 
         StyleBox["x", "TI"], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        SubscriptBox[
         StyleBox["u", "TI"], 
         StyleBox["t", "TI"]], ",", 
        RowBox[{"{", 
         StyleBox["a", "TI"], "}"}], ",", 
        RowBox[{"{", 
         StyleBox["b", "TI"], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]finds values of the parameters that extremize the \
ratio ",
     Cell[BoxData[
      RowBox[{
       SubsuperscriptBox["\[Integral]", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["min", "TI"]], 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["max", "TI"]]], 
       RowBox[{
        UnderscriptBox[
         StyleBox["f", "TI"], "\[InvisibleSpace]"], 
        RowBox[{
         RowBox[{"\[DifferentialD]", 
          StyleBox["x", "TI"]}], 
         StyleBox["/", "TI"], 
         RowBox[{
          SubsuperscriptBox["\[Integral]", 
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["min", "TI"]], 
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["max", "TI"]]], 
          RowBox[{
           UnderscriptBox[
            StyleBox["g", "TI"], "\[InvisibleSpace]"], 
           RowBox[{"\[DifferentialD]", 
            StyleBox["x", "TI"]}]}]}]}]}]}]], "InlineFormula"],
     ", where the integrands ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " are functions of ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     ", its derivatives, and ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->6824]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["VariationalBound"], "InlineFormula"],
 " returns the extremal value of the functional as well as the optimal \
parameter values."
}], "Notes",
 CellID->31999],

Cell[TextData[{
 "By default, the parameters ",
 Cell[BoxData[
  RowBox[{
   StyleBox["a", "TI"], ",", 
   StyleBox["b", "TI"], ",", 
   StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
 " may range over the interval ",
 Cell[BoxData[
  RowBox[{"-", "\[Infinity]"}]], "InlineFormula"],
 " to ",
 Cell[BoxData["\[Infinity]"], "InlineFormula"],
 ". A parameter specification of ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    SubscriptBox[
     StyleBox["a", "TI"], 
     StyleBox["min", "TI"]], ",", 
    SubscriptBox[
     StyleBox["a", "TI"], 
     StyleBox["max", "TI"]]}], "}"}]], "InlineFormula"],
 " can be used to restrict the range to the interval ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 "."
}], "Notes",
 CellID->28422]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->407361270],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->55455061],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VariationalMethods`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->656726918],

Cell["\<\
Eigenvalue problem for a fourth order ordinary differential equation:\
\>", "ExampleText",
 CellID->465509604],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"eqn", " ", "=", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "''''"}], "[", "x", "]"}], " ", "+", 
      RowBox[{"Pi", " ", 
       RowBox[{
        RowBox[{"y", "''"}], "[", "x", "]"}]}], " ", "+", " ", 
      RowBox[{"5", "  ", 
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}]}]}], " ", "\[Equal]", 
     RowBox[{"\[Lambda]", " ", 
      RowBox[{"y", "[", "x", "]"}]}]}]}], ";"}], " "}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24687720],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"VariationalBound", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], " ", 
       RowBox[{"eqn", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ",", " ", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "^", "2"}]}], "}"}], ",", " ", 
    RowBox[{"y", "[", "x", "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}], ",", " ", 
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"c", " ", "x"}], ")"}]}], ",", " ", 
    RowBox[{"{", "c", "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->496150263],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.7456497360186531`"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", "\[Rule]", 
     RowBox[{"-", "0.6337388575670625`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{187, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->14755012]
}, Open  ]],

Cell["The solution fits the equation well in this case:", "ExampleText",
 CellID->612009702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "[", "x_", "]"}], " ", "=", " ", 
  RowBox[{
   RowBox[{"E", "^", 
    RowBox[{"(", 
     RowBox[{"c", " ", "x"}], ")"}]}], "/.", 
   RowBox[{"sol", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->340536490],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{
   RowBox[{"-", "0.6337388575670625`"}], " ", "x"}]]], "Output",
 ImageSize->{64, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->115160375]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"eqn", "[", 
     RowBox[{"[", "1", "]"}], "]"}], " ", "-", 
    RowBox[{"eqn", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "/.", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]", " ", "\[Rule]", " ", 
     RowBox[{"sol", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], "}"}]}], "//", "Chop"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->460029263],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->156555799]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", "y", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->275555294]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15793],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["NVariationalBound",
   BaseStyle->"Link",
   ButtonData->"paclet:VariationalMethods/ref/NVariationalBound"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->21873]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->121],

Cell[TextData[ButtonBox["Variational Methods",
 BaseStyle->"Link",
 ButtonData->
  "paclet:VariationalMethods/tutorial/VariationalMethods"]], "Tutorials",
 CellID->15733]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"VariationalBound - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 52.0596014}", "context" -> 
    "VariationalMethods`", "keywords" -> {}, "index" -> True, "label" -> 
    "Variational Methods Package Symbol", "language" -> "en", "paclet" -> 
    "VariationalMethods Package", "status" -> "None", "summary" -> 
    "VariationalBound[f, u[x ], {x, x_min, x_max}, u_t, {a}, {b}, ...] finds \
values of the parameters a, b, ... of a trial function u_t that extremize the \
functional SubsuperscriptBox[\\[Integral], x_min, x_max] UnderscriptBox[f, ] \
\\[DifferentialD]x, where the integrand f is a function of u, its \
derivatives, and x. VariationalBound[f, u[x, y, ...], {{x, x_min, x_max}, {y, \
y_min, y_max}, ...}, u_t, {a}, {b}, ...] finds values of the parameters of a \
trial function of two or more variables. VariationalBound[{f, g}, u[x], {x, \
x_min, x_max}, u_t, {a}, {b}, ...] finds values of the parameters that \
extremize the ratio SubsuperscriptBox[\\[Integral], x_min, x_max] \
UnderscriptBox[f, ] \\[DifferentialD]x/ SubsuperscriptBox[\\[Integral], \
x_min, x_max] UnderscriptBox[g, ] \\[DifferentialD]x, where the integrands f \
and g are functions of u, its derivatives, and x.", "synonyms" -> {}, "title" -> 
    "VariationalBound", "type" -> "Symbol", "uri" -> 
    "VariationalMethods/ref/VariationalBound"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9582, 320, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->407361270]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16339, 548}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1258, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1881, 61, 54, 1, 70, "ObjectName",
 CellID->19443],
Cell[1938, 64, 5960, 187, 70, "Usage",
 CellID->6824]
}, Open  ]],
Cell[CellGroupData[{
Cell[7935, 256, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8413, 273, 189, 5, 70, "Notes",
 CellID->31999],
Cell[8605, 280, 940, 35, 70, "Notes",
 CellID->28422]
}, Closed]],
Cell[CellGroupData[{
Cell[9582, 320, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->407361270],
Cell[CellGroupData[{
Cell[9967, 334, 147, 5, 70, "ExampleSection",
 CellID->55455061],
Cell[10117, 341, 143, 4, 70, "Input",
 CellID->656726918],
Cell[10263, 347, 120, 3, 70, "ExampleText",
 CellID->465509604],
Cell[10386, 352, 523, 17, 70, "Input",
 CellID->24687720],
Cell[CellGroupData[{
Cell[10934, 373, 662, 20, 47, "Input",
 CellID->496150263],
Cell[11599, 395, 334, 11, 36, "Output",
 CellID->14755012]
}, Open  ]],
Cell[11948, 409, 92, 1, 70, "ExampleText",
 CellID->612009702],
Cell[CellGroupData[{
Cell[12065, 414, 286, 10, 70, "Input",
 CellID->340536490],
Cell[12354, 426, 255, 8, 36, "Output",
 CellID->115160375]
}, Open  ]],
Cell[CellGroupData[{
Cell[12646, 439, 398, 13, 70, "Input",
 CellID->460029263],
Cell[13047, 454, 158, 5, 36, "Output",
 CellID->156555799]
}, Open  ]],
Cell[13220, 462, 101, 3, 70, "Input",
 CellID->275555294]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13370, 471, 311, 9, 70, "SeeAlsoSection",
 CellID->15793],
Cell[13684, 482, 233, 6, 70, "SeeAlso",
 CellID->21873]
}, Open  ]],
Cell[CellGroupData[{
Cell[13954, 493, 312, 9, 70, "TutorialsSection",
 CellID->121],
Cell[14269, 504, 170, 4, 70, "Tutorials",
 CellID->15733]
}, Open  ]],
Cell[14454, 511, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

