(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     52895,       1749]
NotebookOptionsPosition[     48211,       1607]
NotebookOutlinePosition[     50355,       1655]
CellTagsIndexPosition[     50312,       1652]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VARIATIONAL METHODS PACKAGE TUTORIAL", "PacletNameCell"], Cell[
    TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"EulerEquations" :> 
         Documentation`HelpLookup[
          "paclet:VariationalMethods/ref/EulerEquations"], "FirstIntegral" :> 
         Documentation`HelpLookup[
          "paclet:VariationalMethods/ref/FirstIntegral"], "FirstIntegrals" :> 
         Documentation`HelpLookup[
          "paclet:VariationalMethods/ref/FirstIntegrals"], 
         "NVariationalBound" :> 
         Documentation`HelpLookup[
          "paclet:VariationalMethods/ref/NVariationalBound"], 
         "VariationalBound" :> 
         Documentation`HelpLookup[
          "paclet:VariationalMethods/ref/VariationalBound"], "VariationalD" :> 
         Documentation`HelpLookup[
          "paclet:VariationalMethods/ref/VariationalD"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"EulerEquations\"\>", 2->"\<\"FirstIntegral\"\>", 
      3->"\<\"FirstIntegrals\"\>", 4->"\<\"NVariationalBound\"\>", 
      5->"\<\"VariationalBound\"\>", 
      6->"\<\"VariationalD\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Variational Methods", "Title",
 CellID->32120],

Cell[TextData[{
 "The basic problem of the calculus of variations is to determine the \
function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["u", "TI"], 
    RowBox[{"(", 
     StyleBox["x", "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
 " that extremizes a functional ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["F", "TI"], "=", 
    SubsuperscriptBox["\[Integral]", 
     StyleBox[
      RowBox[{"x", "m", "i", "n"}], "TI"], 
     StyleBox[
      RowBox[{"x", "m", "a", "x"}], "TI"]], 
    StyleBox["f", "TI"], 
    RowBox[{"[", 
     RowBox[{
      StyleBox["u", "TI"], 
      RowBox[{"(", 
       StyleBox["x", "TI"], ")"}], ",", 
      SuperscriptBox[
       StyleBox["u", "TI"], "\[Prime]"], 
      RowBox[{"(", 
       StyleBox["x", "TI"], ")"}], ",", 
      StyleBox["x", "TI"]}], "]"}], "\[DifferentialD]", 
    StyleBox["x", "TI"]}], TraditionalForm]], "InlineFormula"],
 ". In general, there can be more than one independent variable and the \
integrand ",
 Cell[BoxData[
  FormBox[
   StyleBox["f", "TI"], TraditionalForm]], "InlineFormula"],
 " can depend on several functions and their higher derivatives. "
}], "Text",
 CellID->20801],

Cell[TextData[{
 "The extremal functions are solutions of the Euler(\[Hyphen]Lagrange) \
equations that are obtained by setting the first variational derivatives of \
the functional ",
 Cell[BoxData[
  FormBox[
   StyleBox["F", "TI"], TraditionalForm]], "InlineFormula"],
 " with respect to each function equal to zero. Since many ordinary and \
partial differential equations that occur in physics and engineering can be \
derived as the Euler equations for appropriate functionals, variational \
methods are of general utility. "
}], "Text",
 CellID->16780],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["VariationalD",
      BaseStyle->"Link",
      ButtonData->"paclet:VariationalMethods/ref/VariationalD"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["u", "TI"], "[", 
     StyleBox["x", "TI"], "]", ",", 
     StyleBox["x", "TI"], "]", ",", 
     ButtonBox["VariationalD",
      BaseStyle->"Link",
      ButtonData->"paclet:VariationalMethods/ref/VariationalD"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["u", "TI"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]", ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "give the first variational derivative of the functional ",
     Cell[BoxData[
      StyleBox["F", "TI"]], "InlineFormula"],
     " defined by the integrand ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " depends on one function ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " and one independent variable ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " or several independent variables ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"], ",", "\[Ellipsis]"}]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["VariationalD",
      BaseStyle->"Link",
      ButtonData->"paclet:VariationalMethods/ref/VariationalD"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["u", "TI"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]", ",", 
     StyleBox["v", "TI"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "give a list of the first variational derivatives of the functional ",
     Cell[BoxData[
      StyleBox["F", "TI"]], "InlineFormula"],
     " defined by the integrand ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " depends on several functions ",
     Cell[BoxData[
      RowBox[{
       StyleBox["u", "TI"], ",", 
       StyleBox["v", "TI"], ",", "\[Ellipsis]"}]], "InlineFormula"],
     " and several independent variables ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"], ",", "\[Ellipsis]"}]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["EulerEquations",
      BaseStyle->"Link",
      ButtonData->"paclet:VariationalMethods/ref/EulerEquations"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["u", "TI"], "[", 
     StyleBox["x", "TI"], "]", ",", 
     StyleBox["x", "TI"], "]", ",", 
     ButtonBox["EulerEquations",
      BaseStyle->"Link",
      ButtonData->"paclet:VariationalMethods/ref/EulerEquations"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["u", "TI"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]", ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "give the Euler equation for the integrand ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " depends on one function ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " and one independent variable ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " or several independent variables ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"], ",", "\[Ellipsis]"}]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["EulerEquations",
      BaseStyle->"Link",
      ButtonData->"paclet:VariationalMethods/ref/EulerEquations"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["u", "TI"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]", ",", 
     StyleBox["v", "TI"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "give a list of the Euler equations for the integrand ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " depends on several functions ",
     Cell[BoxData[
      RowBox[{
       StyleBox["u", "TI"], ",", 
       StyleBox["v", "TI"], ",", "\[Ellipsis]"}]], "InlineFormula"],
     " and several independent variables ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"], ",", "\[Ellipsis]"}]], "InlineFormula"],
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->19177],

Cell["First variational derivatives and Euler equations. ", "Caption",
 CellID->2180],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["VariationalD",
   BaseStyle->"Link",
   ButtonData->"paclet:VariationalMethods/ref/VariationalD"]], 
  "InlineFormula"],
 " gives the first variational derivatives of a functional ",
 Cell[BoxData[
  FormBox[
   StyleBox["F", "TI"], TraditionalForm]], "InlineFormula"],
 " defined by the integrand ",
 Cell[BoxData[
  FormBox[
   StyleBox["f", "TI"], TraditionalForm]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  FormBox[
   StyleBox["f", "TI"], TraditionalForm]], "InlineFormula"],
 " may depend on several functions ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["u", "TI"], ",", 
    StyleBox["v", "TI"], ",", 
    StyleBox["w", "TI"], ",", "\[Ellipsis]"}], TraditionalForm]], 
  "InlineFormula"],
 "; their derivatives of arbitrary order; and variables ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["z", "TI"], ",", "\[Ellipsis]"}], TraditionalForm]], 
  "InlineFormula"],
 "\[ThinSpace]. ",
 Cell[BoxData[
  ButtonBox["EulerEquations",
   BaseStyle->"Link",
   ButtonData->"paclet:VariationalMethods/ref/EulerEquations"]], 
  "InlineFormula"],
 " returns the Euler(\[Hyphen]Lagrange) equations given the integrand ",
 Cell[BoxData[
  FormBox[
   StyleBox["f", "TI"], TraditionalForm]], "InlineFormula"],
 ". Again ",
 Cell[BoxData[
  FormBox[
   StyleBox["f", "TI"], TraditionalForm]], "InlineFormula"],
 " may depend on several functions ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["u", "TI"], ",", 
    StyleBox["v", "TI"], ",", 
    StyleBox["w", "TI"], ",", "\[Ellipsis]"}], TraditionalForm]], 
  "InlineFormula"],
 "; their derivatives of arbitrary order; and variables ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["z", "TI"], "\[Ellipsis]"}], TraditionalForm]], 
  "InlineFormula"],
 "\[ThinSpace]. "
}], "Text",
 CellID->18766],

Cell["This loads the package. ", "MathCaption",
 CellID->17937],

Cell[BoxData[
 RowBox[{"<<", "VariationalMethods`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20115],

Cell[TextData[{
 "This is the first variational derivative of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["F", "TI"], "=", 
    SubsuperscriptBox["\[Integral]", 
     StyleBox[
      RowBox[{"x", "m", "i", "n"}], "TI"], 
     StyleBox[
      RowBox[{"x", "m", "a", "x"}], "TI"]], 
    StyleBox["y", "TI"], 
    RowBox[{"(", 
     StyleBox["x", "TI"], ")"}], 
    SqrtBox[
     RowBox[{"1", "+", 
      SuperscriptBox[
       StyleBox["y", "TI"], "\[Prime]"], 
      SuperscriptBox[
       RowBox[{"(", 
        StyleBox["x", "TI"], ")"}], "2"]}]], "\[DifferentialD]", 
    StyleBox["x", "TI"]}], TraditionalForm]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17435],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VariationalD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], " ", 
    SqrtBox[
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["y", "\[Prime]",
         MultilineFunction->None], "[", "x", "]"}], "2"]}]]}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21519],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", 
   SuperscriptBox[
    RowBox[{
     SuperscriptBox["y", "\[Prime]",
      MultilineFunction->None], "[", "x", "]"}], "2"], "-", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], " ", 
    RowBox[{
     SuperscriptBox["y", "\[Prime]\[Prime]",
      MultilineFunction->None], "[", "x", "]"}]}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox[
      RowBox[{
       SuperscriptBox["y", "\[Prime]",
        MultilineFunction->None], "[", "x", "]"}], "2"]}], ")"}], 
   RowBox[{"3", "/", "2"}]]]], "Output",
 ImageSize->{143, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->23655]
}, Open  ]],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  FormBox[
   StyleBox["f", "TI"], TraditionalForm]], "InlineFormula"],
 " is the Lagrangian for the simple pendulum and ",
 Cell[BoxData[
  ButtonBox["EulerEquations",
   BaseStyle->"Link",
   ButtonData->"paclet:VariationalMethods/ref/EulerEquations"]], 
  "InlineFormula"],
 " gives the pendulum equation. "
}], "MathCaption",
 CellID->21640],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EulerEquations", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", "m", " ", 
     SuperscriptBox["l", "2"], " ", 
     SuperscriptBox[
      RowBox[{
       SuperscriptBox["theta", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
    RowBox[{"m", " ", "g", " ", "l", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"theta", "[", "t", "]"}], "]"}]}]}], ",", 
   RowBox[{"theta", "[", "t", "]"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->16342],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "l"}], " ", "m", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"g", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"theta", "[", "t", "]"}], "]"}]}], "+", 
     RowBox[{"l", " ", 
      RowBox[{
       SuperscriptBox["theta", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}], "\[Equal]", 
  "0"}]], "Output",
 ImageSize->{256, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->15574]
}, Open  ]],

Cell[TextData[{
 "This package defines several coordinates systems as well as the ",
 Cell[BoxData[
  ButtonBox["Grad",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Grad"]], "InlineFormula"],
 " function. "
}], "MathCaption",
 CellID->26834],

Cell[BoxData[
 RowBox[{"<<", "VectorAnalysis`"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->13516],

Cell[TextData[{
 "The default coordinate system is set to ",
 Cell[BoxData[
  ButtonBox["Cartesian",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Cartesian"]], "InlineFormula"],
 " and the coordinates are set to ",
 Cell[BoxData[
  FormBox[
   StyleBox["x", "TI"], TraditionalForm]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["y", "TI"], TraditionalForm]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  FormBox[
   StyleBox["z", "TI"], TraditionalForm]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->30335],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetCoordinates", "[", 
   RowBox[{"Cartesian", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], "]"}], ";"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->7214],

Cell["\<\
This generates Laplace\[CloseCurlyQuote]s equation. \
\>", "MathCaption",
 CellID->6079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EulerEquations", "[", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{
     RowBox[{"Grad", "[", 
      RowBox[{"phi", "[", 
       RowBox[{"x", ",", "y", ",", "z"}], "]"}], "]"}], ".", 
     RowBox[{"Grad", "[", 
      RowBox[{"phi", "[", 
       RowBox[{"x", ",", "y", ",", "z"}], "]"}], "]"}]}]}], ",", 
   RowBox[{"phi", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->6246],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    RowBox[{
     SuperscriptBox["phi", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "-", 
   RowBox[{
    SuperscriptBox["phi", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "2", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], "-", 
   RowBox[{
    SuperscriptBox["phi", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"2", ",", "0", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "\[Equal]", "0"}]], "Output",
 ImageSize->{403, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->4031]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FirstIntegrals",
      BaseStyle->"Link",
      ButtonData->"paclet:VariationalMethods/ref/FirstIntegrals"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["u", "TI"], "[", 
     StyleBox["x", "TI"], "]", ",", 
     StyleBox["x", "TI"], "]", ",", 
     ButtonBox["FirstIntegrals",
      BaseStyle->"Link",
      ButtonData->"paclet:VariationalMethods/ref/FirstIntegrals"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["u", "TI"], "[", 
     StyleBox["x", "TI"], "]", ",", 
     StyleBox["v", "TI"], "[", 
     StyleBox["x", "TI"], "]", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "give first integrals when the integrand ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " is independent of one or more of ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["u", "TI"], "[", 
       StyleBox["x", "TI"], "]", ",", 
       StyleBox["v", "TI"], "[", 
       StyleBox["x", "TI"], "]", ",", 
       StyleBox["\[Ellipsis]", "TR"], "}"}]], "InlineFormula"],
     ", or independent of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FirstIntegral",
      BaseStyle->"Link",
      ButtonData->"paclet:VariationalMethods/ref/FirstIntegral"], "[", 
     StyleBox["u", "TI"], "]"}], Cell[TextData[{
     "first integral associated with the variable ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " (appears in the output of ",
     StyleBox[ButtonBox["FirstIntegrals",
      BaseStyle->"Link",
      ButtonData->"paclet:VariationalMethods/ref/FirstIntegrals"], 
      "InlineCode"],
     ") "
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->31518],

Cell["First integrals. ", "Caption",
 CellID->14718],

Cell[TextData[{
 "When there is only one independent variable ",
 Cell[BoxData[
  FormBox[
   StyleBox["x", "TI"], TraditionalForm]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FirstIntegrals",
   BaseStyle->"Link",
   ButtonData->"paclet:VariationalMethods/ref/FirstIntegrals"]], 
  "InlineFormula"],
 " gives conserved quantities in the following cases: \
(1)\[NonBreakingSpace]if ",
 Cell[BoxData[
  FormBox[
   StyleBox["f", "TI"], TraditionalForm]], "InlineFormula"],
 " does not depend on a coordinate ",
 Cell[BoxData[
  FormBox[
   StyleBox["u", "TI"], TraditionalForm]], "InlineFormula"],
 " explicitly, it is referred to as an ignorable coordinate and the \
corresponding Euler equation possesses an obvious first integral (a conserved \
generalized momentum), and (2)\[NonBreakingSpace]if ",
 Cell[BoxData[
  FormBox[
   StyleBox["f", "TI"], TraditionalForm]], "InlineFormula"],
 " depends on ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["u", "TI"], ",", 
    StyleBox["v", "TI"], ",", "\[Ellipsis]"}], TraditionalForm]], 
  "InlineFormula"],
 " and their first derivatives only and has no explicit ",
 Cell[BoxData[
  FormBox[
   StyleBox["x", "TI"], TraditionalForm]], "InlineFormula"],
 " dependence, ",
 Cell[BoxData[
  ButtonBox["FirstIntegrals",
   BaseStyle->"Link",
   ButtonData->"paclet:VariationalMethods/ref/FirstIntegrals"]], 
  "InlineFormula"],
 " also returns the first integral corresponding to the Hamiltonian. "
}], "Text",
 CellID->24244],

Cell[TextData[{
 "The Lagrangian for central force motion has an ignorable coordinate ",
 Cell[BoxData[
  FormBox["\[Phi]", TraditionalForm]], "InlineFormula"],
 " (angular momentum conservation) and is independent of time ",
 Cell[BoxData[
  FormBox[
   StyleBox["t", "TI"], TraditionalForm]], "InlineFormula"],
 " (energy conservation). ",
 Cell[BoxData[
  ButtonBox["FirstIntegrals",
   BaseStyle->"Link",
   ButtonData->"paclet:VariationalMethods/ref/FirstIntegrals"]], 
  "InlineFormula"],
 " yields both the first integral corresponding to coordinate ",
 Cell[BoxData[
  FormBox["\[Phi]", TraditionalForm]], "InlineFormula"],
 " and the first integral corresponding to the Hamiltonian. "
}], "MathCaption",
 CellID->17790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FirstIntegrals", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", "m", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{
         SuperscriptBox["r", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "2"], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"r", "[", "t", "]"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["phi", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "2"]}]}], ")"}]}], "-", 
    
    RowBox[{"U", "[", "r", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"r", "[", "t", "]"}], ",", 
     RowBox[{"phi", "[", "t", "]"}]}], "}"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->26511],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"FirstIntegral", "[", "phi", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", "m"}], " ", 
     SuperscriptBox[
      RowBox[{"r", "[", "t", "]"}], "2"], " ", 
     RowBox[{
      SuperscriptBox["phi", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"FirstIntegral", "[", "t", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"U", "[", "r", "]"}]}], "+", 
       RowBox[{"m", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox[
            RowBox[{"r", "[", "t", "]"}], "2"], " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["phi", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
          SuperscriptBox[
           RowBox[{
            SuperscriptBox["r", "\[Prime]",
             MultilineFunction->None], "[", "t", "]"}], "2"]}], ")"}]}]}], 
      ")"}]}]}]}], "}"}]], "Output",
 ImageSize->{386, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->12052]
}, Open  ]],

Cell[TextData[{
 "The Ritz variational principle affords a powerful technique for the \
approximate solution of (1)\[NonBreakingSpace]eigenvalue problems ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["A", "TB"], 
    StyleBox["u", "TI"], "=", "\[Lambda]", 
    StyleBox["w", "TI"], 
    StyleBox["u", "TI"]}], TraditionalForm]], "InlineFormula"],
 " where ",
 Cell[BoxData[
  FormBox[
   StyleBox["A", "TB"], TraditionalForm]], "InlineFormula"],
 " is an operator and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["w", "TI"], 
    RowBox[{"(", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"], ",", "\[Ellipsis]"}], ")"}]}], TraditionalForm]], 
  "InlineFormula"],
 " is a weight function and (2)\[NonBreakingSpace]problems of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["B", "TB"], 
    StyleBox["u", "TI"], 
    RowBox[{"(", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"], ",", "\[Ellipsis]"}], ")"}], "=", 
    StyleBox["h", "TI"], 
    RowBox[{"(", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"], ",", "\[Ellipsis]"}], ")"}]}], TraditionalForm]], 
  "InlineFormula"],
 " where ",
 Cell[BoxData[
  FormBox[
   StyleBox["B", "TB"], TraditionalForm]], "InlineFormula"],
 " is a positive definite operator and ",
 Cell[BoxData[
  FormBox[
   StyleBox["h", "TI"], TraditionalForm]], "InlineFormula"],
 " is given. A judicious choice for the trial function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["u", "TI"], 
     StyleBox["t", "TI"]], 
    RowBox[{"(", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"], ",", "\[Ellipsis]"}], ")"}]}], TraditionalForm]], 
  "InlineFormula"],
 " that satisfies boundary conditions and depends on variational parameters \
",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], ",", "\[Ellipsis]"}], "}"}], TraditionalForm]], 
  "InlineFormula"],
 " must be given in both cases. For (1) ",
 StyleBox[ButtonBox["VariationalBound[{",
  BaseStyle->"Link",
  ButtonData->"paclet:VariationalMethods/ref/VariationalBound"], "MR"],
 StyleBox[ButtonBox["f",
  BaseStyle->"Link",
  ButtonData->"paclet:VariationalMethods/ref/VariationalBound"], "TI"],
 StyleBox[ButtonBox[",",
  BaseStyle->"Link",
  ButtonData->"paclet:VariationalMethods/ref/VariationalBound"], "MR"],
 StyleBox[ButtonBox["g",
  BaseStyle->"Link",
  ButtonData->"paclet:VariationalMethods/ref/VariationalBound"], "TI"],
 StyleBox[ButtonBox["},",
  BaseStyle->"Link",
  ButtonData->"paclet:VariationalMethods/ref/VariationalBound"], "MR"],
 " ",
 StyleBox["u", "TI"],
 StyleBox["[", "MR"],
 StyleBox["x", "TI"],
 StyleBox[",", "MR"],
 StyleBox["y", "TI"],
 StyleBox[",", "MR"],
 "\[Ellipsis] ",
 StyleBox["],", "MR"],
 " ",
 StyleBox["{{", "MR"],
 StyleBox["x", "TI"],
 StyleBox[",", "MR"],
 StyleBox["xmin", "TI"],
 StyleBox[",", "MR"],
 StyleBox["xmax", "TI"],
 StyleBox["},", "MR"],
 " ",
 StyleBox["{", "MR"],
 StyleBox["y", "TI"],
 StyleBox[",", "MR"],
 StyleBox["ymin", "TI"],
 StyleBox[",", "MR"],
 StyleBox["ymax", "TI"],
 StyleBox["},", "MR"],
 "\[Ellipsis] ",
 StyleBox["},", "MR"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["u", "TI"], 
    StyleBox["t", "TI"]], TraditionalForm]], "InlineFormula"],
 StyleBox[",", "MR"],
 " ",
 StyleBox["{", "MR"],
 StyleBox["a", "TI"],
 StyleBox[",", "MR"],
 StyleBox["amin", "TI"],
 StyleBox[",", "MR"],
 StyleBox["amax", "TI"],
 StyleBox["},", "MR"],
 " ",
 StyleBox["{", "MR"],
 StyleBox["b", "TI"],
 StyleBox[",", "MR"],
 StyleBox["bmin", "TI"],
 StyleBox[",", "MR"],
 StyleBox["bmax", "TI"],
 StyleBox["},", "MR"],
 " \[Ellipsis] ",
 StyleBox["]", "MR"],
 " extremizes ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SubsuperscriptBox["\[Integral]", 
       StyleBox[
        RowBox[{"x", "m", "i", "n"}], "TI"], 
       StyleBox[
        RowBox[{"x", "m", "a", "x"}], "TI"]], "\[DifferentialD]", 
      StyleBox["x", "TI"], 
      SubsuperscriptBox["\[Integral]", 
       StyleBox[
        RowBox[{"y", "m", "i", "n"}], "TI"], 
       StyleBox[
        RowBox[{"y", "m", "a", "x"}], "TI"]], "\[DifferentialD]", 
      StyleBox["y", "TI"], "\[Ellipsis]", 
      StyleBox["f", "TI"]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      SubsuperscriptBox["\[Integral]", 
       StyleBox[
        RowBox[{"x", "m", "i", "n"}], "TI"], 
       StyleBox[
        RowBox[{"x", "m", "a", "x"}], "TI"]], "\[DifferentialD]", 
      StyleBox["x", "TI"], 
      SubsuperscriptBox["\[Integral]", 
       StyleBox[
        RowBox[{"y", "m", "i", "n"}], "TI"], 
       StyleBox[
        RowBox[{"y", "m", "a", "x"}], "TI"]], "\[DifferentialD]", 
      StyleBox["y", "TI"], "\[Ellipsis]", 
      StyleBox["g", "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
 " where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["f", "TI"], "=", 
    StyleBox["u", "TI"], 
    StyleBox["A", "TB"], 
    StyleBox["u", "TI"]}], TraditionalForm]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["g", "TI"], "=", 
    StyleBox["u", "TI"], 
    StyleBox["w", "TI"], 
    StyleBox["u", "TI"]}], TraditionalForm]], "InlineFormula"],
 ". The result is an upper bound on the corresponding eigenvalue and optimal \
values for the parameters. For (2) ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VariationalBound",
    BaseStyle->"Link",
    ButtonData->"paclet:VariationalMethods/ref/VariationalBound"], "[", 
   StyleBox["f", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["u", "TI"], 
   StyleBox["[", "TI"], 
   StyleBox["x", "TI"], 
   StyleBox[",", "TI"], 
   StyleBox["y", "TI"], 
   StyleBox[",", "TI"], "\[Ellipsis]", " ", 
   StyleBox[
    RowBox[{"]", ","}], "TI"], " ", 
   StyleBox[
    RowBox[{"{", "{"}], "TI"], 
   StyleBox["x", "TI"], 
   StyleBox[",", "TI"], 
   StyleBox["xmin", "TI"], 
   StyleBox[",", "TI"], 
   StyleBox["xmax", "TI"], 
   StyleBox[
    RowBox[{"}", ",", "{"}], "TI"], 
   StyleBox["y", "TI"], 
   StyleBox[",", "TI"], 
   StyleBox["ymin", "TI"], 
   StyleBox[",", "TI"], 
   StyleBox["ymax", "TI"], 
   StyleBox[
    RowBox[{"}", ","}], "TI"], "\[Ellipsis]", " ", 
   StyleBox[
    RowBox[{"}", ","}], "TI"], " ", Cell[BoxData[
    FormBox[
     SubscriptBox[
      StyleBox["u", "TI"], 
      StyleBox["t", "TI"]], TraditionalForm]], "InlineFormula"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["{", "TI"], 
   StyleBox["a", "TI"], 
   StyleBox[",", "TI"], 
   StyleBox["amin", "TI"], 
   StyleBox[",", "TI"], 
   StyleBox["amax", "TI"], 
   StyleBox[
    RowBox[{"}", ","}], "TI"], " ", 
   StyleBox["{", "TI"], 
   StyleBox["b", "TI"], 
   StyleBox[",", "TI"], 
   StyleBox["bmin", "TI"], 
   StyleBox[",", "TI"], 
   StyleBox["bmax", "TI"], 
   StyleBox[
    RowBox[{"}", ","}], "TI"], " ", "\[Ellipsis]", " ", "]"}]], 
  "InlineFormula"],
 " extremizes the functional ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["F", "TI"], "=", 
    SubsuperscriptBox["\[Integral]", 
     StyleBox[
      RowBox[{"x", "m", "i", "n"}], "TI"], 
     StyleBox[
      RowBox[{"x", "m", "a", "x"}], "TI"]], "\[DifferentialD]", 
    StyleBox["x", "TI"], 
    SubsuperscriptBox["\[Integral]", 
     StyleBox[
      RowBox[{"y", "m", "i", "n"}], "TI"], 
     StyleBox[
      RowBox[{"y", "m", "a", "x"}], "TI"]], "\[DifferentialD]", 
    StyleBox["y", "TI"], "\[Ellipsis]", 
    StyleBox["f", "TI"]}], TraditionalForm]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["f", "TI"], "=", 
    StyleBox["u", "TI"], 
    StyleBox["B", "TB"], 
    StyleBox["u", "TI"], " ", "-", "2", 
    StyleBox["u", "TI"], 
    StyleBox["h", "TI"]}], TraditionalForm]], "InlineFormula"],
 " and yields the value of the functional and the optimal parameters. ",
 Cell[BoxData[
  ButtonBox["VariationalBound",
   BaseStyle->"Link",
   ButtonData->"paclet:VariationalMethods/ref/VariationalBound"]], 
  "InlineFormula"],
 " can also be used to extremize general functionals given appropriate trial \
functions. ",
 Cell[BoxData[
  ButtonBox["NVariationalBound",
   BaseStyle->"Link",
   ButtonData->"paclet:VariationalMethods/ref/NVariationalBound"]], 
  "InlineFormula"],
 " performs the same functions as ",
 Cell[BoxData[
  ButtonBox["VariationalBound",
   BaseStyle->"Link",
   ButtonData->"paclet:VariationalMethods/ref/VariationalBound"]], 
  "InlineFormula"],
 " numerically. It uses the internal function ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " and has the same options and input format for parameters. "
}], "Text",
 CellID->27905],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["VariationalBound",
      BaseStyle->"Link",
      ButtonData->"paclet:VariationalMethods/ref/VariationalBound"], "[", "{",
      
     StyleBox["f", "TI"], ",", 
     StyleBox["g", "TI"], "}", ",", 
     StyleBox["u", "TI"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]", ",", "{", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["xmin", "TI"], ",", 
     StyleBox["xmax", "TI"], "}", ",", "{", 
     StyleBox["y", "TI"], ",", 
     StyleBox["ymin", "TI"], ",", 
     StyleBox["ymax", "TI"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     SubscriptBox[
      StyleBox["u", "TI"], 
      StyleBox["t", "TI"]], Cell[",", "TableText"]}], "\[SpanFromLeft]"},
   {"", "\[Null]"},
   {
    RowBox[{"{", 
     StyleBox["a", "TI"], ",", 
     StyleBox["amin", "TI"], ",", 
     StyleBox["amax", "TI"], "}", ",", "{", 
     StyleBox["b", "TI"], ",", 
     StyleBox["bmin", "TI"], ",", 
     StyleBox["bmax", "TI"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "give an upper bound for the eigenvalue and the optimal values of ",
     Cell[BoxData[
      RowBox[{
       StyleBox["a", "TI"], ",", 
       StyleBox["b", "TI"], ",", "\[Ellipsis]"}]], "InlineFormula"],
     " in the range ",
     Cell[BoxData["{"], "InlineFormula"],
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["a", "TI"], 
       StyleBox["m", "TI"], 
       StyleBox["i", "TI"], 
       StyleBox["n", "TI"], ",", 
       StyleBox["a", "TI"], 
       StyleBox["m", "TI"], 
       StyleBox["a", "TI"], 
       StyleBox["x", "TI"], "}"}]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["b", "TI"], 
       StyleBox["m", "TI"], 
       StyleBox["i", "TI"], 
       StyleBox["n", "TI"], ",", 
       StyleBox["b", "TI"], 
       StyleBox["m", "TI"], 
       StyleBox["a", "TI"], 
       StyleBox["x", "TI"], "}"}]], "InlineFormula"],
     ",\[ThinSpace]",
     Cell[BoxData[
      RowBox[{"\[Ellipsis]", " "}]], "InlineFormula"],
     Cell[BoxData["}"], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["VariationalBound",
      BaseStyle->"Link",
      ButtonData->"paclet:VariationalMethods/ref/VariationalBound"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["u", "TI"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]", ",", "{", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["xmin", "TI"], ",", 
     StyleBox["xmax", "TI"], "}", ",", "{", 
     StyleBox["y", "TI"], ",", 
     StyleBox["ymin", "TI"], ",", 
     StyleBox["ymax", "TI"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     SubscriptBox[
      StyleBox["u", "TI"], 
      StyleBox["t", "TI"]], Cell[",", "TableText"]}], "\[SpanFromLeft]"},
   {"", "\[Null]"},
   {
    RowBox[{"{", 
     StyleBox["a", "TI"], ",", 
     StyleBox["amin", "TI"], ",", 
     StyleBox["amax", "TI"], "}", ",", "{", 
     StyleBox["b", "TI"], ",", 
     StyleBox["bmin", "TI"], ",", 
     StyleBox["bmax", "TI"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "give the value of the functional and optimal values of ",
     Cell[BoxData[
      RowBox[{
       StyleBox["a", "TI"], ",", 
       StyleBox["b", "TI"], ",", "\[Ellipsis]"}]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NVariationalBound",
      BaseStyle->"Link",
      ButtonData->"paclet:VariationalMethods/ref/NVariationalBound"], "[", 
     "{", 
     StyleBox["f", "TI"], ",", 
     StyleBox["g", "TI"], "}", ",", 
     StyleBox["u", "TI"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]", ",", "{", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["xmin", "TI"], ",", 
     StyleBox["xmax", "TI"], "}", ",", "{", 
     StyleBox["y", "TI"], ",", 
     StyleBox["ymin", "TI"], ",", 
     StyleBox["ymax", "TI"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     SubscriptBox[
      StyleBox["u", "TI"], 
      StyleBox["t", "TI"]], Cell[",", "TableText"]}], "\[SpanFromLeft]"},
   {"", "\[Null]"},
   {
    RowBox[{"{", 
     StyleBox["a", "TI"], ",", 
     SubscriptBox[
      StyleBox["a", "TI"], "0"], ",", 
     StyleBox["amin", "TI"], ",", 
     StyleBox["amax", "TI"], "}", ",", "{", 
     StyleBox["b", "TI"], ",", 
     SubscriptBox[
      StyleBox["b", "TI"], "0"], ",", 
     StyleBox["bmin", "TI"], ",", 
     StyleBox["bmax", "TI"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "evaluate numerically an upper bound for the eigenvalue and the optimal \
values of ",
     Cell[BoxData[
      RowBox[{
       StyleBox["a", "TI"], ",", 
       StyleBox["b", "TI"], ",", "\[Ellipsis]"}]], "InlineFormula"],
     " in the range ",
     Cell[BoxData["{"], "InlineFormula"],
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["a", "TI"], 
       StyleBox["m", "TI"], 
       StyleBox["i", "TI"], 
       StyleBox["n", "TI"], ",", 
       StyleBox["a", "TI"], 
       StyleBox["m", "TI"], 
       StyleBox["a", "TI"], 
       StyleBox["x", "TI"], "}"}]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["b", "TI"], 
       StyleBox["m", "TI"], 
       StyleBox["i", "TI"], 
       StyleBox["n", "TI"], ",", 
       StyleBox["b", "TI"], 
       StyleBox["m", "TI"], 
       StyleBox["a", "TI"], 
       StyleBox["x", "TI"], "}"}]], "InlineFormula"],
     ",\[ThinSpace]",
     Cell[BoxData[
      RowBox[{"\[Ellipsis]", " "}]], "InlineFormula"],
     Cell[BoxData["}"], "InlineFormula"],
     " given initial values ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["a", "TI"], "0"], ",", 
       SubscriptBox[
        StyleBox["b", "TI"], "0"], ",", "\[Ellipsis]"}]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NVariationalBound",
      BaseStyle->"Link",
      ButtonData->"paclet:VariationalMethods/ref/NVariationalBound"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["u", "TI"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]", ",", "{", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["xmin", "TI"], ",", 
     StyleBox["xmax", "TI"], "}", ",", "{", 
     StyleBox["y", "TI"], ",", 
     StyleBox["ymin", "TI"], ",", 
     StyleBox["ymax", "TI"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     SubscriptBox[
      StyleBox["u", "TI"], 
      StyleBox["t", "TI"]], Cell[",", "TableText"]}], "\[SpanFromLeft]"},
   {"", "\[Null]"},
   {
    RowBox[{"{", 
     StyleBox["a", "TI"], ",", 
     SubscriptBox[
      StyleBox["a", "TI"], "0"], ",", 
     StyleBox["amin", "TI"], ",", 
     StyleBox["amax", "TI"], "}", ",", "{", 
     StyleBox["b", "TI"], ",", 
     SubscriptBox[
      StyleBox["b", "TI"], "0"], ",", 
     StyleBox["bmin", "TI"], ",", 
     StyleBox["bmax", "TI"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "evaluate numerically the value of the functional and optimal values of \
",
     Cell[BoxData[
      RowBox[{
       StyleBox["a", "TI"], ",", 
       StyleBox["b", "TI"], ",", "\[Ellipsis]"}]], "InlineFormula"],
     " given initial values ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["a", "TI"], "0"], ",", 
       SubscriptBox[
        StyleBox["b", "TI"], "0"], ",", "\[Ellipsis]"}]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->14967],

Cell["Ritz variational bounds. ", "Caption",
 CellID->11845],

Cell[TextData[{
 "A trial (wave) function for the 2s state of the hydrogen atom with one node \
at ",
 Cell[BoxData[
  FormBox[
   StyleBox["a", "TI"], TraditionalForm]], "InlineFormula"],
 " yields the exact energy in units of ",
 Cell[BoxData[
  ButtonBox["Rydberg",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Rydberg"]], "InlineFormula"],
 ". Note that the volume element ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["r", "TI"], "2"], TraditionalForm]], "InlineFormula"],
 " is included in functional parameters ",
 Cell[BoxData[
  FormBox[
   StyleBox["f", "TI"], TraditionalForm]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["g", "TI"], TraditionalForm]], "InlineFormula"],
 ", and the default range for the parameters is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], ")"}], 
   TraditionalForm]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->23613],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VariationalBound", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"u", "[", "r", "]"}], " ", 
           RowBox[{
            SubscriptBox["\[PartialD]", "r"], 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["r", "2"], " ", 
              RowBox[{
               SuperscriptBox["u", "\[Prime]",
                MultilineFunction->None], "[", "r", "]"}]}], ")"}]}]}], 
          SuperscriptBox["r", "2"]]}], "-", 
        FractionBox[
         RowBox[{"2", " ", 
          SuperscriptBox[
           RowBox[{"u", "[", "r", "]"}], "2"]}], "r"]}], ")"}], " ", 
      SuperscriptBox["r", "2"]}], ",", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"u", "[", "r", "]"}], "2"], " ", 
      SuperscriptBox["r", "2"]}]}], "}"}], ",", 
   RowBox[{"u", "[", "r", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "-", "r"}], ")"}], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "b"}], " ", "r"}]]}], ",", 
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", "b", "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->7257],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.25`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", "2.`"}], ",", 
     RowBox[{"b", "\[Rule]", "0.5`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->27350]
}, Open  ]],

Cell[TextData[{
 "The problem of the torsion of a rod of square cross section involves \
solving ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[Del]", "2"], 
    StyleBox["u", "TI"], "=", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineFormula"],
 " where ",
 Cell[BoxData[
  FormBox[
   StyleBox["u", "TI"], TraditionalForm]], "InlineFormula"],
 " vanishes on the boundary. ",
 Cell[BoxData[
  ButtonBox["VariationalBound",
   BaseStyle->"Link",
   ButtonData->"paclet:VariationalMethods/ref/VariationalBound"]], 
  "InlineFormula"],
 " gives optimal values of parameters for the approximate solution. "
}], "MathCaption",
 CellID->18376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VariationalBound", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "y"}], "]"}]}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[PartialD]", 
         RowBox[{"{", 
          RowBox[{"x", ",", "2"}], "}"}]], 
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y"}], "]"}]}], "+", 
       RowBox[{
        SubscriptBox["\[PartialD]", 
         RowBox[{"{", 
          RowBox[{"y", ",", "2"}], "}"}]], 
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y"}], "]"}]}]}], ")"}]}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "y"}], "]"}]}]}], ",", 
   RowBox[{"u", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "a"}], ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "a"}], ",", "a"}], "}"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "-", 
      SuperscriptBox["a", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["y", "2"], "-", 
      SuperscriptBox["a", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"a1", "+", 
      RowBox[{"a2", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{"{", "a1", "}"}], ",", 
   RowBox[{"{", "a2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->28408],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "0.5615724027276375`"}], " ", 
    SuperscriptBox["a", "4"]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a1", "\[Rule]", 
      FractionBox["0.2921931407942238`", 
       SuperscriptBox["a", "2"]]}], ",", 
     RowBox[{"a2", "\[Rule]", 
      FractionBox["0.05922833935018051`", 
       SuperscriptBox["a", "4"]]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{321, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->1150]
}, Open  ]],

Cell[TextData[{
 "The ground state energy of the one\[Hyphen]dimensional quantum anharmonic \
oscillator is determined for the given trial (wave) function by ",
 Cell[BoxData[
  ButtonBox["NVariationalBound",
   BaseStyle->"Link",
   ButtonData->"paclet:VariationalMethods/ref/NVariationalBound"]], 
  "InlineFormula"],
 ". Note that the default range for the parameters is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], ")"}], 
   TraditionalForm]], "InlineFormula"],
 " and the initial values are specified. "
}], "MathCaption",
 CellID->22912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NVariationalBound", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["u", "\[Prime]",
         MultilineFunction->None], "[", "x", "]"}], "2"], "+", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["x", "4"]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"u", "[", "x", "]"}], "2"]}]}], ",", 
     SuperscriptBox[
      RowBox[{"u", "[", "x", "]"}], "2"]}], "}"}], ",", 
   RowBox[{"u", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "a"}], " ", 
      SuperscriptBox["x", "2"]}]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "0.1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->30997],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.8041748174596695`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", "0.7413598122397229`"}], ",", 
     RowBox[{"b", "\[Rule]", "0.36555621539339017`"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{262, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->16941]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Variational Methods - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 52.5908650}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Variational Methods Package Tutorial", "language" -> "en", "paclet" -> 
    "VariationalMethods Package", "status" -> "None", "summary" -> 
    "The basic problem of the calculus of variations is to determine the \
function u(x) that extremizes a functional F=SubsuperscriptBox[\\[Integral], \
StyleBox[RowBox[{x, m, i, n}], TI], StyleBox[RowBox[{x, m, a, x}], \
TI]]f[u(x),u^,(x),x]dx. In general, there can be more than one independent \
variable and the integrand f can depend on several functions and their higher \
derivatives. The extremal functions are solutions of the Euler(-Lagrange) \
equations that are obtained by setting the first variational derivatives of \
the functional F with respect to each function equal to zero. Since many \
ordinary and partial differential equations that occur in physics and \
engineering can be derived as the Euler equations for appropriate \
functionals, variational methods are of general utility. First variational \
derivatives and Euler equations. ", "synonyms" -> {}, "title" -> 
    "Variational Methods", "type" -> "Tutorial", "uri" -> 
    "VariationalMethods/tutorial/VariationalMethods"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1384, 30, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2009, 57, 52, 1, 70, "Title",
 CellID->32120],
Cell[2064, 60, 1176, 38, 70, "Text",
 CellID->20801],
Cell[3243, 100, 559, 12, 70, "Text",
 CellID->16780],
Cell[3805, 114, 5592, 162, 70, "DefinitionBox",
 CellID->19177],
Cell[9400, 278, 85, 1, 70, "Caption",
 CellID->2180],
Cell[9488, 281, 1940, 66, 70, "Text",
 CellID->18766],
Cell[11431, 349, 63, 1, 70, "MathCaption",
 CellID->17937],
Cell[11497, 352, 102, 3, 70, "Input",
 CellID->20115],
Cell[11602, 357, 683, 24, 70, "MathCaption",
 CellID->17435],
Cell[CellGroupData[{
Cell[12310, 385, 392, 13, 70, "Input",
 CellID->21519],
Cell[12705, 400, 710, 24, 61, "Output",
 CellID->23655]
}, Open  ]],
Cell[13430, 427, 386, 13, 70, "MathCaption",
 CellID->21640],
Cell[CellGroupData[{
Cell[13841, 444, 538, 16, 70, "Input",
 CellID->16342],
Cell[14382, 462, 524, 18, 36, "Output",
 CellID->15574]
}, Open  ]],
Cell[14921, 483, 260, 8, 70, "MathCaption",
 CellID->26834],
Cell[15184, 493, 98, 3, 70, "Input",
 CellID->13516],
Cell[15285, 498, 553, 20, 70, "MathCaption",
 CellID->30335],
Cell[15841, 520, 195, 6, 70, "Input",
 CellID->7214],
Cell[16039, 528, 98, 3, 70, "MathCaption",
 CellID->6079],
Cell[CellGroupData[{
Cell[16162, 535, 547, 17, 70, "Input",
 CellID->6246],
Cell[16712, 554, 900, 32, 36, "Output",
 CellID->4031]
}, Open  ]],
Cell[17627, 589, 1948, 56, 70, "DefinitionBox",
 CellID->31518],
Cell[19578, 647, 52, 1, 70, "Caption",
 CellID->14718],
Cell[19633, 650, 1488, 45, 70, "Text",
 CellID->24244],
Cell[21124, 697, 728, 19, 70, "MathCaption",
 CellID->17790],
Cell[CellGroupData[{
Cell[21877, 720, 794, 26, 70, "Input",
 CellID->26511],
Cell[22674, 748, 1223, 39, 73, "Output",
 CellID->12052]
}, Open  ]],
Cell[23912, 790, 8703, 298, 70, "Text",
 CellID->27905],
Cell[32618, 1090, 7772, 235, 70, "DefinitionBox",
 CellID->14967],
Cell[40393, 1327, 60, 1, 70, "Caption",
 CellID->11845],
Cell[40456, 1330, 982, 33, 70, "MathCaption",
 CellID->23613],
Cell[CellGroupData[{
Cell[41463, 1367, 1327, 42, 70, "Input",
 CellID->7257],
Cell[42793, 1411, 341, 12, 36, "Output",
 CellID->27350]
}, Open  ]],
Cell[43149, 1426, 660, 21, 70, "MathCaption",
 CellID->18376],
Cell[CellGroupData[{
Cell[43834, 1451, 1581, 54, 70, "Input",
 CellID->28408],
Cell[45418, 1507, 547, 18, 52, "Output",
 CellID->1150]
}, Open  ]],
Cell[45980, 1528, 615, 17, 70, "MathCaption",
 CellID->22912],
Cell[CellGroupData[{
Cell[46620, 1549, 1162, 38, 70, "Input",
 CellID->30997],
Cell[47785, 1589, 372, 12, 36, "Output",
 CellID->16941]
}, Open  ]]
}, Open  ]],
Cell[48184, 1605, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

