(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14595,        471]
NotebookOptionsPosition[     11699,        376]
NotebookOutlinePosition[     13065,        414]
CellTagsIndexPosition[     12980,        409]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Div" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Div"], "Curl" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Curl"], "Grad" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Grad"], 
          "Laplacian" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Laplacian"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Div\"\>", 2->"\<\"Curl\"\>",
        3->"\<\"Grad\"\>", 4->"\<\"Laplacian\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Biharmonic", "ObjectName",
 CellID->18536],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Biharmonic", "[", 
       StyleBox["f", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the biharmonic, ",
     Cell[BoxData[
      RowBox[{
       SuperscriptBox["\[Del]", "4"], 
       StyleBox["f", "TI"]}]], "InlineFormula"],
     ", of the scalar function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " in the default coordinate system. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Biharmonic", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["coordsys", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the biharmonic of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " in the coordinate system ",
     Cell[BoxData[
      StyleBox["coordsys", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->15333]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The biharmonic of ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is the Laplacian of the Laplacian of ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["\[Del]", "4"], 
    StyleBox["f", "TI"]}], "\[Congruent]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["\[Del]", "2"], ")"}], "2"], 
    StyleBox["f", "TI"]}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11105]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->18197239],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->272969372],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->521581811],

Cell["\<\
Biharmonic of a function in the default Cartesian coordinate system:\
\>", "ExampleText",
 CellID->311167460],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Biharmonic", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Xx", "^", "5"}], " ", "Zz"}], " ", "+", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"Yy", " ", "Zz"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->180602537],

Cell[BoxData[
 RowBox[{
  RowBox[{"120", " ", "Xx", " ", "Zz"}], "-", 
  RowBox[{"8", " ", "Yy", " ", "Zz", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"Yy", " ", "Zz"}], "]"}]}], "-", 
  RowBox[{"4", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"Yy", " ", "Zz"}], "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["Yy", "4"], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"Yy", " ", "Zz"}], "]"}]}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["Yy", "2"], " ", 
   SuperscriptBox["Zz", "2"], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"Yy", " ", "Zz"}], "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["Zz", "4"], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"Yy", " ", "Zz"}], "]"}]}]}]], "Output",
 ImageSize->{335, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->33842949]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->91947716],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->372998372],

Cell["Expression for the biharmonic in cylindrical coordinates:", \
"ExampleText",
 CellID->16002052],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Biharmonic", "[", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"Rr", ",", " ", "Ttheta", ",", " ", "Zz"}], "]"}], ",", " ", 
    "Cylindrical"}], "]"}], "//", "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->531867339],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXVtvHDUUnm52N7eSTROgAYnSh97ggUKLBIGXCFHyVCEhHgEpiiq1EghU
ChLvEFUVAhWJ/8EzAsIz4j+ZsT2enf3mmzn27CzZuayU3bF9fHz8+TL2dzyT
u0eP7t/74ujRg+Ojy4cPj766/+D468sffPkwjlo5F0WDO1EU3duL4msVX5k/
9zmM/2zwe321kqZFp2nKD5Dyl5ByHH8P4sgdSL0F4ecTuY8D5UeFpWZjLyTS
t5PfPUj/KFB+COE/TanaplEcqVN14kpGKtLx8d9GInPDqMmiX5QDy1pNZEfJ
r4XAfZzwIL4Ygi0jKEFfjpP4QcZ2LA1r3pa6FbdiNMpanxqSi8USz0P4FQgP
vLTosnSvW4d4I7cKubM6ppjHF6uSNNg1cHly9nGrpZ7SIyYhxvvfRYgd5+zE
fF4YlmrYZrhhmNcSW1zMtSWggFp0eORGYIdx4L0F70w6F5tZfbBh+aojwmbk
YVLKRKibz9zSvlryFn6BSdEZUc9HzxCksmHUhunF863WfsEDp4EbETMjjSPI
7xGIW14bWu1/7+kuRrx3vcispT194CoZ2Y9b7WH9sC2kMNrF0WUWMAzces9h
YSXZSnHFtdXMSpWtEyc9JgtYO6+rzAqqZLy4WlJMAsJ0Thcx3p1Fg45bHGl4
F3qOat4EKd7LNtR0RyTVxu2N2oxS8ZrZoaRVoG63n8Ta0j41zlptv4dl8QVz
u7bj2fh3NenjOv5aEr+RhLcbZi9nW25CLLYZ25e7cAQzQESsPFF2PYV63Wou
VN/ntBavQ+yGgP0osNQTSMc2Hwj6qtXqNchl1j4Fe1ypRGzHx4qvp2b2xgH6
sAanivUuUxq9m+TuqDmpH0GqrA0U9NRirfrX8JNp9KEYCuVFPwuU/yMtJZsq
8ZqfBMr/bkrpAu85Uu2v429pa/b8Z9a+OvnPHsdQHG2v7FlRPh/hHarHxeJi
e0032dFusKV8nujZ0nC2dK3HLBgz29t69lRmCnd7jESMpvso3x7sywsOVH73
kWJQPAKSXIwvkpE8a860mG/WWXHFVIpY6S6O4bjs/KntaVX5UspHFvGMM9Yz
1EOYxx2wGNk5t3P2sjhv2QK4UsvAaP6NcZcSJ4r3ZJR/CmFJP86JWB7WVn9d
SWuQlcS+0pya3FSZFUxNHOhTSK9Tt/66atKQmzZtUJED/RWk5uFT9a9hu9Jo
mfn8VC32ROi/aSnZ1LpPgP5jSvFhPt2MdV0p4X7icpwtK7hVYtlmw+qCc8Xf
aatVZeZQ4w0It5mZ46stLAn3h11CiPe3cO7Sq5c1nqOTT3R69aXG42B7iS9X
6dM3lpe1mxRY59PSy1srPu7DuEhcJ0u8mh+rsey8WvE9ZUBGVDcw4b2pOtfo
5pl5eTQ/LqMZJzU3VVcwme5UfHsszsV5JgzttB/cA6R4SHiJ+J01o+i4Q5/W
90Eh9BTmsqFk+xSyiBPFOTh6T67EwblxFHq+EtnCtQJLg/jNBdhruYu3BfxC
GbATCIcyeNLJQ/11u+GW75OWC9GMluBpT7OSqZEXfNOkvYNWR77M3ROQ2qJS
/izgW+baxcos4HsqjNX7MFA+9Lzkq6lV2VSJBbwbKB96vtJyq45lbCrr5sOO
NvXMZBvPhdpeh6xVl3m8atxwl09t9qdfq+EYMPYaz3vK/K/XiGo8Dv0ZXo7L
JeU7FprDDPuy+s0+i9uNE8h8ru4mR13+xoVQ30Y7zwz356xlzGZ3vO1n5/09
FnV5cZb/NHR/YlzGiN976H0Q6wHhlUjmwZfdH8FHUYAfS6pbADZ+c85ZY1Ph
nSzVkGvcMwV2ZO0peWREpDZUfoGerSCf2//4phA8r+/7hEGQ3bU+YWA9AC8J
7a1zs3eOIF4/C/UK9VSFnpKvdArfq/YhVteNwi8QRr9uPSgY3qGA89Ma2LtN
qKaSeSHUn0ifM6hRv0E2ell/52ZIRHlMpfC5An9fJH0iobqmNEr2QrLzGqbf
ZRQbn3bBGpR5ZvVnf5qnlIXLyzO2g2gt3Ne5edWl3SrJw9avRWW/UaJnPbEb
+4mTuZpijWcxWO9yua6Z9J3ExnIp3DHgOH9f+XmDLyZyh57yVb3NhhHNzbZ3
IIzeYdzxS/Lzep/PT6308lou29Mhq6rcz4krBncqaKia5a/tgk8a62jud3y9
Is7STX9CZY3a5+dfxD6P1qN8l3yvvQ97MTjasWpXqKenp8kMsW2KPzg4yKKN
uVr0dJDkXUIt7i6k48dRnt1op8+394VzXIrvd8v/NBVqlfyq2Af4jItSzfId
d9NjPu8qri3PhGFryFy2PC/SUVOCSzv8xb2PfX7MQkYh44za8Czdzixqiu9C
s+PWtUg3/M29T17GKMOXiXa697dJbyPz8rwLYVcjMd9CvK78yVP0X+HIqoTL
3E+jLpsvehHvtwtArnG+ezsCL0Es8z+PVYB/39N/L4XLvNHX1aw3eldNeRhv
Oys9UzuvZ7/Km/hKLK7Vp79F+4N7B0mV/8AxJLPKY0EPrkmlswOSr1/SL62r
vjH51hOscC8yAe1lnuYilMpq10y0UCuu7TVqaY/zfM7XnSXAEp8E6Kh0bqAm
3d9SZK5A2O/9gqZVZsb+T175Ak4UVNT1Ha2lk9hfcKqbyVzsuybWhewphujc
fwJ0PnU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->83548359]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1064],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Div",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Div"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Curl",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Curl"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Grad",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Grad"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Laplacian",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Laplacian"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14518]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27587],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->30732]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Biharmonic - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 59.1066568}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "Biharmonic[f] gives the biharmonic, \\[Del]^4 f, of the scalar function \
f in the default coordinate system. Biharmonic[f, coordsys] gives the \
biharmonic of f in the coordinate system coordsys.", "synonyms" -> {}, 
    "title" -> "Biharmonic", "type" -> "Symbol", "uri" -> 
    "VectorAnalysis/ref/Biharmonic"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4328, 147, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->18197239]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12838, 402}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1518, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2141, 63, 48, 1, 70, "ObjectName",
 CellID->18536],
Cell[2192, 66, 1080, 34, 70, "Usage",
 CellID->15333]
}, Open  ]],
Cell[CellGroupData[{
Cell[3309, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3787, 122, 504, 20, 70, "Notes",
 CellID->11105]
}, Closed]],
Cell[CellGroupData[{
Cell[4328, 147, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->18197239],
Cell[CellGroupData[{
Cell[4712, 161, 148, 5, 70, "ExampleSection",
 CellID->272969372],
Cell[4863, 168, 139, 4, 70, "Input",
 CellID->521581811],
Cell[5005, 174, 119, 3, 70, "ExampleText",
 CellID->311167460],
Cell[CellGroupData[{
Cell[5149, 181, 248, 8, 28, "Input",
 CellID->180602537],
Cell[5400, 191, 808, 26, 54, "Output",
 CellID->33842949]
}, Open  ]],
Cell[6223, 220, 124, 3, 70, "ExampleDelimiter",
 CellID->91947716],
Cell[6350, 225, 139, 4, 70, "Input",
 CellID->372998372],
Cell[6492, 231, 101, 2, 70, "ExampleText",
 CellID->16002052],
Cell[CellGroupData[{
Cell[6618, 237, 264, 8, 28, "Input",
 CellID->531867339],
Cell[6885, 247, 2904, 52, 122, "Output",
 Evaluatable->False,
 CellID->83548359]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9850, 306, 310, 9, 70, "SeeAlsoSection",
 CellID->1064],
Cell[10163, 317, 977, 35, 70, "SeeAlso",
 CellID->14518]
}, Open  ]],
Cell[CellGroupData[{
Cell[11177, 357, 314, 9, 70, "TutorialsSection",
 CellID->27587],
Cell[11494, 368, 163, 3, 70, "Tutorials",
 CellID->30732]
}, Open  ]],
Cell[11672, 374, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

