(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12162,        437]
NotebookOptionsPosition[      9065,        338]
NotebookOutlinePosition[     10624,        378]
CellTagsIndexPosition[     10539,        373]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Bipolar" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Bipolar"], 
          "Toroidal" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Toroidal"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Bipolar\"\>", 
       2->"\<\"Toroidal\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Bispherical", "ObjectName",
 CellID->18829],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Bispherical"], "InlineFormula"],
     "\[LineSeparator]represents the bispherical coordinate system with \
default variables ",
     Cell[BoxData[
      ButtonBox["Uu",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Uu"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Vv",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Vv"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      ButtonBox["Pphi",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Pphi"]], "InlineFormula"],
     " and default parameter value ",
     Cell[BoxData[
      StyleBox["1", "TR"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Bispherical", "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["v", "TI"], ",", 
        StyleBox["\[Phi]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the bispherical coordinate system with \
variables ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      StyleBox["\[Phi]", "TR"]], "InlineFormula"],
     " and default parameter value ",
     Cell[BoxData[
      StyleBox["1", "TR"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Bispherical", "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["v", "TI"], ",", 
        StyleBox["\[Phi]", "TR"], ",", 
        StyleBox["a", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the bispherical coordinate system with \
variables ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      StyleBox["\[Phi]", "TR"]], "InlineFormula"],
     " and parameter ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->5950]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->254466063],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->72849610],

Cell[TextData[{
 "Use ",
 Cell[BoxData["Bispherical"], "InlineFormula"],
 " as the default coordinate system:"
}], "ExampleText",
 CellID->428269499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", "Bispherical", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->443597938],

Cell[BoxData[
 RowBox[{"Bispherical", "[", 
  RowBox[{"Uu", ",", "Vv", ",", "Pphi", ",", "1"}], "]"}]], "Output",
 ImageSize->{192, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->908843085]
}, Open  ]],

Cell["\<\
All evaluations now use bispherical coordinates as the default:\
\>", "ExampleText",
 CellID->116864137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoordinateRanges", "[", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->709779145],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0", "\[LessEqual]", "Uu", "\[LessEqual]", "\[Pi]"}], ",", 
   RowBox[{
    RowBox[{"-", "\[Infinity]"}], "<", "Vv", "<", "\[Infinity]"}], ",", 
   RowBox[{
    RowBox[{"-", "\[Pi]"}], "<", "Pphi", "\[LessEqual]", "\[Pi]"}]}], 
  "}"}]], "Output",
 ImageSize->{243, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->62393471]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ScaleFactors", "[", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->33744766],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cos", "[", "Uu", "]"}]}], "+", 
     RowBox[{"Cosh", "[", "Vv", "]"}]}]], ",", 
   FractionBox["1", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cos", "[", "Uu", "]"}]}], "+", 
     RowBox[{"Cosh", "[", "Vv", "]"}]}]], ",", 
   FractionBox[
    RowBox[{"Sin", "[", "Uu", "]"}], 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cos", "[", "Uu", "]"}]}], "+", 
     RowBox[{"Cosh", "[", "Vv", "]"}]}]]}], "}"}]], "Output",
 ImageSize->{429, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->962818]
}, Open  ]],

Cell[TextData[{
 "Reset the default coordinate system to ",
 Cell[BoxData[
  ButtonBox["Cartesian",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Cartesian"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->31402094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", "Cartesian", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->74704059],

Cell[BoxData[
 RowBox[{"Cartesian", "[", 
  RowBox[{"Xx", ",", "Yy", ",", "Zz"}], "]"}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->268446225]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30049],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bipolar",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Bipolar"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Toroidal",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Toroidal"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19094]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21457],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->32405]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Bispherical - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 59.8097998}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "Bispherical represents the bispherical coordinate system with default \
variables Uu, Vv, and Pphi and default parameter value 1. Bispherical[u, v, \
\\[Phi]] represents the bispherical coordinate system with variables u, v, \
and \\[Phi] and default parameter value 1. Bispherical[u, v, \\[Phi], a] \
represents the bispherical coordinate system with variables u, v, and \\[Phi] \
and parameter a.", "synonyms" -> {}, "title" -> "Bispherical", "type" -> 
    "Symbol", "uri" -> "VectorAnalysis/ref/Bispherical"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4322, 143, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10404, 366}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1327, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1950, 61, 49, 1, 70, "ObjectName",
 CellID->18829],
Cell[2002, 64, 2283, 74, 70, "Usage",
 CellID->5950]
}, Open  ]],
Cell[CellGroupData[{
Cell[4322, 143, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4699, 157, 148, 5, 70, "ExampleSection",
 CellID->254466063],
Cell[4850, 164, 138, 4, 70, "Input",
 CellID->72849610],
Cell[4991, 170, 149, 5, 70, "ExampleText",
 CellID->428269499],
Cell[CellGroupData[{
Cell[5165, 179, 120, 3, 28, "Input",
 CellID->443597938],
Cell[5288, 184, 244, 7, 36, "Output",
 CellID->908843085]
}, Open  ]],
Cell[5547, 194, 114, 3, 70, "ExampleText",
 CellID->116864137],
Cell[CellGroupData[{
Cell[5686, 201, 107, 3, 28, "Input",
 CellID->709779145],
Cell[5796, 206, 428, 13, 36, "Output",
 CellID->62393471]
}, Open  ]],
Cell[CellGroupData[{
Cell[6261, 224, 102, 3, 70, "Input",
 CellID->33744766],
Cell[6366, 229, 658, 23, 53, "Output",
 CellID->962818]
}, Open  ]],
Cell[7039, 255, 238, 8, 70, "ExampleText",
 CellID->31402094],
Cell[CellGroupData[{
Cell[7302, 267, 117, 3, 70, "Input",
 CellID->74704059],
Cell[7422, 272, 230, 7, 36, "Output",
 CellID->268446225]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7713, 286, 311, 9, 70, "SeeAlsoSection",
 CellID->30049],
Cell[8027, 297, 479, 17, 70, "SeeAlso",
 CellID->19094]
}, Open  ]],
Cell[CellGroupData[{
Cell[8543, 319, 314, 9, 70, "TutorialsSection",
 CellID->21457],
Cell[8860, 330, 163, 3, 70, "Tutorials",
 CellID->32405]
}, Open  ]],
Cell[9038, 336, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

