(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13526,        475]
NotebookOptionsPosition[     10250,        373]
NotebookOutlinePosition[     11986,        416]
CellTagsIndexPosition[     11901,        411]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Conical" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Conical"], 
          "ConfocalParaboloidal" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/ConfocalParaboloidal"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Conical\"\>", 
       2->"\<\"ConfocalParaboloidal\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ConfocalEllipsoidal", "ObjectName",
 CellID->28499],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["ConfocalEllipsoidal"], "InlineFormula"],
     "\[LineSeparator]represents the confocal ellipsoidal coordinate system \
with default variables ",
     Cell[BoxData[
      ButtonBox["Llambda",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Llambda"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Mmu",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Mmu"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      ButtonBox["Nnu",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Nnu"]], "InlineFormula"],
     " and default parameter values ",
     Cell[BoxData[
      StyleBox["3", "TR"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["2", "TR"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      StyleBox["1", "TR"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ConfocalEllipsoidal", "[", 
       RowBox[{
        StyleBox["\[Lambda]", "TR"], ",", 
        StyleBox["\[Mu]", "TR"], ",", 
        StyleBox["\[Nu]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the confocal ellipsoidal coordinate system \
with variables ",
     Cell[BoxData[
      RowBox[{
       StyleBox["\[Lambda]", "TR"], ",", 
       StyleBox["\[Mu]", "TR"]}]], "InlineFormula"],
     " and \[Nu] and default parameter values 3, 2, and 1. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ConfocalEllipsoidal", "[", 
       RowBox[{
        StyleBox["\[Lambda]", "TR"], ",", 
        StyleBox["\[Mu]", "TR"], ",", 
        StyleBox["\[Nu]", "TR"], ",", 
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"], ",", 
        StyleBox["c", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the confocal ellipsoidal coordinate system \
with variables ",
     Cell[BoxData[
      RowBox[{
       StyleBox["\[Lambda]", "TR"], ",", 
       StyleBox["\[Mu]", "TR"]}]], "InlineFormula"],
     " and \[Nu] and parameters ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->16731]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->514766130],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->68127069],

Cell[TextData[{
 "Use ",
 Cell[BoxData["ConfocalEllipsoidal"], "InlineFormula"],
 " as the default coordinate system:"
}], "ExampleText",
 CellID->428269499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", "ConfocalEllipsoidal", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->443597938],

Cell[BoxData[
 RowBox[{"ConfocalEllipsoidal", "[", 
  RowBox[{"Llambda", ",", "Mmu", ",", "Nnu", ",", "3", ",", "2", ",", "1"}], 
  "]"}]], "Output",
 ImageSize->{319, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3098965]
}, Open  ]],

Cell["\<\
All evaluations now use confocal ellipsoidal coordinates as the default:\
\>", "ExampleText",
 CellID->116864137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoordinateRanges", "[", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->709779145],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "\[Infinity]"}], "<", "Llambda", "<", "1"}], ",", 
   RowBox[{"1", "<", "Mmu", "<", "4"}], ",", 
   RowBox[{"4", "<", "Nnu", "<", "9"}]}], "}"}]], "Output",
 ImageSize->{267, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->41149979]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobianDeterminant", "[", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->33744766],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"Llambda", "-", "Nnu"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"Mmu", "-", "Nnu"}], ")"}]}]], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "Llambda"}], "+", "Mmu"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "Llambda"}], "+", "Nnu"}], ")"}]}]], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"Llambda", "-", "Mmu"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "Mmu"}], "+", "Nnu"}], ")"}]}]]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"8", " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "Llambda"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"4", "-", "Llambda"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"9", "-", "Llambda"}], ")"}]}]], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "Mmu"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"4", "-", "Mmu"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"9", "-", "Mmu"}], ")"}]}]], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "Nnu"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"4", "-", "Nnu"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"9", "-", "Nnu"}], ")"}]}]]}], ")"}]}]], "Output",
 ImageSize->{530, 66},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->329788893]
}, Open  ]],

Cell[TextData[{
 "Reset the default coordinate system to ",
 Cell[BoxData[
  ButtonBox["Cartesian",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Cartesian"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->31402094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", "Cartesian", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->74704059],

Cell[BoxData[
 RowBox[{"Cartesian", "[", 
  RowBox[{"Xx", ",", "Yy", ",", "Zz"}], "]"}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->3104678]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28287],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Conical",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Conical"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ConfocalParaboloidal",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/ConfocalParaboloidal"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7389]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11849],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->25442]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ConfocalEllipsoidal - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 0.4504412}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "ConfocalEllipsoidal represents the confocal ellipsoidal coordinate \
system with default variables Llambda, Mmu, and Nnu and default parameter \
values 3, 2, and 1. ConfocalEllipsoidal[\\[Lambda], \\[Mu], \\[Nu]] \
represents the confocal ellipsoidal coordinate system with variables \
\\[Lambda], \\[Mu] and \\[Nu] and default parameter values 3, 2, and 1. \
ConfocalEllipsoidal[\\[Lambda], \\[Mu], \\[Nu], a, b, c] represents the \
confocal ellipsoidal coordinate system with variables \\[Lambda], \\[Mu] and \
\\[Nu] and parameters a, b, and c.", "synonyms" -> {}, "title" -> 
    "ConfocalEllipsoidal", "type" -> "Symbol", "uri" -> 
    "VectorAnalysis/ref/ConfocalEllipsoidal"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4609, 147, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11766, 404}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1374, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1997, 62, 57, 1, 70, "ObjectName",
 CellID->28499],
Cell[2057, 65, 2515, 77, 70, "Usage",
 CellID->16731]
}, Open  ]],
Cell[CellGroupData[{
Cell[4609, 147, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4986, 161, 148, 5, 70, "ExampleSection",
 CellID->514766130],
Cell[5137, 168, 138, 4, 70, "Input",
 CellID->68127069],
Cell[5278, 174, 157, 5, 70, "ExampleText",
 CellID->428269499],
Cell[CellGroupData[{
Cell[5460, 183, 128, 3, 28, "Input",
 CellID->443597938],
Cell[5591, 188, 278, 8, 36, "Output",
 CellID->3098965]
}, Open  ]],
Cell[5884, 199, 123, 3, 70, "ExampleText",
 CellID->116864137],
Cell[CellGroupData[{
Cell[6032, 206, 107, 3, 28, "Input",
 CellID->709779145],
Cell[6142, 211, 355, 11, 36, "Output",
 CellID->41149979]
}, Open  ]],
Cell[CellGroupData[{
Cell[6534, 227, 109, 3, 70, "Input",
 CellID->33744766],
Cell[6646, 232, 1542, 55, 87, "Output",
 CellID->329788893]
}, Open  ]],
Cell[8203, 290, 238, 8, 70, "ExampleText",
 CellID->31402094],
Cell[CellGroupData[{
Cell[8466, 302, 117, 3, 70, "Input",
 CellID->74704059],
Cell[8586, 307, 228, 7, 36, "Output",
 CellID->3104678]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8875, 321, 311, 9, 70, "SeeAlsoSection",
 CellID->28287],
Cell[9189, 332, 502, 17, 70, "SeeAlso",
 CellID->7389]
}, Open  ]],
Cell[CellGroupData[{
Cell[9728, 354, 314, 9, 70, "TutorialsSection",
 CellID->11849],
Cell[10045, 365, 163, 3, 70, "Tutorials",
 CellID->25442]
}, Open  ]],
Cell[10223, 371, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

