(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13487,        477]
NotebookOptionsPosition[     10213,        375]
NotebookOutlinePosition[     11943,        418]
CellTagsIndexPosition[     11858,        413]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Conical" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Conical"], 
          "ConfocalEllipsoidal" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/ConfocalEllipsoidal"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Conical\"\>", 
       2->"\<\"ConfocalEllipsoidal\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ConfocalParaboloidal", "ObjectName",
 CellID->12675],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["ConfocalParaboloidal"], "InlineFormula"],
     "\[LineSeparator]represents the confocal paraboloidal coordinate system \
with default variables ",
     Cell[BoxData[
      ButtonBox["Llambda",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Llambda"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Mmu",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Mmu"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      ButtonBox["Nnu",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Nnu"]], "InlineFormula"],
     " and default parameter values ",
     Cell[BoxData[
      StyleBox["2", "TR"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["1", "TR"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ConfocalParaboloidal", "[", 
       RowBox[{
        StyleBox["\[Lambda]", "TR"], ",", 
        StyleBox["\[Mu]", "TR"], ",", 
        StyleBox["\[Nu]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the confocal paraboloidal coordinate system \
with variables ",
     Cell[BoxData[
      RowBox[{
       StyleBox["\[Lambda]", "TR"], ",", 
       StyleBox["\[Mu]", "TR"]}]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["\[Nu]", "TR"]], "InlineFormula"],
     " and default parameter values ",
     Cell[BoxData[
      StyleBox["2", "TR"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["1", "TR"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ConfocalParaboloidal", "[", 
       RowBox[{
        StyleBox["\[Lambda]", "TR"], ",", 
        StyleBox["\[Mu]", "TR"], ",", 
        StyleBox["\[Nu]", "TR"], ",", 
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the confocal paraboloidal coordinate system \
with variables ",
     Cell[BoxData[
      RowBox[{
       StyleBox["\[Lambda]", "TR"], ",", 
       StyleBox["\[Mu]", "TR"]}]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["\[Nu]", "TR"]], "InlineFormula"],
     " and parameters ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->19736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->596797466],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->69082206],

Cell[TextData[{
 "Use ",
 Cell[BoxData["ConfocalParaboloidal"], "InlineFormula"],
 " as the default coordinate system:"
}], "ExampleText",
 CellID->428269499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", "ConfocalParaboloidal", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->443597938],

Cell[BoxData[
 RowBox[{"ConfocalParaboloidal", "[", 
  RowBox[{"Llambda", ",", "Mmu", ",", "Nnu", ",", "2", ",", "1"}], 
  "]"}]], "Output",
 ImageSize->{308, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->427921818]
}, Open  ]],

Cell["\<\
All evaluations now use confocal paraboloidal coordinates as the default:\
\>", "ExampleText",
 CellID->116864137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoordinateRanges", "[", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->709779145],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "\[Infinity]"}], "<", "Llambda", "<", "1"}], ",", 
   RowBox[{"1", "<", "Mmu", "<", "4"}], ",", 
   RowBox[{"4", "<", "Nnu", "<", "\[Infinity]"}]}], "}"}]], "Output",
 ImageSize->{268, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->203647589]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ScaleFactors", "[", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->33744766],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "Llambda"}], "+", "Mmu"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "Llambda"}], "+", "Nnu"}], ")"}]}]], 
    RowBox[{"2", " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "Llambda"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "-", "Llambda"}], ")"}]}]]}]], ",", 
   FractionBox[
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"Llambda", "-", "Mmu"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "Mmu"}], "+", "Nnu"}], ")"}]}]], 
    RowBox[{"2", " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "Mmu"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "-", "Mmu"}], ")"}]}]]}]], ",", 
   FractionBox[
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"Llambda", "-", "Nnu"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"Mmu", "-", "Nnu"}], ")"}]}]], 
    RowBox[{"2", " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "Nnu"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "-", "Nnu"}], ")"}]}]]}]]}], "}"}]], "Output",
 ImageSize->{416, 80},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->103229841]
}, Open  ]],

Cell[TextData[{
 "Reset the default coordinate system to ",
 Cell[BoxData[
  ButtonBox["Cartesian",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Cartesian"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->31402094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", "Cartesian", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->74704059],

Cell[BoxData[
 RowBox[{"Cartesian", "[", 
  RowBox[{"Xx", ",", "Yy", ",", "Zz"}], "]"}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->77722591]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15013],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Conical",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Conical"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ConfocalEllipsoidal",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/ConfocalEllipsoidal"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5284]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17438],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->9958]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ConfocalParaboloidal - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 0.9192032}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "ConfocalParaboloidal represents the confocal paraboloidal coordinate \
system with default variables Llambda, Mmu, and Nnu and default parameter \
values 2 and 1. ConfocalParaboloidal[\\[Lambda], \\[Mu], \\[Nu]] represents \
the confocal paraboloidal coordinate system with variables \\[Lambda], \\[Mu] \
and \\[Nu] and default parameter values 2 and 1. \
ConfocalParaboloidal[\\[Lambda], \\[Mu], \\[Nu], a, b] represents the \
confocal paraboloidal coordinate system with variables \\[Lambda], \\[Mu] and \
\\[Nu] and parameters a and b.", "synonyms" -> {}, "title" -> 
    "ConfocalParaboloidal", "type" -> "Symbol", "uri" -> 
    "VectorAnalysis/ref/ConfocalParaboloidal"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4711, 152, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11723, 406}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1371, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1994, 62, 58, 1, 70, "ObjectName",
 CellID->12675],
Cell[2055, 65, 2619, 82, 70, "Usage",
 CellID->19736]
}, Open  ]],
Cell[CellGroupData[{
Cell[4711, 152, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[5088, 166, 148, 5, 70, "ExampleSection",
 CellID->596797466],
Cell[5239, 173, 138, 4, 70, "Input",
 CellID->69082206],
Cell[5380, 179, 158, 5, 70, "ExampleText",
 CellID->428269499],
Cell[CellGroupData[{
Cell[5563, 188, 129, 3, 28, "Input",
 CellID->443597938],
Cell[5695, 193, 271, 8, 36, "Output",
 CellID->427921818]
}, Open  ]],
Cell[5981, 204, 124, 3, 70, "ExampleText",
 CellID->116864137],
Cell[CellGroupData[{
Cell[6130, 211, 107, 3, 28, "Input",
 CellID->709779145],
Cell[6240, 216, 366, 11, 36, "Output",
 CellID->203647589]
}, Open  ]],
Cell[CellGroupData[{
Cell[6643, 232, 102, 3, 70, "Input",
 CellID->33744766],
Cell[6748, 237, 1405, 52, 101, "Output",
 CellID->103229841]
}, Open  ]],
Cell[8168, 292, 238, 8, 70, "ExampleText",
 CellID->31402094],
Cell[CellGroupData[{
Cell[8431, 304, 117, 3, 70, "Input",
 CellID->74704059],
Cell[8551, 309, 229, 7, 36, "Output",
 CellID->77722591]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8841, 323, 311, 9, 70, "SeeAlsoSection",
 CellID->15013],
Cell[9155, 334, 500, 17, 70, "SeeAlso",
 CellID->5284]
}, Open  ]],
Cell[CellGroupData[{
Cell[9692, 356, 314, 9, 70, "TutorialsSection",
 CellID->17438],
Cell[10009, 367, 162, 3, 70, "Tutorials",
 CellID->9958]
}, Open  ]],
Cell[10186, 373, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

