(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10117,        379]
NotebookOptionsPosition[      6944,        270]
NotebookOutlinePosition[      8187,        306]
CellTagsIndexPosition[      8103,        301]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Coordinates" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Coordinates"], 
          "SetCoordinates" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/SetCoordinates"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Coordinates\"\>", 
       2->"\<\"SetCoordinates\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CoordinateSystem", "ObjectName",
 CellID->11960],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["CoordinateSystem"], "InlineFormula"],
     " \[LineSeparator]gives the name of the default coordinate system."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17945]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->876809203],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->340841633],

Cell["Find the current coordinate system:", "ExampleText",
 CellID->21984787],

Cell[CellGroupData[{

Cell[BoxData["CoordinateSystem"], "Input",
 CellLabel->"In[2]:=",
 CellID->69885240],

Cell[BoxData["Cartesian"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->633878246]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->371610058],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->516183838],

Cell["Use another coordinate system:", "ExampleText",
 CellID->616093913],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", "Spherical", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->576028527],

Cell[BoxData[
 RowBox[{"Spherical", "[", 
  RowBox[{"Rr", ",", "Ttheta", ",", "Pphi"}], "]"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->472777638]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["CoordinateSystem"], "Input",
 CellLabel->"In[3]:=",
 CellID->351220551],

Cell[BoxData["Spherical"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->53928252]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->301120221],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->631941916],

Cell["Restore the default settings:", "ExampleText",
 CellID->228996021],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", "Cartesian", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->203516],

Cell[BoxData[
 RowBox[{"Cartesian", "[", 
  RowBox[{"Xx", ",", "Yy", ",", "Zz"}], "]"}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->697295670]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["CoordinateSystem"], "Input",
 CellLabel->"In[3]:=",
 CellID->265071703],

Cell[BoxData["Cartesian"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->8019209]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5943],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Coordinates",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Coordinates"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetCoordinates",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/SetCoordinates"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15347]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9923],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->30542]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CoordinateSystem - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 7.3256172}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "CoordinateSystem gives the name of the default coordinate system.", 
    "synonyms" -> {}, "title" -> "CoordinateSystem", "type" -> "Symbol", 
    "uri" -> "VectorAnalysis/ref/CoordinateSystem"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2439, 80, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7969, 294}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1368, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1991, 62, 54, 1, 70, "ObjectName",
 CellID->11960],
Cell[2048, 65, 354, 10, 70, "Usage",
 CellID->17945]
}, Open  ]],
Cell[CellGroupData[{
Cell[2439, 80, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[2816, 94, 148, 5, 70, "ExampleSection",
 CellID->876809203],
Cell[2967, 101, 139, 4, 70, "Input",
 CellID->340841633],
Cell[3109, 107, 77, 1, 70, "ExampleText",
 CellID->21984787],
Cell[CellGroupData[{
Cell[3211, 112, 84, 2, 28, "Input",
 CellID->69885240],
Cell[3298, 116, 166, 5, 36, "Output",
 CellID->633878246]
}, Open  ]],
Cell[3479, 124, 125, 3, 70, "ExampleDelimiter",
 CellID->371610058],
Cell[3607, 129, 139, 4, 70, "Input",
 CellID->516183838],
Cell[3749, 135, 73, 1, 70, "ExampleText",
 CellID->616093913],
Cell[CellGroupData[{
Cell[3847, 140, 118, 3, 70, "Input",
 CellID->576028527],
Cell[3968, 145, 236, 7, 36, "Output",
 CellID->472777638]
}, Open  ]],
Cell[CellGroupData[{
Cell[4241, 157, 85, 2, 70, "Input",
 CellID->351220551],
Cell[4329, 161, 165, 5, 36, "Output",
 CellID->53928252]
}, Open  ]],
Cell[4509, 169, 125, 3, 70, "ExampleDelimiter",
 CellID->301120221],
Cell[4637, 174, 139, 4, 70, "Input",
 CellID->631941916],
Cell[4779, 180, 72, 1, 70, "ExampleText",
 CellID->228996021],
Cell[CellGroupData[{
Cell[4876, 185, 115, 3, 70, "Input",
 CellID->203516],
Cell[4994, 190, 230, 7, 36, "Output",
 CellID->697295670]
}, Open  ]],
Cell[CellGroupData[{
Cell[5261, 202, 85, 2, 70, "Input",
 CellID->265071703],
Cell[5349, 206, 164, 5, 36, "Output",
 CellID->8019209]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5574, 218, 310, 9, 70, "SeeAlsoSection",
 CellID->5943],
Cell[5887, 229, 499, 17, 70, "SeeAlso",
 CellID->15347]
}, Open  ]],
Cell[CellGroupData[{
Cell[6423, 251, 313, 9, 70, "TutorialsSection",
 CellID->9923],
Cell[6739, 262, 163, 3, 70, "Tutorials",
 CellID->30542]
}, Open  ]],
Cell[6917, 268, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

