(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11591,        420]
NotebookOptionsPosition[      8706,        326]
NotebookOutlinePosition[     10101,        364]
CellTagsIndexPosition[     10017,        359]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DotProduct" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/DotProduct"], 
          "ScalarTripleProduct" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/ScalarTripleProduct"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DotProduct\"\>", 
       2->"\<\"ScalarTripleProduct\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CrossProduct", "ObjectName",
 CellID->29726],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CrossProduct", "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the cross product of the two 3-vectors ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["2", "TR"]]}]], "InlineFormula"],
     " in the default coordinate system. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CrossProduct", "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["coordsys", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the cross product of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " ",
     Cell[BoxData[
      StyleBox[Cell["", "InlineFormula"], "TI"]], "InlineFormula"],
     "and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " in the coordinate system ",
     Cell[BoxData[
      StyleBox["coordsys", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->16038]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"CrossProduct", "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["v", "TI"], "1"], ",", 
    SubscriptBox[
     StyleBox["v", "TI"], "2"], ",", 
    StyleBox["coordsys", "TI"]}], "]"}]], "InlineFormula"],
 " is computed by converting ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 " to Cartesian coordinates, forming the cross product, and then converting \
back from Cartesian coordinates."
}], "Notes",
 CellID->29915]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->16705067],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->187821649],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->144821122],

Cell["Find the cross product of a pair of vectors:", "ExampleText",
 CellID->571580703],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", " ", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "5"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->528886812],

Cell[BoxData[
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "4"}], ",", " ", "7", ",", "1"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->68172932],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrossProduct", "[", 
  RowBox[{"a", ",", " ", "b"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->4370932],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "32"}], ",", 
   RowBox[{"-", "21"}], ",", "19"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->183033878]
}, Open  ]],

Cell["\<\
Verify an identity involving the cross product and the dot product of \
vectors:\
\>", "ExampleText",
 CellID->71569699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Norm", "[", 
    RowBox[{"CrossProduct", "[", 
     RowBox[{"a", ",", " ", "b"}], "]"}], "]"}], "^", "2"}], "+", 
  RowBox[{
   RowBox[{"Norm", "[", 
    RowBox[{"a", ".", "b"}], "]"}], "^", "2"}], "-", 
  RowBox[{
   RowBox[{
    RowBox[{"Norm", "[", "a", "]"}], "^", "2"}], "*", 
   RowBox[{
    RowBox[{"Norm", "[", "b", "]"}], "^", "2"}]}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->856232381],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->46029370]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27667],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DotProduct",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/DotProduct"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScalarTripleProduct",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/ScalarTripleProduct"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11128]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28672],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->18352]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CrossProduct - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 7.5131220}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "CrossProduct[v_1, v_2] gives the cross product of the two 3-vectors v_1, \
v_2 in the default coordinate system. CrossProduct[v_1, v_2, coordsys] gives \
the cross product of v_1 and v_2 in the coordinate system coordsys.", 
    "synonyms" -> {}, "title" -> "CrossProduct", "type" -> "Symbol", "uri" -> 
    "VectorAnalysis/ref/CrossProduct"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4935, 170, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->16705067]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9875, 352}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1380, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2003, 62, 50, 1, 70, "ObjectName",
 CellID->29726],
Cell[2056, 65, 1698, 56, 70, "Usage",
 CellID->16038]
}, Open  ]],
Cell[CellGroupData[{
Cell[3791, 126, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4269, 143, 629, 22, 70, "Notes",
 CellID->29915]
}, Closed]],
Cell[CellGroupData[{
Cell[4935, 170, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->16705067],
Cell[CellGroupData[{
Cell[5319, 184, 148, 5, 70, "ExampleSection",
 CellID->187821649],
Cell[5470, 191, 139, 4, 70, "Input",
 CellID->144821122],
Cell[5612, 197, 87, 1, 70, "ExampleText",
 CellID->571580703],
Cell[5702, 200, 174, 6, 70, "Input",
 CellID->528886812],
Cell[5879, 208, 194, 7, 70, "Input",
 CellID->68172932],
Cell[CellGroupData[{
Cell[6098, 219, 134, 4, 70, "Input",
 CellID->4370932],
Cell[6235, 225, 254, 9, 36, "Output",
 CellID->183033878]
}, Open  ]],
Cell[6504, 237, 130, 4, 70, "ExampleText",
 CellID->71569699],
Cell[CellGroupData[{
Cell[6659, 245, 446, 15, 70, "Input",
 CellID->856232381],
Cell[7108, 262, 157, 5, 36, "Output",
 CellID->46029370]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7326, 274, 311, 9, 70, "SeeAlsoSection",
 CellID->27667],
Cell[7640, 285, 507, 17, 70, "SeeAlso",
 CellID->11128]
}, Open  ]],
Cell[CellGroupData[{
Cell[8184, 307, 314, 9, 70, "TutorialsSection",
 CellID->28672],
Cell[8501, 318, 163, 3, 70, "Tutorials",
 CellID->18352]
}, Open  ]],
Cell[8679, 324, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

