(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11604,        417]
NotebookOptionsPosition[      8859,        326]
NotebookOutlinePosition[     10172,        363]
CellTagsIndexPosition[     10088,        358]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Div" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Div"], "Grad" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Grad"], 
          "Laplacian" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Laplacian"], 
          "Biharmonic" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/Biharmonic"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Div\"\>", 2->"\<\"Grad\"\>", 
       3->"\<\"Laplacian\"\>", 4->"\<\"Biharmonic\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Curl", "ObjectName",
 CellID->6382],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Curl", "[", 
       StyleBox["f", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the curl, ",
     Cell[BoxData[
      RowBox[{"\[Del]", 
       RowBox[{"\[Cross]", 
        StyleBox["f", "TI"]}]}]], "InlineFormula"],
     ", of the vector field ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " in the default coordinate system. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Curl", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["coordsys", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the curl of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " in the coordinate system ",
     Cell[BoxData[
      StyleBox["coordsys", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->27261]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The vector field ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " should be a 3-element list where each element is a function of the \
coordinates of the appropriate coordinate system."
}], "Notes",
 CellID->26395]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->334413341],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->208449777],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->17498507],

Cell["Compute the curl of a vector field:", "ExampleText",
 CellID->9556053],

Cell[BoxData[
 RowBox[{"v", ":=", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"3", 
      RowBox[{"Xx", "^", "2"}]}], " ", "+", 
     RowBox[{"2", "Yy"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "  ", "-", 
        RowBox[{"3", " ", "b"}]}], ")"}], "  ", "Zz"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", " ", "-", 
        RowBox[{"7", "a"}]}], ")"}], "Xx"}], " ", "-", 
     RowBox[{"5", "Yy"}], " ", "-", " ", "Zz"}], ",", " ", 
    RowBox[{
     RowBox[{"2", "Xx"}], "+", 
     RowBox[{"c", " ", "a", " ", "Yy"}], "+", 
     RowBox[{"7", "Zz"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20059496],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Curl", "[", "v", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->704563135],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"a", " ", "c"}]}], ",", 
   RowBox[{
    RowBox[{"-", "2"}], "+", "a", "-", 
    RowBox[{"3", " ", "b"}]}], ",", 
   RowBox[{
    RowBox[{"-", "2"}], "-", 
    RowBox[{"7", " ", "a"}], "+", "b"}]}], "}"}]], "Output",
 ImageSize->{205, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1021442526]
}, Open  ]],

Cell["\<\
Find the parameter values for which the vector field is irrotational:\
\>", "ExampleText",
 CellID->64603108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Curl", "[", "v", "]"}], " ", "\[Equal]", "0"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->183259421],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"b", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["4", "5"]}]}], ",", 
    RowBox[{"c", "\[Rule]", 
     FractionBox["5", "2"]}], ",", 
    RowBox[{"a", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["2", "5"]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{173, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->41225535]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26758],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Div",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Div"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Grad",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Grad"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Laplacian",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Laplacian"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Biharmonic",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Biharmonic"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7372]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27151],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->20666]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Curl - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 7.7318776}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "Curl[f] gives the curl, \\[Del]*f, of the vector field f in the default \
coordinate system. Curl[f, coordsys] gives the curl of f in the coordinate \
system coordsys.", "synonyms" -> {}, "title" -> "Curl", "type" -> "Symbol", 
    "uri" -> "VectorAnalysis/ref/Curl"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4078, 136, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->334413341]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9945, 351}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1558, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2181, 65, 41, 1, 70, "ObjectName",
 CellID->6382],
Cell[2225, 68, 1055, 34, 70, "Usage",
 CellID->27261]
}, Open  ]],
Cell[CellGroupData[{
Cell[3317, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3795, 124, 246, 7, 70, "Notes",
 CellID->26395]
}, Closed]],
Cell[CellGroupData[{
Cell[4078, 136, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->334413341],
Cell[CellGroupData[{
Cell[4463, 150, 148, 5, 70, "ExampleSection",
 CellID->208449777],
Cell[4614, 157, 138, 4, 70, "Input",
 CellID->17498507],
Cell[4755, 163, 76, 1, 70, "ExampleText",
 CellID->9556053],
Cell[4834, 166, 688, 23, 70, "Input",
 CellID->20059496],
Cell[CellGroupData[{
Cell[5547, 193, 100, 3, 28, "Input",
 CellID->704563135],
Cell[5650, 198, 422, 15, 36, "Output",
 CellID->1021442526]
}, Open  ]],
Cell[6087, 216, 119, 3, 70, "ExampleText",
 CellID->64603108],
Cell[CellGroupData[{
Cell[6231, 223, 257, 8, 70, "Input",
 CellID->183259421],
Cell[6491, 233, 446, 16, 51, "Output",
 CellID->41225535]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6998, 256, 311, 9, 70, "SeeAlsoSection",
 CellID->26758],
Cell[7312, 267, 988, 35, 70, "SeeAlso",
 CellID->7372]
}, Open  ]],
Cell[CellGroupData[{
Cell[8337, 307, 314, 9, 70, "TutorialsSection",
 CellID->27151],
Cell[8654, 318, 163, 3, 70, "Tutorials",
 CellID->20666]
}, Open  ]],
Cell[8832, 324, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

