(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10582,        387]
NotebookOptionsPosition[      7665,        290]
NotebookOutlinePosition[      9041,        328]
CellTagsIndexPosition[      8957,        323]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cartesian" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Cartesian"], 
          "Spherical" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Spherical"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Cartesian\"\>", 
       2->"\<\"Spherical\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Cylindrical", "ObjectName",
 CellID->19140],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Cylindrical"], "InlineFormula"],
     "\[LineSeparator]represents the cylindrical coordinate system with \
default variables ",
     Cell[BoxData[
      ButtonBox["Rr",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Rr"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Ttheta",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Ttheta"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      ButtonBox["Zz",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Zz"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Cylindrical", "[", 
       RowBox[{
        StyleBox["r", "TI"], ",", 
        StyleBox["\[Theta]", "TR"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the cylindrical coordinate system with \
variables ",
     Cell[BoxData[
      RowBox[{
       StyleBox["r", "TI"], ",", 
       StyleBox["\[Theta]", "TR"]}]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->10048]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->563898764],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->600649726],

Cell[TextData[{
 "Use ",
 Cell[BoxData["Cylindrical"], "InlineFormula"],
 " as the default coordinate system:"
}], "ExampleText",
 CellID->428269499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", "Cylindrical", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->443597938],

Cell[BoxData[
 RowBox[{"Cylindrical", "[", 
  RowBox[{"Rr", ",", "Ttheta", ",", "Zz"}], "]"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->131424086]
}, Open  ]],

Cell["\<\
All evaluations now use cylindrical coordinates as the default:\
\>", "ExampleText",
 CellID->116864137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoordinateRanges", "[", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->709779145],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0", "\[LessEqual]", "Rr", "<", "\[Infinity]"}], ",", 
   RowBox[{
    RowBox[{"-", "\[Pi]"}], "<", "Ttheta", "\[LessEqual]", "\[Pi]"}], ",", 
   RowBox[{
    RowBox[{"-", "\[Infinity]"}], "<", "Zz", "<", "\[Infinity]"}]}], 
  "}"}]], "Output",
 ImageSize->{257, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->959908171]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobianDeterminant", "[", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->33744766],

Cell[BoxData["Rr"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->75063428]
}, Open  ]],

Cell[TextData[{
 "Reset the default coordinate system to ",
 Cell[BoxData[
  ButtonBox["Cartesian",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Cartesian"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->31402094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", "Cartesian", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->74704059],

Cell[BoxData[
 RowBox[{"Cartesian", "[", 
  RowBox[{"Xx", ",", "Yy", ",", "Zz"}], "]"}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->337927229]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18760],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cartesian",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Cartesian"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Spherical",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Spherical"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24382]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31655],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->1807]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Cylindrical - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 7.9193824}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "Cylindrical represents the cylindrical coordinate system with default \
variables Rr, Ttheta, and Zz. Cylindrical[r, \\[Theta], z] represents the \
cylindrical coordinate system with variables r, \\[Theta] and z.", 
    "synonyms" -> {}, "title" -> "Cylindrical", "type" -> "Symbol", "uri" -> 
    "VectorAnalysis/ref/Cylindrical"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3419, 113, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8822, 316}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1336, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1959, 61, 49, 1, 70, "ObjectName",
 CellID->19140],
Cell[2011, 64, 1371, 44, 70, "Usage",
 CellID->10048]
}, Open  ]],
Cell[CellGroupData[{
Cell[3419, 113, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3796, 127, 148, 5, 70, "ExampleSection",
 CellID->563898764],
Cell[3947, 134, 139, 4, 70, "Input",
 CellID->600649726],
Cell[4089, 140, 149, 5, 70, "ExampleText",
 CellID->428269499],
Cell[CellGroupData[{
Cell[4263, 149, 120, 3, 28, "Input",
 CellID->443597938],
Cell[4386, 154, 236, 7, 36, "Output",
 CellID->131424086]
}, Open  ]],
Cell[4637, 164, 114, 3, 70, "ExampleText",
 CellID->116864137],
Cell[CellGroupData[{
Cell[4776, 171, 107, 3, 28, "Input",
 CellID->709779145],
Cell[4886, 176, 426, 13, 36, "Output",
 CellID->959908171]
}, Open  ]],
Cell[CellGroupData[{
Cell[5349, 194, 109, 3, 70, "Input",
 CellID->33744766],
Cell[5461, 199, 158, 5, 36, "Output",
 CellID->75063428]
}, Open  ]],
Cell[5634, 207, 238, 8, 70, "ExampleText",
 CellID->31402094],
Cell[CellGroupData[{
Cell[5897, 219, 117, 3, 70, "Input",
 CellID->74704059],
Cell[6017, 224, 230, 7, 36, "Output",
 CellID->337927229]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6308, 238, 311, 9, 70, "SeeAlsoSection",
 CellID->18760],
Cell[6622, 249, 485, 17, 70, "SeeAlso",
 CellID->24382]
}, Open  ]],
Cell[CellGroupData[{
Cell[7144, 271, 314, 9, 70, "TutorialsSection",
 CellID->31655],
Cell[7461, 282, 162, 3, 70, "Tutorials",
 CellID->1807]
}, Open  ]],
Cell[7638, 288, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

