(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11257,        403]
NotebookOptionsPosition[      8437,        310]
NotebookOutlinePosition[      9769,        347]
CellTagsIndexPosition[      9685,        342]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Curl" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Curl"], "Grad" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Grad"], 
          "Laplacian" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Laplacian"], 
          "Biharmonic" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/Biharmonic"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Curl\"\>", 2->"\<\"Grad\"\>", 
       3->"\<\"Laplacian\"\>", 4->"\<\"Biharmonic\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Div", "ObjectName",
 CellID->25565],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Div", "[", 
       StyleBox["f", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the divergence, ",
     Cell[BoxData[
      RowBox[{"\[Del]", 
       RowBox[{"\[CenterDot]", 
        StyleBox["f", "TI"]}]}]], "InlineFormula"],
     ", of the vector field ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " in the default coordinate system. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Div", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["coordsys", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the divergence of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " in the coordinate system ",
     Cell[BoxData[
      StyleBox["coordsys", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->28221]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The vector field ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " should be a 3-element list where each element is a function of the \
coordinates of the appropriate coordinate system."
}], "Notes",
 CellID->22133]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->123346628],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->122392582],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->5001598],

Cell["Compute the divergence of a vector field:", "ExampleText",
 CellID->245110001],

Cell[BoxData[
 RowBox[{"v", ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"Xx", "^", "2"}], "+", "Zz"}], ",", " ", 
    RowBox[{"Yy", "*", 
     RowBox[{"Sin", "[", "Xx", "]"}]}], ",", " ", 
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"3", "Zz"}], ")"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25566524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Div", "[", "v", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->84095110],

Cell[BoxData[
 RowBox[{
  RowBox[{"3", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"3", " ", "Zz"}]]}], "+", 
  RowBox[{"2", " ", "Xx"}], "+", 
  RowBox[{"Sin", "[", "Xx", "]"}]}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->109971914]
}, Open  ]],

Cell["\<\
Verify that the divergence of the curl of a vector field is 0:\
\>", "ExampleText",
 CellID->2311719],

Cell[BoxData[
 RowBox[{"w", ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"Xx", ",", " ", "Yy", ",", " ", "Zz"}], "]"}], ",", " ", 
    RowBox[{"g", "[", 
     RowBox[{"Xx", ",", " ", "Yy", ",", " ", "Zz"}], "]"}], ",", " ", 
    RowBox[{"h", "[", 
     RowBox[{"Xx", ",", " ", "Yy", ",", " ", "Zz"}], "]"}]}], "}"}], 
  " "}]], "Input",
 CellLabel->"In[4]:=",
 CellID->73999190],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Div", "[", 
  RowBox[{"Curl", "[", "w", "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->872824419],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->116567102]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17362],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Curl",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Curl"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Grad",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Grad"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Laplacian",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Laplacian"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Biharmonic",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Biharmonic"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23954]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13175],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->6241]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Div - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 8.1068872}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "Div[f] gives the divergence, \\[Del]\\[CenterDot]f, of the vector field \
f in the default coordinate system. Div[f, coordsys] gives the divergence of \
f in the coordinate system coordsys.", "synonyms" -> {}, "title" -> "Div", 
    "type" -> "Symbol", "uri" -> "VectorAnalysis/ref/Div"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4095, 136, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->123346628]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9542, 335}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1561, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2184, 65, 41, 1, 70, "ObjectName",
 CellID->25565],
Cell[2228, 68, 1069, 34, 70, "Usage",
 CellID->28221]
}, Open  ]],
Cell[CellGroupData[{
Cell[3334, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3812, 124, 246, 7, 70, "Notes",
 CellID->22133]
}, Closed]],
Cell[CellGroupData[{
Cell[4095, 136, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->123346628],
Cell[CellGroupData[{
Cell[4480, 150, 148, 5, 70, "ExampleSection",
 CellID->122392582],
Cell[4631, 157, 137, 4, 70, "Input",
 CellID->5001598],
Cell[4771, 163, 84, 1, 70, "ExampleText",
 CellID->245110001],
Cell[4858, 166, 346, 12, 70, "Input",
 CellID->25566524],
Cell[CellGroupData[{
Cell[5229, 182, 98, 3, 28, "Input",
 CellID->84095110],
Cell[5330, 187, 334, 11, 36, "Output",
 CellID->109971914]
}, Open  ]],
Cell[5679, 201, 111, 3, 70, "ExampleText",
 CellID->2311719],
Cell[5793, 206, 404, 12, 70, "Input",
 CellID->73999190],
Cell[CellGroupData[{
Cell[6222, 222, 130, 4, 70, "Input",
 CellID->872824419],
Cell[6355, 228, 158, 5, 36, "Output",
 CellID->116567102]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6574, 240, 311, 9, 70, "SeeAlsoSection",
 CellID->17362],
Cell[6888, 251, 991, 35, 70, "SeeAlso",
 CellID->23954]
}, Open  ]],
Cell[CellGroupData[{
Cell[7916, 291, 314, 9, 70, "TutorialsSection",
 CellID->13175],
Cell[8233, 302, 162, 3, 70, "Tutorials",
 CellID->6241]
}, Open  ]],
Cell[8410, 308, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

