(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8046,        292]
NotebookOptionsPosition[      5691,        213]
NotebookOutlinePosition[      6936,        249]
CellTagsIndexPosition[      6852,        244]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Xxi" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Xxi"], "Pphi" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Pphi"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Xxi\"\>", 
       2->"\<\"Pphi\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Eeta", "ObjectName",
 CellID->5234],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Eeta"], "InlineFormula"],
     "\[LineSeparator]is one of the default coordinates for the ",
     Cell[BoxData[
      ButtonBox["ProlateSpheroidal",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/ProlateSpheroidal"]], 
      "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["OblateSpheroidal",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/OblateSpheroidal"]], 
      "InlineFormula"],
     " coordinate systems."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26841]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->440821500],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->88122904],

Cell[TextData[{
 Cell[BoxData["Eeta"], "InlineFormula"],
 " is used as a coordinate in the following systems:"
}], "ExampleText",
 CellID->35004531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "ProlateSpheroidal", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->406403560],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Xxi", ",", "Eeta", ",", "Pphi"}], "}"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->39743007]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "OblateSpheroidal", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->566909803],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Xxi", ",", "Eeta", ",", "Pphi"}], "}"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->43753564]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16811],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Xxi",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Xxi"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pphi",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Pphi"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21793]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24019],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->25352]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Eeta - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 14.8414346}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "Eeta is one of the default coordinates for the ProlateSpheroidal and \
OblateSpheroidal coordinate systems.", "synonyms" -> {}, "title" -> "Eeta", 
    "type" -> "Symbol", "uri" -> "VectorAnalysis/ref/Eeta"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2722, 90, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6718, 237}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1292, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1915, 60, 41, 1, 70, "ObjectName",
 CellID->5234],
Cell[1959, 63, 726, 22, 70, "Usage",
 CellID->26841]
}, Open  ]],
Cell[CellGroupData[{
Cell[2722, 90, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3099, 104, 148, 5, 70, "ExampleSection",
 CellID->440821500],
Cell[3250, 111, 138, 4, 70, "Input",
 CellID->88122904],
Cell[3391, 117, 148, 4, 70, "ExampleText",
 CellID->35004531],
Cell[CellGroupData[{
Cell[3564, 125, 123, 3, 28, "Input",
 CellID->406403560],
Cell[3690, 130, 221, 7, 36, "Output",
 CellID->39743007]
}, Open  ]],
Cell[CellGroupData[{
Cell[3948, 142, 122, 3, 28, "Input",
 CellID->566909803],
Cell[4073, 147, 221, 7, 36, "Output",
 CellID->43753564]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4355, 161, 311, 9, 70, "SeeAlsoSection",
 CellID->16811],
Cell[4669, 172, 463, 17, 70, "SeeAlso",
 CellID->21793]
}, Open  ]],
Cell[CellGroupData[{
Cell[5169, 194, 314, 9, 70, "TutorialsSection",
 CellID->24019],
Cell[5486, 205, 163, 3, 70, "Tutorials",
 CellID->25352]
}, Open  ]],
Cell[5664, 211, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

