(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12849,        449]
NotebookOptionsPosition[      9695,        349]
NotebookOutlinePosition[     11308,        390]
CellTagsIndexPosition[     11223,        385]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Paraboloidal" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Paraboloidal"], 
          "ParabolicCylindrical" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/ParabolicCylindrical"], 
          "ProlateSpheroidal" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/ProlateSpheroidal"], "OblateSpheroidal" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/OblateSpheroidal"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Paraboloidal\"\>", 
       2->"\<\"ParabolicCylindrical\"\>", 3->"\<\"ProlateSpheroidal\"\>", 
       4->"\<\"OblateSpheroidal\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EllipticCylindrical", "ObjectName",
 CellID->23162],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["EllipticCylindrical"], "InlineFormula"],
     "\[LineSeparator]represents the elliptic cylindrical coordinate system \
with default variables ",
     Cell[BoxData[
      ButtonBox["Uu",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Uu"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Vv",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Vv"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      ButtonBox["Zz",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Zz"]], "InlineFormula"],
     " and default parameter value ",
     Cell[BoxData[
      StyleBox["1", "TR"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"EllipticCylindrical", "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["v", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the elliptic cylindrical coordinate system \
with variables ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     " and default parameter value ",
     StyleBox["1", "TR"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"EllipticCylindrical", "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["v", "TI"], ",", 
        StyleBox["z", "TI"], ",", 
        StyleBox["a", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the elliptic cylindrical coordinate system \
with variables ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     " and parameter ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->12537]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->61057702],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->45053717],

Cell[TextData[{
 "Use ",
 Cell[BoxData["EllipticCylindrical"], "InlineFormula"],
 " as the default coordinate system:"
}], "ExampleText",
 CellID->428269499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", "EllipticCylindrical", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->443597938],

Cell[BoxData[
 RowBox[{"EllipticCylindrical", "[", 
  RowBox[{"Uu", ",", "Vv", ",", "Zz", ",", "1"}], "]"}]], "Output",
 ImageSize->{234, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17952433]
}, Open  ]],

Cell["\<\
All evaluations now use elliptic cylindrical coordinates as the default:\
\>", "ExampleText",
 CellID->116864137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoordinateRanges", "[", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->709779145],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0", "\[LessEqual]", "Uu", "<", "\[Infinity]"}], ",", 
   RowBox[{
    RowBox[{"-", "\[Pi]"}], "<", "Vv", "\[LessEqual]", "\[Pi]"}], ",", 
   RowBox[{
    RowBox[{"-", "\[Infinity]"}], "<", "Zz", "<", "\[Infinity]"}]}], 
  "}"}]], "Output",
 ImageSize->{229, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->51370030]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobianDeterminant", "[", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->33744766],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"Sin", "[", "Vv", "]"}], "2"], "+", 
  SuperscriptBox[
   RowBox[{"Sinh", "[", "Uu", "]"}], "2"]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->226943758]
}, Open  ]],

Cell[TextData[{
 "Reset the default coordinate system to ",
 Cell[BoxData[
  ButtonBox["Cartesian",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Cartesian"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->31402094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", "Cartesian", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->74704059],

Cell[BoxData[
 RowBox[{"Cartesian", "[", 
  RowBox[{"Xx", ",", "Yy", ",", "Zz"}], "]"}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->693862426]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18938],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Paraboloidal",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Paraboloidal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ParabolicCylindrical",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/ParabolicCylindrical"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ProlateSpheroidal",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/ProlateSpheroidal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OblateSpheroidal",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/OblateSpheroidal"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27445]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18551],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->25851]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EllipticCylindrical - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 15.1539426}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "EllipticCylindrical represents the elliptic cylindrical coordinate \
system with default variables Uu, Vv, and Zz and default parameter value 1. \
EllipticCylindrical[u, v, z] represents the elliptic cylindrical coordinate \
system with variables u, v, and z and default parameter value 1. \
EllipticCylindrical[u, v, z, a] represents the elliptic cylindrical \
coordinate system with variables u, v, and z and parameter a.", 
    "synonyms" -> {}, "title" -> "EllipticCylindrical", "type" -> "Symbol", 
    "uri" -> "VectorAnalysis/ref/EllipticCylindrical"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4699, 149, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11088, 378}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1707, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2330, 68, 57, 1, 70, "ObjectName",
 CellID->23162],
Cell[2390, 71, 2272, 73, 70, "Usage",
 CellID->12537]
}, Open  ]],
Cell[CellGroupData[{
Cell[4699, 149, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[5076, 163, 147, 5, 70, "ExampleSection",
 CellID->61057702],
Cell[5226, 170, 138, 4, 70, "Input",
 CellID->45053717],
Cell[5367, 176, 157, 5, 70, "ExampleText",
 CellID->428269499],
Cell[CellGroupData[{
Cell[5549, 185, 128, 3, 28, "Input",
 CellID->443597938],
Cell[5680, 190, 249, 7, 36, "Output",
 CellID->17952433]
}, Open  ]],
Cell[5944, 200, 123, 3, 70, "ExampleText",
 CellID->116864137],
Cell[CellGroupData[{
Cell[6092, 207, 107, 3, 28, "Input",
 CellID->709779145],
Cell[6202, 212, 421, 13, 36, "Output",
 CellID->51370030]
}, Open  ]],
Cell[CellGroupData[{
Cell[6660, 230, 109, 3, 70, "Input",
 CellID->33744766],
Cell[6772, 235, 294, 10, 36, "Output",
 CellID->226943758]
}, Open  ]],
Cell[7081, 248, 238, 8, 70, "ExampleText",
 CellID->31402094],
Cell[CellGroupData[{
Cell[7344, 260, 117, 3, 70, "Input",
 CellID->74704059],
Cell[7464, 265, 230, 7, 36, "Output",
 CellID->693862426]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7755, 279, 311, 9, 70, "SeeAlsoSection",
 CellID->18938],
Cell[8069, 290, 1067, 35, 70, "SeeAlso",
 CellID->27445]
}, Open  ]],
Cell[CellGroupData[{
Cell[9173, 330, 314, 9, 70, "TutorialsSection",
 CellID->18551],
Cell[9490, 341, 163, 3, 70, "Tutorials",
 CellID->25851]
}, Open  ]],
Cell[9668, 347, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

