(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16626,        571]
NotebookOptionsPosition[     13477,        469]
NotebookOutlinePosition[     14986,        509]
CellTagsIndexPosition[     14901,        504]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"JacobianDeterminant" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/JacobianDeterminant"], 
          "ArcLengthFactor" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/ArcLengthFactor"], "ScaleFactors" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/ScaleFactors"], 
          "Div" :> Documentation`HelpLookup["paclet:VectorAnalysis/ref/Div"], 
          "Curl" :> Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/Curl"], "Grad" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Grad"], 
          "Laplacian" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Laplacian"], 
          "Biharmonic" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Biharmonic"], 
          "DotProduct" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/DotProduct"], 
          "CrossProduct" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/CrossProduct"], 
          "ScalarTripleProduct" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/ScalarTripleProduct"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"JacobianDeterminant\"\>", 
       2->"\<\"ArcLengthFactor\"\>", 3->"\<\"ScaleFactors\"\>", 
       4->"\<\"Div\"\>", 5->"\<\"Curl\"\>", 6->"\<\"Grad\"\>", 
       7->"\<\"Laplacian\"\>", 8->"\<\"Biharmonic\"\>", 
       9->"\<\"DotProduct\"\>", 10->"\<\"CrossProduct\"\>", 
       11->"\<\"ScalarTripleProduct\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JacobianMatrix", "ObjectName",
 CellID->8785],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"JacobianMatrix", "[", 
       StyleBox["pt", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Jacobian matrix of the transformation from \
the default coordinate system to the Cartesian coordinate system at the point \
",
     Cell[BoxData[
      StyleBox["pt", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"JacobianMatrix", "[", 
       RowBox[{
        StyleBox["pt", "TI"], ",", 
        StyleBox["coordsys", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Jacobian matrix of the transformation from \
the coordinate system ",
     Cell[BoxData[
      StyleBox["coordsys", "TI"]], "InlineFormula"],
     " to the Cartesian coordinate system at the point ",
     Cell[BoxData[
      StyleBox["pt", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->23774]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The Jacobian matrix consists of the elements ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["m", "TI"], 
    StyleBox[
     RowBox[{"i", ",", "j"}], "TI"]], "=", 
   RowBox[{
    SubscriptBox["\[PartialD]", 
     SubscriptBox[
      StyleBox["u", "TI"], 
      StyleBox["j", "TI"]]], 
    SubscriptBox[
     StyleBox["r", "TI"], 
     StyleBox["i", "TI"]]}]}]], "InlineFormula"],
 " where ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["r", "TI"], "1"], ",", 
   SubscriptBox[
    StyleBox["r", "TI"], 
    StyleBox["2", "TR"]], ",", 
   SubscriptBox[
    StyleBox["r", "TI"], 
    StyleBox["3", "TR"]]}]], "InlineFormula"],
 " are the Cartesian coordinates ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], ",", 
   StyleBox["y", "TI"], ",", 
   StyleBox["z", "TI"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["u", "TI"], "1"], ",", 
   SubscriptBox[
    StyleBox["u", "TI"], 
    StyleBox["2", "TR"]], ",", 
   SubscriptBox[
    StyleBox["u", "TI"], 
    StyleBox["3", "TR"]]}]], "InlineFormula"],
 " are the coordinates of the coordinate system ",
 Cell[BoxData[
  StyleBox["coordsys", "TI"]], "InlineFormula"],
 ", if specified, or the default coordinate system otherwise."
}], "Notes",
 CellID->19184],

Cell[TextData[{
 "The coordinates of ",
 Cell[BoxData[
  StyleBox["pt", "TI"]], "InlineFormula"],
 " should be given in the coordinate system ",
 Cell[BoxData[
  StyleBox["coordsys", "TI"]], "InlineFormula"],
 ", if specified, or the default coordinate system otherwise."
}], "Notes",
 CellID->6651],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["pt", "TI"]], "InlineFormula"],
 " is not given, the default coordinate variables for ",
 Cell[BoxData[
  StyleBox["coordsys", "TI"]], "InlineFormula"],
 " are used."
}], "Notes",
 CellID->18884]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->506492516],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->16756784],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->542289294],

Cell["\<\
Jacobian matrix for transformation from cylindrical to Cartesian coordinates:\
\
\>", "ExampleText",
 CellID->32079075],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobianMatrix", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Rr", ",", " ", "Ttheta", ",", " ", "Zz"}], "}"}], ",", " ", 
    "Cylindrical"}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->114494658],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"Cos", "[", "Ttheta", "]"}], 
      RowBox[{
       RowBox[{"-", "Rr"}], " ", 
       RowBox[{"Sin", "[", "Ttheta", "]"}]}], "0"},
     {
      RowBox[{"Sin", "[", "Ttheta", "]"}], 
      RowBox[{"Rr", " ", 
       RowBox[{"Cos", "[", "Ttheta", "]"}]}], "0"},
     {"0", "0", "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{226, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->132121740]
}, Open  ]],

Cell["Determinant for this transformation:", "ExampleText",
 CellID->195274895],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Det", "[", "%", "]"}], "//", "Simplify"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->817544068],

Cell[BoxData["Rr"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->186697450]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobianDeterminant", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Rr", ",", " ", "Ttheta", ",", " ", "Zz"}], "}"}], ",", " ", 
   "Cylindrical"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->136547481],

Cell[BoxData["Rr"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->435622140]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19074],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobianDeterminant",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/JacobianDeterminant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcLengthFactor",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/ArcLengthFactor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScaleFactors",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/ScaleFactors"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Div",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Div"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Curl",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Curl"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Grad",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Grad"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Laplacian",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Laplacian"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Biharmonic",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Biharmonic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DotProduct",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/DotProduct"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CrossProduct",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/CrossProduct"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScalarTripleProduct",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/ScalarTripleProduct"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13759]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27037],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->10915]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JacobianMatrix - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 16.1070920}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "JacobianMatrix[pt] gives the Jacobian matrix of the transformation from \
the default coordinate system to the Cartesian coordinate system at the point \
pt. JacobianMatrix[pt, coordsys] gives the Jacobian matrix of the \
transformation from the coordinate system coordsys to the Cartesian \
coordinate system at the point pt.", "synonyms" -> {}, "title" -> 
    "JacobianMatrix", "type" -> "Symbol", "uri" -> 
    "VectorAnalysis/ref/JacobianMatrix"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6727, 216, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->506492516]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14758, 497}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2561, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3184, 83, 51, 1, 70, "ObjectName",
 CellID->8785],
Cell[3238, 86, 1092, 32, 70, "Usage",
 CellID->23774]
}, Open  ]],
Cell[CellGroupData[{
Cell[4367, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4845, 140, 1295, 49, 70, "Notes",
 CellID->19184],
Cell[6143, 191, 299, 9, 70, "Notes",
 CellID->6651],
Cell[6445, 202, 245, 9, 70, "Notes",
 CellID->18884]
}, Closed]],
Cell[CellGroupData[{
Cell[6727, 216, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->506492516],
Cell[CellGroupData[{
Cell[7112, 230, 147, 5, 70, "ExampleSection",
 CellID->16756784],
Cell[7262, 237, 139, 4, 70, "Input",
 CellID->542289294],
Cell[7404, 243, 129, 4, 70, "ExampleText",
 CellID->32079075],
Cell[CellGroupData[{
Cell[7558, 251, 265, 8, 28, "Input",
 CellID->114494658],
Cell[7826, 261, 995, 30, 78, "Output",
 CellID->132121740]
}, Open  ]],
Cell[8836, 294, 79, 1, 70, "ExampleText",
 CellID->195274895],
Cell[CellGroupData[{
Cell[8940, 299, 130, 4, 70, "Input",
 CellID->817544068],
Cell[9073, 305, 159, 5, 36, "Output",
 CellID->186697450]
}, Open  ]],
Cell[CellGroupData[{
Cell[9269, 315, 233, 7, 70, "Input",
 CellID->136547481],
Cell[9505, 324, 159, 5, 36, "Output",
 CellID->435622140]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9725, 336, 311, 9, 70, "SeeAlsoSection",
 CellID->19074],
Cell[10039, 347, 2879, 98, 70, "SeeAlso",
 CellID->13759]
}, Open  ]],
Cell[CellGroupData[{
Cell[12955, 450, 314, 9, 70, "TutorialsSection",
 CellID->27037],
Cell[13272, 461, 163, 3, 70, "Tutorials",
 CellID->10915]
}, Open  ]],
Cell[13450, 467, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

