(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8799,        321]
NotebookOptionsPosition[      6260,        235]
NotebookOutlinePosition[      7538,        272]
CellTagsIndexPosition[      7454,        267]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mmu" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Mmu"], "Nnu" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Nnu"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Mmu\"\>", 
       2->"\<\"Nnu\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Llambda", "ObjectName",
 CellID->12425],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Llambda"], "InlineFormula"],
     " \[LineSeparator]is one of the default coordinates for the ",
     Cell[BoxData[
      ButtonBox["Conical",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Conical"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["ConfocalEllipsoidal",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/ConfocalEllipsoidal"]], 
      "InlineFormula"],
     ", and ",
     Cell[BoxData[
      ButtonBox["ConfocalParaboloidal",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/ConfocalParaboloidal"]], 
      "InlineFormula"],
     " coordinate systems."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26896]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->623458797],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->235907080],

Cell[TextData[{
 Cell[BoxData["Llambda"], "InlineFormula"],
 " is used as a coordinate in several coordinate systems:"
}], "ExampleText",
 CellID->35004531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "Conical", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->406403560],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Llambda", ",", "Mmu", ",", "Nnu"}], "}"}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->225086390]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "ConfocalEllipsoidal", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->566909803],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Llambda", ",", "Mmu", ",", "Nnu"}], "}"}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->441259458]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "ConfocalParaboloidal", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->6802135],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Llambda", ",", "Mmu", ",", "Nnu"}], "}"}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->628818435]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5970],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mmu",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Mmu"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Nnu",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Nnu"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19537]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27769],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->25331]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Llambda - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 16.7633588}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "Llambda is one of the default coordinates for the Conical, \
ConfocalEllipsoidal, and ConfocalParaboloidal coordinate systems.", 
    "synonyms" -> {}, "title" -> "Llambda", "type" -> "Symbol", "uri" -> 
    "VectorAnalysis/ref/Llambda"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2898, 95, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7320, 260}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1288, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1911, 60, 45, 1, 70, "ObjectName",
 CellID->12425],
Cell[1959, 63, 902, 27, 70, "Usage",
 CellID->26896]
}, Open  ]],
Cell[CellGroupData[{
Cell[2898, 95, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3275, 109, 148, 5, 70, "ExampleSection",
 CellID->623458797],
Cell[3426, 116, 139, 4, 70, "Input",
 CellID->235907080],
Cell[3568, 122, 156, 4, 70, "ExampleText",
 CellID->35004531],
Cell[CellGroupData[{
Cell[3749, 130, 113, 3, 28, "Input",
 CellID->406403560],
Cell[3865, 135, 224, 7, 36, "Output",
 CellID->225086390]
}, Open  ]],
Cell[CellGroupData[{
Cell[4126, 147, 125, 3, 28, "Input",
 CellID->566909803],
Cell[4254, 152, 224, 7, 36, "Output",
 CellID->441259458]
}, Open  ]],
Cell[CellGroupData[{
Cell[4515, 164, 124, 3, 28, "Input",
 CellID->6802135],
Cell[4642, 169, 224, 7, 36, "Output",
 CellID->628818435]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4927, 183, 310, 9, 70, "SeeAlsoSection",
 CellID->5970],
Cell[5240, 194, 461, 17, 70, "SeeAlso",
 CellID->19537]
}, Open  ]],
Cell[CellGroupData[{
Cell[5738, 216, 314, 9, 70, "TutorialsSection",
 CellID->27769],
Cell[6055, 227, 163, 3, 70, "Tutorials",
 CellID->25331]
}, Open  ]],
Cell[6233, 233, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

