(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8791,        322]
NotebookOptionsPosition[      6274,        236]
NotebookOutlinePosition[      7536,        273]
CellTagsIndexPosition[      7452,        268]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Llambda" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Llambda"], 
          "Mmu" :> Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/Mmu"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Llambda\"\>", 
       2->"\<\"Mmu\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Nnu", "ObjectName",
 CellID->15791],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Nnu"], "InlineFormula"],
     " \[LineSeparator]is one of the default coordinates for the ",
     Cell[BoxData[
      ButtonBox["Conical",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Conical"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["ConfocalEllipsoidal",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/ConfocalEllipsoidal"]], 
      "InlineFormula"],
     ", and ",
     Cell[BoxData[
      ButtonBox["ConfocalParaboloidal",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/ConfocalParaboloidal"]], 
      "InlineFormula"],
     " coordinate systems."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25422]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->607105272],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->5201763],

Cell[TextData[{
 Cell[BoxData["Nnu"], "InlineFormula"],
 " is used as a coordinate in several coordinate systems:"
}], "ExampleText",
 CellID->35004531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "Conical", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->406403560],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Llambda", ",", "Mmu", ",", "Nnu"}], "}"}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->89487641]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "ConfocalEllipsoidal", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->566909803],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Llambda", ",", "Mmu", ",", "Nnu"}], "}"}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->212508684]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "ConfocalParaboloidal", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->6802135],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Llambda", ",", "Mmu", ",", "Nnu"}], "}"}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->207651782]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5994],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Llambda",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Llambda"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mmu",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Mmu"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->579]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8010],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->20987]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Nnu - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 22.5916330}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "Nnu is one of the default coordinates for the Conical, \
ConfocalEllipsoidal, and ConfocalParaboloidal coordinate systems.", 
    "synonyms" -> {}, "title" -> "Nnu", "type" -> "Symbol", "uri" -> 
    "VectorAnalysis/ref/Nnu"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2914, 96, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7318, 261}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1312, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1935, 61, 41, 1, 70, "ObjectName",
 CellID->15791],
Cell[1979, 64, 898, 27, 70, "Usage",
 CellID->25422]
}, Open  ]],
Cell[CellGroupData[{
Cell[2914, 96, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3291, 110, 148, 5, 70, "ExampleSection",
 CellID->607105272],
Cell[3442, 117, 137, 4, 70, "Input",
 CellID->5201763],
Cell[3582, 123, 152, 4, 70, "ExampleText",
 CellID->35004531],
Cell[CellGroupData[{
Cell[3759, 131, 113, 3, 28, "Input",
 CellID->406403560],
Cell[3875, 136, 223, 7, 36, "Output",
 CellID->89487641]
}, Open  ]],
Cell[CellGroupData[{
Cell[4135, 148, 125, 3, 28, "Input",
 CellID->566909803],
Cell[4263, 153, 224, 7, 36, "Output",
 CellID->212508684]
}, Open  ]],
Cell[CellGroupData[{
Cell[4524, 165, 124, 3, 28, "Input",
 CellID->6802135],
Cell[4651, 170, 224, 7, 36, "Output",
 CellID->207651782]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4936, 184, 310, 9, 70, "SeeAlsoSection",
 CellID->5994],
Cell[5249, 195, 467, 17, 70, "SeeAlso",
 CellID->579]
}, Open  ]],
Cell[CellGroupData[{
Cell[5753, 217, 313, 9, 70, "TutorialsSection",
 CellID->8010],
Cell[6069, 228, 163, 3, 70, "Tutorials",
 CellID->20987]
}, Open  ]],
Cell[6247, 234, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

