(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13344,        463]
NotebookOptionsPosition[     10149,        363]
NotebookOutlinePosition[     11803,        404]
CellTagsIndexPosition[     11718,        399]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Paraboloidal" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Paraboloidal"], 
          "ParabolicCylindrical" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/ParabolicCylindrical"], 
          "EllipticCylindrical" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/EllipticCylindrical"], 
          "ProlateSpheroidal" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/ProlateSpheroidal"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Paraboloidal\"\>", 
       2->"\<\"ParabolicCylindrical\"\>", 3->"\<\"EllipticCylindrical\"\>", 
       4->"\<\"ProlateSpheroidal\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["OblateSpheroidal", "ObjectName",
 CellID->30954],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["OblateSpheroidal"], "InlineFormula"],
     " \[LineSeparator]represents the oblate spheroidal coordinate system \
with default variables ",
     Cell[BoxData[
      ButtonBox["Xxi",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Xxi"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Eeta",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Eeta"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      ButtonBox["Pphi",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Pphi"]], "InlineFormula"],
     " and default parameter value ",
     Cell[BoxData[
      StyleBox["1", "TR"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"OblateSpheroidal", "[", 
       RowBox[{
        StyleBox["\[Xi]", "TR"], ",", 
        StyleBox["\[Eta]", "TR"], ",", 
        StyleBox["\[Phi]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the oblate spheroidal coordinate system with \
variables ",
     Cell[BoxData[
      RowBox[{
       StyleBox["\[Xi]", "TR"], ",", 
       StyleBox["\[Eta]", "TR"]}]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["\[Phi]", "TR"]], "InlineFormula"],
     " and default parameter value ",
     Cell[BoxData[
      StyleBox["1", "TR"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"OblateSpheroidal", "[", 
       RowBox[{
        StyleBox["\[Xi]", "TR"], ",", 
        StyleBox["\[Eta]", "TR"], ",", 
        StyleBox["\[Phi]", "TR"], ",", 
        StyleBox["a", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the oblate spheroidal coordinate system with \
variables ",
     Cell[BoxData[
      RowBox[{
       StyleBox["\[Xi]", "TR"], ",", 
       StyleBox["\[Eta]", "TR"]}]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["\[Phi]", "TR"]], "InlineFormula"],
     " and parameter ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->31504]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->19415420],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->51373493],

Cell[TextData[{
 "Use ",
 Cell[BoxData["OblateSpheroidal"], "InlineFormula"],
 " as the default coordinate system:"
}], "ExampleText",
 CellID->428269499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", "OblateSpheroidal", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->443597938],

Cell[BoxData[
 RowBox[{"OblateSpheroidal", "[", 
  RowBox[{"Xxi", ",", "Eeta", ",", "Pphi", ",", "1"}], "]"}]], "Output",
 ImageSize->{248, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->70339710]
}, Open  ]],

Cell["\<\
All evaluations now use oblate spheroidal coordinates as the default:\
\>", "ExampleText",
 CellID->116864137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoordinateRanges", "[", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->709779145],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0", "\[LessEqual]", "Xxi", "<", "\[Infinity]"}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["\[Pi]", "2"]}], "\[LessEqual]", "Eeta", "\[LessEqual]", 
    FractionBox["\[Pi]", "2"]}], ",", 
   RowBox[{
    RowBox[{"-", "\[Pi]"}], "<", "Pphi", "\[LessEqual]", "\[Pi]"}]}], 
  "}"}]], "Output",
 ImageSize->{272, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->420444561]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ScaleFactors", "[", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->33744766],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SqrtBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", "Eeta", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"Sinh", "[", "Xxi", "]"}], "2"]}]], ",", 
   SqrtBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", "Eeta", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"Sinh", "[", "Xxi", "]"}], "2"]}]], ",", 
   RowBox[{
    RowBox[{"Cos", "[", "Xxi", "]"}], " ", 
    RowBox[{"Cosh", "[", "Eeta", "]"}]}]}], "}"}]], "Output",
 ImageSize->{507, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->301973671]
}, Open  ]],

Cell[TextData[{
 "Reset the default coordinate system to ",
 Cell[BoxData[
  ButtonBox["Cartesian",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Cartesian"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->31402094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", "Cartesian", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->74704059],

Cell[BoxData[
 RowBox[{"Cartesian", "[", 
  RowBox[{"Xx", ",", "Yy", ",", "Zz"}], "]"}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->30197421]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16114],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Paraboloidal",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Paraboloidal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ParabolicCylindrical",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/ParabolicCylindrical"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticCylindrical",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/EllipticCylindrical"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ProlateSpheroidal",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/ProlateSpheroidal"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10350]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3281],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->14246]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"OblateSpheroidal - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 22.8260140}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "OblateSpheroidal represents the oblate spheroidal coordinate system with \
default variables Xxi, Eeta, and Pphi and default parameter value 1. \
OblateSpheroidal[\\[Xi], \\[Eta], \\[Phi]] represents the oblate spheroidal \
coordinate system with variables \\[Xi], \\[Eta] and \\[Phi] and default \
parameter value 1. OblateSpheroidal[\\[Xi], \\[Eta], \\[Phi], a] represents \
the oblate spheroidal coordinate system with variables \\[Xi], \\[Eta] and \
\\[Phi] and parameter a.", "synonyms" -> {}, "title" -> "OblateSpheroidal", 
    "type" -> "Symbol", "uri" -> "VectorAnalysis/ref/OblateSpheroidal"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4754, 149, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11583, 392}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1727, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2350, 69, 54, 1, 70, "ObjectName",
 CellID->30954],
Cell[2407, 72, 2310, 72, 70, "Usage",
 CellID->31504]
}, Open  ]],
Cell[CellGroupData[{
Cell[4754, 149, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[5131, 163, 147, 5, 70, "ExampleSection",
 CellID->19415420],
Cell[5281, 170, 138, 4, 70, "Input",
 CellID->51373493],
Cell[5422, 176, 154, 5, 70, "ExampleText",
 CellID->428269499],
Cell[CellGroupData[{
Cell[5601, 185, 125, 3, 28, "Input",
 CellID->443597938],
Cell[5729, 190, 251, 7, 36, "Output",
 CellID->70339710]
}, Open  ]],
Cell[5995, 200, 120, 3, 70, "ExampleText",
 CellID->116864137],
Cell[CellGroupData[{
Cell[6140, 207, 107, 3, 28, "Input",
 CellID->709779145],
Cell[6250, 212, 484, 15, 49, "Output",
 CellID->420444561]
}, Open  ]],
Cell[CellGroupData[{
Cell[6771, 232, 102, 3, 70, "Input",
 CellID->33744766],
Cell[6876, 237, 640, 22, 48, "Output",
 CellID->301973671]
}, Open  ]],
Cell[7531, 262, 238, 8, 70, "ExampleText",
 CellID->31402094],
Cell[CellGroupData[{
Cell[7794, 274, 117, 3, 70, "Input",
 CellID->74704059],
Cell[7914, 279, 229, 7, 36, "Output",
 CellID->30197421]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8204, 293, 311, 9, 70, "SeeAlsoSection",
 CellID->16114],
Cell[8518, 304, 1073, 35, 70, "SeeAlso",
 CellID->10350]
}, Open  ]],
Cell[CellGroupData[{
Cell[9628, 344, 313, 9, 70, "TutorialsSection",
 CellID->3281],
Cell[9944, 355, 163, 3, 70, "Tutorials",
 CellID->14246]
}, Open  ]],
Cell[10122, 361, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

