(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11731,        418]
NotebookOptionsPosition[      8813,        321]
NotebookOutlinePosition[     10192,        359]
CellTagsIndexPosition[     10108,        354]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ParabolicCylindrical" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/ParabolicCylindrical"], 
          "EllipticCylindrical" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/EllipticCylindrical"], 
          "ProlateSpheroidal" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/ProlateSpheroidal"], "OblateSpheroidal" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/OblateSpheroidal"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ParabolicCylindrical\"\>", 
       2->"\<\"EllipticCylindrical\"\>", 3->"\<\"ProlateSpheroidal\"\>", 
       4->"\<\"OblateSpheroidal\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Paraboloidal", "ObjectName",
 CellID->15062],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Paraboloidal"], "InlineFormula"],
     " \[LineSeparator]represents the paraboloidal coordinate system with \
default variables ",
     Cell[BoxData[
      ButtonBox["Uu",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Uu"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Vv",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Vv"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      ButtonBox["Pphi",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Pphi"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Paraboloidal", "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["v", "TI"], ",", 
        StyleBox["\[Phi]", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the paraboloidal coordinate system with \
variables ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      StyleBox["\[Phi]", "TR"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->29229]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->181293186],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->318253196],

Cell[TextData[{
 "Use ",
 Cell[BoxData["Paraboloidal"], "InlineFormula"],
 " as the default coordinate system:"
}], "ExampleText",
 CellID->428269499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", "Paraboloidal", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->443597938],

Cell[BoxData[
 RowBox[{"Paraboloidal", "[", 
  RowBox[{"Uu", ",", "Vv", ",", "Pphi"}], "]"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7117756]
}, Open  ]],

Cell["\<\
All evaluations now use paraboloidal coordinates as the default:\
\>", "ExampleText",
 CellID->116864137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoordinateRanges", "[", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->709779145],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0", "\[LessEqual]", "Uu", "<", "\[Infinity]"}], ",", 
   RowBox[{"0", "\[LessEqual]", "Vv", "<", "\[Infinity]"}], ",", 
   RowBox[{
    RowBox[{"-", "\[Pi]"}], "\[LessEqual]", "Pphi", "\[LessEqual]", 
    "\[Pi]"}]}], "}"}]], "Output",
 ImageSize->{235, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->30519680]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobianDeterminant", "[", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->33744766],

Cell[BoxData[
 RowBox[{"Uu", " ", "Vv", " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["Uu", "2"], "+", 
    SuperscriptBox["Vv", "2"]}], ")"}]}]], "Output",
 ImageSize->{104, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->140855728]
}, Open  ]],

Cell[TextData[{
 "Reset the default coordinate system to ",
 Cell[BoxData[
  ButtonBox["Cartesian",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Cartesian"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->31402094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", "Cartesian", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->74704059],

Cell[BoxData[
 RowBox[{"Cartesian", "[", 
  RowBox[{"Xx", ",", "Yy", ",", "Zz"}], "]"}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->360035363]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8709],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ParabolicCylindrical",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/ParabolicCylindrical"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticCylindrical",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/EllipticCylindrical"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ProlateSpheroidal",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/ProlateSpheroidal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OblateSpheroidal",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/OblateSpheroidal"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9662]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27560],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->7718]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Paraboloidal - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 23.2322744}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "Paraboloidal represents the paraboloidal coordinate system with default \
variables Uu, Vv, and Pphi. Paraboloidal[u, v, \\[Phi]] represents the \
paraboloidal coordinate system with variables u, v, and \\[Phi].", 
    "synonyms" -> {}, "title" -> "Paraboloidal", "type" -> "Symbol", "uri" -> 
    "VectorAnalysis/ref/Paraboloidal"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3846, 122, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9973, 347}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1740, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2363, 69, 50, 1, 70, "ObjectName",
 CellID->15062],
Cell[2416, 72, 1393, 45, 70, "Usage",
 CellID->29229]
}, Open  ]],
Cell[CellGroupData[{
Cell[3846, 122, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4223, 136, 148, 5, 70, "ExampleSection",
 CellID->181293186],
Cell[4374, 143, 139, 4, 70, "Input",
 CellID->318253196],
Cell[4516, 149, 150, 5, 70, "ExampleText",
 CellID->428269499],
Cell[CellGroupData[{
Cell[4691, 158, 121, 3, 28, "Input",
 CellID->443597938],
Cell[4815, 163, 233, 7, 36, "Output",
 CellID->7117756]
}, Open  ]],
Cell[5063, 173, 115, 3, 70, "ExampleText",
 CellID->116864137],
Cell[CellGroupData[{
Cell[5203, 180, 107, 3, 28, "Input",
 CellID->709779145],
Cell[5313, 185, 417, 12, 36, "Output",
 CellID->30519680]
}, Open  ]],
Cell[CellGroupData[{
Cell[5767, 202, 109, 3, 70, "Input",
 CellID->33744766],
Cell[5879, 207, 294, 10, 39, "Output",
 CellID->140855728]
}, Open  ]],
Cell[6188, 220, 238, 8, 70, "ExampleText",
 CellID->31402094],
Cell[CellGroupData[{
Cell[6451, 232, 117, 3, 70, "Input",
 CellID->74704059],
Cell[6571, 237, 230, 7, 36, "Output",
 CellID->360035363]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6862, 251, 310, 9, 70, "SeeAlsoSection",
 CellID->8709],
Cell[7175, 262, 1080, 35, 70, "SeeAlso",
 CellID->9662]
}, Open  ]],
Cell[CellGroupData[{
Cell[8292, 302, 314, 9, 70, "TutorialsSection",
 CellID->27560],
Cell[8609, 313, 162, 3, 70, "Tutorials",
 CellID->7718]
}, Open  ]],
Cell[8786, 319, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

