(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9664,        344]
NotebookOptionsPosition[      6893,        254]
NotebookOutlinePosition[      8303,        292]
CellTagsIndexPosition[      8219,        287]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Parameters" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Parameters"], 
          "CoordinateRanges" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/CoordinateRanges"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Parameters\"\>", 
       2->"\<\"CoordinateRanges\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ParameterRanges", "ObjectName",
 CellID->15948],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ParameterRanges", "[", "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the intervals over which each the of the \
parameters in the default coordinate system may range. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ParameterRanges", "[", 
       StyleBox["coordsys", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the ranges for each of the parameters in the \
coordinate system ",
     Cell[BoxData[
      StyleBox["coordsys", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->28251]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Many of the coordinate systems do not have parameters, in which case ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 " is returned."
}], "Notes",
 CellID->5081],

Cell[TextData[{
 "The parameters are identified as ",
 Cell[BoxData[
  RowBox[{"#", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " refers to the order in which the parameters are listed when the coordinate \
system is specified."
}], "Notes",
 CellID->32271]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->204247850],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->85939633],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->159415132],

Cell["Parameter ranges in different coordinate systems:", "ExampleText",
 CellID->61715614],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParameterRanges", "[", "Bipolar", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->105500638],

Cell[BoxData[
 RowBox[{"0", "<", "#1", "<", "\[Infinity]"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->41738251]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParameterRanges", "[", "ConfocalEllipsoidal", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->113305780],

Cell[BoxData[
 RowBox[{"0", "<", "#3", "<", "#2", "<", "#1", "<", "\[Infinity]"}]], "Output",\

 ImageSize->{117, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->457048734]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10309],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Parameters",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Parameters"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CoordinateRanges",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/CoordinateRanges"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6430]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31825],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->9228]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ParameterRanges - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 23.4510300}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "ParameterRanges[] gives the intervals over which each the of the \
parameters in the default coordinate system may range. \
ParameterRanges[coordsys] gives the ranges for each of the parameters in the \
coordinate system coordsys.", "synonyms" -> {}, "title" -> "ParameterRanges", 
    "type" -> "Symbol", "uri" -> "VectorAnalysis/ref/ParameterRanges"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3952, 135, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->204247850]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8076, 280}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1371, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1994, 62, 53, 1, 70, "ObjectName",
 CellID->15948],
Cell[2050, 65, 772, 22, 70, "Usage",
 CellID->28251]
}, Open  ]],
Cell[CellGroupData[{
Cell[2859, 92, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3337, 109, 245, 8, 70, "Notes",
 CellID->5081],
Cell[3585, 119, 330, 11, 70, "Notes",
 CellID->32271]
}, Closed]],
Cell[CellGroupData[{
Cell[3952, 135, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->204247850],
Cell[CellGroupData[{
Cell[4337, 149, 147, 5, 70, "ExampleSection",
 CellID->85939633],
Cell[4487, 156, 139, 4, 70, "Input",
 CellID->159415132],
Cell[4629, 162, 91, 1, 70, "ExampleText",
 CellID->61715614],
Cell[CellGroupData[{
Cell[4745, 167, 117, 3, 28, "Input",
 CellID->105500638],
Cell[4865, 172, 200, 6, 36, "Output",
 CellID->41738251]
}, Open  ]],
Cell[CellGroupData[{
Cell[5102, 183, 129, 3, 28, "Input",
 CellID->113305780],
Cell[5234, 188, 226, 7, 36, "Output",
 CellID->457048734]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5521, 202, 311, 9, 70, "SeeAlsoSection",
 CellID->10309],
Cell[5835, 213, 500, 17, 70, "SeeAlso",
 CellID->6430]
}, Open  ]],
Cell[CellGroupData[{
Cell[6372, 235, 314, 9, 70, "TutorialsSection",
 CellID->31825],
Cell[6689, 246, 162, 3, 70, "Tutorials",
 CellID->9228]
}, Open  ]],
Cell[6866, 252, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

