(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9547,        344]
NotebookOptionsPosition[      6697,        250]
NotebookOutlinePosition[      8050,        288]
CellTagsIndexPosition[      7966,        283]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ParameterRanges" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/ParameterRanges"], "CoordinateRanges" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/CoordinateRanges"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ParameterRanges\"\>", 
       2->"\<\"CoordinateRanges\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Parameters", "ObjectName",
 CellID->22270],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Parameters", "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the default parameters of the default \
coordinate system. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Parameters", "[", 
       StyleBox["coordsys", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the default parameters in the \
coordinate system ",
     Cell[BoxData[
      StyleBox["coordsys", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->3919]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Many of the coordinate systems do not have parameters, in which case an empty \
list is returned.\
\>", "Notes",
 CellID->28849]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->73817534],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->184483762],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->167044809],

Cell["There are no parameters in the default Cartesian system:", "ExampleText",
 CellID->221468712],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Parameters", "[", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->286467644],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->94934143]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->389054519],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->473077585],

Cell["Parameter value for the bipolar coordinate system:", "ExampleText",
 CellID->263017348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Parameters", "[", "Bipolar", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->44872000],

Cell[BoxData[
 RowBox[{"{", "1", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->87245545]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29556],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ParameterRanges",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/ParameterRanges"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CoordinateRanges",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/CoordinateRanges"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28603]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26112],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->20576]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Parameters - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 23.6229094}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "Parameters[] gives a list of the default parameters of the default \
coordinate system. Parameters[coordsys] gives a list of the default \
parameters in the coordinate system coordsys.", "synonyms" -> {}, "title" -> 
    "Parameters", "type" -> "Symbol", "uri" -> 
    "VectorAnalysis/ref/Parameters"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3477, 118, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->73817534]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7824, 276}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1387, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2010, 62, 48, 1, 70, "ObjectName",
 CellID->22270],
Cell[2061, 65, 726, 22, 70, "Usage",
 CellID->3919]
}, Open  ]],
Cell[CellGroupData[{
Cell[2824, 92, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3302, 109, 138, 4, 70, "Notes",
 CellID->28849]
}, Closed]],
Cell[CellGroupData[{
Cell[3477, 118, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->73817534],
Cell[CellGroupData[{
Cell[3861, 132, 148, 5, 70, "ExampleSection",
 CellID->184483762],
Cell[4012, 139, 139, 4, 70, "Input",
 CellID->167044809],
Cell[4154, 145, 99, 1, 70, "ExampleText",
 CellID->221468712],
Cell[CellGroupData[{
Cell[4278, 150, 101, 3, 28, "Input",
 CellID->286467644],
Cell[4382, 155, 174, 6, 36, "Output",
 CellID->94934143]
}, Open  ]],
Cell[4571, 164, 125, 3, 70, "ExampleDelimiter",
 CellID->389054519],
Cell[4699, 169, 139, 4, 70, "Input",
 CellID->473077585],
Cell[4841, 175, 93, 1, 70, "ExampleText",
 CellID->263017348],
Cell[CellGroupData[{
Cell[4959, 180, 111, 3, 70, "Input",
 CellID->44872000],
Cell[5073, 185, 179, 6, 36, "Output",
 CellID->87245545]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5313, 198, 311, 9, 70, "SeeAlsoSection",
 CellID->29556],
Cell[5627, 209, 511, 17, 70, "SeeAlso",
 CellID->28603]
}, Open  ]],
Cell[CellGroupData[{
Cell[6175, 231, 314, 9, 70, "TutorialsSection",
 CellID->26112],
Cell[6492, 242, 163, 3, 70, "Tutorials",
 CellID->20576]
}, Open  ]],
Cell[6670, 248, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

