(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12920,        445]
NotebookOptionsPosition[      9716,        345]
NotebookOutlinePosition[     11379,        386]
CellTagsIndexPosition[     11294,        381]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Paraboloidal" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Paraboloidal"], 
          "ParabolicCylindrical" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/ParabolicCylindrical"], 
          "EllipticCylindrical" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/EllipticCylindrical"], 
          "OblateSpheroidal" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/OblateSpheroidal"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Paraboloidal\"\>", 
       2->"\<\"ParabolicCylindrical\"\>", 3->"\<\"EllipticCylindrical\"\>", 
       4->"\<\"OblateSpheroidal\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ProlateSpheroidal", "ObjectName",
 CellID->20093],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["ProlateSpheroidal"], "InlineFormula"],
     "\[LineSeparator]represents the prolate spheroidal coordinate system \
with default variables ",
     Cell[BoxData[
      ButtonBox["Xxi",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Xxi"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Eeta",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Eeta"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      ButtonBox["Pphi",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Pphi"]], "InlineFormula"],
     " and default parameter value 1. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ProlateSpheroidal", "[", 
       RowBox[{
        StyleBox["\[Xi]", "TR"], ",", 
        StyleBox["\[Eta]", "TR"], ",", 
        StyleBox["\[Phi]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the prolate spheroidal coordinate system \
with variables ",
     Cell[BoxData[
      RowBox[{
       StyleBox["\[Xi]", "TR"], ",", 
       StyleBox["\[Eta]", "TR"]}]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["\[Phi]", "TR"]], "InlineFormula"],
     " and default parameter value 1. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ProlateSpheroidal", "[", 
       RowBox[{
        StyleBox["\[Xi]", "TR"], ",", 
        StyleBox["\[Eta]", "TR"], ",", 
        StyleBox["\[Phi]", "TR"], ",", 
        StyleBox["a", "TI"]}], "]"}]], "InlineFormula"],
     " represents the prolate spheroidal coordinate system with variables ",
     Cell[BoxData[
      RowBox[{
       StyleBox["\[Xi]", "TR"], ",", 
       StyleBox["\[Eta]", "TR"]}]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["\[Phi]", "TR"]], "InlineFormula"],
     " and parameter ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->3936]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->489243177],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->39681768],

Cell[TextData[{
 "Use ",
 Cell[BoxData["ProlateSpheroidal"], "InlineFormula"],
 " as the default coordinate system:"
}], "ExampleText",
 CellID->428269499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", "ProlateSpheroidal", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->443597938],

Cell[BoxData[
 RowBox[{"ProlateSpheroidal", "[", 
  RowBox[{"Xxi", ",", "Eeta", ",", "Pphi", ",", "1"}], "]"}]], "Output",
 ImageSize->{255, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->54806386]
}, Open  ]],

Cell["\<\
All evaluations now use prolate spheroidal coordinates as the default:\
\>", "ExampleText",
 CellID->116864137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoordinateRanges", "[", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->709779145],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0", "\[LessEqual]", "Xxi", "<", "\[Infinity]"}], ",", 
   RowBox[{"0", "\[LessEqual]", "Eeta", "\[LessEqual]", "\[Pi]"}], ",", 
   RowBox[{
    RowBox[{"-", "\[Pi]"}], "<", "Pphi", "\[LessEqual]", "\[Pi]"}]}], 
  "}"}]], "Output",
 ImageSize->{256, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->527994868]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobianDeterminant", "[", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->33744766],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", "Eeta", "]"}], " ", 
  RowBox[{"Sinh", "[", "Xxi", "]"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", "Eeta", "]"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"Sinh", "[", "Xxi", "]"}], "2"]}], ")"}]}]], "Output",
 ImageSize->{300, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->335568395]
}, Open  ]],

Cell[TextData[{
 "Reset the default coordinate system to ",
 Cell[BoxData[
  ButtonBox["Cartesian",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Cartesian"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->31402094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", "Cartesian", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->74704059],

Cell[BoxData[
 RowBox[{"Cartesian", "[", 
  RowBox[{"Xx", ",", "Yy", ",", "Zz"}], "]"}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->29639191]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19714],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Paraboloidal",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Paraboloidal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ParabolicCylindrical",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/ParabolicCylindrical"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticCylindrical",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/EllipticCylindrical"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OblateSpheroidal",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/OblateSpheroidal"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25599]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15846],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->21238]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ProlateSpheroidal - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 23.9979190}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "ProlateSpheroidal represents the prolate spheroidal coordinate system \
with default variables Xxi, Eeta, and Pphi and default parameter value 1. \
ProlateSpheroidal[\\[Xi], \\[Eta], \\[Phi]] represents the prolate spheroidal \
coordinate system with variables \\[Xi], \\[Eta] and \\[Phi] and default \
parameter value 1. ProlateSpheroidal[\\[Xi], \\[Eta], \\[Phi], a] represents \
the prolate spheroidal coordinate system with variables \\[Xi], \\[Eta] and \
\\[Phi] and parameter a.", "synonyms" -> {}, "title" -> "ProlateSpheroidal", 
    "type" -> "Symbol", "uri" -> "VectorAnalysis/ref/ProlateSpheroidal"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4593, 142, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11159, 374}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1724, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2347, 69, 55, 1, 70, "ObjectName",
 CellID->20093],
Cell[2405, 72, 2151, 65, 70, "Usage",
 CellID->3936]
}, Open  ]],
Cell[CellGroupData[{
Cell[4593, 142, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4970, 156, 148, 5, 70, "ExampleSection",
 CellID->489243177],
Cell[5121, 163, 138, 4, 70, "Input",
 CellID->39681768],
Cell[5262, 169, 155, 5, 70, "ExampleText",
 CellID->428269499],
Cell[CellGroupData[{
Cell[5442, 178, 126, 3, 28, "Input",
 CellID->443597938],
Cell[5571, 183, 252, 7, 36, "Output",
 CellID->54806386]
}, Open  ]],
Cell[5838, 193, 121, 3, 70, "ExampleText",
 CellID->116864137],
Cell[CellGroupData[{
Cell[5984, 200, 107, 3, 28, "Input",
 CellID->709779145],
Cell[6094, 205, 413, 12, 36, "Output",
 CellID->527994868]
}, Open  ]],
Cell[CellGroupData[{
Cell[6544, 222, 109, 3, 70, "Input",
 CellID->33744766],
Cell[6656, 227, 428, 14, 39, "Output",
 CellID->335568395]
}, Open  ]],
Cell[7099, 244, 238, 8, 70, "ExampleText",
 CellID->31402094],
Cell[CellGroupData[{
Cell[7362, 256, 117, 3, 70, "Input",
 CellID->74704059],
Cell[7482, 261, 229, 7, 36, "Output",
 CellID->29639191]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7772, 275, 311, 9, 70, "SeeAlsoSection",
 CellID->19714],
Cell[8086, 286, 1071, 35, 70, "SeeAlso",
 CellID->25599]
}, Open  ]],
Cell[CellGroupData[{
Cell[9194, 326, 314, 9, 70, "TutorialsSection",
 CellID->15846],
Cell[9511, 337, 163, 3, 70, "Tutorials",
 CellID->21238]
}, Open  ]],
Cell[9689, 343, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

