(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13375,        491]
NotebookOptionsPosition[     10079,        384]
NotebookOutlinePosition[     11555,        423]
CellTagsIndexPosition[     11470,        418]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DotProduct" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/DotProduct"], 
          "CrossProduct" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/CrossProduct"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DotProduct\"\>", 
       2->"\<\"CrossProduct\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ScalarTripleProduct", "ObjectName",
 CellID->7728],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ScalarTripleProduct", "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["3", "TR"]]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the scalar triple product of the three 3-vectors \
",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["2", "TR"]]}]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["3", "TR"]]], "InlineFormula"],
     " in the default coordinate system. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ScalarTripleProduct", "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["3", "TR"]], ",", 
        StyleBox["coordsys", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the scalar triple product of ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["2", "TR"]]}]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["3", "TR"]]], "InlineFormula"],
     " in the coordinate system ",
     Cell[BoxData[
      StyleBox["coordsys", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->4985]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ScalarTripleProduct", "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["v", "TI"], "1"], ",", 
    SubscriptBox[
     StyleBox["v", "TI"], "2"], ",", 
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["3", "TR"]], ",", 
    StyleBox["coordsys", "TI"]}], "]"}]], "InlineFormula"],
 " is computed by converting ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["v", "TI"], 
    StyleBox["1", "TR"]], ",", 
   SubscriptBox[
    StyleBox["v", "TI"], 
    StyleBox["2", "TR"]]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], "3"]], "InlineFormula"],
 " to Cartesian coordinates and then forming the scalar triple product."
}], "Notes",
 CellID->5537]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->618596678],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->23681796],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->287744980],

Cell["Compute the scalar triple product of three vectors in space:", \
"ExampleText",
 CellID->145331529],

Cell[BoxData[
 RowBox[{
  RowBox[{"r1", "=", " ", 
   RowBox[{"{", 
    RowBox[{"1", ",", " ", 
     RowBox[{"-", "3"}], ",", " ", "2"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->296668926],

Cell[BoxData[
 RowBox[{
  RowBox[{"r2", "=", " ", 
   RowBox[{"{", 
    RowBox[{"3", ",", "7", ",", 
     RowBox[{"-", " ", "5"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->133051291],

Cell[BoxData[
 RowBox[{
  RowBox[{"r3", "=", " ", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1", ",", "6"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->246960603],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ScalarTripleProduct", "[", 
  RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->548069095],

Cell[BoxData["111"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->7875757]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Det",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Det"]], "InlineFormula"],
 " to obtain the same answer:"
}], "ExampleText",
 CellID->150608689],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  RowBox[{"{", 
   RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->339084079],

Cell[BoxData["111"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->122332862]
}, Open  ]],

Cell["\<\
Find the equation of the plane passing through the points with position \
vectors r1, r2, and r3:\
\>", "ExampleText",
 CellID->78203665],

Cell[BoxData[
 RowBox[{
  RowBox[{"r", " ", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", " ", "z"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->688589917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ScalarTripleProduct", "[", 
   RowBox[{
    RowBox[{"r", "-", "r1"}], ",", " ", 
    RowBox[{"r2", "-", "r1"}], ",", " ", 
    RowBox[{"r3", "-", "r1"}]}], "]"}], "\[Equal]", "0"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->183930761],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "111"}], "+", 
   RowBox[{"68", " ", "x"}], "-", 
   RowBox[{"29", " ", "y"}], "-", 
   RowBox[{"22", " ", "z"}]}], "\[Equal]", "0"}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->682982763]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28703],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DotProduct",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/DotProduct"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CrossProduct",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/CrossProduct"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5494]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26320],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->13124]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ScalarTripleProduct - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 30.7949680}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "ScalarTripleProduct[v_1, v_2, v_3] gives the scalar triple product of \
the three 3-vectors v_1, v_2 and v_3 in the default coordinate system. \
ScalarTripleProduct[v_1, v_2, v_3, coordsys] gives the scalar triple product \
of v_1, v_2 and v_3 in the coordinate system coordsys.", "synonyms" -> {}, 
    "title" -> "ScalarTripleProduct", "type" -> "Symbol", "uri" -> 
    "VectorAnalysis/ref/ScalarTripleProduct"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5390, 188, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->618596678]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11327, 411}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1359, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1982, 62, 56, 1, 70, "ObjectName",
 CellID->7728],
Cell[2041, 65, 2052, 69, 70, "Usage",
 CellID->4985]
}, Open  ]],
Cell[CellGroupData[{
Cell[4130, 139, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4608, 156, 745, 27, 70, "Notes",
 CellID->5537]
}, Closed]],
Cell[CellGroupData[{
Cell[5390, 188, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->618596678],
Cell[CellGroupData[{
Cell[5775, 202, 147, 5, 70, "ExampleSection",
 CellID->23681796],
Cell[5925, 209, 139, 4, 70, "Input",
 CellID->287744980],
Cell[6067, 215, 105, 2, 70, "ExampleText",
 CellID->145331529],
Cell[6175, 219, 206, 7, 70, "Input",
 CellID->296668926],
Cell[6384, 228, 201, 7, 70, "Input",
 CellID->133051291],
Cell[6588, 237, 175, 6, 70, "Input",
 CellID->246960603],
Cell[CellGroupData[{
Cell[6788, 247, 161, 4, 70, "Input",
 CellID->548069095],
Cell[6952, 253, 158, 5, 36, "Output",
 CellID->7875757]
}, Open  ]],
Cell[7125, 261, 203, 8, 70, "ExampleText",
 CellID->150608689],
Cell[CellGroupData[{
Cell[7353, 273, 169, 5, 70, "Input",
 CellID->339084079],
Cell[7525, 280, 160, 5, 36, "Output",
 CellID->122332862]
}, Open  ]],
Cell[7700, 288, 147, 4, 70, "ExampleText",
 CellID->78203665],
Cell[7850, 294, 179, 6, 70, "Input",
 CellID->688589917],
Cell[CellGroupData[{
Cell[8054, 304, 269, 8, 70, "Input",
 CellID->183930761],
Cell[8326, 314, 327, 11, 36, "Output",
 CellID->682982763]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8714, 332, 311, 9, 70, "SeeAlsoSection",
 CellID->28703],
Cell[9028, 343, 492, 17, 70, "SeeAlso",
 CellID->5494]
}, Open  ]],
Cell[CellGroupData[{
Cell[9557, 365, 314, 9, 70, "TutorialsSection",
 CellID->26320],
Cell[9874, 376, 163, 3, 70, "Tutorials",
 CellID->13124]
}, Open  ]],
Cell[10052, 382, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

