(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11087,        403]
NotebookOptionsPosition[      8017,        301]
NotebookOutlinePosition[      9421,        339]
CellTagsIndexPosition[      9337,        334]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CoordinateSystem" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/CoordinateSystem"], "Coordinates" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/Coordinates"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"CoordinateSystem\"\>", 
       2->"\<\"Coordinates\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SetCoordinates", "ObjectName",
 CellID->26222],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SetCoordinates", "[", 
       StyleBox["coordsys", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]sets the default coordinate system to be ",
     Cell[BoxData[
      StyleBox["coordsys", "TI"]], "InlineFormula"],
     " with default variables. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SetCoordinates", "[", 
       RowBox[{
        StyleBox["coordsys", "TI"], "[", 
        RowBox[{
         SubscriptBox[
          StyleBox["c", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["c", "TI"], 
          StyleBox["2", "TR"]], ",", 
         SubscriptBox[
          StyleBox["c", "TI"], 
          StyleBox["3", "TR"]]}], "]"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]sets the default coordinate system to be ",
     Cell[BoxData[
      StyleBox["coordsys", "TI"]], "InlineFormula"],
     " with variables ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["2", "TR"]]}]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["3", "TR"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->5754]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Certain coordinate systems have parameters associated with them, and these \
parameters can be set by specifying the full description of the coordinate \
system.\
\>", "Notes",
 CellID->1552]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->16376783],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->288264260],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->223036226],

Cell[TextData[{
 "Use ",
 Cell[BoxData["SetCoordinates"], "InlineFormula"],
 " to change the default coordinate system:"
}], "ExampleText",
 CellID->125547855],

Cell[CellGroupData[{

Cell[BoxData["CoordinateSystem"], "Input",
 CellLabel->"In[2]:=",
 CellID->161440791],

Cell[BoxData["Cartesian"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->469408105]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", "Spherical", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->152811563],

Cell[BoxData[
 RowBox[{"Spherical", "[", 
  RowBox[{"Rr", ",", "Ttheta", ",", "Pphi"}], "]"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->445982174]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["CoordinateSystem"], "Input",
 CellLabel->"In[4]:=",
 CellID->378112005],

Cell[BoxData["Spherical"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->159587772]
}, Open  ]],

Cell["Restore the default settings:", "ExampleText",
 CellID->240369597],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", "Cartesian", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->36382390],

Cell[BoxData[
 RowBox[{"Cartesian", "[", 
  RowBox[{"Xx", ",", "Yy", ",", "Zz"}], "]"}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->20732698]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6602],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CoordinateSystem",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/CoordinateSystem"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Coordinates",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Coordinates"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7737]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->850],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->1516]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SetCoordinates - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 31.2012284}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "SetCoordinates[coordsys] sets the default coordinate system to be \
coordsys with default variables. SetCoordinates[coordsys[c_1, c_2, c_3]] sets \
the default coordinate system to be coordsys with variables c_1, c_2, and \
c_3.", "synonyms" -> {}, "title" -> "SetCoordinates", "type" -> "Symbol", 
    "uri" -> "VectorAnalysis/ref/SetCoordinates"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4324, 146, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->16376783]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9195, 327}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1375, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1998, 62, 52, 1, 70, "ObjectName",
 CellID->26222],
Cell[2053, 65, 1518, 49, 70, "Usage",
 CellID->5754]
}, Open  ]],
Cell[CellGroupData[{
Cell[3608, 119, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4086, 136, 201, 5, 70, "Notes",
 CellID->1552]
}, Closed]],
Cell[CellGroupData[{
Cell[4324, 146, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->16376783],
Cell[CellGroupData[{
Cell[4708, 160, 148, 5, 70, "ExampleSection",
 CellID->288264260],
Cell[4859, 167, 139, 4, 70, "Input",
 CellID->223036226],
Cell[5001, 173, 159, 5, 70, "ExampleText",
 CellID->125547855],
Cell[CellGroupData[{
Cell[5185, 182, 85, 2, 28, "Input",
 CellID->161440791],
Cell[5273, 186, 166, 5, 36, "Output",
 CellID->469408105]
}, Open  ]],
Cell[CellGroupData[{
Cell[5476, 196, 118, 3, 28, "Input",
 CellID->152811563],
Cell[5597, 201, 236, 7, 36, "Output",
 CellID->445982174]
}, Open  ]],
Cell[CellGroupData[{
Cell[5870, 213, 85, 2, 70, "Input",
 CellID->378112005],
Cell[5958, 217, 166, 5, 36, "Output",
 CellID->159587772]
}, Open  ]],
Cell[6139, 225, 72, 1, 70, "ExampleText",
 CellID->240369597],
Cell[CellGroupData[{
Cell[6236, 230, 117, 3, 70, "Input",
 CellID->36382390],
Cell[6356, 235, 229, 7, 36, "Output",
 CellID->20732698]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6646, 249, 310, 9, 70, "SeeAlsoSection",
 CellID->6602],
Cell[6959, 260, 502, 17, 70, "SeeAlso",
 CellID->7737]
}, Open  ]],
Cell[CellGroupData[{
Cell[7498, 282, 312, 9, 70, "TutorialsSection",
 CellID->850],
Cell[7813, 293, 162, 3, 70, "Tutorials",
 CellID->1516]
}, Open  ]],
Cell[7990, 299, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

