(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7989,        291]
NotebookOptionsPosition[      5637,        212]
NotebookOutlinePosition[      6877,        248]
CellTagsIndexPosition[      6793,        243]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Rr" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Rr"], "Zz" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Zz"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Rr\"\>", 
       2->"\<\"Zz\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Ttheta", "ObjectName",
 CellID->8835],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Ttheta"], "InlineFormula"],
     "\[LineSeparator]is one of the default coordinates for the ",
     Cell[BoxData[
      ButtonBox["Cylindrical",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Cylindrical"]], 
      "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Spherical",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Spherical"]], "InlineFormula"],
     " coordinate systems."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24987]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->438945670],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->36589113],

Cell[TextData[{
 Cell[BoxData["Ttheta"], "InlineFormula"],
 " is used as a coordinate in the following systems:"
}], "ExampleText",
 CellID->35004531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "Cylindrical", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->406403560],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Rr", ",", "Ttheta", ",", "Zz"}], "}"}]], "Output",
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->291040701]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "Spherical", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->566909803],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Rr", ",", "Ttheta", ",", "Pphi"}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->251561357]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29521],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rr",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Rr"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Zz",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Zz"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10597]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20570],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->25589]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Ttheta - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 31.8106190}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "Ttheta is one of the default coordinates for the Cylindrical and \
Spherical coordinate systems.", "synonyms" -> {}, "title" -> "Ttheta", "type" -> 
    "Symbol", "uri" -> "VectorAnalysis/ref/Ttheta"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2683, 89, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6659, 236}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1282, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1905, 60, 43, 1, 70, "ObjectName",
 CellID->8835],
Cell[1951, 63, 695, 21, 70, "Usage",
 CellID->24987]
}, Open  ]],
Cell[CellGroupData[{
Cell[2683, 89, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3060, 103, 148, 5, 70, "ExampleSection",
 CellID->438945670],
Cell[3211, 110, 138, 4, 70, "Input",
 CellID->36589113],
Cell[3352, 116, 150, 4, 70, "ExampleText",
 CellID->35004531],
Cell[CellGroupData[{
Cell[3527, 124, 117, 3, 28, "Input",
 CellID->406403560],
Cell[3647, 129, 221, 7, 36, "Output",
 CellID->291040701]
}, Open  ]],
Cell[CellGroupData[{
Cell[3905, 141, 115, 3, 28, "Input",
 CellID->566909803],
Cell[4023, 146, 223, 7, 36, "Output",
 CellID->251561357]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4307, 160, 311, 9, 70, "SeeAlsoSection",
 CellID->29521],
Cell[4621, 171, 457, 17, 70, "SeeAlso",
 CellID->10597]
}, Open  ]],
Cell[CellGroupData[{
Cell[5115, 193, 314, 9, 70, "TutorialsSection",
 CellID->20570],
Cell[5432, 204, 163, 3, 70, "Tutorials",
 CellID->25589]
}, Open  ]],
Cell[5610, 210, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

