(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     79710,       2646]
NotebookOptionsPosition[     70509,       2340]
NotebookOutlinePosition[     72841,       2390]
CellTagsIndexPosition[     72798,       2387]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE TUTORIAL", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"ArcLengthFactor" :> 
         Documentation`HelpLookup[
          "paclet:VectorAnalysis/ref/ArcLengthFactor"], "Biharmonic" :> 
         Documentation`HelpLookup["paclet:VectorAnalysis/ref/Biharmonic"], 
         "Bipolar" :> 
         Documentation`HelpLookup["paclet:VectorAnalysis/ref/Bipolar"], 
         "Bispherical" :> 
         Documentation`HelpLookup["paclet:VectorAnalysis/ref/Bispherical"], 
         "Cartesian" :> 
         Documentation`HelpLookup["paclet:VectorAnalysis/ref/Cartesian"], 
         "ConfocalEllipsoidal" :> 
         Documentation`HelpLookup[
          "paclet:VectorAnalysis/ref/ConfocalEllipsoidal"], 
         "ConfocalParaboloidal" :> 
         Documentation`HelpLookup[
          "paclet:VectorAnalysis/ref/ConfocalParaboloidal"], "Conical" :> 
         Documentation`HelpLookup["paclet:VectorAnalysis/ref/Conical"], 
         "CoordinateRanges" :> 
         Documentation`HelpLookup[
          "paclet:VectorAnalysis/ref/CoordinateRanges"], "Coordinates" :> 
         Documentation`HelpLookup["paclet:VectorAnalysis/ref/Coordinates"], 
         "CoordinatesFromCartesian" :> 
         Documentation`HelpLookup[
          "paclet:VectorAnalysis/ref/CoordinatesFromCartesian"], 
         "CoordinatesToCartesian" :> 
         Documentation`HelpLookup[
          "paclet:VectorAnalysis/ref/CoordinatesToCartesian"], 
         "CoordinateSystem" :> 
         Documentation`HelpLookup[
          "paclet:VectorAnalysis/ref/CoordinateSystem"], "CrossProduct" :> 
         Documentation`HelpLookup["paclet:VectorAnalysis/ref/CrossProduct"], 
         "Curl" :> Documentation`HelpLookup["paclet:VectorAnalysis/ref/Curl"],
          "Cylindrical" :> 
         Documentation`HelpLookup["paclet:VectorAnalysis/ref/Cylindrical"], 
         "Div" :> Documentation`HelpLookup["paclet:VectorAnalysis/ref/Div"], 
         "DotProduct" :> 
         Documentation`HelpLookup["paclet:VectorAnalysis/ref/DotProduct"], 
         "EllipticCylindrical" :> 
         Documentation`HelpLookup[
          "paclet:VectorAnalysis/ref/EllipticCylindrical"], "Grad" :> 
         Documentation`HelpLookup["paclet:VectorAnalysis/ref/Grad"], 
         "JacobianDeterminant" :> 
         Documentation`HelpLookup[
          "paclet:VectorAnalysis/ref/JacobianDeterminant"], "JacobianMatrix" :> 
         Documentation`HelpLookup["paclet:VectorAnalysis/ref/JacobianMatrix"],
          "Laplacian" :> 
         Documentation`HelpLookup["paclet:VectorAnalysis/ref/Laplacian"], 
         "OblateSpheroidal" :> 
         Documentation`HelpLookup[
          "paclet:VectorAnalysis/ref/OblateSpheroidal"], 
         "ParabolicCylindrical" :> 
         Documentation`HelpLookup[
          "paclet:VectorAnalysis/ref/ParabolicCylindrical"], "Paraboloidal" :> 
         Documentation`HelpLookup["paclet:VectorAnalysis/ref/Paraboloidal"], 
         "ParameterRanges" :> 
         Documentation`HelpLookup[
          "paclet:VectorAnalysis/ref/ParameterRanges"], "Parameters" :> 
         Documentation`HelpLookup["paclet:VectorAnalysis/ref/Parameters"], 
         "ProlateSpheroidal" :> 
         Documentation`HelpLookup[
          "paclet:VectorAnalysis/ref/ProlateSpheroidal"], 
         "ScalarTripleProduct" :> 
         Documentation`HelpLookup[
          "paclet:VectorAnalysis/ref/ScalarTripleProduct"], "ScaleFactors" :> 
         Documentation`HelpLookup["paclet:VectorAnalysis/ref/ScaleFactors"], 
         "SetCoordinates" :> 
         Documentation`HelpLookup["paclet:VectorAnalysis/ref/SetCoordinates"],
          "Spherical" :> 
         Documentation`HelpLookup["paclet:VectorAnalysis/ref/Spherical"], 
         "Toroidal" :> 
         Documentation`HelpLookup["paclet:VectorAnalysis/ref/Toroidal"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"ArcLengthFactor\"\>", 
      2->"\<\"Biharmonic\"\>", 3->"\<\"Bipolar\"\>", 4->"\<\"Bispherical\"\>",
       5->"\<\"Cartesian\"\>", 6->"\<\"ConfocalEllipsoidal\"\>", 
      7->"\<\"ConfocalParaboloidal\"\>", 8->"\<\"Conical\"\>", 
      9->"\<\"CoordinateRanges\"\>", 10->"\<\"Coordinates\"\>", 
      11->"\<\"CoordinatesFromCartesian\"\>", 
      12->"\<\"CoordinatesToCartesian\"\>", 13->"\<\"CoordinateSystem\"\>", 
      14->"\<\"CrossProduct\"\>", 15->"\<\"Curl\"\>", 
      16->"\<\"Cylindrical\"\>", 17->"\<\"Div\"\>", 18->"\<\"DotProduct\"\>", 
      19->"\<\"EllipticCylindrical\"\>", 20->"\<\"Grad\"\>", 
      21->"\<\"JacobianDeterminant\"\>", 22->"\<\"JacobianMatrix\"\>", 
      23->"\<\"Laplacian\"\>", 24->"\<\"OblateSpheroidal\"\>", 
      25->"\<\"ParabolicCylindrical\"\>", 26->"\<\"Paraboloidal\"\>", 
      27->"\<\"ParameterRanges\"\>", 28->"\<\"Parameters\"\>", 
      29->"\<\"ProlateSpheroidal\"\>", 30->"\<\"ScalarTripleProduct\"\>", 
      31->"\<\"ScaleFactors\"\>", 32->"\<\"SetCoordinates\"\>", 
      33->"\<\"Spherical\"\>", 34->"\<\"Toroidal\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Vector Analysis Package", "Title",
 CellID->2171],

Cell["\<\
A three\[Hyphen]dimensional coordinate system assigns three numbers to each \
point in space. In defining a coordinate system, you have to make a choice \
about what to measure and how to measure it. Frequently, physical systems \
exhibit special symmetries or structures that make a particular coordinate \
system especially useful. In a mathematically elegant solution to problems \
related to these systems, often the main step is choosing the correct \
coordinates. \
\>", "Text",
 CellID->27795],

Cell[TextData[{
 "A variety of tools for doing calculus in various three\[Hyphen]dimensional \
coordinate systems are provided in this package. Because a given symbolic or \
numeric expression can mean different things in different coordinate systems, \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " must know what coordinate system you are using and what the coordinate \
variables are. The initial default coordinate system is ",
 Cell[BoxData[
  ButtonBox["Cartesian",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Cartesian"]], "InlineFormula"],
 ", with coordinate variables ",
 Cell[BoxData[
  ButtonBox["Xx",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Xx"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Yy",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Yy"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Zz",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Zz"]], "InlineFormula"],
 ". If you frequently work in another system, it may be useful to change the \
default to that system using ",
 Cell[BoxData[
  ButtonBox["SetCoordinates",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/SetCoordinates"]], 
  "InlineFormula"],
 ". "
}], "Text",
 CellID->28931],

Cell[BoxData[GridBox[{
   {
    ButtonBox["CoordinateSystem",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorAnalysis/ref/CoordinateSystem"], Cell[
    "the name of the default coordinate system", "TableText"]},
   {
    RowBox[{
     ButtonBox["Coordinates",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/Coordinates"], "[", "]"}], Cell[
    "give the default variables in the default coordinate system", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["Coordinates",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/Coordinates"], "[", 
     StyleBox["coordsys", "TI"], "]"}], Cell[TextData[{
     "give the default variables in the coordinate system ",
     StyleBox["coordsys", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SetCoordinates",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/SetCoordinates"], "[", 
     StyleBox["coordsys", "TI"], "]"}], Cell[TextData[{
     "set the default coordinate system to be ",
     Cell[BoxData[
      StyleBox["coordsys", "TI"]], "InlineFormula"],
     " with default variables"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SetCoordinates",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/SetCoordinates"], "[", 
     StyleBox["coordsys", "TI"], "[", 
     StyleBox["vars", "TI"], "]", "]"}], Cell[TextData[{
     "set the default coordinate system to be ",
     Cell[BoxData[
      StyleBox["coordsys", "TI"]], "InlineFormula"],
     " with variables ",
     StyleBox["vars", "TI"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->5310],

Cell["Coordinate systems and coordinate variables. ", "Caption",
 CellID->3290],

Cell["This loads the package. ", "MathCaption",
 CellID->22344],

Cell[BoxData[
 RowBox[{"<<", "VectorAnalysis`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2473],

Cell["This resets the default coordinate system and variables. ", \
"MathCaption",
 CellID->32694],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", 
  RowBox[{"Paraboloidal", "[", 
   RowBox[{"w1", ",", "w2", ",", "w3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28529],

Cell[BoxData[
 RowBox[{"Paraboloidal", "[", 
  RowBox[{"w1", ",", "w2", ",", "w3"}], "]"}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21724]
}, Open  ]],

Cell["Here are the new defaults. ", "MathCaption",
 CellID->31875],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"CoordinateSystem", ",", 
   RowBox[{"Coordinates", "[", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->29362],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Paraboloidal", ",", 
   RowBox[{"{", 
    RowBox[{"w1", ",", "w2", ",", "w3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{192, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->13966]
}, Open  ]],

Cell[TextData[{
 "All coordinate systems can be viewed as arising from three \
one\[Hyphen]parameter families of surfaces. The three numbers assigned to \
each point (",
 StyleBox["i.e.",
  FontSlant->"Italic"],
 ", its coordinates) simply tell you to which member of each family the point \
belongs. Members of these families are called ",
 StyleBox["coordinate surfaces",
  FontSlant->"Italic"],
 ". In the simplest example, the ",
 Cell[BoxData[
  ButtonBox["Cartesian",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Cartesian"]], "InlineFormula"],
 " system, the coordinate surfaces are members of families of planes parallel \
to the coordinate planes. In more complicated systems, the coordinate \
surfaces often belong to families of quadric surfaces such as ellipsoids, \
hyperboloids or elliptic paraboloids. In certain cases the families of \
coordinate surfaces depend on parameters such as focal distances or radii. In \
these cases the coordinate system as a whole depends on the parameters. These \
parameters are initially given default values and can be reset with ",
 Cell[BoxData[
  ButtonBox["SetCoordinates",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/SetCoordinates"]], 
  "InlineFormula"],
 ". "
}], "Text",
 CellID->12415],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Bipolar",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorAnalysis/ref/Bipolar"], 
    ButtonBox["Bispherical",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorAnalysis/ref/Bispherical"]},
   {
    ButtonBox["Cartesian",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorAnalysis/ref/Cartesian"], 
    ButtonBox["ConfocalEllipsoidal",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorAnalysis/ref/ConfocalEllipsoidal"]},
   {
    ButtonBox["ConfocalParaboloidal",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorAnalysis/ref/ConfocalParaboloidal"], 
    ButtonBox["Conical",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorAnalysis/ref/Conical"]},
   {
    ButtonBox["Cylindrical",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorAnalysis/ref/Cylindrical"], 
    ButtonBox["EllipticCylindrical",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorAnalysis/ref/EllipticCylindrical"]},
   {
    ButtonBox["OblateSpheroidal",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorAnalysis/ref/OblateSpheroidal"], 
    ButtonBox["ParabolicCylindrical",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorAnalysis/ref/ParabolicCylindrical"]},
   {
    ButtonBox["Paraboloidal",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorAnalysis/ref/Paraboloidal"], 
    ButtonBox["ProlateSpheroidal",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorAnalysis/ref/ProlateSpheroidal"]},
   {
    ButtonBox["Spherical",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorAnalysis/ref/Spherical"], 
    ButtonBox["Toroidal",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorAnalysis/ref/Toroidal"]}
  }]], "DefinitionBox",
 CellID->26437],

Cell["Coordinate systems.", "Caption",
 CellID->13730],

Cell[TextData[{
 "There are often conflicting definitions of a particular coordinate system \
in the literature. When you use a coordinate system with this package, you \
should look at the definition given below to make sure it is what you want. \
The easiest way to check the definition of a coordinate system used in the \
package is to use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CoordinatesToCartesian",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/CoordinatesToCartesian"], "[", 
   StyleBox["pt", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["coordsys", "TI"], "]"}]], "InlineFormula"],
 " as described below. This will give you the formulas for the transformation \
into Cartesian coordinates. "
}], "Text",
 CellID->16882],

Cell[TextData[{
 "The ",
 StyleBox["Cartesian coordinate system", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Cartesian",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Cartesian"], "[", 
   StyleBox["x", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["y", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " is the standard rectangular coordinate system in three dimensions. "
}], "Text",
 CellID->2168],

Cell[TextData[{
 "The ",
 StyleBox["cylindrical coordinate system", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Cylindrical",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Cylindrical"], "[", 
   StyleBox["r", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["theta", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " uses polar coordinates ",
 Cell[BoxData[
  FormBox[
   StyleBox["r", "TI"], TraditionalForm]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineFormula"],
 " to locate a point in the ",
 Cell[BoxData[
  FormBox[
   StyleBox["x", "TI"], TraditionalForm]], "InlineFormula"],
 "\[Hyphen]",
 Cell[BoxData[
  FormBox[
   StyleBox["y", "TI"], TraditionalForm]], "InlineFormula"],
 " plane and the coordinate ",
 Cell[BoxData[
  FormBox[
   StyleBox["z", "TI"], TraditionalForm]], "InlineFormula"],
 " for the height of the point above the ",
 Cell[BoxData[
  FormBox[
   StyleBox["x", "TI"], TraditionalForm]], "InlineFormula"],
 "\[Hyphen]",
 Cell[BoxData[
  FormBox[
   StyleBox["y", "TI"], TraditionalForm]], "InlineFormula"],
 " plane. "
}], "Text",
 CellID->15733],

Cell[TextData[{
 "In the ",
 StyleBox["spherical coordinate system", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Spherical",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Spherical"], "[", 
   StyleBox["r", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["theta", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["phi", "TI"], "]"}]], "InlineFormula"],
 ", the coordinate ",
 Cell[BoxData[
  FormBox[
   StyleBox["r", "TI"], TraditionalForm]], "InlineFormula"],
 " gives the distance of the point from the origin, the coordinate ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineFormula"],
 " gives the angle measured from the positive ",
 Cell[BoxData[
  FormBox[
   StyleBox["z", "TI"], TraditionalForm]], "InlineFormula"],
 " axis, and the coordinate ",
 Cell[BoxData[
  FormBox["\[Phi]", TraditionalForm]], "InlineFormula"],
 " gives the angle measured in the ",
 Cell[BoxData[
  FormBox[
   StyleBox["x", "TI"], TraditionalForm]], "InlineFormula"],
 "\[Hyphen]",
 Cell[BoxData[
  FormBox[
   StyleBox["y", "TI"], TraditionalForm]], "InlineFormula"],
 " plane from the positive ",
 Cell[BoxData[
  FormBox[
   StyleBox["x", "TI"], TraditionalForm]], "InlineFormula"],
 " axis, counterclockwise as viewed from the positive ",
 Cell[BoxData[
  FormBox[
   StyleBox["z", "TI"], TraditionalForm]], "InlineFormula"],
 " axis. "
}], "Text",
 CellID->25605],

Cell[TextData[{
 "In the ",
 StyleBox["parabolic cylindrical coordinate system", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ParabolicCylindrical",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/ParabolicCylindrical"], "[", 
   StyleBox["u", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["v", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 ", varying only one of the coordinates ",
 Cell[BoxData[
  FormBox[
   StyleBox["u", "TI"], TraditionalForm]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["v", "TI"], TraditionalForm]], "InlineFormula"],
 " while coordinate ",
 Cell[BoxData[
  FormBox[
   StyleBox["z", "TI"], TraditionalForm]], "InlineFormula"],
 " is held constant produces opposite facing parabolas. The coordinate ",
 Cell[BoxData[
  FormBox[
   StyleBox["z", "TI"], TraditionalForm]], "InlineFormula"],
 " specifies distances along the axis of common focus. "
}], "Text",
 CellID->16947],

Cell[TextData[{
 "In the ",
 StyleBox["paraboloidal coordinate system", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Paraboloidal",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Paraboloidal"], "[", 
   StyleBox["u", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["v", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["phi", "TI"], "]"}]], "InlineFormula"],
 ", varying only one of the coordinates ",
 Cell[BoxData[
  FormBox[
   StyleBox["u", "TI"], TraditionalForm]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["v", "TI"], TraditionalForm]], "InlineFormula"],
 " while coordinate ",
 Cell[BoxData[
  FormBox["\[Phi]", TraditionalForm]], "InlineFormula"],
 " is held constant produces opposite facing parabolas. The coordinate ",
 Cell[BoxData[
  FormBox["\[Phi]", TraditionalForm]], "InlineFormula"],
 " specifies rotations about their common bisectors. "
}], "Text",
 CellID->2750],

Cell[TextData[{
 "The ",
 StyleBox["elliptic cylindrical coordinate system", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EllipticCylindrical",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/EllipticCylindrical"], "[", 
   StyleBox["u", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["v", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["z", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["a", "TI"], "]"}]], "InlineFormula"],
 ", parameterized by ",
 Cell[BoxData[
  FormBox[
   StyleBox["a", "TI"], TraditionalForm]], "InlineFormula"],
 ", is built around two foci separated by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", 
    StyleBox["a", "TI"]}], TraditionalForm]], "InlineFormula"],
 ". Holding coordinate ",
 Cell[BoxData[
  FormBox[
   StyleBox["u", "TI"], TraditionalForm]], "InlineFormula"],
 " constant while varying the other coordinates produces a family of confocal \
ellipses. Fixing coordinate ",
 Cell[BoxData[
  FormBox[
   StyleBox["v", "TI"], TraditionalForm]], "InlineFormula"],
 " produces a family of confocal hyperbolas. The coordinate ",
 Cell[BoxData[
  FormBox[
   StyleBox["z", "TI"], TraditionalForm]], "InlineFormula"],
 " specifies distance along the axis of common focus. The default value for \
parameter ",
 Cell[BoxData[
  FormBox[
   StyleBox["a", "TI"], TraditionalForm]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula"],
 ". "
}], "Text",
 CellID->15822],

Cell[TextData[{
 "The ",
 StyleBox["prolate spheroidal coordinate system", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ProlateSpheroidal",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/ProlateSpheroidal"], "[", 
   StyleBox["xi", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["eta", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["phi", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["a", "TI"], "]"}]], "InlineFormula"],
 ", parameterized by ",
 Cell[BoxData[
  FormBox[
   StyleBox["a", "TI"], TraditionalForm]], "InlineFormula"],
 ", is obtained by rotating elliptic cylindrical coordinates about the axis \
connecting the two foci. The coordinate ",
 Cell[BoxData[
  FormBox["\[Phi]", TraditionalForm]], "InlineFormula"],
 " specifies the rotation. The default value for parameter ",
 Cell[BoxData[
  FormBox[
   StyleBox["a", "TI"], TraditionalForm]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula"],
 ". "
}], "Text",
 CellID->7351],

Cell[TextData[{
 "The ",
 StyleBox["oblate spheroidal coordinate system", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["OblateSpheroidal",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/OblateSpheroidal"], "[", 
   StyleBox["xi", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["eta", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["phi", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["a", "TI"], "]"}]], "InlineFormula"],
 ", parameterized by ",
 Cell[BoxData[
  FormBox[
   StyleBox["a", "TI"], TraditionalForm]], "InlineFormula"],
 ", is obtained by rotating elliptic cylindrical coordinates about an axis \
perpendicular to the axis connecting the two foci. The coordinate ",
 Cell[BoxData[
  FormBox["\[Phi]", TraditionalForm]], "InlineFormula"],
 " specifies the rotation. The default value for parameter ",
 Cell[BoxData[
  FormBox[
   StyleBox["a", "TI"], TraditionalForm]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula"],
 ". "
}], "Text",
 CellID->32029],

Cell[TextData[{
 "The ",
 StyleBox["bipolar coordinate system", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Bipolar",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Bipolar"], "[", 
   StyleBox["u", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["v", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["z", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["a", "TI"], "]"}]], "InlineFormula"],
 ", parameterized by ",
 Cell[BoxData[
  FormBox[
   StyleBox["a", "TI"], TraditionalForm]], "InlineFormula"],
 ", is built around two foci separated by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", 
    StyleBox["a", "TI"]}], TraditionalForm]], "InlineFormula"],
 ". Holding coordinate ",
 Cell[BoxData[
  FormBox[
   StyleBox["u", "TI"], TraditionalForm]], "InlineFormula"],
 " constant produces a family of circles that pass through both foci. Fixing \
coordinate ",
 Cell[BoxData[
  FormBox[
   StyleBox["v", "TI"], TraditionalForm]], "InlineFormula"],
 " produces a family of degenerate ellipses about one of the foci. The \
coordinate ",
 Cell[BoxData[
  FormBox[
   StyleBox["z", "TI"], TraditionalForm]], "InlineFormula"],
 " specifies distance along the axis of common focus. The default value for \
parameter ",
 Cell[BoxData[
  FormBox[
   StyleBox["a", "TI"], TraditionalForm]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula"],
 ". "
}], "Text",
 CellID->29753],

Cell[TextData[{
 "The ",
 StyleBox["bispherical coordinate system", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Bispherical",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Bispherical"], "[", 
   StyleBox["u", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["v", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["phi", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["a", "TI"], "]"}]], "InlineFormula"],
 ", parameterized by ",
 Cell[BoxData[
  FormBox[
   StyleBox["a", "TI"], TraditionalForm]], "InlineFormula"],
 ", differs from the bipolar system only in that coordinate ",
 Cell[BoxData[
  FormBox["\[Phi]", TraditionalForm]], "InlineFormula"],
 " measures an azimuthal angle. "
}], "Text",
 CellID->22247],

Cell[TextData[{
 "The ",
 StyleBox["toroidal coordinate system", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Toroidal",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Toroidal"], "[", 
   StyleBox["u", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["v", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["phi", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["a", "TI"], "]"}]], "InlineFormula"],
 ", parameterized by ",
 Cell[BoxData[
  FormBox[
   StyleBox["a", "TI"], TraditionalForm]], "InlineFormula"],
 ", is obtained by rotating bipolar coordinates about an axis perpendicular \
to the axis connecting the two foci. The coordinate ",
 Cell[BoxData[
  FormBox["\[Phi]", TraditionalForm]], "InlineFormula"],
 " specifies the rotation. The default value for parameter ",
 Cell[BoxData[
  FormBox[
   StyleBox["a", "TI"], TraditionalForm]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula"],
 ". "
}], "Text",
 CellID->25610],

Cell[TextData[{
 "In the ",
 StyleBox["conical coordinate system", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Conical",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Conical"], "[", 
   StyleBox["lambda", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["mu", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["nu", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["a", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["b", "TI"], "]"}]], "InlineFormula"],
 ", parameterized by ",
 Cell[BoxData[
  FormBox[
   StyleBox["a", "TI"], TraditionalForm]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["b", "TI"], TraditionalForm]], "InlineFormula"],
 ", the surfaces described by fixing coordinate ",
 Cell[BoxData[
  FormBox["\[Lambda]", TraditionalForm]], "InlineFormula"],
 " are spheres centered at the origin. Fixing coordinate ",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]], "InlineFormula"],
 " gives cones with apexes at the origin and axes along the ",
 Cell[BoxData[
  FormBox[
   StyleBox["z", "TI"], TraditionalForm]], "InlineFormula"],
 " axis, and fixing coordinate ",
 Cell[BoxData[
  FormBox["\[Nu]", TraditionalForm]], "InlineFormula"],
 " gives cones with apexes at the origin and axes along the ",
 Cell[BoxData[
  FormBox[
   StyleBox["y", "TI"], TraditionalForm]], "InlineFormula"],
 " axis. The default values for parameters ",
 Cell[BoxData[
  FormBox[
   StyleBox["a", "TI"], TraditionalForm]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["b", "TI"], TraditionalForm]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineFormula"],
 ", respectively. "
}], "Text",
 CellID->13709],

Cell[TextData[{
 "In the ",
 StyleBox["confocal ellipsoidal coordinate system", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ConfocalEllipsoidal",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/ConfocalEllipsoidal"], "[", 
   StyleBox["lambda", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["mu", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["nu", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["a", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["b", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["c", "TI"], "]"}]], "InlineFormula"],
 ", parameterized by ",
 Cell[BoxData[
  FormBox[
   StyleBox["a", "TI"], TraditionalForm]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["b", "TI"], TraditionalForm]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  FormBox[
   StyleBox["c", "TI"], TraditionalForm]], "InlineFormula"],
 ", the surfaces described by fixing coordinate ",
 Cell[BoxData[
  FormBox["\[Lambda]", TraditionalForm]], "InlineFormula"],
 " are ellipsoids. Fixing coordinate ",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]], "InlineFormula"],
 " gives hyperboloids of one sheet, and fixing coordinate ",
 Cell[BoxData[
  FormBox["\[Nu]", TraditionalForm]], "InlineFormula"],
 " gives hyperboloids of two sheets. The default values for parameters ",
 Cell[BoxData[
  FormBox[
   StyleBox["a", "TI"], TraditionalForm]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["b", "TI"], TraditionalForm]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["c", "TI"], TraditionalForm]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  FormBox["3", TraditionalForm]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula"],
 ", respectively. "
}], "Text",
 CellID->19691],

Cell[TextData[{
 "In the ",
 StyleBox["confocal paraboloidal coordinate system", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ConfocalParaboloidal",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/ConfocalParaboloidal"], "[", 
   StyleBox["lambda", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["mu", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["nu", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["a", "TI"], 
   StyleBox[",", "TI"], " ", 
   StyleBox["b", "TI"], "]"}]], "InlineFormula"],
 ", parameterized by ",
 Cell[BoxData[
  FormBox[
   StyleBox["a", "TI"], TraditionalForm]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["b", "TI"], TraditionalForm]], "InlineFormula"],
 ", the surfaces described by fixing coordinate ",
 Cell[BoxData[
  FormBox["\[Lambda]", TraditionalForm]], "InlineFormula"],
 " are elliptic paraboloids extending in the negative ",
 Cell[BoxData[
  FormBox[
   StyleBox["z", "TI"], TraditionalForm]], "InlineFormula"],
 " direction. Fixing coordinate ",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]], "InlineFormula"],
 " gives hyperbolic paraboloids, and fixing coordinate ",
 Cell[BoxData[
  FormBox["\[Nu]", TraditionalForm]], "InlineFormula"],
 " gives elliptic paraboloids extending in the positive ",
 Cell[BoxData[
  FormBox[
   StyleBox["z", "TI"], TraditionalForm]], "InlineFormula"],
 " direction. The default values for parameters ",
 Cell[BoxData[
  FormBox[
   StyleBox["a", "TI"], TraditionalForm]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["b", "TI"], TraditionalForm]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula"],
 ", respectively. "
}], "Text",
 CellID->16144],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["CoordinateRanges",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/CoordinateRanges"], "[", "]"}], 
    Cell["\<\
give the intervals over which each of the coordinate variables of the default \
coordinate system may range\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["Parameters",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/Parameters"], "[", "]"}], 
    Cell["\<\
give a list of the default parameter values for the default coordinate system\
\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["ParameterRanges",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/ParameterRanges"], "[", "]"}], 
    Cell["\<\
give the intervals over which each of the parameters of the default \
coordinate system may range\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["CoordinateRanges",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/CoordinateRanges"], "[", 
     StyleBox["coordsys", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["Parameters",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/Parameters"], "[", 
     StyleBox["coordsys", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["ParameterRanges",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/ParameterRanges"], "[", 
     StyleBox["coordsys", "TI"], "]"}], Cell[TextData[{
     "give the result for the coordinate system ",
     StyleBox["coordsys", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SetCoordinates",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/SetCoordinates"], "[", 
     StyleBox["coordsys", "TI"], "[", 
     StyleBox["vars", "TI"], ",", 
     StyleBox["param", "TI"], "]", "]"}], Cell[TextData[{
     "set the default coordinate system to be ",
     Cell[BoxData[
      StyleBox["coordsys", "TI"]], "InlineFormula"],
     " with variables ",
     Cell[BoxData[
      StyleBox["vars", "TI"]], "InlineFormula"],
     " and parameter values ",
     Cell[BoxData[
      StyleBox["param", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->27673],

Cell["The range of coordinate variables and parameters. ", "Caption",
 CellID->5637],

Cell[TextData[{
 "This gives the default coordinate variables and their ranges for the ",
 Cell[BoxData[
  ButtonBox["Conical",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Conical"]], "InlineFormula"],
 " system. "
}], "MathCaption",
 CellID->4827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Coordinates", "[", "Conical", "]"}], ",", 
   RowBox[{"CoordinateRanges", "[", "Conical", "]"}]}], "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->17276],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Llambda", ",", "Mmu", ",", "Nnu"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[Infinity]"}], "<", "Llambda", "<", "\[Infinity]"}], ",",
      
     RowBox[{"1", "<", 
      SuperscriptBox["Mmu", "2"], "<", "4"}], ",", 
     RowBox[{
      SuperscriptBox["Nnu", "2"], "<", "1"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{410, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->3430]
}, Open  ]],

Cell[TextData[{
 "This means that the ",
 Cell[BoxData[
  ButtonBox["Bipolar",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Bipolar"]], "InlineFormula"],
 " system has one parameter that must be a positive number. The default value \
of this parameter is ",
 StyleBox["1", "MR"],
 ". "
}], "MathCaption",
 CellID->6384],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Parameters", "[", "Bipolar", "]"}], ",", 
   RowBox[{"ParameterRanges", "[", "Bipolar", "]"}]}], "}"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->4434],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"0", "<", "#1", "<", "\[Infinity]"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->31107]
}, Open  ]],

Cell[TextData[{
 "This resets the ",
 Cell[BoxData[
  ButtonBox["Bipolar",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Bipolar"]], "InlineFormula"],
 " variables and parameter. "
}], "MathCaption",
 CellID->18801],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", 
  RowBox[{"Bipolar", "[", 
   RowBox[{"u", ",", "v", ",", "z", ",", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->17966],

Cell[BoxData[
 RowBox[{"Bipolar", "[", 
  RowBox[{"u", ",", "v", ",", "z", ",", "2"}], "]"}]], "Output",
 ImageSize->{129, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->30191]
}, Open  ]],

Cell[TextData[{
 "In the ",
 Cell[BoxData[
  ButtonBox["Conical",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Conical"]], "InlineFormula"],
 " system there are two parameters, and the second must always be larger than \
the first. "
}], "MathCaption",
 CellID->1517],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Parameters", "[", "Conical", "]"}], ",", 
   RowBox[{"ParameterRanges", "[", "Conical", "]"}]}], "}"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->23116],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"0", "<", "#1", "<", "#2", "<", "\[Infinity]"}]}], "}"}]], "Output",\

 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->18007]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["CoordinatesToCartesian",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/CoordinatesToCartesian"], "[", 
     StyleBox["pt", "TI"], "]"}], Cell[TextData[{
     "give the Cartesian coordinates of ",
     Cell[BoxData[
      StyleBox["pt", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["pt", "TI"]], "InlineFormula"],
     " is given in the default coordinate system"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CoordinatesToCartesian",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/CoordinatesToCartesian"], "[", 
     StyleBox["pt", "TI"], ",", 
     StyleBox["coordsys", "TI"], "]"}], Cell[TextData[{
     "give the Cartesian coordinates of ",
     Cell[BoxData[
      StyleBox["pt", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["pt", "TI"]], "InlineFormula"],
     " is given in the coordinate system ",
     StyleBox["coordsys", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CoordinatesFromCartesian",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/CoordinatesFromCartesian"], "[", 
     
     StyleBox["pt", "TI"], "]"}], Cell[TextData[{
     "give the default system coordinates of ",
     Cell[BoxData[
      StyleBox["pt", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["pt", "TI"]], "InlineFormula"],
     " is given in Cartesian coordinates"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CoordinatesFromCartesian",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/CoordinatesFromCartesian"], "[", 
     
     StyleBox["pt", "TI"], ",", 
     StyleBox["coordsys", "TI"], "]"}], Cell[TextData[{
     "give the ",
     Cell[BoxData[
      StyleBox["coordsys", "TI"]], "InlineFormula"],
     " coordinates of ",
     Cell[BoxData[
      StyleBox["pt", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["pt", "TI"]], "InlineFormula"],
     " is given in Cartesian coordinates"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->2084],

Cell["Converting to and from Cartesian coordinates. ", "Caption",
 CellID->11905],

Cell[TextData[{
 "This gives Cartesian coordinates of the point whose ",
 Cell[BoxData[
  ButtonBox["Spherical",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Spherical"]], "InlineFormula"],
 " coordinates are ",
 StyleBox["{1,", "MR"],
 " ",
 StyleBox["Pi/2,", "MR"],
 " ",
 StyleBox["Pi/4}", "MR"],
 ". "
}], "MathCaption",
 CellID->16236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoordinatesToCartesian", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     FractionBox["\[Pi]", "2"], ",", 
     FractionBox["\[Pi]", "4"]}], "}"}], ",", "Spherical"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->10259],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    SqrtBox["2"]], ",", 
   FractionBox["1", 
    SqrtBox["2"]], ",", "0"}], "}"}]], "Output",
 ImageSize->{104, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->11337]
}, Open  ]],

Cell["\<\
You get the general coordinate transformation formula when you give the \
variables in symbolic form. \
\>", "MathCaption",
 CellID->10627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoordinatesToCartesian", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", ",", "v", ",", "phi"}], "}"}], ",", "Paraboloidal"}], 
  "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->32641],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"u", " ", "v", " ", 
    RowBox[{"Cos", "[", "phi", "]"}]}], ",", 
   RowBox[{"u", " ", "v", " ", 
    RowBox[{"Sin", "[", "phi", "]"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["u", "2"], "-", 
      SuperscriptBox["v", "2"]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{259, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->15457]
}, Open  ]],

Cell[TextData[{
 "Here are the formulas for changing from ",
 Cell[BoxData[
  ButtonBox["Cartesian",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Cartesian"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["Bispherical",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Bispherical"]], "InlineFormula"],
 " coordinates. "
}], "MathCaption",
 CellID->27123],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoordinatesFromCartesian", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Bispherical"}], 
  "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->32616],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"Re", "[", 
     RowBox[{"ArcCot", "[", 
      RowBox[{
       SqrtBox[
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}]], "-", 
       RowBox[{"\[ImaginaryI]", " ", "z"}]}], "]"}], "]"}]}], ",", 
   RowBox[{"2", " ", 
    RowBox[{"Im", "[", 
     RowBox[{"ArcCot", "[", 
      RowBox[{
       SqrtBox[
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}]], "-", 
       RowBox[{"\[ImaginaryI]", " ", "z"}]}], "]"}], "]"}]}], ",", 
   RowBox[{"ArcTan", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}], "}"}]], "Output",
 ImageSize->{484, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->12287]
}, Open  ]],

Cell[TextData[{
 "The standard vector product operations, such as the dot and cross product, \
are usually defined and computed in the Cartesian coordinate system. If you \
have vectors given in a different coordinate system, you can compute vector \
products using ",
 Cell[BoxData[
  ButtonBox["DotProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/DotProduct"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CrossProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/CrossProduct"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["ScalarTripleProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/ScalarTripleProduct"]], 
  "InlineFormula"],
 ". These functions convert the given vectors into Cartesian coordinates and \
then compute the products using the standard definitions. "
}], "Text",
 CellID->9123],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DotProduct",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/DotProduct"], "[", 
     SubscriptBox[
      StyleBox["v", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["v", "TI"], "2"], "]"}], Cell[TextData[{
     "compute the dot product of the vectors ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], "1"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], "2"]], "InlineFormula"],
     " given in default coordinates"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CrossProduct",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/CrossProduct"], "[", 
     SubscriptBox[
      StyleBox["v", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["v", "TI"], "2"], "]"}], Cell["\<\
compute the cross product of the vectors given in default coordinates\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["ScalarTripleProduct",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/ScalarTripleProduct"], "[", 
     SubscriptBox[
      StyleBox["v", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["v", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["v", "TI"], "3"], "]"}], Cell["\<\
compute the scalar triple product of the vectors given in default coordinates\
\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["DotProduct",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/DotProduct"], "[", 
     SubscriptBox[
      StyleBox["v", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["v", "TI"], "2"], ",", 
     StyleBox["coordsys", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["CrossProduct",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/CrossProduct"], "[", 
     SubscriptBox[
      StyleBox["v", "TI"], "1"], Cell[", ", "TableText"], 
     SubscriptBox[
      StyleBox["v", "TI"], "2"], Cell[", ", "TableText"], 
     StyleBox["coordsys", "TI"], "]", Cell[",  etc.", "TableText"]}], Cell[
    TextData[{
     "give the result when the vectors are given in the coordinate system ",
     StyleBox["coordsys", "TI"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->893],

Cell["Computing vector products in various coordinate systems. ", "Caption",
 CellID->4767],

Cell[TextData[{
 "This sets the default coordinate system to ",
 Cell[BoxData[
  ButtonBox["ParabolicCylindrical",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/ParabolicCylindrical"]], 
  "InlineFormula"],
 " with default variables. "
}], "MathCaption",
 CellID->7771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", 
  RowBox[{"ParabolicCylindrical", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->16434],

Cell[BoxData[
 RowBox[{"ParabolicCylindrical", "[", 
  RowBox[{"Uu", ",", "Vv", ",", "Zz"}], "]"}]], "Output",
 ImageSize->{223, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->27753]
}, Open  ]],

Cell[TextData[{
 "This converts the vectors from the default system to ",
 Cell[BoxData[
  ButtonBox["Cartesian",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Cartesian"]], "InlineFormula"],
 " coordinates and then computes the scalar product. "
}], "MathCaption",
 CellID->24947],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DotProduct", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.2", ",", "1.1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.4", ",", 
     RowBox[{"-", "2"}], ",", "1.2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->20496],

Cell[BoxData[
 RowBox[{"-", "12.809300000000004`"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->10383]
}, Open  ]],

Cell["\<\
Viewed geometrically, the scalar triple product gives the volume of the \
parallelepiped spanned by the three vectors. \
\>", "MathCaption",
 CellID->11471],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ScalarTripleProduct", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", "Cartesian"}], 
  "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->7986],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->14945]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ArcLengthFactor",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/ArcLengthFactor"], "[", "{", 
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["x", "TI"]], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["y", "TI"]], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["z", "TI"]], "}", ",", 
     StyleBox["t", "TI"], "]"}], Cell[TextData[{
     "give the derivative of the arc length along the curve parameterized by \
",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " in the default coordinate system"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ArcLengthFactor",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/ArcLengthFactor"], "[", "{", 
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["x", "TI"]], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["y", "TI"]], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["z", "TI"]], "}", ",", 
     StyleBox["t", "TI"], ",", 
     StyleBox["coordsys", "TI"], "]"}], Cell[TextData[{
     "give the derivative in the coordinate system ",
     StyleBox["coordsys", "TI"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->1185],

Cell["Differential arc length element. ", "Caption",
 CellID->6605],

Cell[TextData[{
 "In Cartesian coordinates the differential arc length element is just ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      StyleBox["d", "TI"], 
      SuperscriptBox[
       StyleBox["x", "TI"], "2"], "+", 
      StyleBox["d", "TI"], 
      SuperscriptBox[
       StyleBox["y", "TI"], "2"], "+", 
      StyleBox["d", "TI"], 
      SuperscriptBox[
       StyleBox["z", "TI"], "2"]}], ")"}], 
    RowBox[{"1", "/", "2"}]], TraditionalForm]], "InlineFormula"],
 ". When you compute an integral along a parameterized curve in another \
coordinate system, you need to use the form appropriate to the coordinate \
system. To get the integral along the curve, you must plug the \
parameterization into the arc length element, compute the appropriate \
derivatives, and then integrate with respect to the parameter. The function \
",
 Cell[BoxData[
  ButtonBox["ArcLengthFactor",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/ArcLengthFactor"]], 
  "InlineFormula"],
 " takes the parameterization as an argument and returns the formula for the \
derivative of the arc length along the curve. "
}], "Text",
 CellID->26767],

Cell["This gives the parameterization of an ascending helix. ", "MathCaption",
 CellID->934],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"param", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Cos", "[", "t", "]"}], ",", 
    RowBox[{"Sin", "[", "t", "]"}], ",", "t"}], "}"}]}]], "Input",
 CellLabel->"In[14]:=",
 CellID->17854],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Cos", "[", "t", "]"}], ",", 
   RowBox[{"Sin", "[", "t", "]"}], ",", "t"}], "}"}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->8909]
}, Open  ]],

Cell[TextData[{
 "This means that the derivative of the arc length, with respect to ",
 Cell[BoxData[
  FormBox[
   StyleBox["t", "TI"], TraditionalForm]], "InlineFormula"],
 " along the helix, is ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]], "InlineFormula"],
 ". If we think of the parameterization as describing the motion of a \
particle in ",
 Cell[BoxData[
  ButtonBox["Cartesian",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Cartesian"]], "InlineFormula"],
 " coordinates, this just means that the speed of the particle is ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->5957],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"ArcLengthFactor", "[", 
   RowBox[{"param", ",", "t", ",", "Cartesian"}], "]"}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->17756],

Cell[BoxData[
 SqrtBox["2"]], "Output",
 ImageSize->{28, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->32209]
}, Open  ]],

Cell["\<\
Here is a scalar\[Hyphen]valued function on three space. \
\>", "MathCaption",
 CellID->26995],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"{", 
    RowBox[{"x_", ",", "y_", ",", "z_"}], "}"}], "]"}], ":=", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox["y", "2"], " ", "z"}]}]], "Input",
 CellLabel->"In[16]:=",
 CellID->30973],

Cell["This gives the integral of the function along the helix. ", \
"MathCaption",
 CellID->24249],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   SubsuperscriptBox["\[Integral]", "0", 
    RowBox[{"2", " ", "\[Pi]"}]], 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "param", "]"}], " ", 
     RowBox[{"ArcLengthFactor", "[", 
      RowBox[{"param", ",", "t", ",", "Cartesian"}], "]"}]}], 
    RowBox[{"\[DifferentialD]", "t"}]}]}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->28650],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[Pi]", "2"], 
  RowBox[{"2", " ", 
   SqrtBox["2"]}]]], "Output",
 ImageSize->{42, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->9758]
}, Open  ]],

Cell[TextData[{
 "The derivative of a coordinate transformation is the matrix of its partial \
derivatives. In the case of three\[Hyphen]dimensional coordinate systems this \
is always a three by three matrix. This matrix is sometimes called the ",
 StyleBox["Jacobian matrix",
  FontSlant->"Italic"],
 ". The determinant of this matrix is called the ",
 StyleBox["Jacobian determinant",
  FontSlant->"Italic"],
 " of the transformation, or else just the ",
 StyleBox["Jacobian",
  FontSlant->"Italic"],
 ". This determinant measures how infinitesimal volumes change under the \
transformation. For this reason, the Jacobian determinant is the \
multiplicative factor needed to adjust the differential volume form when you \
change coordinates. "
}], "Text",
 CellID->28018],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["JacobianMatrix",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/JacobianMatrix"], "[", "]"}], 
    Cell["\<\
give the derivative matrix of the transformation from the default coordinate \
system to Cartesian coordinates using the default variables\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["JacobianMatrix",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/JacobianMatrix"], "[", 
     StyleBox["pt", "TI"], "]"}], Cell[TextData[{
     "give the derivative at the point ",
     Cell[BoxData[
      StyleBox["pt", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["pt", "TI"]], "InlineFormula"],
     " is given in the default system"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["JacobianMatrix",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/JacobianMatrix"], "[", 
     StyleBox["coordsys", "TI"], "]"}], Cell[TextData[{
     "give the derivative of the transformation from the coordinate system ",
     Cell[BoxData[
      StyleBox["coordsys", "TI"]], "InlineFormula"],
     " to Cartesian coordinates "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["JacobianMatrix",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/JacobianMatrix"], "[", 
     StyleBox["pt", "TI"], ",", 
     StyleBox["coordsys", "TI"], "]"}], Cell[TextData[{
     "give the derivative at the point ",
     Cell[BoxData[
      StyleBox["pt", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["pt", "TI"]], "InlineFormula"],
     " is given in the coordinate system ",
     StyleBox["coordsys", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["JacobianDeterminant",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/JacobianDeterminant"], "[", "]", 
     Cell[", ", "TableText"], 
     ButtonBox["JacobianDeterminant",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/JacobianDeterminant"], "[", 
     StyleBox["pt", "TI"], "]", Cell[",  etc.", "TableText"]}], Cell[
    "give the determinant of the Jacobian matrix", "TableText"]},
   {
    RowBox[{
     ButtonBox["ScaleFactors",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/ScaleFactors"], "[", "]", Cell[
     ", ", "TableText"], 
     ButtonBox["ScaleFactors",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/ScaleFactors"], "[", 
     StyleBox["pt", "TI"], "]", Cell[",  etc.", "TableText"]}], Cell[
    "give a list of the scale factors", "TableText"]}
  }]], "DefinitionBox",
 CellID->30365],

Cell["\<\
The transformation matrix derivative, its determinant, and scale factors. \
\>", "Caption",
 CellID->9910],

Cell[TextData[{
 "This is the matrix of partial derivatives of the transformation from ",
 Cell[BoxData[
  ButtonBox["Spherical",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Spherical"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["Cartesian",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Cartesian"]], "InlineFormula"],
 " coordinates. "
}], "MathCaption",
 CellID->31822],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobianMatrix", "[", 
  RowBox[{"Spherical", "[", 
   RowBox[{"r", ",", "theta", ",", "phi"}], "]"}], "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->12243],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "phi", "]"}], " ", 
      RowBox[{"Sin", "[", "theta", "]"}]}], ",", 
     RowBox[{"r", " ", 
      RowBox[{"Cos", "[", "phi", "]"}], " ", 
      RowBox[{"Cos", "[", "theta", "]"}]}], ",", 
     RowBox[{
      RowBox[{"-", "r"}], " ", 
      RowBox[{"Sin", "[", "phi", "]"}], " ", 
      RowBox[{"Sin", "[", "theta", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "phi", "]"}], " ", 
      RowBox[{"Sin", "[", "theta", "]"}]}], ",", 
     RowBox[{"r", " ", 
      RowBox[{"Cos", "[", "theta", "]"}], " ", 
      RowBox[{"Sin", "[", "phi", "]"}]}], ",", 
     RowBox[{"r", " ", 
      RowBox[{"Cos", "[", "phi", "]"}], " ", 
      RowBox[{"Sin", "[", "theta", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "theta", "]"}], ",", 
     RowBox[{
      RowBox[{"-", "r"}], " ", 
      RowBox[{"Sin", "[", "theta", "]"}]}], ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{470, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->24221]
}, Open  ]],

Cell["\<\
The determinant of the derivative of the coordinate transformation gives the \
infinitesimal change in volume. \
\>", "MathCaption",
 CellID->17408],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobianDeterminant", "[", 
  RowBox[{"Spherical", "[", 
   RowBox[{"r", ",", "theta", ",", "phi"}], "]"}], "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->18042],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["r", "2"], " ", 
  RowBox[{"Sin", "[", "theta", "]"}]}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->18588]
}, Open  ]],

Cell[TextData[{
 "This triple integral computes the integral of the function ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["r", "TI"], "2"], TraditionalForm]], "InlineFormula"],
 " over a solid sphere of radius ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineFormula"],
 " using spherical coordinates. Note that the Jacobian is included in the \
integrand, because the integral is expressed in ",
 Cell[BoxData[
  ButtonBox["Spherical",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Spherical"]], "InlineFormula"],
 " coordinates. "
}], "MathCaption",
 CellID->182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "2"], 
  RowBox[{
   SubsuperscriptBox["\[Integral]", "0", "\[Pi]"], 
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "\[Pi]"}], "\[Pi]"], 
    RowBox[{
     RowBox[{
      SuperscriptBox["r", "2"], " ", 
      RowBox[{"JacobianDeterminant", "[", 
       RowBox[{"Spherical", "[", 
        RowBox[{"r", ",", "theta", ",", "phi"}], "]"}], "]"}]}], 
     RowBox[{"\[DifferentialD]", "phi"}], 
     RowBox[{"\[DifferentialD]", "theta"}], 
     RowBox[{"\[DifferentialD]", "r"}]}]}]}]}]], "Input",
 CellLabel->"In[20]:=",
 CellID->20728],

Cell[BoxData[
 FractionBox[
  RowBox[{"128", " ", "\[Pi]"}], "5"]], "Output",
 ImageSize->{41, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->6422]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Div",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/Div"], "[", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "give the divergence of the vector field ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " in the default coordinate system"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Curl",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/Curl"], "[", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "give the curl of the vector field ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " in the default coordinate system"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Grad",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/Grad"], "[", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "give the gradient of the scalar function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " in the default coordinate system"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Laplacian",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/Laplacian"], "[", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "give the Laplacian of the scalar function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " in the default coordinate system"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Biharmonic",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/Biharmonic"], "[", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "give the Laplacian of the Laplacian of the scalar function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " in the default coordinate system"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Div",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/Div"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["coordsys", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["Curl",
      BaseStyle->"Link",
      ButtonData->"paclet:VectorAnalysis/ref/Curl"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["coordsys", "TI"], "]", Cell[", etc.", "TableText"]}], Cell[
    TextData[{
     "give the result if the coordinate system is ",
     StyleBox["coordsys", "TI"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->7033],

Cell["Common differential operations. ", "Caption",
 CellID->7262],

Cell[TextData[{
 "As is the case with the vector products discussed above, the common \
differential operations in three dimensions are defined in terms of ",
 Cell[BoxData[
  ButtonBox["Cartesian",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Cartesian"]], "InlineFormula"],
 " coordinates. If you are working in another coordinate system and you wish \
to compute these quantities, you must, in principle, first transform into the \
",
 Cell[BoxData[
  ButtonBox["Cartesian",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Cartesian"]], "InlineFormula"],
 " system and then do the calculation. When you specify the coordinate system \
in functions like ",
 Cell[BoxData[
  ButtonBox["Laplacian",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Laplacian"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Grad",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Grad"]], "InlineFormula"],
 ", and so on, this transformation is done automatically. "
}], "Text",
 CellID->30899],

Cell["Here is the usual gradient. ", "MathCaption",
 CellID->17496],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grad", "[", 
  RowBox[{
   RowBox[{"5", " ", 
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox["y", "3"], " ", 
    SuperscriptBox["z", "4"]}], ",", 
   RowBox[{"Cartesian", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->1644],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"10", " ", "x", " ", 
    SuperscriptBox["y", "3"], " ", 
    SuperscriptBox["z", "4"]}], ",", 
   RowBox[{"15", " ", 
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox["y", "2"], " ", 
    SuperscriptBox["z", "4"]}], ",", 
   RowBox[{"20", " ", 
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox["y", "3"], " ", 
    SuperscriptBox["z", "3"]}]}], "}"}]], "Output",
 ImageSize->{217, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->24946]
}, Open  ]],

Cell[TextData[{
 "This gradient is different, because we are treating the function as being \
in ",
 Cell[BoxData[
  ButtonBox["ProlateSpheroidal",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/ProlateSpheroidal"]], 
  "InlineFormula"],
 " coordinates with the (nonstandard) variables ",
 StyleBox["x", "MR"],
 ", ",
 StyleBox["y", "MR"],
 ", and ",
 StyleBox["z", "MR"],
 ". "
}], "MathCaption",
 CellID->9332],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grad", "[", 
  RowBox[{
   RowBox[{"5", " ", 
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox["y", "3"], " ", 
    SuperscriptBox["z", "4"]}], ",", 
   RowBox[{"ProlateSpheroidal", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->4897],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"10", " ", "x", " ", 
     SuperscriptBox["y", "3"], " ", 
     SuperscriptBox["z", "4"]}], 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", "y", "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"Sinh", "[", "x", "]"}], "2"]}]]], ",", 
   FractionBox[
    RowBox[{"15", " ", 
     SuperscriptBox["x", "2"], " ", 
     SuperscriptBox["y", "2"], " ", 
     SuperscriptBox["z", "4"]}], 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", "y", "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"Sinh", "[", "x", "]"}], "2"]}]]], ",", 
   RowBox[{"20", " ", 
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox["y", "3"], " ", 
    SuperscriptBox["z", "3"], " ", 
    RowBox[{"Csc", "[", "y", "]"}], " ", 
    RowBox[{"Csch", "[", "x", "]"}]}]}], "}"}]], "Output",
 ImageSize->{474, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->27506]
}, Open  ]],

Cell["\<\
If you give an unknown function, the result is returned in symbolic form.\
\>", "MathCaption",
 CellID->9212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Curl", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"r", ",", "theta", ",", "phi"}], "]"}], ",", 
     RowBox[{"g", "[", 
      RowBox[{"r", ",", "theta", ",", "phi"}], "]"}], ",", 
     RowBox[{"h", "[", 
      RowBox[{"r", ",", "theta", ",", "phi"}], "]"}]}], "}"}], ",", 
   RowBox[{"Cylindrical", "[", 
    RowBox[{"r", ",", "theta", ",", "phi"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->11562],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "r"}], " ", 
      RowBox[{
       SuperscriptBox["g", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "theta", ",", "phi"}], "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["h", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"r", ",", "theta", ",", "phi"}], "]"}]}], "r"], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["f", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"r", ",", "theta", ",", "phi"}], "]"}], "-", 
    RowBox[{
     SuperscriptBox["h", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "0", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"r", ",", "theta", ",", "phi"}], "]"}]}], ",", 
   RowBox[{
    FractionBox["1", "r"], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"g", "[", 
       RowBox[{"r", ",", "theta", ",", "phi"}], "]"}], "-", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "theta", ",", "phi"}], "]"}], "+", 
      RowBox[{"r", " ", 
       RowBox[{
        SuperscriptBox["g", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"r", ",", "theta", ",", "phi"}], "]"}]}]}], ")"}]}]}], 
  "}"}]], "Output",
 ImageSize->{472, 80},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->13030]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Vector Analysis Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 39.2326840}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Tutorial", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "A three-dimensional coordinate system assigns three numbers to each \
point in space. In defining a coordinate system, you have to make a choice \
about what to measure and how to measure it. Frequently, physical systems \
exhibit special symmetries or structures that make a particular coordinate \
system especially useful. In a mathematically elegant solution to problems \
related to these systems, often the main step is choosing the correct \
coordinates. A variety of tools for doing calculus in various \
three-dimensional coordinate systems are provided in this package. Because a \
given symbolic or numeric expression can mean different things in different \
coordinate systems, Mathematica must know what coordinate system you are \
using and what the coordinate variables are. The initial default coordinate \
system is Cartesian, with coordinate variables Xx, Yy, and Zz. If you \
frequently work in another system, it may be useful to change the default to \
that system using SetCoordinates. Coordinate systems and coordinate \
variables. ", "synonyms" -> {}, "title" -> "Vector Analysis Package", "type" -> 
    "Tutorial", "uri" -> "VectorAnalysis/tutorial/VectorAnalysis"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 5271, 99, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[5896, 126, 55, 1, 70, "Title",
 CellID->2171],
Cell[5954, 129, 510, 9, 70, "Text",
 CellID->27795],
Cell[6467, 140, 1287, 37, 70, "Text",
 CellID->28931],
Cell[7757, 179, 1621, 47, 70, "DefinitionBox",
 CellID->5310],
Cell[9381, 228, 79, 1, 70, "Caption",
 CellID->3290],
Cell[9463, 231, 63, 1, 70, "MathCaption",
 CellID->22344],
Cell[9529, 234, 97, 3, 70, "Input",
 CellID->2473],
Cell[9629, 239, 98, 2, 70, "MathCaption",
 CellID->32694],
Cell[CellGroupData[{
Cell[9752, 245, 182, 5, 28, "Input",
 CellID->28529],
Cell[9937, 252, 229, 7, 36, "Output",
 CellID->21724]
}, Open  ]],
Cell[10181, 262, 66, 1, 70, "MathCaption",
 CellID->31875],
Cell[CellGroupData[{
Cell[10272, 267, 160, 5, 70, "Input",
 CellID->29362],
Cell[10435, 274, 273, 9, 36, "Output",
 CellID->13966]
}, Open  ]],
Cell[10723, 286, 1284, 29, 70, "Text",
 CellID->12415],
Cell[12010, 317, 1740, 51, 70, "DefinitionBox",
 CellID->26437],
Cell[13753, 370, 54, 1, 70, "Caption",
 CellID->13730],
Cell[13810, 373, 760, 17, 70, "Text",
 CellID->16882],
Cell[14573, 392, 474, 16, 70, "Text",
 CellID->2168],
Cell[15050, 410, 1194, 43, 70, "Text",
 CellID->15733],
Cell[16247, 455, 1402, 46, 70, "Text",
 CellID->25605],
Cell[17652, 503, 995, 32, 70, "Text",
 CellID->16947],
Cell[18650, 537, 939, 30, 70, "Text",
 CellID->2750],
Cell[19592, 569, 1473, 48, 70, "Text",
 CellID->15822],
Cell[21068, 619, 1022, 33, 70, "Text",
 CellID->7351],
Cell[22093, 654, 1045, 33, 70, "Text",
 CellID->32029],
Cell[23141, 689, 1442, 49, 70, "Text",
 CellID->29753],
Cell[24586, 740, 746, 25, 70, "Text",
 CellID->22247],
Cell[25335, 767, 1004, 33, 70, "Text",
 CellID->25610],
Cell[26342, 802, 1791, 59, 70, "Text",
 CellID->13709],
Cell[28136, 863, 1881, 64, 70, "Text",
 CellID->19691],
Cell[30020, 929, 1825, 59, 70, "Text",
 CellID->16144],
Cell[31848, 990, 2206, 64, 70, "DefinitionBox",
 CellID->27673],
Cell[34057, 1056, 84, 1, 70, "Caption",
 CellID->5637],
Cell[34144, 1059, 268, 8, 70, "MathCaption",
 CellID->4827],
Cell[CellGroupData[{
Cell[34437, 1071, 206, 6, 70, "Input",
 CellID->17276],
Cell[34646, 1079, 539, 18, 39, "Output",
 CellID->3430]
}, Open  ]],
Cell[35200, 1100, 338, 11, 70, "MathCaption",
 CellID->6384],
Cell[CellGroupData[{
Cell[35563, 1115, 203, 6, 70, "Input",
 CellID->4434],
Cell[35769, 1123, 269, 9, 36, "Output",
 CellID->31107]
}, Open  ]],
Cell[36053, 1135, 233, 8, 70, "MathCaption",
 CellID->18801],
Cell[CellGroupData[{
Cell[36311, 1147, 184, 5, 70, "Input",
 CellID->17966],
Cell[36498, 1154, 231, 7, 36, "Output",
 CellID->30191]
}, Open  ]],
Cell[36744, 1164, 286, 9, 70, "MathCaption",
 CellID->1517],
Cell[CellGroupData[{
Cell[37055, 1177, 204, 6, 70, "Input",
 CellID->23116],
Cell[37262, 1185, 307, 11, 36, "Output",
 CellID->18007]
}, Open  ]],
Cell[37584, 1199, 2149, 66, 70, "DefinitionBox",
 CellID->2084],
Cell[39736, 1267, 81, 1, 70, "Caption",
 CellID->11905],
Cell[39820, 1270, 359, 14, 70, "MathCaption",
 CellID->16236],
Cell[CellGroupData[{
Cell[40204, 1288, 260, 8, 70, "Input",
 CellID->10259],
Cell[40467, 1298, 282, 11, 55, "Output",
 CellID->11337]
}, Open  ]],
Cell[40764, 1312, 149, 4, 70, "MathCaption",
 CellID->10627],
Cell[CellGroupData[{
Cell[40938, 1320, 212, 7, 70, "Input",
 CellID->32641],
Cell[41153, 1329, 500, 17, 51, "Output",
 CellID->15457]
}, Open  ]],
Cell[41668, 1349, 398, 13, 70, "MathCaption",
 CellID->27123],
Cell[CellGroupData[{
Cell[42091, 1366, 212, 7, 70, "Input",
 CellID->32616],
Cell[42306, 1375, 802, 27, 48, "Output",
 CellID->12287]
}, Open  ]],
Cell[43123, 1405, 891, 23, 70, "Text",
 CellID->9123],
Cell[44017, 1430, 2254, 68, 70, "DefinitionBox",
 CellID->893],
Cell[46274, 1500, 91, 1, 70, "Caption",
 CellID->4767],
Cell[46368, 1503, 287, 9, 70, "MathCaption",
 CellID->7771],
Cell[CellGroupData[{
Cell[46680, 1516, 149, 4, 70, "Input",
 CellID->16434],
Cell[46832, 1522, 238, 7, 36, "Output",
 CellID->27753]
}, Open  ]],
Cell[47085, 1532, 299, 8, 70, "MathCaption",
 CellID->24947],
Cell[CellGroupData[{
Cell[47409, 1544, 273, 9, 70, "Input",
 CellID->20496],
Cell[47685, 1555, 190, 6, 36, "Output",
 CellID->10383]
}, Open  ]],
Cell[47890, 1564, 166, 4, 70, "MathCaption",
 CellID->11471],
Cell[CellGroupData[{
Cell[48081, 1572, 342, 11, 70, "Input",
 CellID->7986],
Cell[48426, 1585, 155, 5, 36, "Output",
 CellID->14945]
}, Open  ]],
Cell[48596, 1593, 1317, 42, 70, "DefinitionBox",
 CellID->1185],
Cell[49916, 1637, 67, 1, 70, "Caption",
 CellID->6605],
Cell[49986, 1640, 1181, 31, 70, "Text",
 CellID->26767],
Cell[51170, 1673, 92, 1, 70, "MathCaption",
 CellID->934],
Cell[CellGroupData[{
Cell[51287, 1678, 214, 7, 70, "Input",
 CellID->17854],
Cell[51504, 1687, 272, 9, 36, "Output",
 CellID->8909]
}, Open  ]],
Cell[51791, 1699, 691, 21, 70, "MathCaption",
 CellID->5957],
Cell[CellGroupData[{
Cell[52507, 1724, 189, 5, 70, "Input",
 CellID->17756],
Cell[52699, 1731, 166, 6, 38, "Output",
 CellID->32209]
}, Open  ]],
Cell[52880, 1740, 104, 3, 70, "MathCaption",
 CellID->26995],
Cell[52987, 1745, 263, 9, 70, "Input",
 CellID->30973],
Cell[53253, 1756, 98, 2, 70, "MathCaption",
 CellID->24249],
Cell[CellGroupData[{
Cell[53376, 1762, 399, 12, 70, "Input",
 CellID->28650],
Cell[53778, 1776, 238, 9, 58, "Output",
 CellID->9758]
}, Open  ]],
Cell[54031, 1788, 774, 17, 70, "Text",
 CellID->28018],
Cell[54808, 1807, 2656, 74, 70, "DefinitionBox",
 CellID->30365],
Cell[57467, 1883, 116, 3, 70, "Caption",
 CellID->9910],
Cell[57586, 1888, 423, 13, 70, "MathCaption",
 CellID->31822],
Cell[CellGroupData[{
Cell[58034, 1905, 183, 5, 70, "Input",
 CellID->12243],
Cell[58220, 1912, 1176, 37, 71, "Output",
 CellID->24221]
}, Open  ]],
Cell[59411, 1952, 158, 4, 70, "MathCaption",
 CellID->17408],
Cell[CellGroupData[{
Cell[59594, 1960, 188, 5, 70, "Input",
 CellID->18042],
Cell[59785, 1967, 235, 8, 36, "Output",
 CellID->18588]
}, Open  ]],
Cell[60035, 1978, 609, 17, 70, "MathCaption",
 CellID->182],
Cell[CellGroupData[{
Cell[60669, 1999, 617, 18, 70, "Input",
 CellID->20728],
Cell[61289, 2019, 203, 7, 51, "Output",
 CellID->6422]
}, Open  ]],
Cell[61507, 2029, 2412, 73, 70, "DefinitionBox",
 CellID->7033],
Cell[63922, 2104, 66, 1, 70, "Caption",
 CellID->7262],
Cell[63991, 2107, 1050, 27, 70, "Text",
 CellID->30899],
Cell[65044, 2136, 67, 1, 70, "MathCaption",
 CellID->17496],
Cell[CellGroupData[{
Cell[65136, 2141, 313, 10, 70, "Input",
 CellID->1644],
Cell[65452, 2153, 554, 18, 39, "Output",
 CellID->24946]
}, Open  ]],
Cell[66021, 2174, 429, 16, 70, "MathCaption",
 CellID->9332],
Cell[CellGroupData[{
Cell[66475, 2194, 321, 10, 70, "Input",
 CellID->4897],
Cell[66799, 2206, 1024, 34, 65, "Output",
 CellID->27506]
}, Open  ]],
Cell[67838, 2243, 119, 3, 70, "MathCaption",
 CellID->9212],
Cell[CellGroupData[{
Cell[67982, 2250, 481, 14, 70, "Input",
 CellID->11562],
Cell[68466, 2266, 1989, 68, 101, "Output",
 CellID->13030]
}, Open  ]]
}, Open  ]],
Cell[70482, 2338, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

