(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23549,        612]
NotebookOptionsPosition[     20925,        530]
NotebookOutlinePosition[     22386,        569]
CellTagsIndexPosition[     22301,        564]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR FIELD PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"GradientFieldPlot3D" :> 
         Documentation`HelpLookup[
          "paclet:VectorFieldPlots/ref/GradientFieldPlot3D"], 
         "VectorFieldPlot" :> 
         Documentation`HelpLookup[
          "paclet:VectorFieldPlots/ref/VectorFieldPlot"], 
         "HamiltonianFieldPlot" :> 
         Documentation`HelpLookup[
          "paclet:VectorFieldPlots/ref/HamiltonianFieldPlot"], 
         "PolyaFieldPlot" :> 
         Documentation`HelpLookup[
          "paclet:VectorFieldPlots/ref/PolyaFieldPlot"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"GradientFieldPlot3D\"\>", 
      2->"\<\"VectorFieldPlot\"\>", 3->"\<\"HamiltonianFieldPlot\"\>", 
      4->"\<\"PolyaFieldPlot\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GradientFieldPlot", "ObjectName",
 CellID->26372],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GradientFieldPlot", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["y", "TI"], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a plot of the gradient vector field of the \
scalar function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GradientFieldPlot", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["dx", "TI"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["y", "TI"], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["dy", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]uses steps ",
     Cell[BoxData[
      StyleBox["dx", "TI"]], "InlineFormula"],
     " in variable ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", and steps ",
     Cell[BoxData[
      StyleBox["dy", "TI"]], "InlineFormula"],
     " in variable ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->3321]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The derivatives of ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " are calculated analytically."
}], "Notes",
 CellID->18830],

Cell[TextData[{
 Cell[BoxData["GradientFieldPlot"], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", with the following additions and changes:"
}], "Notes",
 CellID->5281],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ColorFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunction"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["\<\
a function to use for coloring the vectors by their magnitude\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MaxArrowLength",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorFieldPlots/ref/MaxArrowLength"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "length of the largest vector to be drawn, applied after the ",
     Cell[BoxData[
      ButtonBox["ScaleFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorFieldPlots/ref/ScaleFunction"]], 
      "InlineFormula"],
     ", but before the ",
     Cell[BoxData[
      ButtonBox["ScaleFactor",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorFieldPlots/ref/ScaleFactor"]], 
      "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotPoints",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotPoints"], "15", Cell[
    "the number of evaluation points in each direction", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ScaleFactor",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorFieldPlots/ref/ScaleFactor"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "linearly rescales the vectors so the longest vector is equal to this \
value; ",
     Cell[BoxData[
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
     " fits the vectors in the mesh, ",
     Cell[BoxData[
      ButtonBox["None",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/None"]], "InlineFormula"],
     " eliminates the rescaling"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ScaleFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorFieldPlots/ref/ScaleFunction"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "a function to use for rescaling the magnitude of vectors", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->28571]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->467966063],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->237857605],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorFieldPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->33891130],

Cell[TextData[{
 "Gradient field of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", "(", 
    RowBox[{"x", " ", "y"}], ")"}], TraditionalForm]], "InlineMath"],
 " over the unit square:"
}], "ExampleText",
 CellID->1737741043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GradientFieldPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", "0", ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2097615854],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->653080133]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22005],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GradientFieldPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/GradientFieldPlot3D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VectorFieldPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/VectorFieldPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HamiltonianFieldPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/HamiltonianFieldPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolyaFieldPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/PolyaFieldPlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->726142772]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GradientFieldPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 40.1233318}", "context" -> 
    "VectorFieldPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Field Plots Package Symbol", "language" -> "en", "paclet" -> 
    "VectorFieldPlots Package", "status" -> "None", "summary" -> 
    "GradientFieldPlot[f, {x, x_min, x_max}, {y, y_min, y_max}] generates a \
plot of the gradient vector field of the scalar function f. \
GradientFieldPlot[f, {x, x_min, x_max, dx}, {y, y_min, y_max, dy}] uses steps \
dx in variable x, and steps dy in variable y.", "synonyms" -> {}, "title" -> 
    "GradientFieldPlot", "type" -> "Symbol", "uri" -> 
    "VectorFieldPlots/ref/GradientFieldPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7648, 245, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->467966063]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22158, 557}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1116, 26, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1739, 53, 55, 1, 70, "ObjectName",
 CellID->26372],
Cell[1797, 56, 2277, 74, 70, "Usage",
 CellID->3321]
}, Open  ]],
Cell[CellGroupData[{
Cell[4111, 135, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4589, 152, 158, 6, 70, "Notes",
 CellID->18830],
Cell[4750, 160, 293, 9, 70, "Notes",
 CellID->5281],
Cell[5046, 171, 2565, 69, 70, "3ColumnTableMod",
 CellID->28571]
}, Closed]],
Cell[CellGroupData[{
Cell[7648, 245, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->467966063],
Cell[CellGroupData[{
Cell[8033, 259, 148, 5, 70, "ExampleSection",
 CellID->237857605],
Cell[8184, 266, 140, 4, 70, "Input",
 CellID->33891130],
Cell[8327, 272, 224, 8, 70, "ExampleText",
 CellID->1737741043],
Cell[CellGroupData[{
Cell[8576, 284, 351, 10, 28, "Input",
 CellID->2097615854],
Cell[8930, 296, 10493, 176, 201, "Output",
 Evaluatable->False,
 CellID->653080133]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19484, 479, 311, 9, 70, "SeeAlsoSection",
 CellID->22005],
Cell[19798, 490, 1085, 35, 70, "SeeAlso",
 CellID->726142772]
}, Open  ]],
Cell[20898, 528, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

