(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22008,        588]
NotebookOptionsPosition[     19346,        506]
NotebookOutlinePosition[     20857,        545]
CellTagsIndexPosition[     20772,        540]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR FIELD PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"VectorFieldPlot" :> 
         Documentation`HelpLookup[
          "paclet:VectorFieldPlots/ref/VectorFieldPlot"], "GradientFieldPlot" :> 
         Documentation`HelpLookup[
          "paclet:VectorFieldPlots/ref/GradientFieldPlot"], "PolyaFieldPlot" :> 
         Documentation`HelpLookup[
          "paclet:VectorFieldPlots/ref/PolyaFieldPlot"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"VectorFieldPlot\"\>", 
      2->"\<\"GradientFieldPlot\"\>", 
      3->"\<\"PolyaFieldPlot\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["HamiltonianFieldPlot", "ObjectName",
 CellID->7416],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"HamiltonianFieldPlot", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["y", "TI"], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a plot of the Hamiltonian vector field of \
the scalar-valued function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " as a function of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"HamiltonianFieldPlot", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["dx", "TI"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["y", "TI"], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["dy", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]uses steps ",
     Cell[BoxData[
      StyleBox["dx", "TI"]], "InlineFormula"],
     " in variable ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", and steps ",
     Cell[BoxData[
      StyleBox["dy", "TI"]], "InlineFormula"],
     " in variable ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->20288]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The derivatives of ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " are calculated analytically."
}], "Notes",
 CellID->3467],

Cell[TextData[{
 Cell[BoxData["HamiltonianFieldPlot"], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", with the following additions and changes:"
}], "Notes",
 CellID->629],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ColorFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunction"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["\<\
a function to use for coloring the vectors by their magnitude\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MaxArrowLength",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorFieldPlots/ref/MaxArrowLength"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "length of the largest vector to be drawn, applied after the ",
     Cell[BoxData[
      ButtonBox["ScaleFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorFieldPlots/ref/ScaleFunction"]], 
      "InlineFormula"],
     ", but before the ",
     Cell[BoxData[
      ButtonBox["ScaleFactor",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorFieldPlots/ref/ScaleFactor"]], 
      "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotPoints",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotPoints"], "15", Cell[
    "the number of evaluation points in each direction", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ScaleFactor",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorFieldPlots/ref/ScaleFactor"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "linearly rescales the vectors so the longest vector is equal to this \
value; ",
     Cell[BoxData[
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
     " fits the vectors in the mesh, ",
     Cell[BoxData[
      ButtonBox["None",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/None"]], "InlineFormula"],
     " eliminates the rescaling"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ScaleFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorFieldPlots/ref/ScaleFunction"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "a function to use for rescaling the magnitude of vectors", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->28571]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->794983730],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->57156687],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorFieldPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->47822361],

Cell[TextData[{
 "Hamiltonian vector field of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", "(", 
    RowBox[{"x", " ", "y"}], ")"}], TraditionalForm]], "InlineMath"],
 " as ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " run from 0 to 2\[Pi]:"
}], "ExampleText",
 CellID->314933347],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HamiltonianFieldPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1769971188],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->550178976]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5589],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["VectorFieldPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/VectorFieldPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GradientFieldPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/GradientFieldPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolyaFieldPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/PolyaFieldPlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4834]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HamiltonianFieldPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 40.4514652}", "context" -> 
    "VectorFieldPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Field Plots Package Symbol", "language" -> "en", "paclet" -> 
    "VectorFieldPlots Package", "status" -> "None", "summary" -> 
    "HamiltonianFieldPlot[f, {x, x_min, x_max}, {y, y_min, y_max}] generates \
a plot of the Hamiltonian vector field of the scalar-valued function f as a \
function of x and y. HamiltonianFieldPlot[f, {x, x_min, x_max, dx}, {y, \
y_min, y_max, dy}] uses steps dx in variable x, and steps dy in variable y.", 
    "synonyms" -> {}, "title" -> "HamiltonianFieldPlot", "type" -> "Symbol", 
    "uri" -> "VectorFieldPlots/ref/HamiltonianFieldPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7643, 246, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->794983730]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20629, 533}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 920, 21, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1543, 48, 57, 1, 70, "ObjectName",
 CellID->7416],
Cell[1603, 51, 2465, 80, 70, "Usage",
 CellID->20288]
}, Open  ]],
Cell[CellGroupData[{
Cell[4105, 136, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4583, 153, 157, 6, 70, "Notes",
 CellID->3467],
Cell[4743, 161, 295, 9, 70, "Notes",
 CellID->629],
Cell[5041, 172, 2565, 69, 70, "3ColumnTableMod",
 CellID->28571]
}, Closed]],
Cell[CellGroupData[{
Cell[7643, 246, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->794983730],
Cell[CellGroupData[{
Cell[8028, 260, 147, 5, 70, "ExampleSection",
 CellID->57156687],
Cell[8178, 267, 140, 4, 70, "Input",
 CellID->47822361],
Cell[8321, 273, 380, 14, 70, "ExampleText",
 CellID->314933347],
Cell[CellGroupData[{
Cell[8726, 291, 398, 12, 28, "Input",
 CellID->1769971188],
Cell[9127, 305, 9013, 152, 201, "Output",
 Evaluatable->False,
 CellID->550178976]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18201, 464, 310, 9, 70, "SeeAlsoSection",
 CellID->5589],
Cell[18514, 475, 790, 26, 70, "SeeAlso",
 CellID->4834]
}, Open  ]],
Cell[19319, 504, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

