(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24187,        572]
NotebookOptionsPosition[     21797,        495]
NotebookOutlinePosition[     23111,        532]
CellTagsIndexPosition[     23026,        527]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR FIELD PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"VectorFieldPlot" :> 
         Documentation`HelpLookup[
          "paclet:VectorFieldPlots/ref/VectorFieldPlot"], "ScaleFunction" :> 
         Documentation`HelpLookup[
          "paclet:VectorFieldPlots/ref/ScaleFunction"], "ScaleFactor" :> 
         Documentation`HelpLookup[
          "paclet:VectorFieldPlots/ref/ScaleFactor"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"VectorFieldPlot\"\>", 2->"\<\"ScaleFunction\"\>", 
      3->"\<\"ScaleFactor\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MaxArrowLength", "ObjectName",
 CellID->12113],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["MaxArrowLength"], "InlineFormula"],
     " \[LineSeparator]is an option for the vector field visualization \
functions that determines the longest vector to be ",
     "drawn",
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23301]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "No vectors longer than ",
 Cell[BoxData["MaxArrowLength"], "InlineFormula"],
 " are drawn. "
}], "Notes",
 CellID->1936007971],

Cell[TextData[{
 Cell[BoxData["MaxArrowLength"], "InlineFormula"],
 " is applied after ",
 Cell[BoxData[
  ButtonBox["ScaleFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorFieldPlots/ref/ScaleFunction"]], 
  "InlineFormula"],
 " and before ",
 Cell[BoxData[
  ButtonBox["ScaleFactor",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorFieldPlots/ref/ScaleFactor"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1961232900]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->310700190],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->97717606],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorFieldPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->627728891],

Cell["Omit all vectors whose magnitude is greater than one:", "ExampleText",
 CellID->1981049717],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorFieldPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"ScaleFactor", "\[Rule]", "None"}], ",", " ", 
   RowBox[{"MaxArrowLength", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1648785539],

Cell[BoxData[
 GraphicsBox[
  {Thickness[Small], Arrowheads[0.02], PointBox[{0., 0.}], 
   ArrowBox[{{0., 0.07142857142857142}, {0., 0.14285714285714285`}}], 
   ArrowBox[{{0., 0.14285714285714285`}, {0., 0.2857142857142857}}], 
   ArrowBox[{{0., 0.21428571428571427`}, {0., 0.42857142857142855`}}], 
   ArrowBox[{{0., 0.2857142857142857}, {0., 0.5714285714285714}}], 
   ArrowBox[{{0., 0.35714285714285715`}, {0., 0.7142857142857143}}], 
   ArrowBox[{{0., 0.42857142857142855`}, {0., 0.8571428571428571}}], 
   ArrowBox[{{0., 0.5}, {0., 1.}}], 
   ArrowBox[{{0., 0.5714285714285714}, {0., 1.1428571428571428`}}], 
   ArrowBox[{{0., 0.6428571428571429}, {0., 1.2857142857142858`}}], 
   ArrowBox[{{0., 0.7142857142857143}, {0., 1.4285714285714286`}}], 
   ArrowBox[{{0., 0.7857142857142857}, {0., 1.5714285714285714`}}], 
   ArrowBox[{{0., 0.8571428571428571}, {0., 1.7142857142857142`}}], 
   ArrowBox[{{0., 0.9285714285714286}, {0., 1.8571428571428572`}}], 
   ArrowBox[{{0., 1.}, {0., 2.}}], 
   ArrowBox[{{0.07142857142857142, 0.}, {0.14285714285714285`, 0.}}], 
   ArrowBox[{{0.07142857142857142, 0.07142857142857142}, {
    0.14285714285714285`, 0.14285714285714285`}}], 
   ArrowBox[{{0.07142857142857142, 0.14285714285714285`}, {
    0.14285714285714285`, 0.2857142857142857}}], 
   ArrowBox[{{0.07142857142857142, 0.21428571428571427`}, {
    0.14285714285714285`, 0.42857142857142855`}}], 
   ArrowBox[{{0.07142857142857142, 0.2857142857142857}, {0.14285714285714285`,
     0.5714285714285714}}], 
   ArrowBox[{{0.07142857142857142, 0.35714285714285715`}, {
    0.14285714285714285`, 0.7142857142857143}}], 
   ArrowBox[{{0.07142857142857142, 0.42857142857142855`}, {
    0.14285714285714285`, 0.8571428571428571}}], 
   ArrowBox[{{0.07142857142857142, 0.5}, {0.14285714285714285`, 1.}}], 
   ArrowBox[{{0.07142857142857142, 0.5714285714285714}, {0.14285714285714285`,
     1.1428571428571428`}}], 
   ArrowBox[{{0.07142857142857142, 0.6428571428571429}, {0.14285714285714285`,
     1.2857142857142858`}}], 
   ArrowBox[{{0.07142857142857142, 0.7142857142857143}, {0.14285714285714285`,
     1.4285714285714286`}}], 
   ArrowBox[{{0.07142857142857142, 0.7857142857142857}, {0.14285714285714285`,
     1.5714285714285714`}}], 
   ArrowBox[{{0.07142857142857142, 0.8571428571428571}, {0.14285714285714285`,
     1.7142857142857142`}}], 
   ArrowBox[{{0.07142857142857142, 0.9285714285714286}, {0.14285714285714285`,
     1.8571428571428572`}}], 
   ArrowBox[{{0.14285714285714285`, 0.}, {0.2857142857142857, 0.}}], 
   ArrowBox[{{0.14285714285714285`, 0.07142857142857142}, {0.2857142857142857,
     0.14285714285714285`}}], 
   ArrowBox[{{0.14285714285714285`, 0.14285714285714285`}, {
    0.2857142857142857, 0.2857142857142857}}], 
   ArrowBox[{{0.14285714285714285`, 0.21428571428571427`}, {
    0.2857142857142857, 0.42857142857142855`}}], 
   ArrowBox[{{0.14285714285714285`, 0.2857142857142857}, {0.2857142857142857, 
    0.5714285714285714}}], 
   ArrowBox[{{0.14285714285714285`, 0.35714285714285715`}, {
    0.2857142857142857, 0.7142857142857143}}], 
   ArrowBox[{{0.14285714285714285`, 0.42857142857142855`}, {
    0.2857142857142857, 0.8571428571428571}}], 
   ArrowBox[{{0.14285714285714285`, 0.5}, {0.2857142857142857, 1.}}], 
   ArrowBox[{{0.14285714285714285`, 0.5714285714285714}, {0.2857142857142857, 
    1.1428571428571428`}}], 
   ArrowBox[{{0.14285714285714285`, 0.6428571428571429}, {0.2857142857142857, 
    1.2857142857142858`}}], 
   ArrowBox[{{0.14285714285714285`, 0.7142857142857143}, {0.2857142857142857, 
    1.4285714285714286`}}], 
   ArrowBox[{{0.14285714285714285`, 0.7857142857142857}, {0.2857142857142857, 
    1.5714285714285714`}}], 
   ArrowBox[{{0.14285714285714285`, 0.8571428571428571}, {0.2857142857142857, 
    1.7142857142857142`}}], 
   ArrowBox[{{0.14285714285714285`, 0.9285714285714286}, {0.2857142857142857, 
    1.8571428571428572`}}], 
   ArrowBox[{{0.21428571428571427`, 0.}, {0.42857142857142855`, 0.}}], 
   ArrowBox[{{0.21428571428571427`, 0.07142857142857142}, {
    0.42857142857142855`, 0.14285714285714285`}}], 
   ArrowBox[{{0.21428571428571427`, 0.14285714285714285`}, {
    0.42857142857142855`, 0.2857142857142857}}], 
   ArrowBox[{{0.21428571428571427`, 0.21428571428571427`}, {
    0.42857142857142855`, 0.42857142857142855`}}], 
   ArrowBox[{{0.21428571428571427`, 0.2857142857142857}, {
    0.42857142857142855`, 0.5714285714285714}}], 
   ArrowBox[{{0.21428571428571427`, 0.35714285714285715`}, {
    0.42857142857142855`, 0.7142857142857143}}], 
   ArrowBox[{{0.21428571428571427`, 0.42857142857142855`}, {
    0.42857142857142855`, 0.8571428571428571}}], 
   ArrowBox[{{0.21428571428571427`, 0.5}, {0.42857142857142855`, 1.}}], 
   ArrowBox[{{0.21428571428571427`, 0.5714285714285714}, {
    0.42857142857142855`, 1.1428571428571428`}}], 
   ArrowBox[{{0.21428571428571427`, 0.6428571428571429}, {
    0.42857142857142855`, 1.2857142857142858`}}], 
   ArrowBox[{{0.21428571428571427`, 0.7142857142857143}, {
    0.42857142857142855`, 1.4285714285714286`}}], 
   ArrowBox[{{0.21428571428571427`, 0.7857142857142857}, {
    0.42857142857142855`, 1.5714285714285714`}}], 
   ArrowBox[{{0.21428571428571427`, 0.8571428571428571}, {
    0.42857142857142855`, 1.7142857142857142`}}], 
   ArrowBox[{{0.21428571428571427`, 0.9285714285714286}, {
    0.42857142857142855`, 1.8571428571428572`}}], 
   ArrowBox[{{0.2857142857142857, 0.}, {0.5714285714285714, 0.}}], 
   ArrowBox[{{0.2857142857142857, 0.07142857142857142}, {0.5714285714285714, 
    0.14285714285714285`}}], 
   ArrowBox[{{0.2857142857142857, 0.14285714285714285`}, {0.5714285714285714, 
    0.2857142857142857}}], 
   ArrowBox[{{0.2857142857142857, 0.21428571428571427`}, {0.5714285714285714, 
    0.42857142857142855`}}], 
   ArrowBox[{{0.2857142857142857, 0.2857142857142857}, {0.5714285714285714, 
    0.5714285714285714}}], 
   ArrowBox[{{0.2857142857142857, 0.35714285714285715`}, {0.5714285714285714, 
    0.7142857142857143}}], 
   ArrowBox[{{0.2857142857142857, 0.42857142857142855`}, {0.5714285714285714, 
    0.8571428571428571}}], 
   ArrowBox[{{0.2857142857142857, 0.5}, {0.5714285714285714, 1.}}], 
   ArrowBox[{{0.2857142857142857, 0.5714285714285714}, {0.5714285714285714, 
    1.1428571428571428`}}], 
   ArrowBox[{{0.2857142857142857, 0.6428571428571429}, {0.5714285714285714, 
    1.2857142857142858`}}], 
   ArrowBox[{{0.2857142857142857, 0.7142857142857143}, {0.5714285714285714, 
    1.4285714285714286`}}], 
   ArrowBox[{{0.2857142857142857, 0.7857142857142857}, {0.5714285714285714, 
    1.5714285714285714`}}], 
   ArrowBox[{{0.2857142857142857, 0.8571428571428571}, {0.5714285714285714, 
    1.7142857142857142`}}], 
   ArrowBox[{{0.2857142857142857, 0.9285714285714286}, {0.5714285714285714, 
    1.8571428571428572`}}], 
   ArrowBox[{{0.35714285714285715`, 0.}, {0.7142857142857143, 0.}}], 
   ArrowBox[{{0.35714285714285715`, 0.07142857142857142}, {0.7142857142857143,
     0.14285714285714285`}}], 
   ArrowBox[{{0.35714285714285715`, 0.14285714285714285`}, {
    0.7142857142857143, 0.2857142857142857}}], 
   ArrowBox[{{0.35714285714285715`, 0.21428571428571427`}, {
    0.7142857142857143, 0.42857142857142855`}}], 
   ArrowBox[{{0.35714285714285715`, 0.2857142857142857}, {0.7142857142857143, 
    0.5714285714285714}}], 
   ArrowBox[{{0.35714285714285715`, 0.35714285714285715`}, {
    0.7142857142857143, 0.7142857142857143}}], 
   ArrowBox[{{0.35714285714285715`, 0.42857142857142855`}, {
    0.7142857142857143, 0.8571428571428571}}], 
   ArrowBox[{{0.35714285714285715`, 0.5}, {0.7142857142857143, 1.}}], 
   ArrowBox[{{0.35714285714285715`, 0.5714285714285714}, {0.7142857142857143, 
    1.1428571428571428`}}], 
   ArrowBox[{{0.35714285714285715`, 0.6428571428571429}, {0.7142857142857143, 
    1.2857142857142858`}}], 
   ArrowBox[{{0.35714285714285715`, 0.7142857142857143}, {0.7142857142857143, 
    1.4285714285714286`}}], 
   ArrowBox[{{0.35714285714285715`, 0.7857142857142857}, {0.7142857142857143, 
    1.5714285714285714`}}], 
   ArrowBox[{{0.35714285714285715`, 0.8571428571428571}, {0.7142857142857143, 
    1.7142857142857142`}}], 
   ArrowBox[{{0.35714285714285715`, 0.9285714285714286}, {0.7142857142857143, 
    1.8571428571428572`}}], 
   ArrowBox[{{0.42857142857142855`, 0.}, {0.8571428571428571, 0.}}], 
   ArrowBox[{{0.42857142857142855`, 0.07142857142857142}, {0.8571428571428571,
     0.14285714285714285`}}], 
   ArrowBox[{{0.42857142857142855`, 0.14285714285714285`}, {
    0.8571428571428571, 0.2857142857142857}}], 
   ArrowBox[{{0.42857142857142855`, 0.21428571428571427`}, {
    0.8571428571428571, 0.42857142857142855`}}], 
   ArrowBox[{{0.42857142857142855`, 0.2857142857142857}, {0.8571428571428571, 
    0.5714285714285714}}], 
   ArrowBox[{{0.42857142857142855`, 0.35714285714285715`}, {
    0.8571428571428571, 0.7142857142857143}}], 
   ArrowBox[{{0.42857142857142855`, 0.42857142857142855`}, {
    0.8571428571428571, 0.8571428571428571}}], 
   ArrowBox[{{0.42857142857142855`, 0.5}, {0.8571428571428571, 1.}}], 
   ArrowBox[{{0.42857142857142855`, 0.5714285714285714}, {0.8571428571428571, 
    1.1428571428571428`}}], 
   ArrowBox[{{0.42857142857142855`, 0.6428571428571429}, {0.8571428571428571, 
    1.2857142857142858`}}], 
   ArrowBox[{{0.42857142857142855`, 0.7142857142857143}, {0.8571428571428571, 
    1.4285714285714286`}}], 
   ArrowBox[{{0.42857142857142855`, 0.7857142857142857}, {0.8571428571428571, 
    1.5714285714285714`}}], 
   ArrowBox[{{0.42857142857142855`, 0.8571428571428571}, {0.8571428571428571, 
    1.7142857142857142`}}], ArrowBox[{{0.5, 0.}, {1., 0.}}], 
   ArrowBox[{{0.5, 0.07142857142857142}, {1., 0.14285714285714285`}}], 
   ArrowBox[{{0.5, 0.14285714285714285`}, {1., 0.2857142857142857}}], 
   ArrowBox[{{0.5, 0.21428571428571427`}, {1., 0.42857142857142855`}}], 
   ArrowBox[{{0.5, 0.2857142857142857}, {1., 0.5714285714285714}}], 
   ArrowBox[{{0.5, 0.35714285714285715`}, {1., 0.7142857142857143}}], 
   ArrowBox[{{0.5, 0.42857142857142855`}, {1., 0.8571428571428571}}], 
   ArrowBox[{{0.5, 0.5}, {1., 1.}}], 
   ArrowBox[{{0.5, 0.5714285714285714}, {1., 1.1428571428571428`}}], 
   ArrowBox[{{0.5, 0.6428571428571429}, {1., 1.2857142857142858`}}], 
   ArrowBox[{{0.5, 0.7142857142857143}, {1., 1.4285714285714286`}}], 
   ArrowBox[{{0.5, 0.7857142857142857}, {1., 1.5714285714285714`}}], 
   ArrowBox[{{0.5, 0.8571428571428571}, {1., 1.7142857142857142`}}], 
   ArrowBox[{{0.5714285714285714, 0.}, {1.1428571428571428`, 0.}}], 
   ArrowBox[{{0.5714285714285714, 0.07142857142857142}, {1.1428571428571428`, 
    0.14285714285714285`}}], 
   ArrowBox[{{0.5714285714285714, 0.14285714285714285`}, {1.1428571428571428`,
     0.2857142857142857}}], 
   ArrowBox[{{0.5714285714285714, 0.21428571428571427`}, {1.1428571428571428`,
     0.42857142857142855`}}], 
   ArrowBox[{{0.5714285714285714, 0.2857142857142857}, {1.1428571428571428`, 
    0.5714285714285714}}], 
   ArrowBox[{{0.5714285714285714, 0.35714285714285715`}, {1.1428571428571428`,
     0.7142857142857143}}], 
   ArrowBox[{{0.5714285714285714, 0.42857142857142855`}, {1.1428571428571428`,
     0.8571428571428571}}], 
   ArrowBox[{{0.5714285714285714, 0.5}, {1.1428571428571428`, 1.}}], 
   ArrowBox[{{0.5714285714285714, 0.5714285714285714}, {1.1428571428571428`, 
    1.1428571428571428`}}], 
   ArrowBox[{{0.5714285714285714, 0.6428571428571429}, {1.1428571428571428`, 
    1.2857142857142858`}}], 
   ArrowBox[{{0.5714285714285714, 0.7142857142857143}, {1.1428571428571428`, 
    1.4285714285714286`}}], 
   ArrowBox[{{0.5714285714285714, 0.7857142857142857}, {1.1428571428571428`, 
    1.5714285714285714`}}], 
   ArrowBox[{{0.6428571428571429, 0.}, {1.2857142857142858`, 0.}}], 
   ArrowBox[{{0.6428571428571429, 0.07142857142857142}, {1.2857142857142858`, 
    0.14285714285714285`}}], 
   ArrowBox[{{0.6428571428571429, 0.14285714285714285`}, {1.2857142857142858`,
     0.2857142857142857}}], 
   ArrowBox[{{0.6428571428571429, 0.21428571428571427`}, {1.2857142857142858`,
     0.42857142857142855`}}], 
   ArrowBox[{{0.6428571428571429, 0.2857142857142857}, {1.2857142857142858`, 
    0.5714285714285714}}], 
   ArrowBox[{{0.6428571428571429, 0.35714285714285715`}, {1.2857142857142858`,
     0.7142857142857143}}], 
   ArrowBox[{{0.6428571428571429, 0.42857142857142855`}, {1.2857142857142858`,
     0.8571428571428571}}], 
   ArrowBox[{{0.6428571428571429, 0.5}, {1.2857142857142858`, 1.}}], 
   ArrowBox[{{0.6428571428571429, 0.5714285714285714}, {1.2857142857142858`, 
    1.1428571428571428`}}], 
   ArrowBox[{{0.6428571428571429, 0.6428571428571429}, {1.2857142857142858`, 
    1.2857142857142858`}}], 
   ArrowBox[{{0.6428571428571429, 0.7142857142857143}, {1.2857142857142858`, 
    1.4285714285714286`}}], 
   ArrowBox[{{0.7142857142857143, 0.}, {1.4285714285714286`, 0.}}], 
   ArrowBox[{{0.7142857142857143, 0.07142857142857142}, {1.4285714285714286`, 
    0.14285714285714285`}}], 
   ArrowBox[{{0.7142857142857143, 0.14285714285714285`}, {1.4285714285714286`,
     0.2857142857142857}}], 
   ArrowBox[{{0.7142857142857143, 0.21428571428571427`}, {1.4285714285714286`,
     0.42857142857142855`}}], 
   ArrowBox[{{0.7142857142857143, 0.2857142857142857}, {1.4285714285714286`, 
    0.5714285714285714}}], 
   ArrowBox[{{0.7142857142857143, 0.35714285714285715`}, {1.4285714285714286`,
     0.7142857142857143}}], 
   ArrowBox[{{0.7142857142857143, 0.42857142857142855`}, {1.4285714285714286`,
     0.8571428571428571}}], 
   ArrowBox[{{0.7142857142857143, 0.5}, {1.4285714285714286`, 1.}}], 
   ArrowBox[{{0.7142857142857143, 0.5714285714285714}, {1.4285714285714286`, 
    1.1428571428571428`}}], 
   ArrowBox[{{0.7142857142857143, 0.6428571428571429}, {1.4285714285714286`, 
    1.2857142857142858`}}], 
   ArrowBox[{{0.7857142857142857, 0.}, {1.5714285714285714`, 0.}}], 
   ArrowBox[{{0.7857142857142857, 0.07142857142857142}, {1.5714285714285714`, 
    0.14285714285714285`}}], 
   ArrowBox[{{0.7857142857142857, 0.14285714285714285`}, {1.5714285714285714`,
     0.2857142857142857}}], 
   ArrowBox[{{0.7857142857142857, 0.21428571428571427`}, {1.5714285714285714`,
     0.42857142857142855`}}], 
   ArrowBox[{{0.7857142857142857, 0.2857142857142857}, {1.5714285714285714`, 
    0.5714285714285714}}], 
   ArrowBox[{{0.7857142857142857, 0.35714285714285715`}, {1.5714285714285714`,
     0.7142857142857143}}], 
   ArrowBox[{{0.7857142857142857, 0.42857142857142855`}, {1.5714285714285714`,
     0.8571428571428571}}], 
   ArrowBox[{{0.7857142857142857, 0.5}, {1.5714285714285714`, 1.}}], 
   ArrowBox[{{0.7857142857142857, 0.5714285714285714}, {1.5714285714285714`, 
    1.1428571428571428`}}], 
   ArrowBox[{{0.8571428571428571, 0.}, {1.7142857142857142`, 0.}}], 
   ArrowBox[{{0.8571428571428571, 0.07142857142857142}, {1.7142857142857142`, 
    0.14285714285714285`}}], 
   ArrowBox[{{0.8571428571428571, 0.14285714285714285`}, {1.7142857142857142`,
     0.2857142857142857}}], 
   ArrowBox[{{0.8571428571428571, 0.21428571428571427`}, {1.7142857142857142`,
     0.42857142857142855`}}], 
   ArrowBox[{{0.8571428571428571, 0.2857142857142857}, {1.7142857142857142`, 
    0.5714285714285714}}], 
   ArrowBox[{{0.8571428571428571, 0.35714285714285715`}, {1.7142857142857142`,
     0.7142857142857143}}], 
   ArrowBox[{{0.8571428571428571, 0.42857142857142855`}, {1.7142857142857142`,
     0.8571428571428571}}], 
   ArrowBox[{{0.8571428571428571, 0.5}, {1.7142857142857142`, 1.}}], 
   ArrowBox[{{0.9285714285714286, 0.}, {1.8571428571428572`, 0.}}], 
   ArrowBox[{{0.9285714285714286, 0.07142857142857142}, {1.8571428571428572`, 
    0.14285714285714285`}}], 
   ArrowBox[{{0.9285714285714286, 0.14285714285714285`}, {1.8571428571428572`,
     0.2857142857142857}}], 
   ArrowBox[{{0.9285714285714286, 0.21428571428571427`}, {1.8571428571428572`,
     0.42857142857142855`}}], 
   ArrowBox[{{0.9285714285714286, 0.2857142857142857}, {1.8571428571428572`, 
    0.5714285714285714}}], 
   ArrowBox[{{0.9285714285714286, 0.35714285714285715`}, {1.8571428571428572`,
     0.7142857142857143}}], ArrowBox[{{1., 0.}, {2., 0.}}]}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9573085]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23668],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["VectorFieldPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/VectorFieldPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScaleFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/ScaleFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScaleFactor",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/ScaleFactor"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20536]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MaxArrowLength - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 47.1860126}", "context" -> 
    "VectorFieldPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Field Plots Package Symbol", "language" -> "en", "paclet" -> 
    "VectorFieldPlots Package", "status" -> "None", "summary" -> 
    "MaxArrowLength is an option for the vector field visualization functions \
that determines the longest vector to be drawn.", "synonyms" -> {}, "title" -> 
    "MaxArrowLength", "type" -> "Symbol", "uri" -> 
    "VectorFieldPlots/ref/MaxArrowLength"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3134, 112, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->310700190]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22883, 520}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 892, 20, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1515, 47, 52, 1, 70, "ObjectName",
 CellID->12113],
Cell[1570, 50, 429, 13, 70, "Usage",
 CellID->23301]
}, Open  ]],
Cell[CellGroupData[{
Cell[2036, 68, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2514, 85, 144, 5, 70, "Notes",
 CellID->1936007971],
Cell[2661, 92, 436, 15, 70, "Notes",
 CellID->1961232900]
}, Closed]],
Cell[CellGroupData[{
Cell[3134, 112, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->310700190],
Cell[CellGroupData[{
Cell[3519, 126, 147, 5, 70, "ExampleSection",
 CellID->97717606],
Cell[3669, 133, 141, 4, 70, "Input",
 CellID->627728891],
Cell[3813, 139, 97, 1, 70, "ExampleText",
 CellID->1981049717],
Cell[CellGroupData[{
Cell[3935, 144, 458, 12, 47, "Input",
 CellID->1648785539],
Cell[4396, 158, 16207, 288, 201, "Output",
 CellID->9573085]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20664, 453, 311, 9, 70, "SeeAlsoSection",
 CellID->23668],
Cell[20978, 464, 777, 26, 70, "SeeAlso",
 CellID->20536]
}, Open  ]],
Cell[21770, 493, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

