(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39474,        869]
NotebookOptionsPosition[     36699,        779]
NotebookOutlinePosition[     38039,        816]
CellTagsIndexPosition[     37954,        811]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR FIELD PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"VectorFieldPlot" :> 
         Documentation`HelpLookup[
          "paclet:VectorFieldPlots/ref/VectorFieldPlot"], "ScaleFunction" :> 
         Documentation`HelpLookup[
          "paclet:VectorFieldPlots/ref/ScaleFunction"], "MaxArrowLength" :> 
         Documentation`HelpLookup[
          "paclet:VectorFieldPlots/ref/MaxArrowLength"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"VectorFieldPlot\"\>", 2->"\<\"ScaleFunction\"\>", 
      3->"\<\"MaxArrowLength\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ScaleFactor", "ObjectName",
 CellID->1984],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["ScaleFactor"], "InlineFormula"],
     " \[LineSeparator]",
     "is an option for the vector field visualization functions that scales \
the vectors so that the longest vector displayed is of the length specified."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23286]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "In function-based visualization functions, ",
 Cell[BoxData[
  RowBox[{"ScaleFactor", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " scales the vectors so that each vector fits within the grid without \
overlapping the base of another vector."
}], "Notes",
 CellID->1502395761],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ScaleFactor", "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 " does not rescale the vectors."
}], "Notes",
 CellID->652833701],

Cell[TextData[{
 "In list-based visualization functions, ",
 Cell[BoxData[
  RowBox[{"ScaleFactor", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " is the same as ",
 Cell[BoxData[
  RowBox[{"ScaleFunction", "->", 
   RowBox[{
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], ".", " "}]}]], "InlineFormula"]
}], "Notes",
 CellID->682060184],

Cell[TextData[{
 Cell[BoxData["ScaleFactor"], "InlineFormula"],
 " is applied after ",
 Cell[BoxData[
  ButtonBox["ScaleFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorFieldPlots/ref/ScaleFunction"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MaxArrowLength",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorFieldPlots/ref/MaxArrowLength"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->117804802]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->130660375],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->301109681],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorFieldPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->161461216],

Cell["Scale vectors so they do not overlap:", "ExampleText",
 CellID->2046368990],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorFieldPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"ScaleFactor", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1373008225],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->90509287]
}, Open  ]],

Cell["Unscaled vectors:", "ExampleText",
 CellID->1437450560],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorFieldPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"ScaleFactor", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->40533170],

Cell[BoxData[
 GraphicsBox[
  {Thickness[Small], Arrowheads[0.02], PointBox[{0., 0.}], 
   ArrowBox[{{0., 0.07142857142857142}, {0., 0.14285714285714285`}}], 
   ArrowBox[{{0., 0.14285714285714285`}, {0., 0.2857142857142857}}], 
   ArrowBox[{{0., 0.21428571428571427`}, {0., 0.42857142857142855`}}], 
   ArrowBox[{{0., 0.2857142857142857}, {0., 0.5714285714285714}}], 
   ArrowBox[{{0., 0.35714285714285715`}, {0., 0.7142857142857143}}], 
   ArrowBox[{{0., 0.42857142857142855`}, {0., 0.8571428571428571}}], 
   ArrowBox[{{0., 0.5}, {0., 1.}}], 
   ArrowBox[{{0., 0.5714285714285714}, {0., 1.1428571428571428`}}], 
   ArrowBox[{{0., 0.6428571428571429}, {0., 1.2857142857142858`}}], 
   ArrowBox[{{0., 0.7142857142857143}, {0., 1.4285714285714286`}}], 
   ArrowBox[{{0., 0.7857142857142857}, {0., 1.5714285714285714`}}], 
   ArrowBox[{{0., 0.8571428571428571}, {0., 1.7142857142857142`}}], 
   ArrowBox[{{0., 0.9285714285714286}, {0., 1.8571428571428572`}}], 
   ArrowBox[{{0., 1.}, {0., 2.}}], 
   ArrowBox[{{0.07142857142857142, 0.}, {0.14285714285714285`, 0.}}], 
   ArrowBox[{{0.07142857142857142, 0.07142857142857142}, {
    0.14285714285714285`, 0.14285714285714285`}}], 
   ArrowBox[{{0.07142857142857142, 0.14285714285714285`}, {
    0.14285714285714285`, 0.2857142857142857}}], 
   ArrowBox[{{0.07142857142857142, 0.21428571428571427`}, {
    0.14285714285714285`, 0.42857142857142855`}}], 
   ArrowBox[{{0.07142857142857142, 0.2857142857142857}, {0.14285714285714285`,
     0.5714285714285714}}], 
   ArrowBox[{{0.07142857142857142, 0.35714285714285715`}, {
    0.14285714285714285`, 0.7142857142857143}}], 
   ArrowBox[{{0.07142857142857142, 0.42857142857142855`}, {
    0.14285714285714285`, 0.8571428571428571}}], 
   ArrowBox[{{0.07142857142857142, 0.5}, {0.14285714285714285`, 1.}}], 
   ArrowBox[{{0.07142857142857142, 0.5714285714285714}, {0.14285714285714285`,
     1.1428571428571428`}}], 
   ArrowBox[{{0.07142857142857142, 0.6428571428571429}, {0.14285714285714285`,
     1.2857142857142858`}}], 
   ArrowBox[{{0.07142857142857142, 0.7142857142857143}, {0.14285714285714285`,
     1.4285714285714286`}}], 
   ArrowBox[{{0.07142857142857142, 0.7857142857142857}, {0.14285714285714285`,
     1.5714285714285714`}}], 
   ArrowBox[{{0.07142857142857142, 0.8571428571428571}, {0.14285714285714285`,
     1.7142857142857142`}}], 
   ArrowBox[{{0.07142857142857142, 0.9285714285714286}, {0.14285714285714285`,
     1.8571428571428572`}}], 
   ArrowBox[{{0.07142857142857142, 1.}, {0.14285714285714285`, 2.}}], 
   ArrowBox[{{0.14285714285714285`, 0.}, {0.2857142857142857, 0.}}], 
   ArrowBox[{{0.14285714285714285`, 0.07142857142857142}, {0.2857142857142857,
     0.14285714285714285`}}], 
   ArrowBox[{{0.14285714285714285`, 0.14285714285714285`}, {
    0.2857142857142857, 0.2857142857142857}}], 
   ArrowBox[{{0.14285714285714285`, 0.21428571428571427`}, {
    0.2857142857142857, 0.42857142857142855`}}], 
   ArrowBox[{{0.14285714285714285`, 0.2857142857142857}, {0.2857142857142857, 
    0.5714285714285714}}], 
   ArrowBox[{{0.14285714285714285`, 0.35714285714285715`}, {
    0.2857142857142857, 0.7142857142857143}}], 
   ArrowBox[{{0.14285714285714285`, 0.42857142857142855`}, {
    0.2857142857142857, 0.8571428571428571}}], 
   ArrowBox[{{0.14285714285714285`, 0.5}, {0.2857142857142857, 1.}}], 
   ArrowBox[{{0.14285714285714285`, 0.5714285714285714}, {0.2857142857142857, 
    1.1428571428571428`}}], 
   ArrowBox[{{0.14285714285714285`, 0.6428571428571429}, {0.2857142857142857, 
    1.2857142857142858`}}], 
   ArrowBox[{{0.14285714285714285`, 0.7142857142857143}, {0.2857142857142857, 
    1.4285714285714286`}}], 
   ArrowBox[{{0.14285714285714285`, 0.7857142857142857}, {0.2857142857142857, 
    1.5714285714285714`}}], 
   ArrowBox[{{0.14285714285714285`, 0.8571428571428571}, {0.2857142857142857, 
    1.7142857142857142`}}], 
   ArrowBox[{{0.14285714285714285`, 0.9285714285714286}, {0.2857142857142857, 
    1.8571428571428572`}}], 
   ArrowBox[{{0.14285714285714285`, 1.}, {0.2857142857142857, 2.}}], 
   ArrowBox[{{0.21428571428571427`, 0.}, {0.42857142857142855`, 0.}}], 
   ArrowBox[{{0.21428571428571427`, 0.07142857142857142}, {
    0.42857142857142855`, 0.14285714285714285`}}], 
   ArrowBox[{{0.21428571428571427`, 0.14285714285714285`}, {
    0.42857142857142855`, 0.2857142857142857}}], 
   ArrowBox[{{0.21428571428571427`, 0.21428571428571427`}, {
    0.42857142857142855`, 0.42857142857142855`}}], 
   ArrowBox[{{0.21428571428571427`, 0.2857142857142857}, {
    0.42857142857142855`, 0.5714285714285714}}], 
   ArrowBox[{{0.21428571428571427`, 0.35714285714285715`}, {
    0.42857142857142855`, 0.7142857142857143}}], 
   ArrowBox[{{0.21428571428571427`, 0.42857142857142855`}, {
    0.42857142857142855`, 0.8571428571428571}}], 
   ArrowBox[{{0.21428571428571427`, 0.5}, {0.42857142857142855`, 1.}}], 
   ArrowBox[{{0.21428571428571427`, 0.5714285714285714}, {
    0.42857142857142855`, 1.1428571428571428`}}], 
   ArrowBox[{{0.21428571428571427`, 0.6428571428571429}, {
    0.42857142857142855`, 1.2857142857142858`}}], 
   ArrowBox[{{0.21428571428571427`, 0.7142857142857143}, {
    0.42857142857142855`, 1.4285714285714286`}}], 
   ArrowBox[{{0.21428571428571427`, 0.7857142857142857}, {
    0.42857142857142855`, 1.5714285714285714`}}], 
   ArrowBox[{{0.21428571428571427`, 0.8571428571428571}, {
    0.42857142857142855`, 1.7142857142857142`}}], 
   ArrowBox[{{0.21428571428571427`, 0.9285714285714286}, {
    0.42857142857142855`, 1.8571428571428572`}}], 
   ArrowBox[{{0.21428571428571427`, 1.}, {0.42857142857142855`, 2.}}], 
   ArrowBox[{{0.2857142857142857, 0.}, {0.5714285714285714, 0.}}], 
   ArrowBox[{{0.2857142857142857, 0.07142857142857142}, {0.5714285714285714, 
    0.14285714285714285`}}], 
   ArrowBox[{{0.2857142857142857, 0.14285714285714285`}, {0.5714285714285714, 
    0.2857142857142857}}], 
   ArrowBox[{{0.2857142857142857, 0.21428571428571427`}, {0.5714285714285714, 
    0.42857142857142855`}}], 
   ArrowBox[{{0.2857142857142857, 0.2857142857142857}, {0.5714285714285714, 
    0.5714285714285714}}], 
   ArrowBox[{{0.2857142857142857, 0.35714285714285715`}, {0.5714285714285714, 
    0.7142857142857143}}], 
   ArrowBox[{{0.2857142857142857, 0.42857142857142855`}, {0.5714285714285714, 
    0.8571428571428571}}], 
   ArrowBox[{{0.2857142857142857, 0.5}, {0.5714285714285714, 1.}}], 
   ArrowBox[{{0.2857142857142857, 0.5714285714285714}, {0.5714285714285714, 
    1.1428571428571428`}}], 
   ArrowBox[{{0.2857142857142857, 0.6428571428571429}, {0.5714285714285714, 
    1.2857142857142858`}}], 
   ArrowBox[{{0.2857142857142857, 0.7142857142857143}, {0.5714285714285714, 
    1.4285714285714286`}}], 
   ArrowBox[{{0.2857142857142857, 0.7857142857142857}, {0.5714285714285714, 
    1.5714285714285714`}}], 
   ArrowBox[{{0.2857142857142857, 0.8571428571428571}, {0.5714285714285714, 
    1.7142857142857142`}}], 
   ArrowBox[{{0.2857142857142857, 0.9285714285714286}, {0.5714285714285714, 
    1.8571428571428572`}}], 
   ArrowBox[{{0.2857142857142857, 1.}, {0.5714285714285714, 2.}}], 
   ArrowBox[{{0.35714285714285715`, 0.}, {0.7142857142857143, 0.}}], 
   ArrowBox[{{0.35714285714285715`, 0.07142857142857142}, {0.7142857142857143,
     0.14285714285714285`}}], 
   ArrowBox[{{0.35714285714285715`, 0.14285714285714285`}, {
    0.7142857142857143, 0.2857142857142857}}], 
   ArrowBox[{{0.35714285714285715`, 0.21428571428571427`}, {
    0.7142857142857143, 0.42857142857142855`}}], 
   ArrowBox[{{0.35714285714285715`, 0.2857142857142857}, {0.7142857142857143, 
    0.5714285714285714}}], 
   ArrowBox[{{0.35714285714285715`, 0.35714285714285715`}, {
    0.7142857142857143, 0.7142857142857143}}], 
   ArrowBox[{{0.35714285714285715`, 0.42857142857142855`}, {
    0.7142857142857143, 0.8571428571428571}}], 
   ArrowBox[{{0.35714285714285715`, 0.5}, {0.7142857142857143, 1.}}], 
   ArrowBox[{{0.35714285714285715`, 0.5714285714285714}, {0.7142857142857143, 
    1.1428571428571428`}}], 
   ArrowBox[{{0.35714285714285715`, 0.6428571428571429}, {0.7142857142857143, 
    1.2857142857142858`}}], 
   ArrowBox[{{0.35714285714285715`, 0.7142857142857143}, {0.7142857142857143, 
    1.4285714285714286`}}], 
   ArrowBox[{{0.35714285714285715`, 0.7857142857142857}, {0.7142857142857143, 
    1.5714285714285714`}}], 
   ArrowBox[{{0.35714285714285715`, 0.8571428571428571}, {0.7142857142857143, 
    1.7142857142857142`}}], 
   ArrowBox[{{0.35714285714285715`, 0.9285714285714286}, {0.7142857142857143, 
    1.8571428571428572`}}], 
   ArrowBox[{{0.35714285714285715`, 1.}, {0.7142857142857143, 2.}}], 
   ArrowBox[{{0.42857142857142855`, 0.}, {0.8571428571428571, 0.}}], 
   ArrowBox[{{0.42857142857142855`, 0.07142857142857142}, {0.8571428571428571,
     0.14285714285714285`}}], 
   ArrowBox[{{0.42857142857142855`, 0.14285714285714285`}, {
    0.8571428571428571, 0.2857142857142857}}], 
   ArrowBox[{{0.42857142857142855`, 0.21428571428571427`}, {
    0.8571428571428571, 0.42857142857142855`}}], 
   ArrowBox[{{0.42857142857142855`, 0.2857142857142857}, {0.8571428571428571, 
    0.5714285714285714}}], 
   ArrowBox[{{0.42857142857142855`, 0.35714285714285715`}, {
    0.8571428571428571, 0.7142857142857143}}], 
   ArrowBox[{{0.42857142857142855`, 0.42857142857142855`}, {
    0.8571428571428571, 0.8571428571428571}}], 
   ArrowBox[{{0.42857142857142855`, 0.5}, {0.8571428571428571, 1.}}], 
   ArrowBox[{{0.42857142857142855`, 0.5714285714285714}, {0.8571428571428571, 
    1.1428571428571428`}}], 
   ArrowBox[{{0.42857142857142855`, 0.6428571428571429}, {0.8571428571428571, 
    1.2857142857142858`}}], 
   ArrowBox[{{0.42857142857142855`, 0.7142857142857143}, {0.8571428571428571, 
    1.4285714285714286`}}], 
   ArrowBox[{{0.42857142857142855`, 0.7857142857142857}, {0.8571428571428571, 
    1.5714285714285714`}}], 
   ArrowBox[{{0.42857142857142855`, 0.8571428571428571}, {0.8571428571428571, 
    1.7142857142857142`}}], 
   ArrowBox[{{0.42857142857142855`, 0.9285714285714286}, {0.8571428571428571, 
    1.8571428571428572`}}], 
   ArrowBox[{{0.42857142857142855`, 1.}, {0.8571428571428571, 2.}}], 
   ArrowBox[{{0.5, 0.}, {1., 0.}}], 
   ArrowBox[{{0.5, 0.07142857142857142}, {1., 0.14285714285714285`}}], 
   ArrowBox[{{0.5, 0.14285714285714285`}, {1., 0.2857142857142857}}], 
   ArrowBox[{{0.5, 0.21428571428571427`}, {1., 0.42857142857142855`}}], 
   ArrowBox[{{0.5, 0.2857142857142857}, {1., 0.5714285714285714}}], 
   ArrowBox[{{0.5, 0.35714285714285715`}, {1., 0.7142857142857143}}], 
   ArrowBox[{{0.5, 0.42857142857142855`}, {1., 0.8571428571428571}}], 
   ArrowBox[{{0.5, 0.5}, {1., 1.}}], 
   ArrowBox[{{0.5, 0.5714285714285714}, {1., 1.1428571428571428`}}], 
   ArrowBox[{{0.5, 0.6428571428571429}, {1., 1.2857142857142858`}}], 
   ArrowBox[{{0.5, 0.7142857142857143}, {1., 1.4285714285714286`}}], 
   ArrowBox[{{0.5, 0.7857142857142857}, {1., 1.5714285714285714`}}], 
   ArrowBox[{{0.5, 0.8571428571428571}, {1., 1.7142857142857142`}}], 
   ArrowBox[{{0.5, 0.9285714285714286}, {1., 1.8571428571428572`}}], 
   ArrowBox[{{0.5, 1.}, {1., 2.}}], 
   ArrowBox[{{0.5714285714285714, 0.}, {1.1428571428571428`, 0.}}], 
   ArrowBox[{{0.5714285714285714, 0.07142857142857142}, {1.1428571428571428`, 
    0.14285714285714285`}}], 
   ArrowBox[{{0.5714285714285714, 0.14285714285714285`}, {1.1428571428571428`,
     0.2857142857142857}}], 
   ArrowBox[{{0.5714285714285714, 0.21428571428571427`}, {1.1428571428571428`,
     0.42857142857142855`}}], 
   ArrowBox[{{0.5714285714285714, 0.2857142857142857}, {1.1428571428571428`, 
    0.5714285714285714}}], 
   ArrowBox[{{0.5714285714285714, 0.35714285714285715`}, {1.1428571428571428`,
     0.7142857142857143}}], 
   ArrowBox[{{0.5714285714285714, 0.42857142857142855`}, {1.1428571428571428`,
     0.8571428571428571}}], 
   ArrowBox[{{0.5714285714285714, 0.5}, {1.1428571428571428`, 1.}}], 
   ArrowBox[{{0.5714285714285714, 0.5714285714285714}, {1.1428571428571428`, 
    1.1428571428571428`}}], 
   ArrowBox[{{0.5714285714285714, 0.6428571428571429}, {1.1428571428571428`, 
    1.2857142857142858`}}], 
   ArrowBox[{{0.5714285714285714, 0.7142857142857143}, {1.1428571428571428`, 
    1.4285714285714286`}}], 
   ArrowBox[{{0.5714285714285714, 0.7857142857142857}, {1.1428571428571428`, 
    1.5714285714285714`}}], 
   ArrowBox[{{0.5714285714285714, 0.8571428571428571}, {1.1428571428571428`, 
    1.7142857142857142`}}], 
   ArrowBox[{{0.5714285714285714, 0.9285714285714286}, {1.1428571428571428`, 
    1.8571428571428572`}}], 
   ArrowBox[{{0.5714285714285714, 1.}, {1.1428571428571428`, 2.}}], 
   ArrowBox[{{0.6428571428571429, 0.}, {1.2857142857142858`, 0.}}], 
   ArrowBox[{{0.6428571428571429, 0.07142857142857142}, {1.2857142857142858`, 
    0.14285714285714285`}}], 
   ArrowBox[{{0.6428571428571429, 0.14285714285714285`}, {1.2857142857142858`,
     0.2857142857142857}}], 
   ArrowBox[{{0.6428571428571429, 0.21428571428571427`}, {1.2857142857142858`,
     0.42857142857142855`}}], 
   ArrowBox[{{0.6428571428571429, 0.2857142857142857}, {1.2857142857142858`, 
    0.5714285714285714}}], 
   ArrowBox[{{0.6428571428571429, 0.35714285714285715`}, {1.2857142857142858`,
     0.7142857142857143}}], 
   ArrowBox[{{0.6428571428571429, 0.42857142857142855`}, {1.2857142857142858`,
     0.8571428571428571}}], 
   ArrowBox[{{0.6428571428571429, 0.5}, {1.2857142857142858`, 1.}}], 
   ArrowBox[{{0.6428571428571429, 0.5714285714285714}, {1.2857142857142858`, 
    1.1428571428571428`}}], 
   ArrowBox[{{0.6428571428571429, 0.6428571428571429}, {1.2857142857142858`, 
    1.2857142857142858`}}], 
   ArrowBox[{{0.6428571428571429, 0.7142857142857143}, {1.2857142857142858`, 
    1.4285714285714286`}}], 
   ArrowBox[{{0.6428571428571429, 0.7857142857142857}, {1.2857142857142858`, 
    1.5714285714285714`}}], 
   ArrowBox[{{0.6428571428571429, 0.8571428571428571}, {1.2857142857142858`, 
    1.7142857142857142`}}], 
   ArrowBox[{{0.6428571428571429, 0.9285714285714286}, {1.2857142857142858`, 
    1.8571428571428572`}}], 
   ArrowBox[{{0.6428571428571429, 1.}, {1.2857142857142858`, 2.}}], 
   ArrowBox[{{0.7142857142857143, 0.}, {1.4285714285714286`, 0.}}], 
   ArrowBox[{{0.7142857142857143, 0.07142857142857142}, {1.4285714285714286`, 
    0.14285714285714285`}}], 
   ArrowBox[{{0.7142857142857143, 0.14285714285714285`}, {1.4285714285714286`,
     0.2857142857142857}}], 
   ArrowBox[{{0.7142857142857143, 0.21428571428571427`}, {1.4285714285714286`,
     0.42857142857142855`}}], 
   ArrowBox[{{0.7142857142857143, 0.2857142857142857}, {1.4285714285714286`, 
    0.5714285714285714}}], 
   ArrowBox[{{0.7142857142857143, 0.35714285714285715`}, {1.4285714285714286`,
     0.7142857142857143}}], 
   ArrowBox[{{0.7142857142857143, 0.42857142857142855`}, {1.4285714285714286`,
     0.8571428571428571}}], 
   ArrowBox[{{0.7142857142857143, 0.5}, {1.4285714285714286`, 1.}}], 
   ArrowBox[{{0.7142857142857143, 0.5714285714285714}, {1.4285714285714286`, 
    1.1428571428571428`}}], 
   ArrowBox[{{0.7142857142857143, 0.6428571428571429}, {1.4285714285714286`, 
    1.2857142857142858`}}], 
   ArrowBox[{{0.7142857142857143, 0.7142857142857143}, {1.4285714285714286`, 
    1.4285714285714286`}}], 
   ArrowBox[{{0.7142857142857143, 0.7857142857142857}, {1.4285714285714286`, 
    1.5714285714285714`}}], 
   ArrowBox[{{0.7142857142857143, 0.8571428571428571}, {1.4285714285714286`, 
    1.7142857142857142`}}], 
   ArrowBox[{{0.7142857142857143, 0.9285714285714286}, {1.4285714285714286`, 
    1.8571428571428572`}}], 
   ArrowBox[{{0.7142857142857143, 1.}, {1.4285714285714286`, 2.}}], 
   ArrowBox[{{0.7857142857142857, 0.}, {1.5714285714285714`, 0.}}], 
   ArrowBox[{{0.7857142857142857, 0.07142857142857142}, {1.5714285714285714`, 
    0.14285714285714285`}}], 
   ArrowBox[{{0.7857142857142857, 0.14285714285714285`}, {1.5714285714285714`,
     0.2857142857142857}}], 
   ArrowBox[{{0.7857142857142857, 0.21428571428571427`}, {1.5714285714285714`,
     0.42857142857142855`}}], 
   ArrowBox[{{0.7857142857142857, 0.2857142857142857}, {1.5714285714285714`, 
    0.5714285714285714}}], 
   ArrowBox[{{0.7857142857142857, 0.35714285714285715`}, {1.5714285714285714`,
     0.7142857142857143}}], 
   ArrowBox[{{0.7857142857142857, 0.42857142857142855`}, {1.5714285714285714`,
     0.8571428571428571}}], 
   ArrowBox[{{0.7857142857142857, 0.5}, {1.5714285714285714`, 1.}}], 
   ArrowBox[{{0.7857142857142857, 0.5714285714285714}, {1.5714285714285714`, 
    1.1428571428571428`}}], 
   ArrowBox[{{0.7857142857142857, 0.6428571428571429}, {1.5714285714285714`, 
    1.2857142857142858`}}], 
   ArrowBox[{{0.7857142857142857, 0.7142857142857143}, {1.5714285714285714`, 
    1.4285714285714286`}}], 
   ArrowBox[{{0.7857142857142857, 0.7857142857142857}, {1.5714285714285714`, 
    1.5714285714285714`}}], 
   ArrowBox[{{0.7857142857142857, 0.8571428571428571}, {1.5714285714285714`, 
    1.7142857142857142`}}], 
   ArrowBox[{{0.7857142857142857, 0.9285714285714286}, {1.5714285714285714`, 
    1.8571428571428572`}}], 
   ArrowBox[{{0.7857142857142857, 1.}, {1.5714285714285714`, 2.}}], 
   ArrowBox[{{0.8571428571428571, 0.}, {1.7142857142857142`, 0.}}], 
   ArrowBox[{{0.8571428571428571, 0.07142857142857142}, {1.7142857142857142`, 
    0.14285714285714285`}}], 
   ArrowBox[{{0.8571428571428571, 0.14285714285714285`}, {1.7142857142857142`,
     0.2857142857142857}}], 
   ArrowBox[{{0.8571428571428571, 0.21428571428571427`}, {1.7142857142857142`,
     0.42857142857142855`}}], 
   ArrowBox[{{0.8571428571428571, 0.2857142857142857}, {1.7142857142857142`, 
    0.5714285714285714}}], 
   ArrowBox[{{0.8571428571428571, 0.35714285714285715`}, {1.7142857142857142`,
     0.7142857142857143}}], 
   ArrowBox[{{0.8571428571428571, 0.42857142857142855`}, {1.7142857142857142`,
     0.8571428571428571}}], 
   ArrowBox[{{0.8571428571428571, 0.5}, {1.7142857142857142`, 1.}}], 
   ArrowBox[{{0.8571428571428571, 0.5714285714285714}, {1.7142857142857142`, 
    1.1428571428571428`}}], 
   ArrowBox[{{0.8571428571428571, 0.6428571428571429}, {1.7142857142857142`, 
    1.2857142857142858`}}], 
   ArrowBox[{{0.8571428571428571, 0.7142857142857143}, {1.7142857142857142`, 
    1.4285714285714286`}}], 
   ArrowBox[{{0.8571428571428571, 0.7857142857142857}, {1.7142857142857142`, 
    1.5714285714285714`}}], 
   ArrowBox[{{0.8571428571428571, 0.8571428571428571}, {1.7142857142857142`, 
    1.7142857142857142`}}], 
   ArrowBox[{{0.8571428571428571, 0.9285714285714286}, {1.7142857142857142`, 
    1.8571428571428572`}}], 
   ArrowBox[{{0.8571428571428571, 1.}, {1.7142857142857142`, 2.}}], 
   ArrowBox[{{0.9285714285714286, 0.}, {1.8571428571428572`, 0.}}], 
   ArrowBox[{{0.9285714285714286, 0.07142857142857142}, {1.8571428571428572`, 
    0.14285714285714285`}}], 
   ArrowBox[{{0.9285714285714286, 0.14285714285714285`}, {1.8571428571428572`,
     0.2857142857142857}}], 
   ArrowBox[{{0.9285714285714286, 0.21428571428571427`}, {1.8571428571428572`,
     0.42857142857142855`}}], 
   ArrowBox[{{0.9285714285714286, 0.2857142857142857}, {1.8571428571428572`, 
    0.5714285714285714}}], 
   ArrowBox[{{0.9285714285714286, 0.35714285714285715`}, {1.8571428571428572`,
     0.7142857142857143}}], 
   ArrowBox[{{0.9285714285714286, 0.42857142857142855`}, {1.8571428571428572`,
     0.8571428571428571}}], 
   ArrowBox[{{0.9285714285714286, 0.5}, {1.8571428571428572`, 1.}}], 
   ArrowBox[{{0.9285714285714286, 0.5714285714285714}, {1.8571428571428572`, 
    1.1428571428571428`}}], 
   ArrowBox[{{0.9285714285714286, 0.6428571428571429}, {1.8571428571428572`, 
    1.2857142857142858`}}], 
   ArrowBox[{{0.9285714285714286, 0.7142857142857143}, {1.8571428571428572`, 
    1.4285714285714286`}}], 
   ArrowBox[{{0.9285714285714286, 0.7857142857142857}, {1.8571428571428572`, 
    1.5714285714285714`}}], 
   ArrowBox[{{0.9285714285714286, 0.8571428571428571}, {1.8571428571428572`, 
    1.7142857142857142`}}], 
   ArrowBox[{{0.9285714285714286, 0.9285714285714286}, {1.8571428571428572`, 
    1.8571428571428572`}}], 
   ArrowBox[{{0.9285714285714286, 1.}, {1.8571428571428572`, 2.}}], 
   ArrowBox[{{1., 0.}, {2., 0.}}], 
   ArrowBox[{{1., 0.07142857142857142}, {2., 0.14285714285714285`}}], 
   ArrowBox[{{1., 0.14285714285714285`}, {2., 0.2857142857142857}}], 
   ArrowBox[{{1., 0.21428571428571427`}, {2., 0.42857142857142855`}}], 
   ArrowBox[{{1., 0.2857142857142857}, {2., 0.5714285714285714}}], 
   ArrowBox[{{1., 0.35714285714285715`}, {2., 0.7142857142857143}}], 
   ArrowBox[{{1., 0.42857142857142855`}, {2., 0.8571428571428571}}], 
   ArrowBox[{{1., 0.5}, {2., 1.}}], 
   ArrowBox[{{1., 0.5714285714285714}, {2., 1.1428571428571428`}}], 
   ArrowBox[{{1., 0.6428571428571429}, {2., 1.2857142857142858`}}], 
   ArrowBox[{{1., 0.7142857142857143}, {2., 1.4285714285714286`}}], 
   ArrowBox[{{1., 0.7857142857142857}, {2., 1.5714285714285714`}}], 
   ArrowBox[{{1., 0.8571428571428571}, {2., 1.7142857142857142`}}], 
   ArrowBox[{{1., 0.9285714285714286}, {2., 1.8571428571428572`}}], 
   ArrowBox[{{1., 1.}, {2., 2.}}]}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2095569174]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8667],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["VectorFieldPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/VectorFieldPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScaleFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/ScaleFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MaxArrowLength",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/MaxArrowLength"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1437]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ScaleFactor - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 47.8735302}", "context" -> 
    "VectorFieldPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Field Plots Package Symbol", "language" -> "en", "paclet" -> 
    "VectorFieldPlots Package", "status" -> "None", "summary" -> 
    "ScaleFactor is an option for the vector field visualization functions \
that scales the vectors so that the longest vector displayed is of the length \
specified.", "synonyms" -> {}, "title" -> "ScaleFactor", "type" -> "Symbol", 
    "uri" -> "VectorFieldPlots/ref/ScaleFactor"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4074, 144, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->130660375]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 37811, 804}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 901, 20, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1524, 47, 48, 1, 70, "ObjectName",
 CellID->1984],
Cell[1575, 50, 458, 12, 70, "Usage",
 CellID->23286]
}, Open  ]],
Cell[CellGroupData[{
Cell[2070, 67, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2548, 84, 369, 10, 70, "Notes",
 CellID->1502395761],
Cell[2920, 96, 230, 8, 70, "Notes",
 CellID->652833701],
Cell[3153, 106, 447, 15, 70, "Notes",
 CellID->682060184],
Cell[3603, 123, 434, 16, 70, "Notes",
 CellID->117804802]
}, Closed]],
Cell[CellGroupData[{
Cell[4074, 144, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->130660375],
Cell[CellGroupData[{
Cell[4459, 158, 148, 5, 70, "ExampleSection",
 CellID->301109681],
Cell[4610, 165, 141, 4, 70, "Input",
 CellID->161461216],
Cell[4754, 171, 81, 1, 70, "ExampleText",
 CellID->2046368990],
Cell[CellGroupData[{
Cell[4860, 176, 400, 11, 28, "Input",
 CellID->1373008225],
Cell[5263, 189, 8605, 145, 201, "Output",
 Evaluatable->False,
 CellID->90509287]
}, Open  ]],
Cell[13883, 337, 61, 1, 70, "ExampleText",
 CellID->1437450560],
Cell[CellGroupData[{
Cell[13969, 342, 393, 11, 70, "Input",
 CellID->40533170],
Cell[14365, 355, 21136, 375, 201, "Output",
 CellID->2095569174]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[35562, 737, 310, 9, 70, "SeeAlsoSection",
 CellID->8667],
Cell[35875, 748, 782, 26, 70, "SeeAlso",
 CellID->1437]
}, Open  ]],
Cell[36672, 777, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

