(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     53934,       1186]
NotebookOptionsPosition[     51252,       1100]
NotebookOutlinePosition[     52632,       1138]
CellTagsIndexPosition[     52546,       1133]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR FIELD PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"VectorFieldPlot" :> 
         Documentation`HelpLookup[
          "paclet:VectorFieldPlots/ref/VectorFieldPlot"], "MaxArrowLength" :> 
         Documentation`HelpLookup[
          "paclet:VectorFieldPlots/ref/MaxArrowLength"], "ScaleFactor" :> 
         Documentation`HelpLookup[
          "paclet:VectorFieldPlots/ref/ScaleFactor"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"VectorFieldPlot\"\>", 2->"\<\"MaxArrowLength\"\>",
       3->"\<\"ScaleFactor\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ScaleFunction", "ObjectName",
 CellID->17684],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["ScaleFunction"], "InlineFormula"],
     " \[LineSeparator]",
     "is an option for the vector field visualization functions that rescales \
each vector to a length determined by applying a pure function to the current \
length of that vector."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23301]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["ScaleFunction"], "InlineFormula"],
 " will ignore vectors of zero magnitude "
}], "Notes",
 CellID->714852497],

Cell[TextData[{
 Cell[BoxData["ScaleFunction"], "InlineFormula"],
 " is applied before ",
 Cell[BoxData[
  ButtonBox["ScaleFactor",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorFieldPlots/ref/ScaleFactor"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MaxArrowLength",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorFieldPlots/ref/MaxArrowLength"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->188385097]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->136778080],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->282114342],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorFieldPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->420153047],

Cell["With no scaling, the vectors have exponential lengths:", "ExampleText",
 CellID->669243486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorFieldPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Exp", "[", "x", "]"}], ",", 
     RowBox[{"Exp", "[", "y", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"ScaleFactor", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1264639680],

Cell[BoxData[
 GraphicsBox[
  {Thickness[Small], Arrowheads[0.02], ArrowBox[{{0., 0.}, {1., 1.}}], 
   ArrowBox[{{0., 0.07142857142857142}, {1., 1.1454700021448672`}}], 
   ArrowBox[{{0., 0.14285714285714285`}, {1., 1.2964221377522505`}}], 
   ArrowBox[{{0., 0.21428571428571427`}, {1., 1.4532623118270922`}}], 
   ArrowBox[{{0., 0.2857142857142857}, {1., 1.6164264831616357`}}], 
   ArrowBox[{{0., 0.35714285714285715`}, {1., 1.786382889560835}}], 
   ArrowBox[{{0., 0.42857142857142855`}, {1., 1.9636344378266384`}}], 
   ArrowBox[{{0., 0.5}, {1., 2.148721270700128}}], 
   ArrowBox[{{0., 0.5714285714285714}, {1., 2.3422235238637263`}}], 
   ArrowBox[{{0., 0.6428571428571429}, {1., 2.544764287075792}}], 
   ArrowBox[{{0., 0.7142857142857143}, {1., 2.7570127845518564`}}], 
   ArrowBox[{{0., 0.7857142857142857}, {1., 2.97968779082584}}], 
   ArrowBox[{{0., 0.8571428571428571}, {1., 3.2135612995265177`}}], 
   ArrowBox[{{0., 0.9285714285714286}, {1., 3.4594624637954405`}}], 
   ArrowBox[{{0., 1.}, {1., 3.718281828459045}}], 
   ArrowBox[{{0.07142857142857142, 0.}, {1.1454700021448672`, 1.}}], 
   ArrowBox[{{0.07142857142857142, 0.07142857142857142}, {1.1454700021448672`,
     1.1454700021448672`}}], 
   ArrowBox[{{0.07142857142857142, 0.14285714285714285`}, {
    1.1454700021448672`, 1.2964221377522505`}}], 
   ArrowBox[{{0.07142857142857142, 0.21428571428571427`}, {
    1.1454700021448672`, 1.4532623118270922`}}], 
   ArrowBox[{{0.07142857142857142, 0.2857142857142857}, {1.1454700021448672`, 
    1.6164264831616357`}}], 
   ArrowBox[{{0.07142857142857142, 0.35714285714285715`}, {
    1.1454700021448672`, 1.786382889560835}}], 
   ArrowBox[{{0.07142857142857142, 0.42857142857142855`}, {
    1.1454700021448672`, 1.9636344378266384`}}], 
   ArrowBox[{{0.07142857142857142, 0.5}, {1.1454700021448672`, 
    2.148721270700128}}], 
   ArrowBox[{{0.07142857142857142, 0.5714285714285714}, {1.1454700021448672`, 
    2.3422235238637263`}}], 
   ArrowBox[{{0.07142857142857142, 0.6428571428571429}, {1.1454700021448672`, 
    2.544764287075792}}], 
   ArrowBox[{{0.07142857142857142, 0.7142857142857143}, {1.1454700021448672`, 
    2.7570127845518564`}}], 
   ArrowBox[{{0.07142857142857142, 0.7857142857142857}, {1.1454700021448672`, 
    2.97968779082584}}], 
   ArrowBox[{{0.07142857142857142, 0.8571428571428571}, {1.1454700021448672`, 
    3.2135612995265177`}}], 
   ArrowBox[{{0.07142857142857142, 0.9285714285714286}, {1.1454700021448672`, 
    3.4594624637954405`}}], 
   ArrowBox[{{0.07142857142857142, 1.}, {1.1454700021448672`, 
    3.718281828459045}}], 
   ArrowBox[{{0.14285714285714285`, 0.}, {1.2964221377522505`, 1.}}], 
   ArrowBox[{{0.14285714285714285`, 0.07142857142857142}, {
    1.2964221377522505`, 1.1454700021448672`}}], 
   ArrowBox[{{0.14285714285714285`, 0.14285714285714285`}, {
    1.2964221377522505`, 1.2964221377522505`}}], 
   ArrowBox[{{0.14285714285714285`, 0.21428571428571427`}, {
    1.2964221377522505`, 1.4532623118270922`}}], 
   ArrowBox[{{0.14285714285714285`, 0.2857142857142857}, {1.2964221377522505`,
     1.6164264831616357`}}], 
   ArrowBox[{{0.14285714285714285`, 0.35714285714285715`}, {
    1.2964221377522505`, 1.786382889560835}}], 
   ArrowBox[{{0.14285714285714285`, 0.42857142857142855`}, {
    1.2964221377522505`, 1.9636344378266384`}}], 
   ArrowBox[{{0.14285714285714285`, 0.5}, {1.2964221377522505`, 
    2.148721270700128}}], 
   ArrowBox[{{0.14285714285714285`, 0.5714285714285714}, {1.2964221377522505`,
     2.3422235238637263`}}], 
   ArrowBox[{{0.14285714285714285`, 0.6428571428571429}, {1.2964221377522505`,
     2.544764287075792}}], 
   ArrowBox[{{0.14285714285714285`, 0.7142857142857143}, {1.2964221377522505`,
     2.7570127845518564`}}], 
   ArrowBox[{{0.14285714285714285`, 0.7857142857142857}, {1.2964221377522505`,
     2.97968779082584}}], 
   ArrowBox[{{0.14285714285714285`, 0.8571428571428571}, {1.2964221377522505`,
     3.2135612995265177`}}], 
   ArrowBox[{{0.14285714285714285`, 0.9285714285714286}, {1.2964221377522505`,
     3.4594624637954405`}}], 
   ArrowBox[{{0.14285714285714285`, 1.}, {1.2964221377522505`, 
    3.718281828459045}}], 
   ArrowBox[{{0.21428571428571427`, 0.}, {1.4532623118270922`, 1.}}], 
   ArrowBox[{{0.21428571428571427`, 0.07142857142857142}, {
    1.4532623118270922`, 1.1454700021448672`}}], 
   ArrowBox[{{0.21428571428571427`, 0.14285714285714285`}, {
    1.4532623118270922`, 1.2964221377522505`}}], 
   ArrowBox[{{0.21428571428571427`, 0.21428571428571427`}, {
    1.4532623118270922`, 1.4532623118270922`}}], 
   ArrowBox[{{0.21428571428571427`, 0.2857142857142857}, {1.4532623118270922`,
     1.6164264831616357`}}], 
   ArrowBox[{{0.21428571428571427`, 0.35714285714285715`}, {
    1.4532623118270922`, 1.786382889560835}}], 
   ArrowBox[{{0.21428571428571427`, 0.42857142857142855`}, {
    1.4532623118270922`, 1.9636344378266384`}}], 
   ArrowBox[{{0.21428571428571427`, 0.5}, {1.4532623118270922`, 
    2.148721270700128}}], 
   ArrowBox[{{0.21428571428571427`, 0.5714285714285714}, {1.4532623118270922`,
     2.3422235238637263`}}], 
   ArrowBox[{{0.21428571428571427`, 0.6428571428571429}, {1.4532623118270922`,
     2.544764287075792}}], 
   ArrowBox[{{0.21428571428571427`, 0.7142857142857143}, {1.4532623118270922`,
     2.7570127845518564`}}], 
   ArrowBox[{{0.21428571428571427`, 0.7857142857142857}, {1.4532623118270922`,
     2.97968779082584}}], 
   ArrowBox[{{0.21428571428571427`, 0.8571428571428571}, {1.4532623118270922`,
     3.2135612995265177`}}], 
   ArrowBox[{{0.21428571428571427`, 0.9285714285714286}, {1.4532623118270922`,
     3.4594624637954405`}}], 
   ArrowBox[{{0.21428571428571427`, 1.}, {1.4532623118270922`, 
    3.718281828459045}}], 
   ArrowBox[{{0.2857142857142857, 0.}, {1.6164264831616357`, 1.}}], 
   ArrowBox[{{0.2857142857142857, 0.07142857142857142}, {1.6164264831616357`, 
    1.1454700021448672`}}], 
   ArrowBox[{{0.2857142857142857, 0.14285714285714285`}, {1.6164264831616357`,
     1.2964221377522505`}}], 
   ArrowBox[{{0.2857142857142857, 0.21428571428571427`}, {1.6164264831616357`,
     1.4532623118270922`}}], 
   ArrowBox[{{0.2857142857142857, 0.2857142857142857}, {1.6164264831616357`, 
    1.6164264831616357`}}], 
   ArrowBox[{{0.2857142857142857, 0.35714285714285715`}, {1.6164264831616357`,
     1.786382889560835}}], 
   ArrowBox[{{0.2857142857142857, 0.42857142857142855`}, {1.6164264831616357`,
     1.9636344378266384`}}], 
   ArrowBox[{{0.2857142857142857, 0.5}, {1.6164264831616357`, 
    2.148721270700128}}], 
   ArrowBox[{{0.2857142857142857, 0.5714285714285714}, {1.6164264831616357`, 
    2.3422235238637263`}}], 
   ArrowBox[{{0.2857142857142857, 0.6428571428571429}, {1.6164264831616357`, 
    2.544764287075792}}], 
   ArrowBox[{{0.2857142857142857, 0.7142857142857143}, {1.6164264831616357`, 
    2.7570127845518564`}}], 
   ArrowBox[{{0.2857142857142857, 0.7857142857142857}, {1.6164264831616357`, 
    2.97968779082584}}], 
   ArrowBox[{{0.2857142857142857, 0.8571428571428571}, {1.6164264831616357`, 
    3.2135612995265177`}}], 
   ArrowBox[{{0.2857142857142857, 0.9285714285714286}, {1.6164264831616357`, 
    3.4594624637954405`}}], 
   ArrowBox[{{0.2857142857142857, 1.}, {1.6164264831616357`, 
    3.718281828459045}}], 
   ArrowBox[{{0.35714285714285715`, 0.}, {1.786382889560835, 1.}}], 
   ArrowBox[{{0.35714285714285715`, 0.07142857142857142}, {1.786382889560835, 
    1.1454700021448672`}}], 
   ArrowBox[{{0.35714285714285715`, 0.14285714285714285`}, {1.786382889560835,
     1.2964221377522505`}}], 
   ArrowBox[{{0.35714285714285715`, 0.21428571428571427`}, {1.786382889560835,
     1.4532623118270922`}}], 
   ArrowBox[{{0.35714285714285715`, 0.2857142857142857}, {1.786382889560835, 
    1.6164264831616357`}}], 
   ArrowBox[{{0.35714285714285715`, 0.35714285714285715`}, {1.786382889560835,
     1.786382889560835}}], 
   ArrowBox[{{0.35714285714285715`, 0.42857142857142855`}, {1.786382889560835,
     1.9636344378266384`}}], 
   ArrowBox[{{0.35714285714285715`, 0.5}, {1.786382889560835, 
    2.148721270700128}}], 
   ArrowBox[{{0.35714285714285715`, 0.5714285714285714}, {1.786382889560835, 
    2.3422235238637263`}}], 
   ArrowBox[{{0.35714285714285715`, 0.6428571428571429}, {1.786382889560835, 
    2.544764287075792}}], 
   ArrowBox[{{0.35714285714285715`, 0.7142857142857143}, {1.786382889560835, 
    2.7570127845518564`}}], 
   ArrowBox[{{0.35714285714285715`, 0.7857142857142857}, {1.786382889560835, 
    2.97968779082584}}], 
   ArrowBox[{{0.35714285714285715`, 0.8571428571428571}, {1.786382889560835, 
    3.2135612995265177`}}], 
   ArrowBox[{{0.35714285714285715`, 0.9285714285714286}, {1.786382889560835, 
    3.4594624637954405`}}], 
   ArrowBox[{{0.35714285714285715`, 1.}, {1.786382889560835, 
    3.718281828459045}}], 
   ArrowBox[{{0.42857142857142855`, 0.}, {1.9636344378266384`, 1.}}], 
   ArrowBox[{{0.42857142857142855`, 0.07142857142857142}, {
    1.9636344378266384`, 1.1454700021448672`}}], 
   ArrowBox[{{0.42857142857142855`, 0.14285714285714285`}, {
    1.9636344378266384`, 1.2964221377522505`}}], 
   ArrowBox[{{0.42857142857142855`, 0.21428571428571427`}, {
    1.9636344378266384`, 1.4532623118270922`}}], 
   ArrowBox[{{0.42857142857142855`, 0.2857142857142857}, {1.9636344378266384`,
     1.6164264831616357`}}], 
   ArrowBox[{{0.42857142857142855`, 0.35714285714285715`}, {
    1.9636344378266384`, 1.786382889560835}}], 
   ArrowBox[{{0.42857142857142855`, 0.42857142857142855`}, {
    1.9636344378266384`, 1.9636344378266384`}}], 
   ArrowBox[{{0.42857142857142855`, 0.5}, {1.9636344378266384`, 
    2.148721270700128}}], 
   ArrowBox[{{0.42857142857142855`, 0.5714285714285714}, {1.9636344378266384`,
     2.3422235238637263`}}], 
   ArrowBox[{{0.42857142857142855`, 0.6428571428571429}, {1.9636344378266384`,
     2.544764287075792}}], 
   ArrowBox[{{0.42857142857142855`, 0.7142857142857143}, {1.9636344378266384`,
     2.7570127845518564`}}], 
   ArrowBox[{{0.42857142857142855`, 0.7857142857142857}, {1.9636344378266384`,
     2.97968779082584}}], 
   ArrowBox[{{0.42857142857142855`, 0.8571428571428571}, {1.9636344378266384`,
     3.2135612995265177`}}], 
   ArrowBox[{{0.42857142857142855`, 0.9285714285714286}, {1.9636344378266384`,
     3.4594624637954405`}}], 
   ArrowBox[{{0.42857142857142855`, 1.}, {1.9636344378266384`, 
    3.718281828459045}}], ArrowBox[{{0.5, 0.}, {2.148721270700128, 1.}}], 
   ArrowBox[{{0.5, 0.07142857142857142}, {2.148721270700128, 
    1.1454700021448672`}}], 
   ArrowBox[{{0.5, 0.14285714285714285`}, {2.148721270700128, 
    1.2964221377522505`}}], 
   ArrowBox[{{0.5, 0.21428571428571427`}, {2.148721270700128, 
    1.4532623118270922`}}], 
   ArrowBox[{{0.5, 0.2857142857142857}, {2.148721270700128, 
    1.6164264831616357`}}], 
   ArrowBox[{{0.5, 0.35714285714285715`}, {2.148721270700128, 
    1.786382889560835}}], 
   ArrowBox[{{0.5, 0.42857142857142855`}, {2.148721270700128, 
    1.9636344378266384`}}], 
   ArrowBox[{{0.5, 0.5}, {2.148721270700128, 2.148721270700128}}], 
   ArrowBox[{{0.5, 0.5714285714285714}, {2.148721270700128, 
    2.3422235238637263`}}], 
   ArrowBox[{{0.5, 0.6428571428571429}, {2.148721270700128, 
    2.544764287075792}}], 
   ArrowBox[{{0.5, 0.7142857142857143}, {2.148721270700128, 
    2.7570127845518564`}}], 
   ArrowBox[{{0.5, 0.7857142857142857}, {2.148721270700128, 
    2.97968779082584}}], 
   ArrowBox[{{0.5, 0.8571428571428571}, {2.148721270700128, 
    3.2135612995265177`}}], 
   ArrowBox[{{0.5, 0.9285714285714286}, {2.148721270700128, 
    3.4594624637954405`}}], 
   ArrowBox[{{0.5, 1.}, {2.148721270700128, 3.718281828459045}}], 
   ArrowBox[{{0.5714285714285714, 0.}, {2.3422235238637263`, 1.}}], 
   ArrowBox[{{0.5714285714285714, 0.07142857142857142}, {2.3422235238637263`, 
    1.1454700021448672`}}], 
   ArrowBox[{{0.5714285714285714, 0.14285714285714285`}, {2.3422235238637263`,
     1.2964221377522505`}}], 
   ArrowBox[{{0.5714285714285714, 0.21428571428571427`}, {2.3422235238637263`,
     1.4532623118270922`}}], 
   ArrowBox[{{0.5714285714285714, 0.2857142857142857}, {2.3422235238637263`, 
    1.6164264831616357`}}], 
   ArrowBox[{{0.5714285714285714, 0.35714285714285715`}, {2.3422235238637263`,
     1.786382889560835}}], 
   ArrowBox[{{0.5714285714285714, 0.42857142857142855`}, {2.3422235238637263`,
     1.9636344378266384`}}], 
   ArrowBox[{{0.5714285714285714, 0.5}, {2.3422235238637263`, 
    2.148721270700128}}], 
   ArrowBox[{{0.5714285714285714, 0.5714285714285714}, {2.3422235238637263`, 
    2.3422235238637263`}}], 
   ArrowBox[{{0.5714285714285714, 0.6428571428571429}, {2.3422235238637263`, 
    2.544764287075792}}], 
   ArrowBox[{{0.5714285714285714, 0.7142857142857143}, {2.3422235238637263`, 
    2.7570127845518564`}}], 
   ArrowBox[{{0.5714285714285714, 0.7857142857142857}, {2.3422235238637263`, 
    2.97968779082584}}], 
   ArrowBox[{{0.5714285714285714, 0.8571428571428571}, {2.3422235238637263`, 
    3.2135612995265177`}}], 
   ArrowBox[{{0.5714285714285714, 0.9285714285714286}, {2.3422235238637263`, 
    3.4594624637954405`}}], 
   ArrowBox[{{0.5714285714285714, 1.}, {2.3422235238637263`, 
    3.718281828459045}}], 
   ArrowBox[{{0.6428571428571429, 0.}, {2.544764287075792, 1.}}], 
   ArrowBox[{{0.6428571428571429, 0.07142857142857142}, {2.544764287075792, 
    1.1454700021448672`}}], 
   ArrowBox[{{0.6428571428571429, 0.14285714285714285`}, {2.544764287075792, 
    1.2964221377522505`}}], 
   ArrowBox[{{0.6428571428571429, 0.21428571428571427`}, {2.544764287075792, 
    1.4532623118270922`}}], 
   ArrowBox[{{0.6428571428571429, 0.2857142857142857}, {2.544764287075792, 
    1.6164264831616357`}}], 
   ArrowBox[{{0.6428571428571429, 0.35714285714285715`}, {2.544764287075792, 
    1.786382889560835}}], 
   ArrowBox[{{0.6428571428571429, 0.42857142857142855`}, {2.544764287075792, 
    1.9636344378266384`}}], 
   ArrowBox[{{0.6428571428571429, 0.5}, {2.544764287075792, 
    2.148721270700128}}], 
   ArrowBox[{{0.6428571428571429, 0.5714285714285714}, {2.544764287075792, 
    2.3422235238637263`}}], 
   ArrowBox[{{0.6428571428571429, 0.6428571428571429}, {2.544764287075792, 
    2.544764287075792}}], 
   ArrowBox[{{0.6428571428571429, 0.7142857142857143}, {2.544764287075792, 
    2.7570127845518564`}}], 
   ArrowBox[{{0.6428571428571429, 0.7857142857142857}, {2.544764287075792, 
    2.97968779082584}}], 
   ArrowBox[{{0.6428571428571429, 0.8571428571428571}, {2.544764287075792, 
    3.2135612995265177`}}], 
   ArrowBox[{{0.6428571428571429, 0.9285714285714286}, {2.544764287075792, 
    3.4594624637954405`}}], 
   ArrowBox[{{0.6428571428571429, 1.}, {2.544764287075792, 
    3.718281828459045}}], 
   ArrowBox[{{0.7142857142857143, 0.}, {2.7570127845518564`, 1.}}], 
   ArrowBox[{{0.7142857142857143, 0.07142857142857142}, {2.7570127845518564`, 
    1.1454700021448672`}}], 
   ArrowBox[{{0.7142857142857143, 0.14285714285714285`}, {2.7570127845518564`,
     1.2964221377522505`}}], 
   ArrowBox[{{0.7142857142857143, 0.21428571428571427`}, {2.7570127845518564`,
     1.4532623118270922`}}], 
   ArrowBox[{{0.7142857142857143, 0.2857142857142857}, {2.7570127845518564`, 
    1.6164264831616357`}}], 
   ArrowBox[{{0.7142857142857143, 0.35714285714285715`}, {2.7570127845518564`,
     1.786382889560835}}], 
   ArrowBox[{{0.7142857142857143, 0.42857142857142855`}, {2.7570127845518564`,
     1.9636344378266384`}}], 
   ArrowBox[{{0.7142857142857143, 0.5}, {2.7570127845518564`, 
    2.148721270700128}}], 
   ArrowBox[{{0.7142857142857143, 0.5714285714285714}, {2.7570127845518564`, 
    2.3422235238637263`}}], 
   ArrowBox[{{0.7142857142857143, 0.6428571428571429}, {2.7570127845518564`, 
    2.544764287075792}}], 
   ArrowBox[{{0.7142857142857143, 0.7142857142857143}, {2.7570127845518564`, 
    2.7570127845518564`}}], 
   ArrowBox[{{0.7142857142857143, 0.7857142857142857}, {2.7570127845518564`, 
    2.97968779082584}}], 
   ArrowBox[{{0.7142857142857143, 0.8571428571428571}, {2.7570127845518564`, 
    3.2135612995265177`}}], 
   ArrowBox[{{0.7142857142857143, 0.9285714285714286}, {2.7570127845518564`, 
    3.4594624637954405`}}], 
   ArrowBox[{{0.7142857142857143, 1.}, {2.7570127845518564`, 
    3.718281828459045}}], 
   ArrowBox[{{0.7857142857142857, 0.}, {2.97968779082584, 1.}}], 
   ArrowBox[{{0.7857142857142857, 0.07142857142857142}, {2.97968779082584, 
    1.1454700021448672`}}], 
   ArrowBox[{{0.7857142857142857, 0.14285714285714285`}, {2.97968779082584, 
    1.2964221377522505`}}], 
   ArrowBox[{{0.7857142857142857, 0.21428571428571427`}, {2.97968779082584, 
    1.4532623118270922`}}], 
   ArrowBox[{{0.7857142857142857, 0.2857142857142857}, {2.97968779082584, 
    1.6164264831616357`}}], 
   ArrowBox[{{0.7857142857142857, 0.35714285714285715`}, {2.97968779082584, 
    1.786382889560835}}], 
   ArrowBox[{{0.7857142857142857, 0.42857142857142855`}, {2.97968779082584, 
    1.9636344378266384`}}], 
   ArrowBox[{{0.7857142857142857, 0.5}, {2.97968779082584, 
    2.148721270700128}}], 
   ArrowBox[{{0.7857142857142857, 0.5714285714285714}, {2.97968779082584, 
    2.3422235238637263`}}], 
   ArrowBox[{{0.7857142857142857, 0.6428571428571429}, {2.97968779082584, 
    2.544764287075792}}], 
   ArrowBox[{{0.7857142857142857, 0.7142857142857143}, {2.97968779082584, 
    2.7570127845518564`}}], 
   ArrowBox[{{0.7857142857142857, 0.7857142857142857}, {2.97968779082584, 
    2.97968779082584}}], 
   ArrowBox[{{0.7857142857142857, 0.8571428571428571}, {2.97968779082584, 
    3.2135612995265177`}}], 
   ArrowBox[{{0.7857142857142857, 0.9285714285714286}, {2.97968779082584, 
    3.4594624637954405`}}], 
   ArrowBox[{{0.7857142857142857, 1.}, {2.97968779082584, 
    3.718281828459045}}], 
   ArrowBox[{{0.8571428571428571, 0.}, {3.2135612995265177`, 1.}}], 
   ArrowBox[{{0.8571428571428571, 0.07142857142857142}, {3.2135612995265177`, 
    1.1454700021448672`}}], 
   ArrowBox[{{0.8571428571428571, 0.14285714285714285`}, {3.2135612995265177`,
     1.2964221377522505`}}], 
   ArrowBox[{{0.8571428571428571, 0.21428571428571427`}, {3.2135612995265177`,
     1.4532623118270922`}}], 
   ArrowBox[{{0.8571428571428571, 0.2857142857142857}, {3.2135612995265177`, 
    1.6164264831616357`}}], 
   ArrowBox[{{0.8571428571428571, 0.35714285714285715`}, {3.2135612995265177`,
     1.786382889560835}}], 
   ArrowBox[{{0.8571428571428571, 0.42857142857142855`}, {3.2135612995265177`,
     1.9636344378266384`}}], 
   ArrowBox[{{0.8571428571428571, 0.5}, {3.2135612995265177`, 
    2.148721270700128}}], 
   ArrowBox[{{0.8571428571428571, 0.5714285714285714}, {3.2135612995265177`, 
    2.3422235238637263`}}], 
   ArrowBox[{{0.8571428571428571, 0.6428571428571429}, {3.2135612995265177`, 
    2.544764287075792}}], 
   ArrowBox[{{0.8571428571428571, 0.7142857142857143}, {3.2135612995265177`, 
    2.7570127845518564`}}], 
   ArrowBox[{{0.8571428571428571, 0.7857142857142857}, {3.2135612995265177`, 
    2.97968779082584}}], 
   ArrowBox[{{0.8571428571428571, 0.8571428571428571}, {3.2135612995265177`, 
    3.2135612995265177`}}], 
   ArrowBox[{{0.8571428571428571, 0.9285714285714286}, {3.2135612995265177`, 
    3.4594624637954405`}}], 
   ArrowBox[{{0.8571428571428571, 1.}, {3.2135612995265177`, 
    3.718281828459045}}], 
   ArrowBox[{{0.9285714285714286, 0.}, {3.4594624637954405`, 1.}}], 
   ArrowBox[{{0.9285714285714286, 0.07142857142857142}, {3.4594624637954405`, 
    1.1454700021448672`}}], 
   ArrowBox[{{0.9285714285714286, 0.14285714285714285`}, {3.4594624637954405`,
     1.2964221377522505`}}], 
   ArrowBox[{{0.9285714285714286, 0.21428571428571427`}, {3.4594624637954405`,
     1.4532623118270922`}}], 
   ArrowBox[{{0.9285714285714286, 0.2857142857142857}, {3.4594624637954405`, 
    1.6164264831616357`}}], 
   ArrowBox[{{0.9285714285714286, 0.35714285714285715`}, {3.4594624637954405`,
     1.786382889560835}}], 
   ArrowBox[{{0.9285714285714286, 0.42857142857142855`}, {3.4594624637954405`,
     1.9636344378266384`}}], 
   ArrowBox[{{0.9285714285714286, 0.5}, {3.4594624637954405`, 
    2.148721270700128}}], 
   ArrowBox[{{0.9285714285714286, 0.5714285714285714}, {3.4594624637954405`, 
    2.3422235238637263`}}], 
   ArrowBox[{{0.9285714285714286, 0.6428571428571429}, {3.4594624637954405`, 
    2.544764287075792}}], 
   ArrowBox[{{0.9285714285714286, 0.7142857142857143}, {3.4594624637954405`, 
    2.7570127845518564`}}], 
   ArrowBox[{{0.9285714285714286, 0.7857142857142857}, {3.4594624637954405`, 
    2.97968779082584}}], 
   ArrowBox[{{0.9285714285714286, 0.8571428571428571}, {3.4594624637954405`, 
    3.2135612995265177`}}], 
   ArrowBox[{{0.9285714285714286, 0.9285714285714286}, {3.4594624637954405`, 
    3.4594624637954405`}}], 
   ArrowBox[{{0.9285714285714286, 1.}, {3.4594624637954405`, 
    3.718281828459045}}], ArrowBox[{{1., 0.}, {3.718281828459045, 1.}}], 
   ArrowBox[{{1., 0.07142857142857142}, {3.718281828459045, 
    1.1454700021448672`}}], 
   ArrowBox[{{1., 0.14285714285714285`}, {3.718281828459045, 
    1.2964221377522505`}}], 
   ArrowBox[{{1., 0.21428571428571427`}, {3.718281828459045, 
    1.4532623118270922`}}], 
   ArrowBox[{{1., 0.2857142857142857}, {3.718281828459045, 
    1.6164264831616357`}}], 
   ArrowBox[{{1., 0.35714285714285715`}, {3.718281828459045, 
    1.786382889560835}}], 
   ArrowBox[{{1., 0.42857142857142855`}, {3.718281828459045, 
    1.9636344378266384`}}], 
   ArrowBox[{{1., 0.5}, {3.718281828459045, 2.148721270700128}}], 
   ArrowBox[{{1., 0.5714285714285714}, {3.718281828459045, 
    2.3422235238637263`}}], 
   ArrowBox[{{1., 0.6428571428571429}, {3.718281828459045, 
    2.544764287075792}}], 
   ArrowBox[{{1., 0.7142857142857143}, {3.718281828459045, 
    2.7570127845518564`}}], 
   ArrowBox[{{1., 0.7857142857142857}, {3.718281828459045, 
    2.97968779082584}}], 
   ArrowBox[{{1., 0.8571428571428571}, {3.718281828459045, 
    3.2135612995265177`}}], 
   ArrowBox[{{1., 0.9285714285714286}, {3.718281828459045, 
    3.4594624637954405`}}], 
   ArrowBox[{{1., 1.}, {3.718281828459045, 3.718281828459045}}]}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->321982369]
}, Open  ]],

Cell["Scale the vectors logarithmically:", "ExampleText",
 CellID->1603409863],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorFieldPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Exp", "[", "x", "]"}], ",", 
     RowBox[{"Exp", "[", "y", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"ScaleFunction", "\[Rule]", "Log"}], ",", " ", 
   RowBox[{"ScaleFactor", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->655587138],

Cell[BoxData[
 GraphicsBox[
  {Thickness[Small], Arrowheads[0.02], 
   ArrowBox[{{0., 0.}, {0.2450645358671368, 0.2450645358671368}}], 
   ArrowBox[{{0., 0.07142857142857142}, {0.26137071502240383`, 
    0.3521515481385753}}], 
   ArrowBox[{{0., 0.14285714285714285`}, {0.27713112046279653`, 
    0.4625459024190842}}], 
   ArrowBox[{{0., 0.21428571428571427`}, {0.29211953060404483`, 
    0.5762149763888982}}], 
   ArrowBox[{{0., 0.2857142857142857}, {0.30612529325731025`, 
    0.6930789473989354}}], 
   ArrowBox[{{0., 0.35714285714285715`}, {0.318961112877225, 
    0.8130148484515765}}], 
   ArrowBox[{{0., 0.42857142857142855`}, {0.33046926618185074`, 
    0.9358625747829012}}], 
   ArrowBox[{{0., 0.5}, {0.3405258822442977, 1.0614322652801007`}}], 
   ArrowBox[{{0., 0.5714285714285714}, {0.3490431451373225, 
    1.1895124110198334`}}], 
   ArrowBox[{{0., 0.6428571428571429}, {0.3559694894245381, 
    1.3198780579175367`}}], 
   ArrowBox[{{0., 0.7142857142857143}, {0.3612880313610058, 
    1.4522985561100037`}}], 
   ArrowBox[{{0., 0.7857142857142857}, {0.3650135940934985, 
    1.5865444401609647`}}], 
   ArrowBox[{{0., 0.8571428571428571}, {0.3671887392306391, 
    1.7223931741015397`}}], 
   ArrowBox[{{0., 0.9285714285714286}, {0.3678792165920683, 
    1.8596336398895268`}}], 
   ArrowBox[{{0., 1.}, {0.3671692022072219, 1.998069370329696}}], 
   ArrowBox[{{0.07142857142857142, 0.}, {0.3521515481385753, 
    0.26137071502240383`}}], 
   ArrowBox[{{0.07142857142857142, 0.07142857142857142}, {0.3670007345233187, 
    0.3670007345233187}}], 
   ArrowBox[{{0.07142857142857142, 0.14285714285714285`}, {
    0.38147283084951333`, 0.47585752283098576`}}], 
   ArrowBox[{{0.07142857142857142, 0.21428571428571427`}, {0.3953469548491897,
     0.5879466226027513}}], 
   ArrowBox[{{0.07142857142857142, 0.2857142857142857}, {0.408409994000247, 
    0.7032263820867937}}], 
   ArrowBox[{{0.07142857142857142, 0.35714285714285715`}, {
    0.42046497682583306`, 0.8216098591581713}}], 
   ArrowBox[{{0.07142857142857142, 0.42857142857142855`}, {
    0.43133841696897857`, 0.9429689878791494}}], 
   ArrowBox[{{0.07142857142857142, 0.5}, {0.4408861031214254, 
    1.0671405903924345`}}], 
   ArrowBox[{{0.07142857142857142, 0.5714285714285714}, {0.44899699825380446`,
     1.193933667880118}}], 
   ArrowBox[{{0.07142857142857142, 0.6428571428571429}, {0.4555951267200081, 
    1.32313733986162}}], 
   ArrowBox[{{0.07142857142857142, 0.7142857142857143}, {0.46063953173771877`,
     1.4545288203058826`}}], 
   ArrowBox[{{0.07142857142857142, 0.7857142857142857}, {0.4641225499875131, 
    1.5878809060471477`}}], 
   ArrowBox[{{0.07142857142857142, 0.8571428571428571}, {0.4660667582546326, 
    1.7229685831444992`}}], 
   ArrowBox[{{0.07142857142857142, 0.9285714285714286}, {0.4665209956658938, 
    1.8595745034903244`}}], 
   ArrowBox[{{0.07142857142857142, 1.}, {0.4655558611202574, 
    1.9974932242178252`}}], 
   ArrowBox[{{0.14285714285714285`, 0.}, {0.4625459024190842, 
    0.27713112046279653`}}], 
   ArrowBox[{{0.14285714285714285`, 0.07142857142857142}, {
    0.47585752283098576`, 0.38147283084951333`}}], 
   ArrowBox[{{0.14285714285714285`, 0.14285714285714285`}, {
    0.48893693317950077`, 0.48893693317950077`}}], 
   ArrowBox[{{0.14285714285714285`, 0.21428571428571427`}, {
    0.5015749466766231, 0.5995634975233963}}], 
   ArrowBox[{{0.14285714285714285`, 0.2857142857142857}, {0.5135627892355827, 
    0.7133473427864183}}], 
   ArrowBox[{{0.14285714285714285`, 0.35714285714285715`}, {
    0.5247004573964493, 0.8302377877846894}}], 
   ArrowBox[{{0.14285714285714285`, 0.42857142857142855`}, {
    0.5348046603943561, 0.9501407709174075}}], 
   ArrowBox[{{0.14285714285714285`, 0.5}, {0.5437157210607323, 
    1.0729231273067228`}}], 
   ArrowBox[{{0.14285714285714285`, 0.5714285714285714}, {0.5513029400610001, 
    1.1984186060019677`}}], 
   ArrowBox[{{0.14285714285714285`, 0.6428571428571429}, {0.5574681142633113, 
    1.3264350704801355`}}], 
   ArrowBox[{{0.14285714285714285`, 0.7142857142857143}, {0.5621471083026937, 
    1.4567622687034063`}}], 
   ArrowBox[{{0.14285714285714285`, 0.7857142857142857}, {0.5653095740508994, 
    1.5891795826942285`}}], 
   ArrowBox[{{0.14285714285714285`, 0.8571428571428571}, {0.5669570686140204, 
    1.7234632559842917`}}], 
   ArrowBox[{{0.14285714285714285`, 0.9285714285714286}, {0.5671199224157668, 
    1.8593927261280336`}}], 
   ArrowBox[{{0.14285714285714285`, 1.}, {0.5658532521011483, 
    1.9967558328791082`}}], 
   ArrowBox[{{0.21428571428571427`, 0.}, {0.5762149763888982, 
    0.29211953060404483`}}], 
   ArrowBox[{{0.21428571428571427`, 0.07142857142857142}, {0.5879466226027513,
     0.3953469548491897}}], 
   ArrowBox[{{0.21428571428571427`, 0.14285714285714285`}, {
    0.5995634975233963, 0.5015749466766231}}], 
   ArrowBox[{{0.21428571428571427`, 0.21428571428571427`}, {
    0.6108731318356827, 0.6108731318356827}}], 
   ArrowBox[{{0.21428571428571427`, 0.2857142857142857}, {0.6216770625037328, 
    0.723269472215807}}], 
   ArrowBox[{{0.21428571428571427`, 0.35714285714285715`}, {
    0.6317786236219758, 0.8387480629700854}}], 
   ArrowBox[{{0.21428571428571427`, 0.42857142857142855`}, {
    0.6409909207926515, 0.9572491934825849}}], 
   ArrowBox[{{0.21428571428571427`, 0.5}, {0.649144343962879, 
    1.0786716826766434`}}], 
   ArrowBox[{{0.21428571428571427`, 0.5714285714285714}, {0.6560930251524859, 
    1.2028772667342957`}}], 
   ArrowBox[{{0.21428571428571427`, 0.6428571428571429}, {0.6617197770005746, 
    1.3296966216115007`}}], 
   ArrowBox[{{0.21428571428571427`, 0.7142857142857143}, {0.6659392302728181, 
    1.4589364730801528`}}], 
   ArrowBox[{{0.21428571428571427`, 0.7857142857142857}, {0.6686990898853793, 
    1.5903871975451929`}}], 
   ArrowBox[{{0.21428571428571427`, 0.8571428571428571}, {0.6699796163640802, 
    1.7238303450825745`}}], 
   ArrowBox[{{0.21428571428571427`, 0.9285714285714286}, {0.6697915872405277, 
    1.8590456059214362`}}], 
   ArrowBox[{{0.21428571428571427`, 1.}, {0.668173086576901, 
    1.995816869111568}}], 
   ArrowBox[{{0.2857142857142857, 0.}, {0.6930789473989354, 
    0.30612529325731025`}}], 
   ArrowBox[{{0.2857142857142857, 0.07142857142857142}, {0.7032263820867937, 
    0.408409994000247}}], 
   ArrowBox[{{0.2857142857142857, 0.14285714285714285`}, {0.7133473427864183, 
    0.5135627892355827}}], 
   ArrowBox[{{0.2857142857142857, 0.21428571428571427`}, {0.723269472215807, 
    0.6216770625037328}}], 
   ArrowBox[{{0.2857142857142857, 0.2857142857142857}, {0.7328093304918646, 
    0.7328093304918646}}], 
   ArrowBox[{{0.2857142857142857, 0.35714285714285715`}, {0.7417791783308423, 
    0.8469754469082174}}], 
   ArrowBox[{{0.2857142857142857, 0.42857142857142855`}, {0.7499944580083691, 
    0.9641487831537525}}], 
   ArrowBox[{{0.2857142857142857, 0.5}, {0.7572813841888538, 
    1.0842605991804803`}}], 
   ArrowBox[{{0.2857142857142857, 0.5714285714285714}, {0.7634840275314019, 
    1.2072025944358793`}}], 
   ArrowBox[{{0.2857142857142857, 0.6428571428571429}, {0.7684703292442395, 
    1.332831406161869}}], 
   ArrowBox[{{0.2857142857142857, 0.7142857142857143}, {0.7721366139401493, 
    1.460974637221034}}], 
   ArrowBox[{{0.2857142857142857, 0.7857142857142857}, {0.7744103462823251, 
    1.5914378756801701`}}], 
   ArrowBox[{{0.2857142857142857, 0.8571428571428571}, {0.7752510714680649, 
    1.7240121263869792`}}], 
   ArrowBox[{{0.2857142857142857, 0.9285714285714286}, {0.7746496586772609, 
    1.8584811074709209`}}], 
   ArrowBox[{{0.2857142857142857, 1.}, {0.772626105867035, 
    1.9946279558585802`}}], 
   ArrowBox[{{0.35714285714285715`, 0.}, {0.8130148484515765, 
    0.318961112877225}}], 
   ArrowBox[{{0.35714285714285715`, 0.07142857142857142}, {0.8216098591581713,
     0.42046497682583306`}}], 
   ArrowBox[{{0.35714285714285715`, 0.14285714285714285`}, {
    0.8302377877846894, 0.5247004573964493}}], 
   ArrowBox[{{0.35714285714285715`, 0.21428571428571427`}, {
    0.8387480629700854, 0.6317786236219758}}], 
   ArrowBox[{{0.35714285714285715`, 0.2857142857142857}, {0.8469754469082174, 
    0.7417791783308423}}], 
   ArrowBox[{{0.35714285714285715`, 0.35714285714285715`}, {
    0.8547455291480466, 0.8547455291480466}}], 
   ArrowBox[{{0.35714285714285715`, 0.42857142857142855`}, {
    0.8618812941579521, 0.9706814216006281}}], 
   ArrowBox[{{0.35714285714285715`, 0.5}, {0.8682102923947621, 
    1.0895495033374196`}}], 
   ArrowBox[{{0.35714285714285715`, 0.5714285714285714}, {0.873571847585056, 
    1.211272004878376}}], 
   ArrowBox[{{0.35714285714285715`, 0.6428571428571429}, {0.877823711099925, 
    1.3357335061951154`}}], 
   ArrowBox[{{0.35714285714285715`, 0.7142857142857143}, {0.8808476333359931, 
    1.4627855455894418`}}], 
   ArrowBox[{{0.35714285714285715`, 0.7857142857142857}, {0.8825534508797239, 
    1.592252652830567}}], 
   ArrowBox[{{0.35714285714285715`, 0.8571428571428571}, {0.8828814622918317, 
    1.7239392782801874`}}], 
   ArrowBox[{{0.35714285714285715`, 0.9285714285714286}, {0.8818030530507506, 
    1.857637055228766}}], 
   ArrowBox[{{0.35714285714285715`, 1.}, {0.8793197009904417, 
    1.9931318698592666`}}], 
   ArrowBox[{{0.42857142857142855`, 0.}, {0.9358625747829012, 
    0.33046926618185074`}}], 
   ArrowBox[{{0.42857142857142855`, 0.07142857142857142}, {0.9429689878791494,
     0.43133841696897857`}}], 
   ArrowBox[{{0.42857142857142855`, 0.14285714285714285`}, {
    0.9501407709174075, 0.5348046603943561}}], 
   ArrowBox[{{0.42857142857142855`, 0.21428571428571427`}, {
    0.9572491934825849, 0.6409909207926515}}], 
   ArrowBox[{{0.42857142857142855`, 0.2857142857142857}, {0.9641487831537525, 
    0.7499944580083691}}], 
   ArrowBox[{{0.42857142857142855`, 0.35714285714285715`}, {
    0.9706814216006281, 0.8618812941579521}}], 
   ArrowBox[{{0.42857142857142855`, 0.42857142857142855`}, {
    0.9766817278042286, 0.9766817278042286}}], 
   ArrowBox[{{0.42857142857142855`, 0.5}, {0.9819834099850617, 
    1.0943873962930386`}}], 
   ArrowBox[{{0.42857142857142855`, 0.5714285714285714}, {0.9864261267811554, 
    1.2149502235210867`}}], 
   ArrowBox[{{0.42857142857142855`, 0.6428571428571429}, {0.9898623109812583, 
    1.3382834105762718`}}], 
   ArrowBox[{{0.42857142857142855`, 0.7142857142857143}, {0.9921633946684478, 
    1.4642644179543511`}}], 
   ArrowBox[{{0.42857142857142855`, 0.7857142857142857}, {0.9932249374277469, 
    1.592739685017015}}], 
   ArrowBox[{{0.42857142857142855`, 0.8571428571428571}, {0.9929702878192985, 
    1.7235306684401002`}}], 
   ArrowBox[{{0.42857142857142855`, 0.9285714285714286}, {0.9913525783013386, 
    1.856440680880205}}], 
   ArrowBox[{{0.42857142857142855`, 1.}, {0.9883550346334362, 
    1.9912619840705523`}}], 
   ArrowBox[{{0.5, 0.}, {1.0614322652801007`, 0.3405258822442977}}], 
   ArrowBox[{{0.5, 0.07142857142857142}, {1.0671405903924345`, 
    0.4408861031214254}}], 
   ArrowBox[{{0.5, 0.14285714285714285`}, {1.0729231273067228`, 
    0.5437157210607323}}], 
   ArrowBox[{{0.5, 0.21428571428571427`}, {1.0786716826766434`, 
    0.649144343962879}}], 
   ArrowBox[{{0.5, 0.2857142857142857}, {1.0842605991804803`, 
    0.7572813841888538}}], 
   ArrowBox[{{0.5, 0.35714285714285715`}, {1.0895495033374196`, 
    0.8682102923947621}}], 
   ArrowBox[{{0.5, 0.42857142857142855`}, {1.0943873962930386`, 
    0.9819834099850617}}], 
   ArrowBox[{{0.5, 0.5}, {1.0986179264604106`, 1.0986179264604106`}}], 
   ArrowBox[{{0.5, 0.5714285714285714}, {1.1020855258121713`, 
    1.2180933709854491`}}], 
   ArrowBox[{{0.5, 0.6428571428571429}, {1.1046419611675486`, 
    1.340350943704754}}], 
   ArrowBox[{{0.5, 0.7142857142857143}, {1.1061527743774606`, 
    1.465294816274167}}], 
   ArrowBox[{{0.5, 0.7857142857142857}, {1.1065030782369707`, 
    1.5927953297135873`}}], 
   ArrowBox[{{0.5, 0.8571428571428571}, {1.1056022415195006`, 
    1.7226938244445877`}}], 
   ArrowBox[{{0.5, 0.9285714285714286}, {1.1033871247588731`, 
    1.8548086840496332`}}], 
   ArrowBox[{{0.5, 1.}, {1.0998236943108455`, 1.9889420834802225`}}], 
   ArrowBox[{{0.5714285714285714, 0.}, {1.1895124110198334`, 
    0.3490431451373225}}], 
   ArrowBox[{{0.5714285714285714, 0.07142857142857142}, {1.193933667880118, 
    0.44899699825380446`}}], 
   ArrowBox[{{0.5714285714285714, 0.14285714285714285`}, {1.1984186060019677`,
     0.5513029400610001}}], 
   ArrowBox[{{0.5714285714285714, 0.21428571428571427`}, {1.2028772667342957`,
     0.6560930251524859}}], 
   ArrowBox[{{0.5714285714285714, 0.2857142857142857}, {1.2072025944358793`, 
    0.7634840275314019}}], 
   ArrowBox[{{0.5714285714285714, 0.35714285714285715`}, {1.211272004878376, 
    0.873571847585056}}], 
   ArrowBox[{{0.5714285714285714, 0.42857142857142855`}, {1.2149502235210867`,
     0.9864261267811554}}], 
   ArrowBox[{{0.5714285714285714, 0.5}, {1.2180933709854491`, 
    1.1020855258121713`}}], 
   ArrowBox[{{0.5714285714285714, 0.5714285714285714}, {1.2205541251165926`, 
    1.2205541251165926`}}], 
   ArrowBox[{{0.5714285714285714, 0.6428571428571429}, {1.222187641639281, 
    1.3417993456778599`}}], 
   ArrowBox[{{0.5714285714285714, 0.7142857142857143}, {1.2228577955539417`, 
    1.465751663888421}}], 
   ArrowBox[{{0.5714285714285714, 0.7857142857142857}, {1.2224432377736627`, 
    1.5923062219720623`}}], 
   ArrowBox[{{0.5714285714285714, 0.8571428571428571}, {1.2208427618054936`, 
    1.721326241472823}}], 
   ArrowBox[{{0.5714285714285714, 0.9285714285714286}, {1.217979545611254, 
    1.8526479638721611`}}], 
   ArrowBox[{{0.5714285714285714, 1.}, {1.213803961698448, 
    1.9860866996591664`}}], 
   ArrowBox[{{0.6428571428571429, 0.}, {1.3198780579175367`, 
    0.3559694894245381}}], 
   ArrowBox[{{0.6428571428571429, 0.07142857142857142}, {1.32313733986162, 
    0.4555951267200081}}], 
   ArrowBox[{{0.6428571428571429, 0.14285714285714285`}, {1.3264350704801355`,
     0.5574681142633113}}], 
   ArrowBox[{{0.6428571428571429, 0.21428571428571427`}, {1.3296966216115007`,
     0.6617197770005746}}], 
   ArrowBox[{{0.6428571428571429, 0.2857142857142857}, {1.332831406161869, 
    0.7684703292442395}}], 
   ArrowBox[{{0.6428571428571429, 0.35714285714285715`}, {1.3357335061951154`,
     0.877823711099925}}], 
   ArrowBox[{{0.6428571428571429, 0.42857142857142855`}, {1.3382834105762718`,
     0.9898623109812583}}], 
   ArrowBox[{{0.6428571428571429, 0.5}, {1.340350943704754, 
    1.1046419611675486`}}], 
   ArrowBox[{{0.6428571428571429, 0.5714285714285714}, {1.3417993456778599`, 
    1.222187641639281}}], 
   ArrowBox[{{0.6428571428571429, 0.6428571428571429}, {1.3424903237727746`, 
    1.3424903237727746`}}], 
   ArrowBox[{{0.6428571428571429, 0.7142857142857143}, {1.3422897574663906`, 
    1.4655053203702701`}}], 
   ArrowBox[{{0.6428571428571429, 0.7857142857142857}, {1.341073629940335, 
    1.591152384072088}}], 
   ArrowBox[{{0.6428571428571429, 0.8571428571428571}, {1.3387337011698652`, 
    1.7193176276699582`}}], 
   ArrowBox[{{0.6428571428571429, 0.9285714285714286}, {1.3351824453740166`, 
    1.849857153232059}}], 
   ArrowBox[{{0.6428571428571429, 1.}, {1.3303568497030078`, 
    1.982602103299734}}], 
   ArrowBox[{{0.7142857142857143, 0.}, {1.4522985561100037`, 
    0.3612880313610058}}], 
   ArrowBox[{{0.7142857142857143, 0.07142857142857142}, {1.4545288203058826`, 
    0.46063953173771877`}}], 
   ArrowBox[{{0.7142857142857143, 0.14285714285714285`}, {1.4567622687034063`,
     0.5621471083026937}}], 
   ArrowBox[{{0.7142857142857143, 0.21428571428571427`}, {1.4589364730801528`,
     0.6659392302728181}}], 
   ArrowBox[{{0.7142857142857143, 0.2857142857142857}, {1.460974637221034, 
    0.7721366139401493}}], 
   ArrowBox[{{0.7142857142857143, 0.35714285714285715`}, {1.4627855455894418`,
     0.8808476333359931}}], 
   ArrowBox[{{0.7142857142857143, 0.42857142857142855`}, {1.4642644179543511`,
     0.9921633946684478}}], 
   ArrowBox[{{0.7142857142857143, 0.5}, {1.465294816274167, 
    1.1061527743774606`}}], 
   ArrowBox[{{0.7142857142857143, 0.5714285714285714}, {1.465751663888421, 
    1.2228577955539417`}}], 
   ArrowBox[{{0.7142857142857143, 0.6428571428571429}, {1.4655053203702701`, 
    1.3422897574663906`}}], 
   ArrowBox[{{0.7142857142857143, 0.7142857142857143}, {1.4644265224289565`, 
    1.4644265224289565`}}], 
   ArrowBox[{{0.7142857142857143, 0.7857142857142857}, {1.4623918732935004`, 
    1.5892112950626809`}}], 
   ArrowBox[{{0.7142857142857143, 0.8571428571428571}, {1.4592894643267278`, 
    1.7165531042557551`}}], 
   ArrowBox[{{0.7142857142857143, 0.9285714285714286}, {1.4550241645660673`, 
    1.8463290333678537`}}], 
   ArrowBox[{{0.7142857142857143, 1.}, {1.4495221289425395`, 
    1.9783880649912948`}}], 
   ArrowBox[{{0.7857142857142857, 0.}, {1.5865444401609647`, 
    0.3650135940934985}}], 
   ArrowBox[{{0.7857142857142857, 0.07142857142857142}, {1.5878809060471477`, 
    0.4641225499875131}}], 
   ArrowBox[{{0.7857142857142857, 0.14285714285714285`}, {1.5891795826942285`,
     0.5653095740508994}}], 
   ArrowBox[{{0.7857142857142857, 0.21428571428571427`}, {1.5903871975451929`,
     0.6686990898853793}}], 
   ArrowBox[{{0.7857142857142857, 0.2857142857142857}, {1.5914378756801701`, 
    0.7744103462823251}}], 
   ArrowBox[{{0.7857142857142857, 0.35714285714285715`}, {1.592252652830567, 
    0.8825534508797239}}], 
   ArrowBox[{{0.7857142857142857, 0.42857142857142855`}, {1.592739685017015, 
    0.9932249374277469}}], 
   ArrowBox[{{0.7857142857142857, 0.5}, {1.5927953297135873`, 
    1.1065030782369707`}}], 
   ArrowBox[{{0.7857142857142857, 0.5714285714285714}, {1.5923062219720623`, 
    1.2224432377736627`}}], 
   ArrowBox[{{0.7857142857142857, 0.6428571428571429}, {1.591152384072088, 
    1.341073629940335}}], 
   ArrowBox[{{0.7857142857142857, 0.7142857142857143}, {1.5892112950626809`, 
    1.4623918732935004`}}], 
   ArrowBox[{{0.7857142857142857, 0.7857142857142857}, {1.5863627210851383`, 
    1.5863627210851383`}}], 
   ArrowBox[{{0.7857142857142857, 0.8571428571428571}, {1.5824939891206098`, 
    1.7129172697550916`}}], 
   ArrowBox[{{0.7857142857142857, 0.9285714285714286}, {1.577505298713121, 
    1.8419538244394222`}}], 
   ArrowBox[{{0.7857142857142857, 1.}, {1.5713146279622696`, 
    1.9733404390657492`}}], 
   ArrowBox[{{0.8571428571428571, 0.}, {1.7223931741015397`, 
    0.3671887392306391}}], 
   ArrowBox[{{0.8571428571428571, 0.07142857142857142}, {1.7229685831444992`, 
    0.4660667582546326}}], 
   ArrowBox[{{0.8571428571428571, 0.14285714285714285`}, {1.7234632559842917`,
     0.5669570686140204}}], 
   ArrowBox[{{0.8571428571428571, 0.21428571428571427`}, {1.7238303450825745`,
     0.6699796163640802}}], 
   ArrowBox[{{0.8571428571428571, 0.2857142857142857}, {1.7240121263869792`, 
    0.7752510714680649}}], 
   ArrowBox[{{0.8571428571428571, 0.35714285714285715`}, {1.7239392782801874`,
     0.8828814622918317}}], 
   ArrowBox[{{0.8571428571428571, 0.42857142857142855`}, {1.7235306684401002`,
     0.9929702878192985}}], 
   ArrowBox[{{0.8571428571428571, 0.5}, {1.7226938244445877`, 
    1.1056022415195006`}}], 
   ArrowBox[{{0.8571428571428571, 0.5714285714285714}, {1.721326241472823, 
    1.2208427618054936`}}], 
   ArrowBox[{{0.8571428571428571, 0.6428571428571429}, {1.7193176276699582`, 
    1.3387337011698652`}}], 
   ArrowBox[{{0.8571428571428571, 0.7142857142857143}, {1.7165531042557551`, 
    1.4592894643267278`}}], 
   ArrowBox[{{0.8571428571428571, 0.7857142857142857}, {1.7129172697550916`, 
    1.5824939891206098`}}], 
   ArrowBox[{{0.8571428571428571, 0.8571428571428571}, {1.7082989197413203`, 
    1.7082989197413203`}}], 
   ArrowBox[{{0.8571428571428571, 0.9285714285714286}, {1.7025961049477196`, 
    1.8366232444475021`}}], 
   ArrowBox[{{0.8571428571428571, 1.}, {1.6957211330995143`, 
    1.9673545446230896`}}], 
   ArrowBox[{{0.9285714285714286, 0.}, {1.8596336398895268`, 
    0.3678792165920683}}], 
   ArrowBox[{{0.9285714285714286, 0.07142857142857142}, {1.8595745034903244`, 
    0.4665209956658938}}], 
   ArrowBox[{{0.9285714285714286, 0.14285714285714285`}, {1.8593927261280336`,
     0.5671199224157668}}], 
   ArrowBox[{{0.9285714285714286, 0.21428571428571427`}, {1.8590456059214362`,
     0.6697915872405277}}], 
   ArrowBox[{{0.9285714285714286, 0.2857142857142857}, {1.8584811074709209`, 
    0.7746496586772609}}], 
   ArrowBox[{{0.9285714285714286, 0.35714285714285715`}, {1.857637055228766, 
    0.8818030530507506}}], 
   ArrowBox[{{0.9285714285714286, 0.42857142857142855`}, {1.856440680880205, 
    0.9913525783013386}}], 
   ArrowBox[{{0.9285714285714286, 0.5}, {1.8548086840496332`, 
    1.1033871247588731`}}], 
   ArrowBox[{{0.9285714285714286, 0.5714285714285714}, {1.8526479638721611`, 
    1.217979545611254}}], 
   ArrowBox[{{0.9285714285714286, 0.6428571428571429}, {1.849857153232059, 
    1.3351824453740166`}}], 
   ArrowBox[{{0.9285714285714286, 0.7142857142857143}, {1.8463290333678537`, 
    1.4550241645660673`}}], 
   ArrowBox[{{0.9285714285714286, 0.7857142857142857}, {1.8419538244394222`, 
    1.577505298713121}}], 
   ArrowBox[{{0.9285714285714286, 0.8571428571428571}, {1.8366232444475021`, 
    1.7025961049477196`}}], 
   ArrowBox[{{0.9285714285714286, 0.9285714285714286}, {1.8302351183975023`, 
    1.8302351183975023`}}], 
   ArrowBox[{{0.9285714285714286, 1.}, {1.8226982207748295`, 
    1.9603292191399126`}}], 
   ArrowBox[{{1., 0.}, {1.998069370329696, 0.3671692022072219}}], 
   ArrowBox[{{1., 0.07142857142857142}, {1.9974932242178252`, 
    0.4655558611202574}}], 
   ArrowBox[{{1., 0.14285714285714285`}, {1.9967558328791082`, 
    0.5658532521011483}}], 
   ArrowBox[{{1., 0.21428571428571427`}, {1.995816869111568, 
    0.668173086576901}}], 
   ArrowBox[{{1., 0.2857142857142857}, {1.9946279558585802`, 
    0.772626105867035}}], 
   ArrowBox[{{1., 0.35714285714285715`}, {1.9931318698592666`, 
    0.8793197009904417}}], 
   ArrowBox[{{1., 0.42857142857142855`}, {1.9912619840705523`, 
    0.9883550346334362}}], 
   ArrowBox[{{1., 0.5}, {1.9889420834802225`, 1.0998236943108455`}}], 
   ArrowBox[{{1., 0.5714285714285714}, {1.9860866996591664`, 
    1.213803961698448}}], 
   ArrowBox[{{1., 0.6428571428571429}, {1.982602103299734, 
    1.3303568497030078`}}], 
   ArrowBox[{{1., 0.7142857142857143}, {1.9783880649912948`, 
    1.4495221289425395`}}], 
   ArrowBox[{{1., 0.7857142857142857}, {1.9733404390657492`, 
    1.5713146279622696`}}], 
   ArrowBox[{{1., 0.8571428571428571}, {1.9673545446230896`, 
    1.6957211330995143`}}], 
   ArrowBox[{{1., 0.9285714285714286}, {1.9603292191399126`, 
    1.8226982207748295`}}], 
   ArrowBox[{{1., 1.}, {1.952171317053684, 1.952171317053684}}]}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->412982039]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13440],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["VectorFieldPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/VectorFieldPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MaxArrowLength",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/MaxArrowLength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScaleFactor",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/ScaleFactor"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11711]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ScaleFunction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 48.2172890}", "context" -> 
    "VectorFieldPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Field Plots Package Symbol", "language" -> "en", "paclet" -> 
    "VectorFieldPlots Package", "status" -> "None", "summary" -> 
    "ScaleFunction is an option for the vector field visualization functions \
that rescales each vector to a length determined by applying a pure function \
to the current length of that vector.", "synonyms" -> {}, "title" -> 
    "ScaleFunction", "type" -> "Symbol", "uri" -> 
    "VectorFieldPlots/ref/ScaleFunction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3186, 111, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->136778080]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 52403, 1126}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 895, 20, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1518, 47, 51, 1, 70, "ObjectName",
 CellID->17684],
Cell[1572, 50, 488, 13, 70, "Usage",
 CellID->23301]
}, Open  ]],
Cell[CellGroupData[{
Cell[2097, 68, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2575, 85, 141, 4, 70, "Notes",
 CellID->714852497],
Cell[2719, 91, 430, 15, 70, "Notes",
 CellID->188385097]
}, Closed]],
Cell[CellGroupData[{
Cell[3186, 111, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->136778080],
Cell[CellGroupData[{
Cell[3571, 125, 148, 5, 70, "ExampleSection",
 CellID->282114342],
Cell[3722, 132, 141, 4, 70, "Input",
 CellID->420153047],
Cell[3866, 138, 97, 1, 70, "ExampleText",
 CellID->669243486],
Cell[CellGroupData[{
Cell[3988, 143, 466, 13, 28, "Input",
 CellID->1264639680],
Cell[4457, 158, 22129, 421, 201, "Output",
 CellID->321982369]
}, Open  ]],
Cell[26601, 582, 78, 1, 70, "ExampleText",
 CellID->1603409863],
Cell[CellGroupData[{
Cell[26704, 587, 524, 14, 70, "Input",
 CellID->655587138],
Cell[27231, 603, 22825, 448, 201, "Output",
 CellID->412982039]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[50117, 1058, 311, 9, 70, "SeeAlsoSection",
 CellID->13440],
Cell[50431, 1069, 779, 26, 70, "SeeAlso",
 CellID->11711]
}, Open  ]],
Cell[51225, 1098, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

