(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23305,        610]
NotebookOptionsPosition[     20699,        530]
NotebookOutlinePosition[     22202,        569]
CellTagsIndexPosition[     22117,        564]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR FIELD PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"VectorFieldPlot3D" :> 
         Documentation`HelpLookup[
          "paclet:VectorFieldPlots/ref/VectorFieldPlot3D"], 
         "ListVectorFieldPlot" :> 
         Documentation`HelpLookup[
          "paclet:VectorFieldPlots/ref/ListVectorFieldPlot"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"VectorFieldPlot3D\"\>", 
      2->"\<\"ListVectorFieldPlot\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["VectorFieldPlot", "ObjectName",
 CellID->18616],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"VectorFieldPlot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["x", "TI"]], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["y", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["y", "TI"], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a plot of the vector field given by the \
vector valued function ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["x", "TI"]], ",", 
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["y", "TI"]]}], "}"}]], "InlineFormula"],
     " as a function of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"VectorFieldPlot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["x", "TI"]], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["y", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["dx", "TI"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["y", "TI"], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["dy", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]uses steps ",
     Cell[BoxData[
      StyleBox["dx", "TI"]], "InlineFormula"],
     " in variable ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", and steps ",
     Cell[BoxData[
      StyleBox["dy", "TI"]], "InlineFormula"],
     " in variable ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->22499]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["VectorFieldPlot"], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", with the following additions and changes:"
}], "Notes",
 CellID->23168],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ColorFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunction"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["\<\
a function to use for coloring the vectors by their magnitude\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MaxArrowLength",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorFieldPlots/ref/MaxArrowLength"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "length of the largest vector to be drawn, applied after the ",
     Cell[BoxData[
      ButtonBox["ScaleFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorFieldPlots/ref/ScaleFunction"]], 
      "InlineFormula"],
     ", but before the ",
     Cell[BoxData[
      ButtonBox["ScaleFactor",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorFieldPlots/ref/ScaleFactor"]], 
      "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotPoints",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotPoints"], "15", Cell[
    "the number of evaluation points in each direction", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ScaleFactor",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorFieldPlots/ref/ScaleFactor"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "linearly rescales the vectors so the longest vector is equal to this \
value; ",
     Cell[BoxData[
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
     " fits the vectors in the mesh, ",
     Cell[BoxData[
      ButtonBox["None",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/None"]], "InlineFormula"],
     " eliminates the rescaling"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ScaleFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorFieldPlots/ref/ScaleFunction"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "a function to use for rescaling the magnitude of vectors", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->18299]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->24973250],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->82602386],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorFieldPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->64782041],

Cell[TextData[{
 "Field plot of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{"sin", "(", "x", ")"}], ",", 
     RowBox[{"cos", "(", "y", ")"}]}], "}"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->172224226],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorFieldPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "y", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1163372847],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 189},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->44471315]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28484],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["VectorFieldPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/VectorFieldPlot3D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListVectorFieldPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/ListVectorFieldPlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28004]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"VectorFieldPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 49.5610734}", "context" -> 
    "VectorFieldPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Field Plots Package Symbol", "language" -> "en", "paclet" -> 
    "VectorFieldPlots Package", "status" -> "None", "summary" -> 
    "VectorFieldPlot[{f_x, f_y}, {x, x_min, x_max}, {y, y_min, y_max}] \
generates a plot of the vector field given by the vector valued function \
{f_x, f_y} as a function of x and y. VectorFieldPlot[{f_x, f_y}, {x, x_min, \
x_max, dx}, {y, y_min, y_max, dy}] uses steps dx in variable x, and steps dy \
in variable y.", "synonyms" -> {}, "title" -> "VectorFieldPlot", "type" -> 
    "Symbol", "uri" -> "VectorFieldPlots/ref/VectorFieldPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7937, 257, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->24973250]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21975, 557}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 793, 19, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1416, 46, 53, 1, 70, "ObjectName",
 CellID->18616],
Cell[1472, 49, 3053, 101, 70, "Usage",
 CellID->22499]
}, Open  ]],
Cell[CellGroupData[{
Cell[4562, 155, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5040, 172, 292, 9, 70, "Notes",
 CellID->23168],
Cell[5335, 183, 2565, 69, 70, "3ColumnTableMod",
 CellID->18299]
}, Closed]],
Cell[CellGroupData[{
Cell[7937, 257, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->24973250],
Cell[CellGroupData[{
Cell[8321, 271, 147, 5, 70, "ExampleSection",
 CellID->82602386],
Cell[8471, 278, 140, 4, 70, "Input",
 CellID->64782041],
Cell[8614, 284, 260, 11, 70, "ExampleText",
 CellID->172224226],
Cell[CellGroupData[{
Cell[8899, 299, 452, 14, 28, "Input",
 CellID->1163372847],
Cell[9354, 315, 10403, 175, 210, "Output",
 Evaluatable->False,
 CellID->44471315]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19818, 497, 311, 9, 70, "SeeAlsoSection",
 CellID->28484],
Cell[20132, 508, 525, 17, 70, "SeeAlso",
 CellID->28004]
}, Open  ]],
Cell[20672, 528, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

