(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29625,        763]
NotebookOptionsPosition[     26622,        671]
NotebookOutlinePosition[     28224,        711]
CellTagsIndexPosition[     28139,        706]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR FIELD PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"VectorFieldPlot" :> 
         Documentation`HelpLookup[
          "paclet:VectorFieldPlots/ref/VectorFieldPlot"], 
         "ListVectorFieldPlot3D" :> 
         Documentation`HelpLookup[
          "paclet:VectorFieldPlots/ref/ListVectorFieldPlot3D"], "VectorHeads" :> 
         Documentation`HelpLookup[
          "paclet:VectorFieldPlots/ref/VectorHeads"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"VectorFieldPlot\"\>", 
      2->"\<\"ListVectorFieldPlot3D\"\>", 
      3->"\<\"VectorHeads\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["VectorFieldPlot3D", "ObjectName",
 CellID->2171],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"VectorFieldPlot3D", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["x", "TI"]], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["y", "TI"]], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["z", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["y", "TI"], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["z", "TI"], ",", 
          SubscriptBox[
           StyleBox["z", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["z", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a three-dimensional plot of the vector field \
given by the vector-valued function ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["x", "TI"]], ",", 
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["y", "TI"]], ",", 
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["z", "TI"]]}], "}"}]], "InlineFormula"],
     " as a function of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"VectorFieldPlot3D", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["x", "TI"]], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["y", "TI"]], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["z", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["dx", "TI"]}], "}"}], ",", 
        RowBox[{
         StyleBox["{", "TR"], 
         RowBox[{
          StyleBox["y", "TR"], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["dy", "TI"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["z", "TI"], ",", 
          SubscriptBox[
           StyleBox["z", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["z", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["dz", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]uses steps ",
     Cell[BoxData[
      StyleBox["dx", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["dy", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["dz", "TI"]], "InlineFormula"],
     " for variables ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     " respectively."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->27795]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Variables ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " are coordinates in a Cartesian coordinate system."
}], "Notes",
 CellID->28931],

Cell[TextData[{
 Cell[BoxData["VectorFieldPlot3D"], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 ", with the following additions and changes:"
}], "Notes",
 CellID->5310],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ScaleFactor",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorFieldPlots/ref/ScaleFactor"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "the scale of the vectors to the mesh; ",
     Cell[BoxData[
      ButtonBox["Max",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Max"]], "InlineFormula"],
     " ensures that the largest vector fits in the mesh"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ScaleFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorFieldPlots/ref/ScaleFunction"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "function to rescale the length of vectors", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MaxArrowLength",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorFieldPlots/ref/MaxArrowLength"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "determines the largest vector to be drawn", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ColorFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunction"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["the colors to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["VectorHeads",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorFieldPlots/ref/VectorHeads"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to draw vectors with heads", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotPoints",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotPoints"], "7", Cell[
    "number of evalution points in each direction", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->3290]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->7435007],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->284166672],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorFieldPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->62491204],

Cell[TextData[{
 "A field radiating from ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2057594804],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorFieldPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "y", ",", " ", "z"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "0", ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1021106617],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->145418078]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["VectorHeads",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/VectorHeads"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " draws arrowheads on the vectors:"
}], "ExampleText",
 CellID->1066703187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorFieldPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "y", ",", " ", "z"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"VectorHeads", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->949995113],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->13825194]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32333],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["VectorFieldPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/VectorFieldPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListVectorFieldPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/ListVectorFieldPlot3D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VectorHeads",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorFieldPlots/ref/VectorHeads"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31875]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"VectorFieldPlot3D - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 49.0298098}", "context" -> 
    "VectorFieldPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Field Plots Package Symbol", "language" -> "en", "paclet" -> 
    "VectorFieldPlots Package", "status" -> "None", "summary" -> 
    "VectorFieldPlot3D[{f_x, f_y, f_z}, {x, x_min, x_max}, {y, y_min, y_max}, \
{z, z_min, z_max}] generates a three-dimensional plot of the vector field \
given by the vector-valued function {f_x, f_y, f_z} as a function of x and y \
and z. VectorFieldPlot3D[{f_x, f_y, f_z}, {x, x_min, x_max, dx}, {y, y_min, \
y_max, dy}, {z, z_min, z_max, dz}] uses steps dx, dy and dz for variables x, \
y and z respectively.", "synonyms" -> {}, "title" -> "VectorFieldPlot3D", 
    "type" -> "Symbol", "uri" -> "VectorFieldPlots/ref/VectorFieldPlot3D"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9197, 300, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->7435007]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 27998, 699}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 933, 22, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1556, 49, 54, 1, 70, "ObjectName",
 CellID->2171],
Cell[1613, 52, 4217, 139, 70, "Usage",
 CellID->27795]
}, Open  ]],
Cell[CellGroupData[{
Cell[5867, 196, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6345, 213, 301, 12, 70, "Notes",
 CellID->28931],
Cell[6649, 227, 297, 9, 70, "Notes",
 CellID->5310],
Cell[6949, 238, 2211, 57, 70, "3ColumnTableMod",
 CellID->3290]
}, Closed]],
Cell[CellGroupData[{
Cell[9197, 300, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->7435007],
Cell[CellGroupData[{
Cell[9580, 314, 148, 5, 70, "ExampleSection",
 CellID->284166672],
Cell[9731, 321, 140, 4, 70, "Input",
 CellID->62491204],
Cell[9874, 327, 183, 7, 70, "ExampleText",
 CellID->2057594804],
Cell[CellGroupData[{
Cell[10082, 338, 448, 12, 28, "Input",
 CellID->1021106617],
Cell[10533, 352, 6552, 111, 216, "Output",
 Evaluatable->False,
 CellID->145418078]
}, Open  ]],
Cell[17100, 466, 337, 11, 70, "ExampleText",
 CellID->1066703187],
Cell[CellGroupData[{
Cell[17462, 481, 505, 13, 28, "Input",
 CellID->949995113],
Cell[17970, 496, 7442, 126, 216, "Output",
 Evaluatable->False,
 CellID->13825194]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25473, 629, 311, 9, 70, "SeeAlsoSection",
 CellID->32333],
Cell[25787, 640, 793, 26, 70, "SeeAlso",
 CellID->31875]
}, Open  ]],
Cell[26595, 669, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

