(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20787,        648]
NotebookOptionsPosition[     17653,        541]
NotebookOutlinePosition[     18934,        578]
CellTagsIndexPosition[     18849,        573]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["XML PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Capabilities" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/Overview"], 
          "Working with MathML" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/MathML"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"XML Capabilities\"\>", 
       2->"\<\"Working with MathML\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BoxesToMathML" :> 
          Documentation`HelpLookup["paclet:XML/ref/BoxesToMathML"], 
          "MathMLToBoxes" :> 
          Documentation`HelpLookup["paclet:XML/ref/MathMLToBoxes"], 
          "ExpressionToMathML" :> 
          Documentation`HelpLookup["paclet:XML/ref/ExpressionToMathML"], 
          "MathMLToExpression" :> 
          Documentation`HelpLookup["paclet:XML/ref/MathMLToExpression"], 
          "ExpressionToSymbolicMathML" :> 
          Documentation`HelpLookup[
           "paclet:XML/ref/ExpressionToSymbolicMathML"], 
          "SymbolicMathMLToExpression" :> 
          Documentation`HelpLookup[
           "paclet:XML/ref/SymbolicMathMLToExpression"], 
          "SymbolicMathMLToBoxes" :> 
          Documentation`HelpLookup[
           "paclet:XML/ref/SymbolicMathMLToBoxes"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"BoxesToMathML\"\>", 2->"\<\"MathMLToBoxes\"\>", 
       3->"\<\"ExpressionToMathML\"\>", 4->"\<\"MathMLToExpression\"\>", 
       5->"\<\"ExpressionToSymbolicMathML\"\>", 
       6->"\<\"SymbolicMathMLToExpression\"\>", 
       7->"\<\"SymbolicMathMLToBoxes\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Package" :> 
          Documentation`HelpLookup["paclet:XML/guide/XMLPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BoxesToSymbolicMathML", "ObjectName",
 CellID->15377],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"BoxesToSymbolicMathML", "[", 
       StyleBox["boxes", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]converts the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " box structure, ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"],
     ", into a MathML-flavored SymbolicXML structure."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1052]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given: ", "Notes",
 CellID->565],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Annotations\>\"", 
    RowBox[{"{", "}"}], Cell[TextData[{
     "annotations to add to the output (acceptable values are combinations of \
\n",
     Cell[BoxData["\"\<DocumentHeader\>\""], "InlineFormula"],
     ", ",
     Cell[BoxData["\"\<XMLDeclaration\>\""], "InlineFormula"],
     ", and ",
     Cell[BoxData["\"\<DOCTYPEDeclaration\>\""], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Formats\>\"", 
    RowBox[{"{", "\"\<PresentationMathML\>\"", "}"}], Cell[
    "type of MathML markup to generate", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<IncludeMarkupAnnotations\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether to add annotation when exporting a formula with constructs \
specific to ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " and no clear counterpart in MathML"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MathAttributes\>\"", 
    RowBox[{"{", "}"}], Cell[
    "attributes to add to the root element of the MathML", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UseUnicodePlane1Characters\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether to replace plane 1 Unicode characters with similar plane 0 characters\
\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->19891]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->59259621],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->876501595],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<XML`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->691635672],

Cell["Generate some MathML-flavored SymbolicXML:", "ExampleText",
 CellID->6648],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpressionToSymbolicMathML", "[", 
  RowBox[{"x", " ", "+", " ", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26804],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{"\<\"math\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"xmlns\"\>", 
     "\[Rule]", "\<\"http://www.w3.org/1998/Math/MathML\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"XMLElement", "[", 
     RowBox[{"\<\"semantics\"\>", ",", 
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"mrow\"\>", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"XMLElement", "[", 
             RowBox[{"\<\"mi\"\>", ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"x\"\>", "}"}]}], "]"}], ",", 
            RowBox[{"XMLElement", "[", 
             RowBox[{"\<\"mo\"\>", ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"+\"\>", "}"}]}], "]"}], ",", 
            RowBox[{"XMLElement", "[", 
             RowBox[{"\<\"mn\"\>", ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"1\"\>", "}"}]}], "]"}]}], "}"}]}], "]"}], ",",
         
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"annotation-xml\"\>", ",", 
          RowBox[{"{", 
           RowBox[{"\<\"encoding\"\>", "\[Rule]", "\<\"MathML-Content\"\>"}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"apply\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"XMLElement", "[", 
                RowBox[{"\<\"plus\"\>", ",", 
                 RowBox[{"{", "}"}], ",", 
                 RowBox[{"{", "}"}]}], "]"}], ",", 
               RowBox[{"XMLElement", "[", 
                RowBox[{"\<\"ci\"\>", ",", 
                 RowBox[{"{", "}"}], ",", 
                 RowBox[{"{", "\<\"x\"\>", "}"}]}], "]"}], ",", 
               RowBox[{"XMLElement", "[", 
                RowBox[{"\<\"cn\"\>", ",", 
                 RowBox[{"{", 
                  RowBox[{"\<\"type\"\>", "\[Rule]", "\<\"integer\"\>"}], 
                  "}"}], ",", 
                 RowBox[{"{", "\<\"1\"\>", "}"}]}], "]"}]}], "}"}]}], "]"}], 
           "}"}]}], "]"}]}], "}"}]}], "]"}], "}"}]}], "]"}]], "Output",
 ImageSize->{556, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27834]
}, Open  ]],

Cell[TextData[{
 "Use the result to convert the data into a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " box expression:"
}], "ExampleText",
 CellID->19368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymbolicMathMLToBoxes", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->31441],

Cell[BoxData[
 RowBox[{"FormBox", "[", 
  RowBox[{
   RowBox[{"TagBox", "[", 
    RowBox[{
     RowBox[{"TagBox", "[", 
      RowBox[{
       RowBox[{"RowBox", "[", 
        RowBox[{"{", 
         RowBox[{"\<\"x\"\>", ",", "\<\"+\"\>", ",", "\<\"1\"\>"}], "}"}], 
        "]"}], ",", "\<\"MathMLPresentationTag\"\>", ",", 
       RowBox[{"AutoDelete", "\[Rule]", "True"}]}], "]"}], ",", 
     RowBox[{"\<\"AnnotationsTagWrapper\"\>", "[", 
      RowBox[{"TagBox", "[", 
       RowBox[{
        RowBox[{"RowBox", "[", 
         RowBox[{"{", 
          RowBox[{"\<\"x\"\>", ",", "\<\"+\"\>", ",", "\<\"1\"\>"}], "}"}], 
         "]"}], ",", "\<\"MathMLContentTag\"\>", ",", 
        RowBox[{"AutoDelete", "\[Rule]", "True"}]}], "]"}], "]"}], ",", 
     RowBox[{"AutoDelete", "\[Rule]", "True"}]}], "]"}], ",", 
   "TraditionalForm"}], "]"}]], "Output",
 ImageSize->{569, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->8872]
}, Open  ]],

Cell["Recover the SymbolicMathML:", "ExampleText",
 CellID->32668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxesToSymbolicMathML", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->19974],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{"\<\"math\"\>", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\<\"xmlns\"\>", 
      "\[Rule]", "\<\"http://www.w3.org/1998/Math/MathML\"\>"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\<\"http://www.wolfram.com/XML/\"\>", ",", "\<\"form\"\>"}], 
       "}"}], "\[Rule]", "\<\"TraditionalForm\"\>"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
        ",", "\<\"mathematica\"\>"}], "}"}], 
      "\[Rule]", "\<\"http://www.wolfram.com/XML/\"\>"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"XMLElement", "[", 
     RowBox[{"\<\"semantics\"\>", ",", 
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"mrow\"\>", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"XMLElement", "[", 
             RowBox[{"\<\"mi\"\>", ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"x\"\>", "}"}]}], "]"}], ",", 
            RowBox[{"XMLElement", "[", 
             RowBox[{"\<\"mo\"\>", ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"+\"\>", "}"}]}], "]"}], ",", 
            RowBox[{"XMLElement", "[", 
             RowBox[{"\<\"mn\"\>", ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"1\"\>", "}"}]}], "]"}]}], "}"}]}], "]"}], ",",
         
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"annotation-xml\"\>", ",", 
          RowBox[{"{", 
           RowBox[{"\<\"encoding\"\>", "\[Rule]", "\<\"MathML-Content\"\>"}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"apply\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"XMLElement", "[", 
                RowBox[{"\<\"plus\"\>", ",", 
                 RowBox[{"{", "}"}], ",", 
                 RowBox[{"{", "}"}]}], "]"}], ",", 
               RowBox[{"XMLElement", "[", 
                RowBox[{"\<\"ci\"\>", ",", 
                 RowBox[{"{", "}"}], ",", 
                 RowBox[{"{", "\<\"x\"\>", "}"}]}], "]"}], ",", 
               RowBox[{"XMLElement", "[", 
                RowBox[{"\<\"cn\"\>", ",", 
                 RowBox[{"{", 
                  RowBox[{"\<\"type\"\>", "\[Rule]", "\<\"integer\"\>"}], 
                  "}"}], ",", 
                 RowBox[{"{", "\<\"1\"\>", "}"}]}], "]"}]}], "}"}]}], "]"}], 
           "}"}]}], "]"}]}], "}"}]}], "]"}], "}"}]}], "]"}]], "Output",
 ImageSize->{556, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->19176]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13787],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BoxesToMathML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/BoxesToMathML",
    ButtonNote->"ObsLink: No successor for BoxesToMathML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathMLToBoxes",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/MathMLToBoxes",
    ButtonNote->"ObsLink: No successor for MathMLToBoxes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpressionToMathML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ExpressionToMathML",
    ButtonNote->"ObsLink: No successor for ExpressionToMathML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathMLToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/MathMLToExpression",
    ButtonNote->"ObsLink: No successor for MathMLToExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpressionToSymbolicMathML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ExpressionToSymbolicMathML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymbolicMathMLToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/SymbolicMathMLToExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymbolicMathMLToBoxes",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/SymbolicMathMLToBoxes"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27224]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->138],

Cell[TextData[ButtonBox["XML Capabilities",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/Overview"]], "Tutorials",
 CellID->31597],

Cell[TextData[ButtonBox["Working with MathML",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/MathML"]], "Tutorials",
 CellID->419751524]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->69135799],

Cell[TextData[ButtonBox["XML Package",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/guide/XMLPackage"]], "MoreAbout",
 CellID->165143]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BoxesToSymbolicMathML - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 14, 22.1087816}", "context" -> "XML`", 
    "keywords" -> {}, "index" -> True, "label" -> "XML Package Symbol", 
    "language" -> "en", "paclet" -> "XML Package", "status" -> "None", 
    "summary" -> 
    "BoxesToSymbolicMathML[boxes] converts the Mathematica box structure, \
boxes, into a MathML-flavored SymbolicXML structure.", "synonyms" -> {}, 
    "title" -> "BoxesToSymbolicMathML", "type" -> "Symbol", "uri" -> 
    "XML/ref/BoxesToSymbolicMathML"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6417, 185, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->59259621]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18707, 566}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2797, 66, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3420, 93, 59, 1, 70, "ObjectName",
 CellID->15377],
Cell[3482, 96, 590, 18, 70, "Usage",
 CellID->1052]
}, Open  ]],
Cell[CellGroupData[{
Cell[4109, 119, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4587, 136, 67, 1, 70, "Notes",
 CellID->565],
Cell[4657, 139, 1723, 41, 70, "3ColumnTableMod",
 CellID->19891]
}, Closed]],
Cell[CellGroupData[{
Cell[6417, 185, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->59259621],
Cell[CellGroupData[{
Cell[6801, 199, 148, 5, 70, "ExampleSection",
 CellID->876501595],
Cell[6952, 206, 126, 3, 70, "Input",
 CellID->691635672],
Cell[7081, 211, 80, 1, 70, "ExampleText",
 CellID->6648],
Cell[CellGroupData[{
Cell[7186, 216, 151, 4, 28, "Input",
 CellID->26804],
Cell[7340, 222, 2374, 60, 122, "Output",
 CellID->27834]
}, Open  ]],
Cell[9729, 285, 166, 6, 70, "ExampleText",
 CellID->19368],
Cell[CellGroupData[{
Cell[9920, 295, 113, 3, 70, "Input",
 CellID->31441],
Cell[10036, 300, 976, 26, 71, "Output",
 CellID->8872]
}, Open  ]],
Cell[11027, 329, 66, 1, 70, "ExampleText",
 CellID->32668],
Cell[CellGroupData[{
Cell[11118, 334, 113, 3, 70, "Input",
 CellID->19974],
Cell[11234, 339, 2764, 70, 156, "Output",
 CellID->19176]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14059, 416, 311, 9, 70, "SeeAlsoSection",
 CellID->13787],
Cell[14373, 427, 2108, 66, 70, "SeeAlso",
 CellID->27224]
}, Open  ]],
Cell[CellGroupData[{
Cell[16518, 498, 312, 9, 70, "TutorialsSection",
 CellID->138],
Cell[16833, 509, 139, 3, 70, "Tutorials",
 CellID->31597],
Cell[16975, 514, 144, 3, 70, "Tutorials",
 CellID->419751524]
}, Open  ]],
Cell[CellGroupData[{
Cell[17156, 522, 318, 9, 70, "MoreAboutSection",
 CellID->69135799],
Cell[17477, 533, 134, 3, 70, "MoreAbout",
 CellID->165143]
}, Open  ]],
Cell[17626, 539, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

