(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14508,        458]
NotebookOptionsPosition[     11894,        371]
NotebookOutlinePosition[     13172,        408]
CellTagsIndexPosition[     13087,        403]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["OBSOLETE  XML PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Capabilities" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/Overview"], 
          "Working with MathML" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/MathML"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"XML Capabilities\"\>", 
       2->"\<\"Working with MathML\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BoxesToMathML" :> 
          Documentation`HelpLookup["paclet:XML/ref/BoxesToMathML"], 
          "MathMLToBoxes" :> 
          Documentation`HelpLookup["paclet:XML/ref/MathMLToBoxes"], 
          "MathMLToExpression" :> 
          Documentation`HelpLookup["paclet:XML/ref/MathMLToExpression"], 
          "ExpressionToSymbolicMathML" :> 
          Documentation`HelpLookup[
           "paclet:XML/ref/ExpressionToSymbolicMathML"], 
          "SymbolicMathMLToExpression" :> 
          Documentation`HelpLookup[
           "paclet:XML/ref/SymbolicMathMLToExpression"], 
          "BoxesToSymbolicMathML" :> 
          Documentation`HelpLookup["paclet:XML/ref/BoxesToSymbolicMathML"], 
          "SymbolicMathMLToBoxes" :> 
          Documentation`HelpLookup[
           "paclet:XML/ref/SymbolicMathMLToBoxes"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"BoxesToMathML\"\>", 2->"\<\"MathMLToBoxes\"\>", 
       3->"\<\"MathMLToExpression\"\>", 
       4->"\<\"ExpressionToSymbolicMathML\"\>", 
       5->"\<\"SymbolicMathMLToExpression\"\>", 
       6->"\<\"BoxesToSymbolicMathML\"\>", 
       7->"\<\"SymbolicMathMLToBoxes\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ExpressionToMathML", "ObjectName",
 CellID->9275],

Cell[TextData[{
 "Same functionality now provided by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ExportString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExportString"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<MathML\>\"", ",", "\"\<Expression\>\""}], "}"}]}], "]"}]], 
  "InlineFormula"],
 "."
}], "ObsolescenceNote",
 CellID->32046],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ExpressionToMathML", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]converts the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expression, ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", into a MathML-flavored XML text string. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17632]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
The output is in both presentation and content MathML wherever possible.\
\>", "Notes",
 CellID->29789],

Cell["The following options can be given: ", "Notes",
 CellID->6046],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Annotations\>\"", 
    RowBox[{"{", "}"}], Cell[TextData[{
     "annotations to add to the output (acceptable values are combinations of \
\n",
     Cell[BoxData["\"\<DocumentHeader\>\""], "InlineFormula"],
     ", ",
     Cell[BoxData["\"\<XMLDeclaration\>\""], "InlineFormula"],
     ", and ",
     Cell[BoxData["\"\<DOCTYPEDeclaration\>\""], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<AttributeQuoting\>\"", "\"\<'\>\"", 
    Cell["character used to quote attribute values", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CheckXML\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to check the output for errors", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ElementFormatting\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "controls indenting in the output", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Entities\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "how to represent special characters as named entities", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Formats\>\"", 
    RowBox[{"{", 
     RowBox[{"\"\<PresentationMathML\>\"", ",", "\"\<ContentMathML\>\""}], 
     "}"}], Cell["type of MathML markup to generate", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<IncludeMarkupAnnotations\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether to add annotation when exporting a formula with constructs \
specific to ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " and no clear counterpart in MathML"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MathAttributes\>\"", 
    RowBox[{"{", "}"}], Cell[
    "attributes to add to the root element of the MathML", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NamespacePrefixes\>\"", 
    RowBox[{"{", "}"}], Cell[
    "specifies namespace declaration and prefix", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UseUnicodePlane1Characters\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether to replace plane 1 Unicode characters with similar plane 0 characters\
\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->2145]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->402771334],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->317968126],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<XML`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->459744],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XML`MathML`ExpressionToMathML", "[", 
  RowBox[{"x", "+", " ", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24346],

Cell[BoxData["\<\"<math xmlns='http://www.w3.org/1998/Math/MathML'>\\n \
<semantics>\\n  <mrow>\\n   <mi>x</mi>\\n   <mo>+</mo>\\n   <mn>3</mn>\\n  \
</mrow>\\n  <annotation-xml encoding='MathML-Content'>\\n   <apply>\\n    \
<plus/>\\n    <ci>x</ci>\\n    <cn type='integer'>3</cn>\\n   </apply>\\n  \
</annotation-xml>\\n </semantics>\\n</math>\"\>"], "Output",
 ImageSize->{347, 271},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1025]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29153],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BoxesToMathML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/BoxesToMathML",
    ButtonNote->"ObsLink: No successor for BoxesToMathML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathMLToBoxes",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/MathMLToBoxes",
    ButtonNote->"ObsLink: No successor for MathMLToBoxes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathMLToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/MathMLToExpression",
    ButtonNote->"ObsLink: No successor for MathMLToExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpressionToSymbolicMathML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ExpressionToSymbolicMathML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymbolicMathMLToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/SymbolicMathMLToExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BoxesToSymbolicMathML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/BoxesToSymbolicMathML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymbolicMathMLToBoxes",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/SymbolicMathMLToBoxes"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21184]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6003],

Cell[TextData[ButtonBox["XML Capabilities",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/Overview"]], "Tutorials",
 CellID->31597],

Cell[TextData[ButtonBox["Working with MathML",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/MathML"]], "Tutorials",
 CellID->255412927]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ExpressionToMathML - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 14, 22.3744134}", "context" -> "XML`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Obsolete  XML Package Symbol", "language" -> "en", "paclet" -> 
    "XML Package", "status" -> "ObsoleteFlag", "summary" -> 
    "ExpressionToMathML[expr] converts the Mathematica expression, expr, into \
a MathML-flavored XML text string. ", "synonyms" -> {}, "title" -> 
    "ExpressionToMathML", "type" -> "Symbol", "uri" -> 
    "XML/ref/ExpressionToMathML"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7462, 216, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->402771334]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12944, 396}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2273, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2896, 79, 55, 1, 70, "ObjectName",
 CellID->9275],
Cell[2954, 82, 390, 14, 70, "ObsolescenceNote",
 CellID->32046],
Cell[3347, 98, 578, 18, 70, "Usage",
 CellID->17632]
}, Open  ]],
Cell[CellGroupData[{
Cell[3962, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4440, 138, 113, 3, 70, "Notes",
 CellID->29789],
Cell[4556, 143, 68, 1, 70, "Notes",
 CellID->6046],
Cell[4627, 146, 2798, 65, 70, "3ColumnTableMod",
 CellID->2145]
}, Closed]],
Cell[CellGroupData[{
Cell[7462, 216, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->402771334],
Cell[CellGroupData[{
Cell[7847, 230, 148, 5, 70, "ExampleSection",
 CellID->317968126],
Cell[7998, 237, 123, 3, 70, "Input",
 CellID->459744],
Cell[CellGroupData[{
Cell[8146, 244, 149, 4, 28, "Input",
 CellID->24346],
Cell[8298, 250, 490, 9, 292, "Output",
 CellID->1025]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8849, 266, 311, 9, 70, "SeeAlsoSection",
 CellID->29153],
Cell[9163, 277, 2050, 65, 70, "SeeAlso",
 CellID->21184]
}, Open  ]],
Cell[CellGroupData[{
Cell[11250, 347, 313, 9, 70, "TutorialsSection",
 CellID->6003],
Cell[11566, 358, 139, 3, 70, "Tutorials",
 CellID->31597],
Cell[11708, 363, 144, 3, 70, "Tutorials",
 CellID->255412927]
}, Open  ]],
Cell[11867, 369, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

