(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14794,        523]
NotebookOptionsPosition[     11401,        407]
NotebookOutlinePosition[     12758,        445]
CellTagsIndexPosition[     12673,        440]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["XML PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Capabilities" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/Overview"], 
          "Importing XML" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/ImportingXML"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"XML Capabilities\"\>", 
       2->"\<\"Importing XML\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XMLGet" :> Documentation`HelpLookup["paclet:XML/ref/XMLGet"], 
          "XMLGetString" :> 
          Documentation`HelpLookup["paclet:XML/ref/XMLGetString"], 
          "ReleaseXMLParser" :> 
          Documentation`HelpLookup["paclet:XML/ref/ReleaseXMLParser"], 
          "XMLParser" :> 
          Documentation`HelpLookup["paclet:XML/ref/XMLParser"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"XMLGet\"\>", 
       2->"\<\"XMLGetString\"\>", 3->"\<\"ReleaseXMLParser\"\>", 
       4->"\<\"XMLParser\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Package" :> 
          Documentation`HelpLookup["paclet:XML/guide/XMLPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InitializeXMLParser", "ObjectName",
 CellID->25631],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"InitializeXMLParser", "[", 
       RowBox[{
        StyleBox["root", "TI"], ",", 
        StyleBox[
         RowBox[{"\"\<\>", "file", "\"\<\>"}], "TI"]}], "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]creates an ",
     Cell[BoxData[
      ButtonBox["XMLParser",
       BaseStyle->"Link",
       ButtonData->"paclet:XML/ref/XMLParser"]], "InlineFormula"],
     " object that has a list of entities corresponding to the contents of ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\""], "InlineFormula"],
     " and can be used on XML documents that have a root element ",
     Cell[BoxData[
      StyleBox["root", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24061]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["InitializeXMLParser"], "InlineFormula"],
 " can be used to preload a DTD. If many documents with the same DTD are to \
be loaded repeatedly, a pre-initialized parser can speed up processing time."
}], "Notes",
 CellID->27219]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->465276344],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->205393322],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<XML`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->873910183],

Cell["Initialize a MathML parser (with a preloaded DTD):", "ExampleText",
 CellID->24898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mathMLParser", "=", 
  RowBox[{"InitializeXMLParser", "[", 
   RowBox[{
   "\"\<math\>\"", ",", 
    "\"\<http://www.w3.org/TR/MathML2/dtd/mathml2.dtd\>\""}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31447],

Cell[BoxData[
 RowBox[{"XMLParser", "[", 
  RowBox[{"\<\"math\"\>", 
   ",", "\<\"http://www.w3.org/TR/MathML2/dtd/mathml2.dtd\"\>"}], 
  "]"}]], "Output",
 ImageSize->{429, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10945]
}, Open  ]],

Cell["\<\
The pre-initialized MathML parser is much faster than reloading the DTD:\
\>", "ExampleText",
 CellID->28406],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"XMLGetString", "[", 
    RowBox[{
    "\"\<<!DOCTYPE math SYSTEM \
'http://www.w3.org/TR/MathML2/dtd/mathml2.dtd'><math><mn>1</mn></math>\>\"", 
     ",", "mathMLParser"}], "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2222],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.039999999999999966`", " ", "Second"}], ",", "Null"}], 
  "}"}]], "Output",
 ImageSize->{131, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->8686]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{
   "XMLGetString", "[", 
    "\"\<<!DOCTYPE math SYSTEM \
'http://www.w3.org/TR/MathML2/dtd/mathml2.dtd'><math><mn>1</mn></math>\>\"", 
    "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->5794],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.059999999999999935`", " ", "Second"}], ",", "Null"}], 
  "}"}]], "Output",
 ImageSize->{131, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->23577]
}, Open  ]],

Cell["\<\
For validation, a DOCTYPE declaration does not need to be present when using \
a pre-initialized parser:\
\>", "ExampleText",
 CellID->12844],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XMLGetString", "[", 
  RowBox[{"\"\<<math><mn>1</mn></math>\>\"", ",", "mathMLParser", ",", 
   RowBox[{"\"\<ValidateAgainstDTD\>\"", "\[Rule]", "True"}]}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->18683],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"XMLObject", "[", "\<\"Doctype\"\>", "]"}], "[", 
     RowBox[{"\<\"math\"\>", ",", 
      RowBox[{"\<\"System\"\>", 
       "\[Rule]", "\<\"http://www.w3.org/TR/MathML2/dtd/mathml2.dtd\"\>"}]}], 
     "]"}], "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"math\"\>", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\<\"mn\"\>", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", "\<\"1\"\>", "}"}]}], "]"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"\<\"Valid\"\>", "\[Rule]", "True"}]}], "]"}]], "Output",
 ImageSize->{578, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->21547]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReleaseXMLParser",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/ReleaseXMLParser"]], "InlineFormula"],
 " frees up resources when the parser is done:"
}], "ExampleText",
 CellID->13240],

Cell[BoxData[
 RowBox[{"ReleaseXMLParser", "[", "mathMLParser", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->485]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1563],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["XMLGet",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/XMLGet"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["XMLGetString",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/XMLGetString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReleaseXMLParser",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ReleaseXMLParser"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["XMLParser",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/XMLParser"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21302]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28781],

Cell[TextData[ButtonBox["XML Capabilities",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/Overview"]], "Tutorials",
 CellID->31597],

Cell[TextData[ButtonBox["Importing XML",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/ImportingXML"]], "Tutorials",
 CellID->180283117]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->63009447],

Cell[TextData[ButtonBox["XML Package",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/guide/XMLPackage"]], "MoreAbout",
 CellID->27339848]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InitializeXMLParser - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 14, 27.4214176}", "context" -> "XML`", 
    "keywords" -> {}, "index" -> True, "label" -> "XML Package Symbol", 
    "language" -> "en", "paclet" -> "XML Package", "status" -> "None", 
    "summary" -> 
    "InitializeXMLParser[root, \" file \"] creates an XMLParser object that \
has a list of entities corresponding to the contents of \" file\" and can be \
used on XML documents that have a root element root.", "synonyms" -> {}, 
    "title" -> "InitializeXMLParser", "type" -> "Symbol", "uri" -> 
    "XML/ref/InitializeXMLParser"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4612, 143, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->465276344]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12530, 433}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2189, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2812, 81, 57, 1, 70, "ObjectName",
 CellID->25631],
Cell[2872, 84, 932, 27, 70, "Usage",
 CellID->24061]
}, Open  ]],
Cell[CellGroupData[{
Cell[3841, 116, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4319, 133, 256, 5, 70, "Notes",
 CellID->27219]
}, Closed]],
Cell[CellGroupData[{
Cell[4612, 143, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->465276344],
Cell[CellGroupData[{
Cell[4997, 157, 148, 5, 70, "ExampleSection",
 CellID->205393322],
Cell[5148, 164, 126, 3, 70, "Input",
 CellID->873910183],
Cell[5277, 169, 89, 1, 70, "ExampleText",
 CellID->24898],
Cell[CellGroupData[{
Cell[5391, 174, 244, 8, 47, "Input",
 CellID->31447],
Cell[5638, 184, 282, 9, 36, "Output",
 CellID->10945]
}, Open  ]],
Cell[5935, 196, 119, 3, 70, "ExampleText",
 CellID->28406],
Cell[CellGroupData[{
Cell[6079, 203, 303, 9, 70, "Input",
 CellID->2222],
Cell[6385, 214, 254, 9, 36, "Output",
 CellID->8686]
}, Open  ]],
Cell[CellGroupData[{
Cell[6676, 228, 270, 9, 70, "Input",
 CellID->5794],
Cell[6949, 239, 255, 9, 36, "Output",
 CellID->23577]
}, Open  ]],
Cell[7219, 251, 151, 4, 70, "ExampleText",
 CellID->12844],
Cell[CellGroupData[{
Cell[7395, 259, 239, 6, 70, "Input",
 CellID->18683],
Cell[7637, 267, 875, 25, 71, "Output",
 CellID->21547]
}, Open  ]],
Cell[8527, 295, 237, 7, 70, "ExampleText",
 CellID->13240],
Cell[8767, 304, 117, 3, 70, "Input",
 CellID->485]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8933, 313, 310, 9, 70, "SeeAlsoSection",
 CellID->1563],
Cell[9246, 324, 979, 35, 70, "SeeAlso",
 CellID->21302]
}, Open  ]],
Cell[CellGroupData[{
Cell[10262, 364, 314, 9, 70, "TutorialsSection",
 CellID->28781],
Cell[10579, 375, 139, 3, 70, "Tutorials",
 CellID->31597],
Cell[10721, 380, 144, 3, 70, "Tutorials",
 CellID->180283117]
}, Open  ]],
Cell[CellGroupData[{
Cell[10902, 388, 318, 9, 70, "MoreAboutSection",
 CellID->63009447],
Cell[11223, 399, 136, 3, 70, "MoreAbout",
 CellID->27339848]
}, Open  ]],
Cell[11374, 405, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

