(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10959,        384]
NotebookOptionsPosition[      8305,        294]
NotebookOutlinePosition[      9533,        330]
CellTagsIndexPosition[      9449,        325]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["XML PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Capabilities" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/Overview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Capabilities\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XMLGet" :> Documentation`HelpLookup["paclet:XML/ref/XMLGet"], 
          "XMLGetString" :> 
          Documentation`HelpLookup["paclet:XML/ref/XMLGetString"], 
          "InitializeXMLParser" :> 
          Documentation`HelpLookup["paclet:XML/ref/InitializeXMLParser"], 
          "XMLParser" :> 
          Documentation`HelpLookup["paclet:XML/ref/XMLParser"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"XMLGet\"\>", 
       2->"\<\"XMLGetString\"\>", 3->"\<\"InitializeXMLParser\"\>", 
       4->"\<\"XMLParser\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Package" :> 
          Documentation`HelpLookup["paclet:XML/guide/XMLPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ReleaseXMLParser", "ObjectName",
 CellID->10057],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ReleaseXMLParser", "[", 
       StyleBox["parser", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]frees up resources associated with the ",
     Cell[BoxData[
      ButtonBox["XMLParser",
       BaseStyle->"Link",
       ButtonData->"paclet:XML/ref/XMLParser"]], "InlineFormula"],
     " object ",
     Cell[BoxData[
      StyleBox["parser", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14095]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InitializeXMLParser",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/InitializeXMLParser"]], "InlineFormula"],
 " can be used to preload a DTD. If many documents with the same DTD are to \
be loaded repeatedly, a pre-initialized parser can speed up processing. ",
 Cell[BoxData["ReleaseXMLParser"], "InlineFormula"],
 " frees up resources when the parser is done."
}], "Notes",
 CellID->8174]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->505986314],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->346174055],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<XML`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->259237511],

Cell["Initialize a MathML parser (with a preloaded DTD):", "ExampleText",
 CellID->24300],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mathMLParser", "=", 
  RowBox[{"InitializeXMLParser", "[", 
   RowBox[{
   "\"\<math\>\"", ",", 
    "\"\<http://www.w3.org/TR/MathML2/dtd/mathml2.dtd\>\""}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15590],

Cell[BoxData[
 RowBox[{"XMLParser", "[", 
  RowBox[{"\<\"math\"\>", 
   ",", "\<\"http://www.w3.org/TR/MathML2/dtd/mathml2.dtd\"\>"}], 
  "]"}]], "Output",
 ImageSize->{429, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21480]
}, Open  ]],

Cell["Once done with the parser, release resources it was using:", \
"ExampleText",
 CellID->17408],

Cell[BoxData[
 RowBox[{"ReleaseXMLParser", "[", "mathMLParser", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->15505]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25722],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["XMLGet",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/XMLGet"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["XMLGetString",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/XMLGetString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InitializeXMLParser",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/InitializeXMLParser"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["XMLParser",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/XMLParser"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16983]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5038],

Cell[TextData[ButtonBox["XML Capabilities",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/Overview"]], "Tutorials",
 CellID->31597]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->10522924],

Cell[TextData[ButtonBox["XML Package",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/guide/XMLPackage"]], "MoreAbout",
 CellID->540974356]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ReleaseXMLParser - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 14, 28.7339512}", "context" -> "XML`", 
    "keywords" -> {}, "index" -> True, "label" -> "XML Package Symbol", 
    "language" -> "en", "paclet" -> "XML Package", "status" -> "None", 
    "summary" -> 
    "ReleaseXMLParser[parser] frees up resources associated with the \
XMLParser object parser.", "synonyms" -> {}, "title" -> "ReleaseXMLParser", 
    "type" -> "Symbol", "uri" -> "XML/ref/ReleaseXMLParser"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4384, 139, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->505986314]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9306, 318}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2066, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2689, 79, 54, 1, 70, "ObjectName",
 CellID->10057],
Cell[2746, 82, 644, 20, 70, "Usage",
 CellID->14095]
}, Open  ]],
Cell[CellGroupData[{
Cell[3427, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3905, 124, 442, 10, 70, "Notes",
 CellID->8174]
}, Closed]],
Cell[CellGroupData[{
Cell[4384, 139, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->505986314],
Cell[CellGroupData[{
Cell[4769, 153, 148, 5, 70, "ExampleSection",
 CellID->346174055],
Cell[4920, 160, 126, 3, 70, "Input",
 CellID->259237511],
Cell[5049, 165, 89, 1, 70, "ExampleText",
 CellID->24300],
Cell[CellGroupData[{
Cell[5163, 170, 244, 8, 47, "Input",
 CellID->15590],
Cell[5410, 180, 282, 9, 36, "Output",
 CellID->21480]
}, Open  ]],
Cell[5707, 192, 99, 2, 70, "ExampleText",
 CellID->17408],
Cell[5809, 196, 119, 3, 70, "Input",
 CellID->15505]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5977, 205, 311, 9, 70, "SeeAlsoSection",
 CellID->25722],
Cell[6291, 216, 985, 35, 70, "SeeAlso",
 CellID->16983]
}, Open  ]],
Cell[CellGroupData[{
Cell[7313, 256, 313, 9, 70, "TutorialsSection",
 CellID->5038],
Cell[7629, 267, 139, 3, 70, "Tutorials",
 CellID->31597]
}, Open  ]],
Cell[CellGroupData[{
Cell[7805, 275, 318, 9, 70, "MoreAboutSection",
 CellID->10522924],
Cell[8126, 286, 137, 3, 70, "MoreAbout",
 CellID->540974356]
}, Open  ]],
Cell[8278, 292, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

